/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.function.ComparatorEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SortTransform<T>
extends AbstractTransform {
    private static final long serialVersionUID = 1L;
    private static final String COLLECT_STAGE_SUFFIX = "-collect";
    private final ComparatorEx<? super T> comparator;

    public SortTransform(@Nonnull Transform upstream, @Nullable ComparatorEx<? super T> comparator) {
        super("sort", upstream);
        this.comparator = comparator == null ? ComparatorEx.naturalOrder() : comparator;
    }

    @Override
    public void addToDag(Planner p, PipelineImpl.Context context) {
        String vertexName = this.name();
        this.determineLocalParallelism(-1, context, p.isPreserveOrder());
        Vertex v1 = p.dag.newVertex(vertexName, Processors.sortP(this.comparator)).localParallelism(this.determinedLocalParallelism());
        if (p.isPreserveOrder()) {
            p.addEdges((Transform)this, v1, Edge::isolated);
        } else {
            p.addEdges(this, v1);
        }
        this.determinedLocalParallelism(1);
        Planner.PlannerVertex pv2 = p.addVertex((Transform)this, vertexName + COLLECT_STAGE_SUFFIX, this.determinedLocalParallelism(), ProcessorMetaSupplier.forceTotalParallelismOne(ProcessorSupplier.of(Processors.mapP(FunctionEx.identity())), vertexName));
        p.dag.edge(Edge.between(v1, pv2.v).distributed().allToOne(vertexName).ordered(this.comparator));
    }
}

