/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.report.jasper;

import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adempiere.apps.graph.ChartBuilder;
import org.compiere.model.MAccount;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MChart;
import org.compiere.model.MColumn;
import org.compiere.model.MImage;
import org.compiere.model.MLocation;
import org.compiere.model.MLocator;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MTable;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;

public class ColumnLookup
implements BiFunction<String, Object, Object> {
    private Language language;

    public ColumnLookup(Language language) {
        this.language = language;
    }

    @Override
    public Object apply(String t, Object key) {
        if (!Util.isEmpty((String)t, (boolean)true) && key != null) {
            String[] parts = t.split("[.]");
            if (parts.length == 2) {
                String tableName = parts[0];
                String columnName = parts[1];
                MTable table = MTable.get((Properties)Env.getCtx(), (String)tableName);
                if (table != null) {
                    MColumn column = table.getColumn(columnName);
                    if (column != null) {
                        if (DisplayType.isList((int)column.getAD_Reference_ID())) {
                            MLookupInfo linfo = MLookupFactory.getLookup_List((Language)this.language, (int)column.getAD_Reference_Value_ID());
                            MLookup lookup = new MLookup(linfo, -1);
                            return lookup.getDisplay(key);
                        }
                        if (DisplayType.isLookup((int)column.getAD_Reference_ID()) && key instanceof Number) {
                            return this.getLookupDisplay(column, (Number)key);
                        }
                        if ((column.getAD_Reference_ID() == 200161 || column.getAD_Reference_ID() == 200163 || column.getAD_Reference_ID() == 200162) && key instanceof String) {
                            return this.getMultiLookupDisplay(column, (String)key);
                        }
                        if (21 == column.getAD_Reference_ID() && key instanceof Number) {
                            return this.getLocation((Number)key);
                        }
                        if (32 == column.getAD_Reference_ID() && key instanceof Number) {
                            return this.getImage(((Number)key).intValue());
                        }
                        if (20 == column.getAD_Reference_ID() && key instanceof String) {
                            String value = (String)key;
                            return this.getYesNoText(value);
                        }
                        if (25 == column.getAD_Reference_ID() && key instanceof Number) {
                            return this.getAccountCombination((Number)key);
                        }
                        if (31 == column.getAD_Reference_ID() && key instanceof Number) {
                            return this.getLocator((Number)key);
                        }
                        if (35 == column.getAD_Reference_ID() && key instanceof Number) {
                            return this.getAttributeSetInstance((Number)key);
                        }
                        if (DisplayType.isNumeric((int)column.getAD_Reference_ID())) {
                            return DisplayType.getNumberFormat((int)column.getAD_Reference_ID(), (Language)this.language).format((Number)key);
                        }
                        if (DisplayType.isDate((int)column.getAD_Reference_ID())) {
                            return DisplayType.getDateFormat((int)column.getAD_Reference_ID(), (Language)this.language).format((Date)key);
                        }
                    } else {
                        return "";
                    }
                }
            }
            if (t.equalsIgnoreCase("location") && key instanceof Number) {
                return this.getLocation((Number)key);
            }
            if (t.equalsIgnoreCase("account") && key instanceof Number) {
                return this.getAccountCombination((Number)key);
            }
            if (t.equalsIgnoreCase("locator") && key instanceof Number) {
                return this.getLocator((Number)key);
            }
            if (t.equalsIgnoreCase("asi") && key instanceof Number) {
                return this.getAttributeSetInstance((Number)key);
            }
            if (t.equalsIgnoreCase("AmtInWords")) {
                if (key instanceof String) {
                    return Msg.getAmtInWords((Language)this.language, (String)((String)key));
                }
                if (key instanceof BigDecimal) {
                    String s = DisplayType.getNumberFormat((int)12, (Language)this.language).format((BigDecimal)key);
                    return Msg.getAmtInWords((Language)this.language, (String)s);
                }
            } else {
                if (t.equalsIgnoreCase("Image") && key instanceof Number) {
                    return this.getImage(((Number)key).intValue());
                }
                if (t.equalsIgnoreCase("YesNo") && key instanceof String) {
                    return this.getYesNoText((String)key);
                }
                if (t.toLowerCase().startsWith("chart/") && key instanceof Number) {
                    parts = t.split("[/]");
                    if (parts.length == 3) {
                        int width = 0;
                        int height = 0;
                        try {
                            width = Integer.parseInt(parts[1]);
                            height = Integer.parseInt(parts[2]);
                        }
                        catch (Exception exception) {}
                        if (width > 0 && height > 0) {
                            return this.getChartImage(((Number)key).intValue(), width, height);
                        }
                    }
                    return null;
                }
                if (t.toLowerCase().startsWith("attachment/")) {
                    return this.getAttachmentData(t, key);
                }
            }
        }
        return "";
    }

    private Object getAttachmentData(String expression, Object key) {
        String[] parts;
        if ((key instanceof Number || key instanceof String) && (parts = expression.split("[/]")).length == 3) {
            String tableName = parts[1];
            MTable table = MTable.get((Properties)Env.getCtx(), (String)tableName);
            if (table != null) {
                int recordId = key instanceof Number ? ((Number)key).intValue() : -1;
                String recordUU = key instanceof String ? (String)key : null;
                MAttachment attachment = MAttachment.get((Properties)Env.getCtx(), (int)table.get_ID(), (int)recordId, (String)recordUU, null);
                if (attachment != null && attachment.get_ID() > 0) {
                    int index = -1;
                    if (parts[2].trim().matches("[0-9]+")) {
                        try {
                            index = Integer.parseInt(parts[2]);
                        }
                        catch (Exception exception) {}
                    }
                    if (index >= 0 && index < attachment.getEntryCount()) {
                        return attachment.getEntryData(index);
                    }
                    String toMatch = null;
                    if (parts[2].contains("*")) {
                        Pattern regex = Pattern.compile("[^*]+|(\\*)");
                        Matcher m = regex.matcher(parts[2]);
                        StringBuffer b = new StringBuffer();
                        while (m.find()) {
                            if (m.group(1) != null) {
                                m.appendReplacement(b, ".*");
                                continue;
                            }
                            m.appendReplacement(b, "\\\\Q" + m.group(0) + "\\\\E");
                        }
                        m.appendTail(b);
                        toMatch = b.toString();
                    }
                    int i = 0;
                    while (i < attachment.getEntryCount()) {
                        if (toMatch != null && attachment.getEntryName(i) != null && attachment.getEntryName(i).matches(toMatch)) {
                            return attachment.getEntryData(i);
                        }
                        if (parts[2].equals(attachment.getEntryName(i))) {
                            return attachment.getEntryData(i);
                        }
                        ++i;
                    }
                }
            }
        }
        return null;
    }

    private Object getAttributeSetInstance(Number key) {
        MAttributeSetInstance asi = new MAttributeSetInstance(Env.getCtx(), key.intValue(), null);
        if (asi.getM_AttributeSetInstance_ID() > 0) {
            return asi.getDescription();
        }
        return "";
    }

    private Object getLocator(Number key) {
        MLocator locator = MLocator.get((int)key.intValue());
        return locator != null ? locator.toString() : "";
    }

    private Object getAccountCombination(Number key) {
        MAccount account = MAccount.get((int)key.intValue());
        return account != null ? account.getCombination() : "";
    }

    private Object getLocation(Number key) {
        MLocation loc = MLocation.get((int)key.intValue());
        return loc.toStringCR();
    }

    private Object getChartImage(int id, int width, int height) {
        MChart mc = new MChart(Env.getCtx(), id, null);
        if (mc.get_ID() == id) {
            ChartBuilder chartBuilder = new ChartBuilder(mc);
            JFreeChart chart = chartBuilder.createChart();
            chart.getPlot().setForegroundAlpha(0.8f);
            ChartRenderingInfo info = new ChartRenderingInfo();
            BufferedImage bi = chart.createBufferedImage(width, height, 3, info);
            return bi;
        }
        return null;
    }

    private Object getYesNoText(String value) {
        if (value.equals("Y")) {
            return Msg.getMsg((Language)this.language, (String)"Yes");
        }
        if (value.equals("N")) {
            return Msg.getMsg((Language)this.language, (String)"No");
        }
        return "";
    }

    private Object getImage(int key) {
        MImage image = MImage.get((int)key);
        return image != null ? image.getImage() : null;
    }

    private Object getMultiLookupDisplay(MColumn column, String key) {
        MLookupInfo mli = MLookupFactory.getLookupInfo((Properties)Env.getCtx(), (int)-1, (int)column.getAD_Column_ID(), (int)column.getAD_Reference_ID(), (Language)this.language, (String)column.getColumnName(), (int)column.getAD_Reference_Value_ID(), (boolean)false, (String)"");
        MLookup lookup = new MLookup(mli, -1);
        return lookup.getDisplay((Object)key);
    }

    private String getLookupDisplay(MColumn column, Number key) {
        MLookupInfo mli = MLookupFactory.getLookupInfo((Properties)Env.getCtx(), (int)-1, (int)column.getAD_Column_ID(), (int)column.getAD_Reference_ID(), (Language)this.language, (String)column.getColumnName(), (int)column.getAD_Reference_Value_ID(), (boolean)false, (String)"");
        MLookup lookup = new MLookup(mli, -1);
        return lookup.getDisplay((Object)key);
    }
}

