/*
 * Decompiled with CFR 0.152.
 */
package com.sfcommerce.jpaymentcomponent.utilities;

import com.sfcommerce.jpaymentcomponent.exceptions.ConfigNotInitializedException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class Config {
    public static final int DEFAULT_TIMEOUT = 120;
    public static final int DEFAULT_RETRIES = 5;
    public static final String DEFAULT_LOGLEVEL = "INFORMATION";
    public static final String DEFAULT_LOG_BASE_PATH = ".";
    public static final String DEFAULT_LOG_FILENAME = "event_log.log";
    public static final int DEFAULT_LOG_MAX_SIZE = 10240000;
    public static final int DEFAULT_LOG_MAX_BACKUP = 10;
    private static Properties theLoadedProperties = new Properties();
    private static String theConfigFileName = null;
    private static boolean theIsInitialized = false;

    public static void reset() {
        theLoadedProperties = new Properties();
    }

    public static void loadFrom(String aFileName) throws IOException {
        File file = new File(aFileName);
        DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        theLoadedProperties.load(is);
        is.close();
    }

    public static final synchronized void init(String aCfgFile) throws IOException {
        theConfigFileName = aCfgFile;
        Config.loadProperties();
        theIsInitialized = true;
    }

    private static final void loadProperties() throws IOException {
        File file = new File(theConfigFileName);
        if (file.isFile()) {
            DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            theLoadedProperties.load(is);
            is.close();
        }
    }

    public static final String getProperty(String aPropertyName, String aDefaultValue) throws ConfigNotInitializedException {
        if (!theIsInitialized) {
            throw new ConfigNotInitializedException("Config not initialized (Config.init() wasn't called).");
        }
        return Config.getProperty(aPropertyName, aDefaultValue, false);
    }

    public static final String getProperty(String aPropertyName, String aDefaultValue, boolean aTrim) throws ConfigNotInitializedException {
        if (!theIsInitialized) {
            throw new ConfigNotInitializedException("Config not initialized (Config.init() wasn't called).");
        }
        String temp = null;
        temp = theLoadedProperties.getProperty(aPropertyName);
        if (temp == null || temp.length() == 0) {
            temp = aDefaultValue;
            theLoadedProperties.put(aPropertyName, temp);
        }
        return temp;
    }

    public static final String getProperty(String aPropertyName) throws ConfigNotInitializedException {
        if (!theIsInitialized) {
            throw new ConfigNotInitializedException("Config not initialized (Config.init() wasn't called).");
        }
        return Config.getProperty(aPropertyName, false);
    }

    public static final String getProperty(String aPropertyName, boolean aTrim) throws ConfigNotInitializedException {
        if (!theIsInitialized) {
            throw new ConfigNotInitializedException("Config not initialized (Config.init() wasn't called).");
        }
        String temp = null;
        temp = theLoadedProperties.getProperty(aPropertyName);
        if (temp != null) {
            temp = aTrim ? temp.trim() : temp;
        }
        return temp;
    }

    public static final void addProperty(String aPropertyName, String aValue) throws ConfigNotInitializedException {
        if (!theIsInitialized) {
            throw new ConfigNotInitializedException("Config not initialized (Config.init() wasn't called).");
        }
        theLoadedProperties.put(aPropertyName, aValue);
    }
}

