/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import org.adempiere.base.annotation.Process;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.process.SvrProcess;

@Process
public class RMACreateOrder
extends SvrProcess {
    private int rmaId = 0;

    protected void prepare() {
        this.rmaId = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MRMALine[] lines;
        MRMA rma = new MRMA(this.getCtx(), this.rmaId, this.get_TrxName());
        MOrder originalOrder = rma.getOriginalOrder();
        if (rma.get_ID() == 0) {
            throw new Exception("No RMA defined");
        }
        if (originalOrder == null) {
            throw new Exception("Could not load the original order");
        }
        MOrder order = new MOrder(this.getCtx(), 0, this.get_TrxName());
        order.setAD_Org_ID(rma.getAD_Org_ID());
        order.setC_BPartner_ID(originalOrder.getC_BPartner_ID());
        order.setC_BPartner_Location_ID(originalOrder.getC_BPartner_Location_ID());
        order.setAD_User_ID(originalOrder.getAD_User_ID());
        order.setBill_BPartner_ID(originalOrder.getBill_BPartner_ID());
        order.setBill_Location_ID(originalOrder.getBill_Location_ID());
        order.setBill_User_ID(originalOrder.getBill_User_ID());
        order.setSalesRep_ID(rma.getSalesRep_ID());
        order.setM_PriceList_ID(originalOrder.getM_PriceList_ID());
        order.setIsSOTrx(originalOrder.isSOTrx());
        order.setM_Warehouse_ID(originalOrder.getM_Warehouse_ID());
        order.setC_DocTypeTarget_ID(originalOrder.getC_DocTypeTarget_ID());
        order.setC_PaymentTerm_ID(originalOrder.getC_PaymentTerm_ID());
        order.setDeliveryRule(originalOrder.getDeliveryRule());
        if (!order.save()) {
            throw new IllegalStateException("Could not create order");
        }
        MInOut originalShipment = rma.getShipment();
        MInvoice originalInvoice = rma.getOriginalInvoice();
        MRMALine[] mRMALineArray = lines = rma.getLines(true);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MRMALine line = mRMALineArray[n2];
            if (line.getShipLine() != null && line.getShipLine().getC_OrderLine_ID() != 0 && line.getM_Product_ID() != 0) {
                orderLine = new MOrderLine(order);
                MOrderLine originalOLine = new MOrderLine(this.getCtx(), line.getShipLine().getC_OrderLine_ID(), null);
                orderLine.setAD_Org_ID(line.getAD_Org_ID());
                orderLine.setM_Product_ID(originalOLine.getM_Product_ID());
                orderLine.setM_AttributeSetInstance_ID(originalOLine.getM_AttributeSetInstance_ID());
                orderLine.setC_UOM_ID(originalOLine.getC_UOM_ID());
                orderLine.setC_Tax_ID(originalOLine.getC_Tax_ID());
                orderLine.setM_Warehouse_ID(originalOLine.getM_Warehouse_ID());
                orderLine.setC_Currency_ID(originalOLine.getC_Currency_ID());
                orderLine.setQty(line.getQty());
                orderLine.setC_Project_ID(originalOLine.getC_Project_ID());
                orderLine.setC_Activity_ID(originalOLine.getC_Activity_ID());
                orderLine.setC_Campaign_ID(originalOLine.getC_Campaign_ID());
                orderLine.setPrice();
                orderLine.setPrice(line.getAmt());
                if (!orderLine.save()) {
                    throw new IllegalStateException("Could not create Order Line");
                }
            } else if (line.getM_Product_ID() != 0) {
                if (originalInvoice != null) {
                    orderLine = new MOrderLine(order);
                    orderLine.setAD_Org_ID(line.getAD_Org_ID());
                    orderLine.setM_Product_ID(line.getM_Product_ID());
                    orderLine.setM_AttributeSetInstance_ID(line.getM_AttributeSetInstance_ID());
                    orderLine.setC_UOM_ID(line.getC_UOM_ID());
                    orderLine.setC_Tax_ID(line.getC_Tax_ID());
                    orderLine.setM_Warehouse_ID(originalShipment.getM_Warehouse_ID());
                    orderLine.setC_Currency_ID(originalInvoice.getC_Currency_ID());
                    orderLine.setQty(line.getQty());
                    orderLine.setC_Project_ID(line.getC_Project_ID());
                    orderLine.setC_Activity_ID(line.getC_Activity_ID());
                    orderLine.setC_Campaign_ID(line.getC_Campaign_ID());
                    orderLine.setPrice();
                    orderLine.setPrice(line.getAmt());
                    if (!orderLine.save()) {
                        throw new IllegalStateException("Could not create Order Line");
                    }
                } else if (originalOrder != null) {
                    orderLine = new MOrderLine(order);
                    orderLine.setAD_Org_ID(line.getAD_Org_ID());
                    orderLine.setM_Product_ID(line.getM_Product_ID());
                    orderLine.setM_AttributeSetInstance_ID(line.getM_AttributeSetInstance_ID());
                    orderLine.setC_UOM_ID(line.getC_UOM_ID());
                    orderLine.setC_Tax_ID(line.getC_Tax_ID());
                    orderLine.setM_Warehouse_ID(originalOrder.getM_Warehouse_ID());
                    orderLine.setC_Currency_ID(originalOrder.getC_Currency_ID());
                    orderLine.setQty(line.getQty());
                    orderLine.setC_Project_ID(line.getC_Project_ID());
                    orderLine.setC_Activity_ID(line.getC_Activity_ID());
                    orderLine.setC_Campaign_ID(line.getC_Campaign_ID());
                    orderLine.setPrice();
                    orderLine.setPrice(line.getAmt());
                    if (!orderLine.save()) {
                        throw new IllegalStateException("Could not create Order Line");
                    }
                }
            }
            ++n2;
        }
        rma.setC_Order_ID(order.getC_Order_ID());
        if (!rma.save()) {
            throw new IllegalStateException("Could not update RMA document");
        }
        return "Order Created: " + order.getDocumentNo();
    }
}

