/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.converter;

import org.w3c.dom.Document;
import org.zkoss.poi.hssf.converter.ExcelToHtmlUtils;
import org.zkoss.poi.hssf.usermodel.HSSFCell;
import org.zkoss.poi.hssf.usermodel.HSSFCellStyle;
import org.zkoss.poi.hssf.usermodel.HSSFDataFormatter;
import org.zkoss.poi.hssf.usermodel.HSSFRichTextString;
import org.zkoss.poi.hssf.usermodel.HSSFRow;
import org.zkoss.poi.hssf.usermodel.HSSFSheet;
import org.zkoss.poi.hwpf.converter.DefaultFontReplacer;
import org.zkoss.poi.hwpf.converter.FontReplacer;
import org.zkoss.poi.hwpf.converter.NumberFormatter;
import org.zkoss.poi.ss.formula.eval.ErrorEval;

public abstract class AbstractExcelConverter {
    protected final HSSFDataFormatter _formatter = new HSSFDataFormatter();
    private FontReplacer fontReplacer = new DefaultFontReplacer();
    private boolean outputColumnHeaders = true;
    private boolean outputHiddenColumns = false;
    private boolean outputHiddenRows = false;
    private boolean outputLeadingSpacesAsNonBreaking = true;
    private boolean outputRowNumbers = true;

    protected static int getColumnWidth(HSSFSheet sheet, int columnIndex) {
        return ExcelToHtmlUtils.getColumnWidthInPx(sheet.getColumnWidth(columnIndex));
    }

    protected static int getDefaultColumnWidth(HSSFSheet sheet) {
        return ExcelToHtmlUtils.getColumnWidthInPx(sheet.getDefaultColumnWidth());
    }

    protected String getColumnName(int columnIndex) {
        return NumberFormatter.getNumber(columnIndex + 1, 3);
    }

    protected abstract Document getDocument();

    public FontReplacer getFontReplacer() {
        return this.fontReplacer;
    }

    protected String getRowName(HSSFRow row) {
        return String.valueOf(row.getRowNum() + 1);
    }

    public boolean isOutputColumnHeaders() {
        return this.outputColumnHeaders;
    }

    public boolean isOutputHiddenColumns() {
        return this.outputHiddenColumns;
    }

    public boolean isOutputHiddenRows() {
        return this.outputHiddenRows;
    }

    public boolean isOutputLeadingSpacesAsNonBreaking() {
        return this.outputLeadingSpacesAsNonBreaking;
    }

    public boolean isOutputRowNumbers() {
        return this.outputRowNumbers;
    }

    protected boolean isTextEmpty(HSSFCell cell) {
        String value;
        block0 : switch (cell.getCellType()) {
            case 1: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            case 2: {
                switch (cell.getCachedFormulaResultType()) {
                    case 1: {
                        HSSFRichTextString str = cell.getRichStringCellValue();
                        if (str == null || str.length() <= 0) {
                            return false;
                        }
                        value = str.toString();
                        break block0;
                    }
                    case 0: {
                        HSSFCellStyle style = cell.getCellStyle();
                        if (style == null) {
                            return false;
                        }
                        value = this._formatter.formatRawCellContents(cell.getNumericCellValue(), style.getDataFormat(), style.getDataFormatString());
                        break block0;
                    }
                    case 4: {
                        value = String.valueOf(cell.getBooleanCellValue());
                        break block0;
                    }
                    case 5: {
                        value = ErrorEval.getText(cell.getErrorCellValue());
                        break block0;
                    }
                }
                value = "";
                break;
            }
            case 3: {
                value = "";
                break;
            }
            case 0: {
                value = this._formatter.formatCellValue(cell);
                break;
            }
            case 4: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 5: {
                value = ErrorEval.getText(cell.getErrorCellValue());
                break;
            }
            default: {
                return true;
            }
        }
        return ExcelToHtmlUtils.isEmpty(value);
    }

    public void setFontReplacer(FontReplacer fontReplacer) {
        this.fontReplacer = fontReplacer;
    }

    public void setOutputColumnHeaders(boolean outputColumnHeaders) {
        this.outputColumnHeaders = outputColumnHeaders;
    }

    public void setOutputHiddenColumns(boolean outputZeroWidthColumns) {
        this.outputHiddenColumns = outputZeroWidthColumns;
    }

    public void setOutputHiddenRows(boolean outputZeroHeightRows) {
        this.outputHiddenRows = outputZeroHeightRows;
    }

    public void setOutputLeadingSpacesAsNonBreaking(boolean outputPrePostSpacesAsNonBreaking) {
        this.outputLeadingSpacesAsNonBreaking = outputPrePostSpacesAsNonBreaking;
    }

    public void setOutputRowNumbers(boolean outputRowNumbers) {
        this.outputRowNumbers = outputRowNumbers;
    }
}

