


(function () {
	function _calScrollWidth () {
		if(zkS.t(zss.Spreadsheet.scrollWidth)) return;
	    
		var body = document.body,
			scr = jq('<div style="position:absolute;top:0px;left:0px;width:80px;height:50px;overflow:auto;"></div>')[0],
			inn = jq('<div style="width:100px;height:100px;overflow: scroll;"></div>')[0]; 
	    
	    scr.appendChild(inn);

	    
	    body.appendChild(scr);

	    
		zss.Spreadsheet.scrollWidth = (scr.offsetWidth - scr.clientWidth);
		if (zss.Spreadsheet.scrollWidth == 0)
			zss.Spreadsheet.scrollWidth = scr.offsetHeight - scr.clientHeight;
		body.removeChild(scr);
		return;
	}
	
	function doUpdate(wgt, shtId, data, token) {
		wgt.sheetCtrl._skipMove = data.sk; 
		wgt.sheetCtrl._cmdCellUpdate(shtId, data);
		if (token)
			zkS.doCallback(token);
		delete wgt.sheetCtrl._skipMove; 
	}

	function doBlockUpdate(wgt, json, token) {
		
		if (wgt.sheetCtrl) {
			wgt.sheetCtrl.startRenderingMessage();
		}

		var ar = wgt._cacheCtrl.getSelectedSheet(),
			tp = json.type;
		if (ar && tp != 'ack') { 
			var d = json.data,
				tRow = json.top,
				lCol = json.left,
				bRow = tRow + json.height - 1,
				rCol = lCol + json.width - 1;
			ar.update(d);
			wgt.sheetCtrl._cmdBlockUpdate(tp, d.dir, tRow, lCol, bRow, rCol);
		}
		if (token)
			zkS.doCallback(token);
		
		
		if (wgt.sheetCtrl) {
			wgt.sheetCtrl.closeRenderingMessage();
		}
	}
	
	function _doInsertRCCmd (sheet, data, token) {
		sheet._cmdInsertRC(data);
		if (token != "")
			zkS.doCallback(token);	
	}
	function _doRemoveRCCmd (sheet, data, token) {
		sheet._cmdRemoveRC(data, true);
		if (token != "")
			zkS.doCallback(token);
	}
	function _doMergeCmd (sheet, data, token) {
		sheet._cmdMerge(jq.evalJSON(data), true);
		if (token != "")
			zkS.doCallback(token);
	}
	function _doSizeCmd (sheet, data, token) {
		sheet._cmdSize(data, true);
		if (token != "")
			zkS.doCallback(token);
	}
	function _doMaxrowCmd (sheet, data) {
		sheet._cmdMaxrow(data);
	}
	
	function _doMaxcolumnCmd (sheet, data) {
		sheet._cmdMaxcolumn(data);
	}
	
	
	function getCSS (id) {
		var head = document.getElementsByTagName("head")[0];
		for (var n = head.firstChild; n; n = n.nextSibling) {
			if (n.id == id) {
				return n;
			}
		}
		return null;
	}
	
	
	function createSSheet (cssText, id) {
	    var head = document.getElementsByTagName("head")[0],
    		styleObj = document.createElement("style"),
    		sheetobj;
	    jq(styleObj).attr("type", "text/css");
		
	    if (id)
	       jq(styleObj).attr("id", id);
	    if (zk.ie && zk.ie < 11) {
	        head.appendChild(styleObj);
	        sheetobj = styleObj.styleSheet;
	        sheetobj.cssText = cssText;
	    } else {
	        try {
	        	styleObj.appendChild(document.createTextNode(cssText));
	        } catch (e) {
	        	styleObj.cssText = cssText;
	        }
	        head.appendChild(styleObj);
			sheetobj = _getElementSheet(styleObj);
	    }
	    return sheetobj;
	}
	
	function removeSSheet (id) {

		var node = document.getElementById(id);
		if(node && node.type == "text/css"){
			
			if(zk.ie >= 10) {
				node.removeAttribute('href');
			}
			node.parentNode.removeChild(node);
		}
	}
	
	function _getElementSheet () {
		if (zk.ie && zk.ie < 11) {
			return function (element) {
				return element.styleSheet;
			};
		} else {
			return function (element) {
				return element.sheet;
			};
		}
	}
	




























	
	
	function _convertKeyEvent (evt) {
		if (zk.mac && evt.metaKey) {
			evt.ctrlKey = true;
			evt.data.ctrlKey = true;
		}
		return evt;
	}
	

var Spreadsheet = 
zss.Spreadsheet = zk.$extends(zul.wgt.Div, {
	
	_ctrlPasteDown: false,
	
	_linkToNewTab: true, 
	_cellPadding: 2,
	_protect: false,
	_maxRows: 20,
	_maxColumns: 10,
	_rowFreeze: -1,
	_columnFreeze: -1,
	_rowHeight: 20,
	_clientCacheDisabled: false,
	_topPanelHeight: 20,
	_leftPanelWidth: 36,
	_maxRenderedCellSize: 8000,
	_displayGridlines: true,
	_showContextMenu: false,
	_selectionRect: null,
	_focusRect: null,
	_highLightRect: null,
	_colorPickerExUsed: false,
	
	
	
	
	$init: function () {
		this.$supers(Spreadsheet, '$init', arguments);
		
		this.appendChild(this.cave = new zul.layout.Borderlayout({
			vflex: true, sclass: 'zscave'
		}));
		
		this._onResponseCallback = [];
	},
	$define: {
		
		clientCacheDisabled: null,
		
		dataBlockUpdate: _dataUpdate = function (v) {
			var sheet = this.sheetCtrl;
			if (!sheet) return;
			var token = v[0],
				json = jq.evalJSON(v[2]);
			if (sheet._initiated) {
				doBlockUpdate(this, json, token);
			} else {
				sheet.addSSInitLater(doBlockUpdate, this, json, token);
			}
		},
		dataBlockUpdateJump: _dataUpdate,
		dataBlockUpdateEast: _dataUpdate,
		dataBlockUpdateWest: _dataUpdate,
		dataBlockUpdateSouth: _dataUpdate,
		dataBlockUpdateNorth: _dataUpdate,
		dataBlockUpdateError: _dataUpdate,
		
		dataUpdate: _updateCell = function (v) {
			var sheet = this.sheetCtrl;
			if (!sheet)	return;
			var token = v[0],
				shtId = v[1],
				data = v[2];
			
			if (sheet._initiated) {
				doUpdate(this, shtId, data, token);
			} else {
				sheet.addSSInitLater(doUpdate, this, shtId, data, token);
			}
		},
		dataUpdateStart: _updateCell,
		dataUpdateCancel: _updateCell,
		dataUpdateStop: _updateCell,
		dataUpdateRetry: _updateCell,
		redrawWidget: function (v) {
			var	sheet = this.sheetCtrl;
			if (!sheet)	return;
			
			var serverSheetId = v[0],
				wgtUuid = v[1],
				fn = function () {
					var w = zk.Widget.$(wgtUuid);
					if (w)
						w.redrawWidgetTo(sheet);
				};
			if (!this.isSheetCSSReady()) {
				sheet.addSSInitLater(fn);
			} else {
				fn();
			}
		},
		
		insertRowColumn: function (v) {
			var sheet = this.sheetCtrl;
			if (!sheet) return;
			
			var token = v[0],
				data = v[2],
				sheet = this.sheetCtrl;
			if (sheet._initiated)
				_doInsertRCCmd(sheet, data, token);
			else {
				sheet.addSSInitLater(_doInsertRCCmd, sheet, data, token);
			}
		},
		
		removeRowColumn: function (v) {
			var sheet = sheet = this.sheetCtrl;
			if (!sheet) return;
			var token = v[0], 
				data = v[2];

			if (sheet._initiated)
				_doRemoveRCCmd(sheet, data, token);
			else {
				sheet.addSSInitLater(_doRemoveRCCmd, sheet, data, token);
			}
		},
		mergeCell: function (v) {
			var sheet = this.sheetCtrl;
			if (!sheet) return;
			var token = v[0], 
				data = v[2];

			if (sheet._initiated)
				_doMergeCmd(sheet, data, token);
			else {
				sheet.addSSInitLater(_doMergeCmd, sheet, data, token);
			}
		},
		columnSize:  _size = function (v) {
			var sheet = this.sheetCtrl;
			if (!sheet) return;
			
			var data = v[2];
			if (sheet._initiated)
				_doSizeCmd(sheet, data);
			else {
				sheet.addSSInitLater(_doSizeCmd, sheet, data);
			}
		},
		
		
		protect: function (v) {
			var sheetCtrl = this.sheetCtrl;
			if (sheetCtrl) {
				sheetCtrl.fireProtectSheet(v);
				var ls = sheetCtrl.getLastSelection();
				if (v) {
					if (!sheetCtrl.isRangeSelectable(ls.left, ls.top, ls.right, ls.bottom)) {
						sheetCtrl.hideCellFocus();
						sheetCtrl.hideCellSelection();
					}
				} else {
					var pos = sheetCtrl.getLastFocus();
					sheetCtrl.moveCellFocus(pos.row, pos.column, true);
					sheetCtrl.showCellSelection();
				}
			}
			if (this._sheetBar) {
				this._sheetBar.getSheetSelector().setProtectSheetCheckmark(v);
			}
		},
		rowSize: _size,
		preloadRowSize: null,
		preloadColumnSize: null,
		initRowSize: null,
		initColumnSize: null,
		maxRenderedCellSize: null,
		
		
		maxRows: function(maxrows) {
			
			if(this.sheetCtrl) {
				this.sheetCtrl._cmdMaxrow(maxrows);
			}
		},
		
		
		maxColumns: function(maxcols) {
			
			if(this.sheetCtrl) {
				this.sheetCtrl._cmdMaxcolumn(maxcols);
			}
		},
		
		
		rowFreeze: null,
		
		
		columnFreeze: null,
		
		
		columntitle: null,
		
		
		rowtitle: null,
		
		
		rowHeight: null,
		
		
		columnWidth: null,
		
		
		topPanelHeight: null,
		
		
		leftPanelWidth: null,
		
		cellPadding: null,
		
		scss: function (href) {
			var el = this.getCSS();
			if (el && this.bindLevel >= 0) {
				el.href = href;
			}
		},
		
		sheetId: function (id, fromServer, visRange) {
			
			
			
			this._invalidatedSheetId = false;
			
			var sheetCtrl = this.sheetCtrl,
				cacheCtrl = this._cacheCtrl,
				sheetBar = this._sheetBar,
				sheetSelector = sheetBar ? sheetBar.getSheetSelector() : null;
			if (sheetSelector)
				sheetSelector.setSelectedSheet(id);
			if (sheetCtrl && cacheCtrl && cacheCtrl.getSelectedSheet().sheetId != id) { 
				if (!fromServer) {
					cacheCtrl.setSelectedSheetBy(id);	
				}
				sheetCtrl.doSheetSelected(visRange);
			}
			var loadSheetStart = this._loadSheetStart;
			if (loadSheetStart) {
				this._loadSheetStart = false;
			}
		},
		
		
		displayGridlines: function (show) {
			var sheet = this.sheetCtrl;
			if (!sheet) return;

			if (this.isSheetCSSReady()) {
				sheet.setDisplayGridlines(show);
			} else {
				
				sheet.addSSInitLater(function () {
					sheet.setDisplayGridlines(show);
				});
			}
		},
		mergeRange: null,
		autoFilter: null,
		csc: null,
		csr: null,
		
		width: function (v) {
			var sheet = this.sheetCtrl;
			if (sheet)
				sheet.resizeTo(v, null);
		},
		
		height: function (v) {
			var sheet = this.sheetCtrl;
			if (sheet)
				sheet.resizeTo(null, v);
		},
		
		
		rowHeadHidden: null,
		
		
		columnHeadHidden: null,
		
		
		showToolbar: function (show) {
			var w = this._toolbar;
			if (!w && show) {
				var tb = this._toolbar = new zss.Toolbar(this),
					tbp = this.getToolbarPanel();
				tbp.appendChild(tb);
				tbp.setHeight(tb.getSize());
			} else if (w) {
				var v = w.isVisible();
				if (v != show) {
					w.setVisible(show);
					this.getToolbarPanel().setVisible(show);
					zUtl.fireSized(this, -1);
				}
			}
		},
		actionDisabled: function (v) {
			var tb = this._toolbar
			if (tb)
				tb.setDisabled(v);
			if (this.getShowContextMenu()) {
				var shtCtrl = this.sheetCtrl;
				if (shtCtrl) {
					shtCtrl.setActionDisabled(v);
				}
			}
			var sb = this._sheetBar;
			if (sb)
				sb.setDisabled(v);
		},
		
		
		showFormulabar: function (show) {
			var w = this._formulabar;
			if (!w && show) {
				this.cave.appendChild(this._formulabar = new zss.Formulabar(this));
			} else if (w) {
				w.setVisible(show);
			}
		},
		
		
		showSheetbar: function (show) {
			var w = this._sheetBar;
			if (!w && show) {
				this.cave.appendChild(this._sheetBar = new zss.Sheetbar(this));
			} else if (w) {
				w.setVisible(show);
			}
		},
		
		showContextMenu: null,
		
		sheetLabels: function (v) {
			var sheetBar = this._sheetBar;
			if (sheetBar) {
				sheetBar.getSheetSelector().setSheetLabels(v);
			}
		},
		copysrc: null, 
		
		
		doPasteFromServer: null,
		colorPickerExUsed: null,
		
		keepCellSelection: false,
		
		ignoreAutoHeight: false,
		
		
		
		showAddRow: function (show) {
			if (this._addRow != show) {
				this._addRow = show;
				var w = this._sheetBar;
				if (w && w.isVisible()) {
					w.cave.addRowButton.setVisible(show);
				}
			}
		},
		
		
		
		showAddColumn: function (show) {
			if (this._addColumn != show) {
				this._addColumn = show;
				var w = this._sheetBar;
				if (w && w.isVisible()) {
					w.cave.addColButton.setVisible(show);
				}
			}
		}
	},
	
	
	setSelectionRect : function(rect) {
		this._selectionRect = this._narrowRect(rect);
	},
	getSelectionRect : function() {
		return this._selectionRect;
	},
	setFocusRect : function(rect) {
		this._focusRect = this._narrowRect(rect);
	},
	getFocusRect : function() {
		return this._focusRect;
	},
	setHighLightRect : function(rect) {
		this._highLightRect = this._narrowRect(rect);
	},
	getHighLightRect : function() {
		return this._highLightRect;
	},
	
	_narrowRect: function (rect) {
		var r = rect.split(",");
		var left = zk.parseInt(r[0]); 
		var top= zk.parseInt(r[1]); 
		var right = zk.parseInt(r[2]); 
		var bottom = zk.parseInt(r[3]);
		if(right > this._maxColumns - 1) {
			right = this._maxColumns - 1;
		}  
		if(bottom > this._maxRows - 1) {
			bottom = this._maxRows - 1;
		}
		return left + "," + top + "," + right + "," + bottom;
	},
	clearCachedSize_: function () {
		this.getToolbarPanel().clearCachedSize_();
		this.cave.clearCachedSize_();
		this.$supers(zss.Spreadsheet, 'clearCachedSize_', arguments);
	},
	getToolbarPanel: function () {
		var tbp = this._toolbarPanel;
		if (!tbp) {
			tbp = this._toolbarPanel = new zul.layout.Borderlayout({vflex: 'min'});
			this.insertBefore(tbp, this.firstChild);
		}
		return tbp;
	},
	getSheetCSSId: function () {
		return this.uuid + '-sheet';
	},
	getSelectorPrefix: function () {
		return '#' + this.uuid;
	},
	
	isSheetCSSReady: function () {
		if (this._invalidatedSheetId) {
			return false;
		}
		return !!zcss.findRule(this.getSelectorPrefix() + " .zs_indicator_" + this.getSheetId(), this.getSheetCSSId());
	},
	
	setActiveRange: function (v) {
		var c = this._cacheCtrl;
		if (!c) {
			this._cacheCtrl = c = new zss.CacheCtrl(this, v);
			
			var center = new zul.layout.Center({border: 0});
			center.appendChild(this.sheetCtrl = new zss.SSheetCtrl(this));
			this.cave.appendChild(center);
		} else {
			var sheet = this.sheetCtrl,
				range;
			if (sheet) {
				c.setSelectedSheet(v);
				this._triggerContentsChanged = true;
			}
		}
	},








	
	syncWidgetPos: function (row, col) {
		var wgtPanel = this.$n('wp'),
			widgets = jq(this.$n('wp')).children('.zswidget'),
			sheet = this.sheetCtrl,
			size = widgets.length;
		while (size--) {
			var n = widgets[size],
				wgt = zk.Widget.$(n.id);
			if (wgt && ((row >= 0 && wgt.getRow() >= row) || (col >= 0 && wgt.getCol() >= col)))
				wgt.adjustLocation();
		}
	},
	
	setRetrieveFocus: function (v) {
		var sheet = this.sheetCtrl;
		if (!sheet) return;
		
		var v0 = typeof v === 'string' ? jq.evalJSON(v) : v; 
		if (this.isSheetCSSReady()) {
			sheet._cmdRetriveFocus(v0);
		} else {
			sheet.addSSInitLater(function () {
				sheet._cmdRetriveFocus(v0);
			});
		}
	},
	
	setCellFocus: function (v) {
		var sheet = this.sheetCtrl;
		if (!sheet || sheet.isSwitchingSheet) return;

		if (this.isSheetCSSReady()) {
			sheet._cmdCellFocus(v);
		} else {
			
			sheet.addSSInitLater(function () {
				sheet._cmdCellFocus(v);
			});
		}
	},
	
	focus: function (trigger) {
		if (zk.ie && zk.ie < 11) {
			var self = this;
			
				var sht = self.sheetCtrl;
				if (sht && sht._initiated)
					sht.dp.gainFocus(trigger);
			
		} else if (this.sheetCtrl)
			this.sheetCtrl.dp.gainFocus(trigger);
	},
	
	hasFocus: function () {
		return jq.isAncestor(this.$n(), document.activeElement);
	},
	
	moveEditorFocus: function (id, name, color, row, col) {
		if (this.sheetCtrl)
			this.sheetCtrl.moveEditorFocus(id, name, color, zk.parseInt(row), zk.parseInt(col));
	},
	
	removeEditorFocus: function (id) {
		if (this.sheetCtrl)
			this.sheetCtrl.removeEditorFocus(id);
	},
	
	setSelectionHighlight: function (v) {
		var sheet = this.sheetCtrl;
		if (!sheet) return;
		
		if (this.isSheetCSSReady()) {
			sheet._cmdHighlight(v);
		} else {
			
			sheet.addSSInitLater(function () {
				sheet._cmdHighlight(v);
			});
		}
	},
	
	setSelection: function (v) {
		var sheet = this.sheetCtrl;
		if (!sheet || sheet.isSwitchingSheet) return;
		
		var sf = this,
			
			fn = function () {
			if (sf._ctrlPasteDown) {
				sf._afterPasteCallback = function () {
					sheet._cmdSelection(v);
				};
			} else {
				sheet._cmdSelection(v);
			}
		};
		if (this.isSheetCSSReady()) {
			fn();
		} else {
			
			sheet.addSSInitLater(function () {
				fn();
			});
		}
	},
	
	_isFireCellEvt: function (type) {
		var evtnm = zss.Spreadsheet.CELL_MOUSE_EVENT_NAME[type];
		if ('onCellFilter' == evtnm) { 
			return true;
		}
		return evtnm && this.isListen(evtnm, {asapOnly: true});
	},
	
	_isFireHeaderEvt: function (type) {
		var evtnm = zss.Spreadsheet.HEADER_MOUSE_EVENT_NAME[type];
		return evtnm && this.isListen(evtnm, {asapOnly: true});
	},
	
	fireHeaderEvt: function (type, shx, shy, mousemeta, row, col, mx, my) {
		var sheetId = this.getSheetId(),
			prop = {type: type, shx: shx, shy: shy, key: mousemeta, sheetId: sheetId, row: row, col: col, mx: mx, my: my};
		if (this._isFireHeaderEvt(type)) {
			
			
			var self = this;
			setTimeout(function() {
				self.fire('onZSSHeaderMouse', prop, {toServer: true});
			}, 0);
		}
		var evtName = zss.Spreadsheet.HEADER_MOUSE_EVENT_NAME[type];
		if (evtName) {
			var e = new zk.Event(this, evtName, prop);
			e.auStopped = true;
			this.fireX(e);
		}
	},
	
	fireCellEvt: function (type, shx, shy, mousemeta, row, col, mx, my, field) {
		if ('af'==type && this.isProtect() &&
			!this.sheetCtrl._wgt.allowAutoFilter) { 
			return;
		}
		
		var sheetId = this.getSheetId(),
			prop = {type: type, shx: shx, shy: shy, key: mousemeta, sheetId: sheetId, row: row, col: col, mx: mx, my: my};
		if (field)
			prop.field = field;
		if (this._isFireCellEvt(type)) {
			
			
			var self = this;
			setTimeout(function() {
				self.fire('onZSSCellMouse',	prop, {toServer: true}, 25);
			}, 0);
		}
		var evtName = zss.Spreadsheet.CELL_MOUSE_EVENT_NAME[type];
		if (evtName) {
			var e = new zk.Event(this, evtName, prop);
			e.auStopped = true;
			this.fireX(e);
		}
	},
	
	fireWidgetUpdatEvt: function (wgt, action, id, dx1, dy1, dx2, dy2, col1, row1, col2, row2) {
		this.fire('onWidgetUpdate', {sheetId:this.getSheetId(), wgtType: wgt, action: action, wgtId: id, dx1: dx1, dy1: dy1, 
			dx2: dx2, dy2: dy2, col1: col1, row1: row1, col2: col2, row2: row2}, {toServer: true}, 25);
	},
	fireToolbarAction: function (action, extra) {
		var data = {sheetId: this.getSheetId(), tag: 'toolbar', action: action};
		this.fire('onAuxAction', zk.copy(data, extra), {toServer: true});
	},
	fireSheetAction: function (action, extra) {
		var data = {sheetId: this.getSheetId(), tag: 'sheet', action: action};
		this.fire('onAuxAction', zk.copy(data, extra), {toServer: true});
	},
	
	fireRowAction: function (action, extra) {
		var data = {sheetId: this.getSheetId(), tag: 'row', action: action};
		this.fire('onAuxAction', zk.copy(data, extra), {toServer: true});
	},
	
	fireColAction: function (action, extra) {
		var data = {sheetId: this.getSheetId(), tag: 'column', action: action};
		this.fire('onAuxAction', zk.copy(data, extra), {toServer: true});
	},
	
	fetchActiveRange: function (top, left, right, bottom) {
		if (!this._fetchActiveRange) {
			this.sheetCtrl.activeBlock.loadstate = zss.MainBlockCtrl.LOADING;
			this.fire('onZSSFetchActiveRange', 
				{sheetId: this.getSheetId(), top: top, left: left, right: right, bottom: bottom}, {toServer: true});
			this._fetchActiveRange = true;
		}
	},
	
	setActiveRangeUpdate: function (v) {
		this._fetchActiveRange = null;
		var cacheCtrl = this._cacheCtrl;
		if (cacheCtrl) {
			this.sheetCtrl.activeBlock.loadstate = zss.MainBlockCtrl.IDLE;
			cacheCtrl.getSelectedSheet().fetchUpdate(v);
			this.sheetCtrl.activeBlock.loadForVisible(); 
			this.sheetCtrl.sendSyncblock();
			
			
			if (zk.ie && zk.ie == 9) {
				this.sheetCtrl.sp._resetIE9ScrollPosition();
			}
		}
	},
	_initFrozenArea: function () {
		var rowFreeze = this.getRowFreeze(),
			colFreeze = this.getColumnFreeze();
		if ((rowFreeze != undefined && rowFreeze > -1) || (colFreeze != undefined && colFreeze > -1)) { 
			var sheet = this.sheetCtrl;
			if (!sheet) return;
			






		}	
	},
	
	getCSS: function () {
		return getCSS(this.uuid + "-sheet");
	},
	_initControl: function () {
		if (this.getSheetId() == null) 
			return;
		
		var cssId = this.uuid + '-sheet';
		if (!getCSS(cssId)) { 
			zk.loadCSS(this._scss, cssId);
		}
		
		this._initFrozenArea();
	},
	bind_: function (desktop, skipper, after) {
		_calScrollWidth();
		this._initControl();
		this.$supers('bind_', arguments);
		
		var sheet = this.sheetCtrl;
		if (sheet) {
			if (zk.safari) {
				zk(sheet.$n()).redoCSS();
			}
			sheet.fireProtectSheet(this.isProtect());
			sheet.fireDisplayGridlines(this.isDisplayGridlines());
		
			
			if (desktop._tmpSnaps) {
				if (desktop._tmpSnapsTimer) {
					clearTimeout(desktop._tmpSnapsTimer);
					delete desktop._tmpSnapsTimer
				}
				sheet.restorePos_(desktop._tmpSnaps);
				delete desktop._tmpSnaps;
			}
		}
		
		zWatch.listen({onResponse: this});
		
		
		


	},
	unbind_: function () {
		
		if (this._cacheCtrl) {
			var sheetId = this.getSheetId(),
				dt = this.desktop;
			dt._tmpSnaps = this._cacheCtrl.snap(sheetId);
			
			dt._tmpSnapsTimer = setTimeout(function () {
				delete dt._tmpSnaps;
			}, 0);
		}
		
		zWatch.unlisten({onResponse: this});
		
		this._cacheCtrl = this._maxColumnMap = this._maxRowMap = null;
		
		removeSSheet(this.getSheetCSSId());
		this.$supers('unbind_', arguments);
		if (window.CollectGarbage)
			window.CollectGarbage();
		
		
		


	},
	onResponse: function () {
		if (this._triggerContentsChanged != undefined) {
			this.sheetCtrl.fire('onContentsChanged');
			delete this._triggerContentsChanged;
		}

		var fns = this._onResponseCallback,
			fn = null;
		while (fn = fns.shift()) {
			fn();
		}
		this._sendAu = false;
	},
	domClass_: function (no) {
		return 'zssheet';
	},
	
	_doPartnerBlur: function (event) {
		var ssctrl = this.sheetCtrl;
		var w = zk.currentFocus;
		while(w) {
			
			if(w.className.indexOf('zss.') == 0 || w.className.indexOf('zssex.') == 0) {
				return;
			} 
			
			if(w.zssPartner) { 
				ssctrl.dp.gainFocus(false); 
				return;
			}
			w = w.parent; 
		}
		ssctrl.dp._doFocusLost(); 
	}, 
	_doDataPanelBlur: function (evt) {
		var sheet = this.sheetCtrl;
		if (sheet.innerClicking <= 0 && sheet.state == zss.SSheetCtrl.FOCUSED) {
			
			
			if (sheet.isPasteFromClipboard) {
				sheet.dp.gainFocus(false); 
				return;
			}

			
			
			var w = zk.currentFocus;
			
			
			
			if(!w){
				var fdom = document.activeElement;
				if(fdom){
					w = zk.Widget.$(fdom);
				}
			}
			
			while(w) {
				if(w.zssPartner) {	
					sheet.dp.gainFocus(false); 
					return;
				}
				w = w.parent; 
			}
			sheet.dp._doFocusLost(); 
			
			
			
		} else if(sheet.state == zss.SSheetCtrl.FOCUSED) {
			
			sheet.dp.gainFocus(false);
		}
	},
	_doDataPanelFocus: function (evt) {
		var sheet = this.sheetCtrl;
		if (sheet.state < zss.SSheetCtrl.FOCUSED)
			sheet.dp.gainFocus(false);
	},
	_doSelAreaMouseMove: function (evt) {
		var sel = this.sheetCtrl.selArea;
		if (sel)
			sel._doMouseMove(evt);
	},
	_doSelAreaMouseOut: function (evt) {
		var sel = this.sheetCtrl.selArea;
		if (sel)
			sel._doMouseOut(evt);
	},
	doClick_: function (evt) {
		if (this.sheetCtrl)
			this.sheetCtrl._doMouseleftclick(evt);
		this.$supers('doClick_', arguments);
	},
	
	doMouseDown_: function (evt) {
		if (this.sheetCtrl)
			this.sheetCtrl._doMousedown(evt);
		this.$supers('doMouseDown_', arguments);
	},
	
	_checkContext : function () {
		var ctxnm = this.getContext(),
			ctxpop = ctxnm ? this.$f(ctxnm) : null,
			ss = this;
		if (ctxpop != this._ctxpopwgt) {
			if (this._ctxpopwgt) {
				this._ctxpopwgt.unlisten({onOpen: [ss, ss._onOpenCtxpop]});
				delete this._ctxpopwgt;
			}
			if (ctxpop) {
				this._ctxpopwgt = ctxpop;
				ctxpop.listen({onOpen: [ss, ss._onOpenCtxpop]})
			}
		}
		if (this._closingCtxpop) {
			this.focus(); 
			this._closingCtxpop = false;
		}
		
	},
	
	_onOpenCtxpop : function (evt) {
		this._closingCtxpop = !evt.open;
		var ss = this;
		if (!evt.open) {
			setTimeout(function() { 
				ss._closingCtxpop = false;
			}, 0);
		}
	},
	doMouseUp_: function (evt) {
		if (this.sheetCtrl)
			this.sheetCtrl._doMouseup(evt);
		this.$supers('doMouseUp_', arguments);
	},
	doRightClick_: function (evt) {
		if (this.sheetCtrl)
			this.sheetCtrl._doMouserightclick(evt);
		this.$supers('doRightClick_', arguments);
	},
	doDoubleClick_: function (evt) {
		if (this.sheetCtrl)
			this.sheetCtrl._doMousedblclick(evt);
		this.$supers('doDoubleClick_', arguments);
	},
	_doDragMouseUp: function (evt) {
		var dragHandler = this.sheetCtrl.dragging;
		if (dragHandler)
			dragHandler.doMouseup(evt);
	},
	_doDragMouseDown: function (evt) {
		var dragHandler = this.sheetCtrl.dragging;
		if (dragHandler)
			dragHandler.doMousemove(evt);
	},
	_releaseClientCache: function (sheetId){
		if(this._cacheCtrl){
			this._cacheCtrl.releaseCache(sheetId);
		}
	},
	
	_releaseSelectedCache: function (sheetId) {
		if(this._cacheCtrl){
			this._cacheCtrl.releaseSelectedCache(sheetId);
		}
	},
	sendAU_: function (evt, timeout, opts) {
		if (evt.name == 'onCtrlKey') {
			
			
			timeout = 0;
		}
		this._sendAu = true;
		this.$supers('sendAU_', arguments);
	},
	doKeyDown_: function (evt) {
		evt = _convertKeyEvent(evt);
		var sheet = this.sheetCtrl;
		if (sheet) {
			sheet._doKeydown(evt);
			
			
			if (evt.ctrlKey && evt.keyCode == 86) {
				this._ctrlPasteDown = true;
			}
		}
		this.$supers('doKeyDown_', arguments);
	},
	afterKeyDown_: function (evt) {
		var sheet = this.sheetCtrl; 
		if (sheet && sheet.state != zss.SSheetCtrl.EDITING) {
			var data = evt.data,
				sel = sheet.getLastSelection();
			if (sel) {
				data.tRow = sel.top;
				data.lCol = sel.left;
				data.bRow = sel.bottom;
				data.rCol = sel.right;
				data.type = sheet.selType ? sheet.selType : zss.SEL.CELL; 
			}
			data.sheetId = this.getSheetId();
			this.$supers('afterKeyDown_', arguments);
			
			var keyCode = evt.keyCode;
			if (this.isListen('onCtrlKey', {any:true}) && 
				(keyCode == 67 || keyCode == 86)) { 
				var parsed = this._parsedCtlKeys,
					ctrlKey = evt.ctrlKey ? 1: evt.altKey ? 2: evt.shiftKey ? 3: 0;
				if (parsed && 
					parsed[ctrlKey][keyCode]) {
					
					evt.domStopped = false;
				}

				
				sheet.isPasteFromClipboard = true;
				sheet.dp.selectInputNode();
				var that = this;
				
				
				setTimeout(function(){ that.doPaste(); }, 0);
			}
		}
		
	},
	doKeyPress_: function (evt) {
		evt = _convertKeyEvent(evt);
		if (this.sheetCtrl)
			this.sheetCtrl._doKeypress(evt);
		this.$supers('doKeyPress_', arguments);
	},
	doKeyUp_: function (evt) {
		this.$supers('doKeyUp_', arguments);
		this._ctrlPasteDown = false;
	},
	
	doPaste: function () {
		if (!this._ctrlPasteDown)
			return;

		var sl = this,
			sheet = this.sheetCtrl,
			clearFn = function () {
				sl._doPasteFromServer = false;
			};
		if (sheet && sheet.state == zss.SSheetCtrl.FOCUSED) {
			sheet.pasteToSheet();
			
			var fn = this._afterPasteCallback;
			if (fn) {
				fn();
				delete this._afterPasteCallback;
			}
		}
		
		if (this._sendAu) {
			this._onResponseCallback.push(clearFn);
		} else {
			clearFn();
		}
	},
	linkTo: function (href, type, evt) {
		
		
		
		
		if (type == 1) {
			if (this._linkToNewTab || evt.ctrlKey) 
				window.open(href);
			else 
				window.location.href = href;
		} else if (type == 3) { 
			window.location.href = href;
			this._skipOnbeforeunloadOnce(); 
		}

			

			
	},
	
	
	_skipOnbeforeunloadOnce: function() {
		var _oldBfUnload = window.onbeforeunload;
		window.onbeforeunload = function () {
			window.onbeforeunload = _oldBfUnload;
		};
	},
	
	setCtrlArrowMoveFocus: function (v) {
		var sheetId = v.sheetId,
			row = v.row,
			col = v.col;
		if (sheetId != this.getSheetId()) return;
		var ssctrl = this.sheetCtrl;
		ssctrl.dp.moveFocus(row, col, true, true);
	},
	
	setShiftPosFocus: function (v) {
		var sheetId = v.sheetId,
			row = v.row,
			col = v.col;
		if (sheetId != this.getSheetId()) return;
		var ssctrl = this.sheetCtrl;
		ssctrl.dp.moveFocus(row, col, true, true);
	}
}, {
	CELL_MOUSE_EVENT_NAME: {lc:'onCellClick', rc:'onCellRightClick', dbc:'onCellDoubleClick', af:'onCellFilter', dv:'onCellValidator'},
	HEADER_MOUSE_EVENT_NAME: {lc:'onHeaderClick', rc:'onHeaderRightClick', dbc:'onHeaderDoubleClick'},
	SRC_CMD_SET_COL_WIDTH: 'setColWidth',
	initLaterAfterCssReady: function (sheet) {
		var wgt = sheet._wgt,
			sheetId = wgt.getSheetId();
		if (wgt.isSheetCSSReady()) {
			sheet._initiated = true;
			
			
			
			
			
			sheet._doSSInitLater();
			if (sheet._initmove) {
				sheet.showMask(false);
			} else if(zk(sheet._wgt).isRealVisible() &&	!sheet.activeBlock.loadForVisible()){
				
				sheet.showMask(false);
			}
			if (zk.opera)
				
				
				createSSheet("", wgt.uuid + "-sheet-opera");
			
			
			if (zk.ie6_ || zk.ie7_)
				jq(sheet.activeBlock.comp).toggleClass('zssnosuch');
			
			
			setTimeout(function(){
				sheet.activeBlock.loadForVisible();
				
				
				sheet.getStyleMenupopup();
			},25);
			
		} else {
			setTimeout(function () {
				zss.Spreadsheet.initLaterAfterCssReady(sheet);
			}, 1);
		}		
	}
});


})();
