/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.SSheetProtection;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractRowAdv;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.Command;
import io.keikai.ui.impl.HeaderPositionHelper;
import io.keikai.ui.impl.UnlockedCellsHelper;
import io.keikai.ui.sys.SpreadsheetCtrl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class ShiftPosCommand
extends AbstractCommand
implements Command {
    @Override
    public void process(AuRequest request) {
        SSheet sheet;
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, ShiftPosCommand.class);
        }
        Map data = request.getData();
        if (data == null || data.size() != 4) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), ShiftPosCommand.class});
        }
        Spreadsheet spreadsheet = (Spreadsheet)comp;
        String sheetId = (String)data.get("sheetId");
        if (!sheetId.equals((sheet = spreadsheet.getSelectedSSheet()).getId())) {
            return;
        }
        int[] index = this.unlockedIndex(spreadsheet, sheet, data);
        if (index != null) {
            SSheetProtection prot;
            int rowIdx = index[0];
            int colIdx = index[1];
            if (sheet.isProtected() && (prot = sheet.getSheetProtection()) != null) {
                if (prot.isSelectUnlockedCells()) {
                    SCellStyle style = sheet.getCell(rowIdx, colIdx).getCellStyle();
                    if (style.isLocked()) {
                        return;
                    }
                } else {
                    return;
                }
            }
            JSONObject param = new JSONObject();
            param.put((Object)"sheetId", (Object)sheetId);
            param.put((Object)"row", (Object)rowIdx);
            param.put((Object)"col", (Object)colIdx);
            spreadsheet.smartUpdate("ctrlArrowMoveFocus", param);
        }
    }

    private int[] unlockedIndex(Spreadsheet spreadsheet, SSheet sheet, Map data) {
        String sheetId = (String)data.get("sheetId");
        int rowIdx = (Integer)data.get("row");
        int colIdx = (Integer)data.get("col");
        String dir = (String)data.get("dir");
        if ("home".equals(dir)) {
            return this.unlockedIndex0(spreadsheet, sheet, data, sheetId, 0, -1, "right");
        }
        if ("end".equals(dir)) {
            return this.unlockedIndex0(spreadsheet, sheet, data, sheetId, spreadsheet.getCurrentMaxVisibleRows() - 1, spreadsheet.getCurrentMaxVisibleColumns(), "left");
        }
        return this.unlockedIndex0(spreadsheet, sheet, data, sheetId, rowIdx, colIdx, dir);
    }

    private int[] unlockedIndex0(Spreadsheet spreadsheet, SSheet sheet, Map data, String sheetId, int rowIdx, int colIdx, String dir) {
        int rowIdx0 = rowIdx;
        int colIdx0 = colIdx;
        SpreadsheetCtrl spreadsheetCtrl = (SpreadsheetCtrl)spreadsheet.getExtraCtrl();
        HeaderPositionHelper rhHelper = spreadsheetCtrl.getRowPositionHelper(sheetId);
        HeaderPositionHelper chHelper = spreadsheetCtrl.getColumnPositionHelper(sheetId);
        if ("left".equals(dir)) {
            boolean cycle = false;
            while (!cycle || rowIdx > rowIdx0 || rowIdx == rowIdx0 && colIdx > colIdx0) {
                UnlockedCellsHelper helper = this.createColumnUnlockedCellsHelper(sheet, rowIdx);
                if (helper == null) {
                    rowIdx = rhHelper.getPrevNonHidden(rowIdx);
                    colIdx = spreadsheet.getCurrentMaxVisibleColumns();
                    if (rowIdx >= 0) continue;
                    rowIdx = spreadsheet.getCurrentMaxVisibleRows() - 1;
                    cycle = true;
                    continue;
                }
                int prev = colIdx;
                while ((prev = helper.getPrevUnlocked(prev)) >= 0) {
                    if (chHelper.isHidden(prev)) continue;
                    int[] result = new int[]{rowIdx, prev};
                    return result;
                }
                rowIdx = rhHelper.getPrevNonHidden(rowIdx);
                colIdx = spreadsheet.getCurrentMaxVisibleColumns();
                if (rowIdx >= 0) continue;
                rowIdx = spreadsheet.getCurrentMaxVisibleRows() - 1;
                cycle = true;
            }
            return null;
        }
        if ("right".equals(dir)) {
            boolean cycle = false;
            block2: while (!cycle || rowIdx < rowIdx0 || rowIdx == rowIdx0 && colIdx < colIdx0) {
                UnlockedCellsHelper helper = this.createColumnUnlockedCellsHelper(sheet, rowIdx);
                if (helper == null) {
                    rowIdx = rhHelper.getNextNonHidden(rowIdx);
                    colIdx = -1;
                    if (rowIdx >= 0 && rowIdx < spreadsheet.getCurrentMaxVisibleRows()) continue;
                    rowIdx = 0;
                    cycle = true;
                    continue;
                }
                int next = colIdx;
                while ((next = helper.getNextUnlocked(next)) >= 0) {
                    if (chHelper.isHidden(next)) continue;
                    if (next >= spreadsheet.getCurrentMaxVisibleColumns()) {
                        rowIdx = rhHelper.getNextNonHidden(rowIdx);
                        colIdx = -1;
                        if (rowIdx >= 0 && rowIdx < spreadsheet.getCurrentMaxVisibleRows()) continue block2;
                        rowIdx = 0;
                        cycle = true;
                        continue block2;
                    }
                    int[] result = new int[]{rowIdx, next};
                    return result;
                }
                rowIdx = rhHelper.getNextNonHidden(rowIdx);
                colIdx = -1;
                if (rowIdx >= 0 && rowIdx < spreadsheet.getCurrentMaxVisibleRows()) continue;
                rowIdx = 0;
                cycle = true;
            }
            return null;
        }
        if ("up".equals(dir)) {
            boolean cycle = false;
            while (!cycle || colIdx > colIdx0 || colIdx == colIdx0 && rowIdx > rowIdx0) {
                UnlockedCellsHelper helper = this.createRowUnlockedCellsHelper(sheet, colIdx);
                if (helper == null) {
                    colIdx = chHelper.getPrevNonHidden(colIdx);
                    rowIdx = spreadsheet.getCurrentMaxVisibleRows();
                    if (colIdx >= 0) continue;
                    colIdx = spreadsheet.getCurrentMaxVisibleColumns() - 1;
                    cycle = true;
                    continue;
                }
                int prev = rowIdx;
                while ((prev = helper.getPrevUnlocked(prev)) >= 0) {
                    if (rhHelper.isHidden(prev)) continue;
                    int[] result = new int[]{prev, colIdx};
                    return result;
                }
                colIdx = chHelper.getPrevNonHidden(colIdx);
                rowIdx = spreadsheet.getCurrentMaxVisibleRows();
                if (colIdx >= 0) continue;
                colIdx = spreadsheet.getCurrentMaxVisibleColumns() - 1;
                cycle = true;
            }
            return null;
        }
        if ("down".equals(dir)) {
            boolean cycle = false;
            block6: while (!cycle || colIdx < colIdx0 || colIdx == colIdx0 && rowIdx < rowIdx0) {
                UnlockedCellsHelper helper = this.createRowUnlockedCellsHelper(sheet, colIdx);
                if (helper == null) {
                    colIdx = chHelper.getNextNonHidden(colIdx);
                    rowIdx = -1;
                    if (colIdx >= 0 && colIdx < spreadsheet.getCurrentMaxVisibleColumns()) continue;
                    colIdx = 0;
                    cycle = true;
                    continue;
                }
                int next = rowIdx;
                while ((next = helper.getNextUnlocked(next)) >= 0) {
                    if (rhHelper.isHidden(next)) continue;
                    if (next >= spreadsheet.getCurrentMaxVisibleRows()) {
                        colIdx = chHelper.getNextNonHidden(colIdx);
                        rowIdx = -1;
                        if (colIdx >= 0 && colIdx < spreadsheet.getCurrentMaxVisibleColumns()) continue block6;
                        colIdx = 0;
                        cycle = true;
                        continue block6;
                    }
                    int[] result = new int[]{next, colIdx};
                    return result;
                }
                colIdx = chHelper.getNextNonHidden(colIdx);
                rowIdx = -1;
                if (colIdx >= 0 && colIdx < spreadsheet.getCurrentMaxVisibleColumns()) continue;
                colIdx = 0;
                cycle = true;
            }
            return null;
        }
        throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), ShiftPosCommand.class});
    }

    private UnlockedCellsHelper createColumnUnlockedCellsHelper(SSheet sheet, int rowIdx) {
        int start = -1;
        int end = -1;
        SRow row = sheet.getRow(rowIdx);
        if (row == null) {
            return null;
        }
        ArrayList<UnlockedCellsHelper.UnlockedCellInfo> infos = new ArrayList<UnlockedCellsHelper.UnlockedCellInfo>();
        Iterator it = row.getCellIterator();
        while (it.hasNext()) {
            SCell cell = (SCell)it.next();
            if (cell == null || cell.isNull() || cell.getCellStyle().isLocked()) {
                if (start < 0) continue;
                infos.add(new UnlockedCellsHelper.UnlockedCellInfo(start, end));
                start = -1;
                end = -1;
                continue;
            }
            int colIdx = cell.getColumnIndex();
            if (start < 0) {
                start = end = colIdx;
                continue;
            }
            if (end + 1 == colIdx) {
                end = colIdx;
                continue;
            }
            infos.add(new UnlockedCellsHelper.UnlockedCellInfo(start, end));
            start = end = colIdx;
        }
        if (start >= 0) {
            infos.add(new UnlockedCellsHelper.UnlockedCellInfo(start, end));
        }
        return infos.isEmpty() ? null : new UnlockedCellsHelper(infos);
    }

    private UnlockedCellsHelper createRowUnlockedCellsHelper(SSheet sheet, int columnIdx) {
        int start = -1;
        int end = -1;
        ArrayList<UnlockedCellsHelper.UnlockedCellInfo> infos = new ArrayList<UnlockedCellsHelper.UnlockedCellInfo>();
        Iterator it = sheet.getRowIterator();
        while (it.hasNext()) {
            SRow row = (SRow)it.next();
            AbstractCellAdv cell = ((AbstractRowAdv)row).getCell(columnIdx, false);
            if (cell == null || cell.isNull() || cell.getCellStyle().isLocked()) {
                if (start < 0) continue;
                infos.add(new UnlockedCellsHelper.UnlockedCellInfo(start, end));
                start = -1;
                end = -1;
                continue;
            }
            int rowIdx = row.getIndex();
            if (start < 0) {
                start = end = rowIdx;
                continue;
            }
            if (end + 1 == rowIdx) {
                end = rowIdx;
                continue;
            }
            infos.add(new UnlockedCellsHelper.UnlockedCellInfo(start, end));
            start = end = rowIdx;
        }
        if (start >= 0) {
            infos.add(new UnlockedCellsHelper.UnlockedCellInfo(start, end));
        }
        return infos.isEmpty() ? null : new UnlockedCellsHelper(infos);
    }
}

