/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.api.model.Chart;
import io.keikai.api.model.Picture;
import io.keikai.api.model.Sheet;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.Command;
import io.keikai.ui.event.KeyEvent;
import io.keikai.ui.event.WidgetKeyEvent;
import java.util.Map;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

public class CtrlKeyCommand
extends AbstractCommand
implements Command {
    @Override
    public void process(AuRequest request) {
        Map data = request.getData();
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        Sheet sheet = ((Spreadsheet)comp).getSelectedSheet();
        String sheetId = (String)data.get("sheetId");
        if (!CtrlKeyCommand.getSheetUuid(sheet).equals(sheetId)) {
            return;
        }
        Boolean widgetType = (Boolean)data.get("wgt");
        if (widgetType != null && widgetType.booleanValue()) {
            this.handleWidgetKeyDown(request);
        } else {
            this.handleSpreadsheetKeyDown(request);
        }
    }

    private void handleSpreadsheetKeyDown(AuRequest request) {
        Map data = request.getData();
        org.zkoss.zk.ui.event.KeyEvent evt = KeyEvent.getKeyEvent((AuRequest)request);
        KeyEvent zssKeyEvt = new KeyEvent("onCtrlKey", evt.getTarget(), evt.getKeyCode(), evt.isCtrlKey(), evt.isShiftKey(), evt.isAltKey(), AuRequests.getInt((Map)data, (String)"tRow", (int)-1), AuRequests.getInt((Map)data, (String)"lCol", (int)-1), AuRequests.getInt((Map)data, (String)"bRow", (int)-1), AuRequests.getInt((Map)data, (String)"rCol", (int)-1));
        Events.postEvent((Event)zssKeyEvt);
    }

    private void handleWidgetKeyDown(AuRequest request) {
        Map data = request.getData();
        Component comp = request.getComponent();
        Sheet sheet = ((Spreadsheet)comp).getSelectedSheet();
        String widgetType = (String)data.get("wgtType");
        org.zkoss.zk.ui.event.KeyEvent evt = KeyEvent.getKeyEvent((AuRequest)request);
        Object widgetData = null;
        String id = (String)data.get("wgtId");
        if ("image".equals(widgetType)) {
            for (Picture p : sheet.getPictures()) {
                if (!p.getId().equals(id)) continue;
                widgetData = p;
                break;
            }
        } else if ("chart".equals(widgetType)) {
            for (Chart c : sheet.getCharts()) {
                if (!c.getId().equals(id)) continue;
                widgetData = c;
                break;
            }
        }
        if (widgetData == null) {
            return;
        }
        WidgetKeyEvent zssKeyEvt = new WidgetKeyEvent("onWidgetCtrlKey", evt.getTarget(), sheet, widgetData, evt.getKeyCode(), evt.isCtrlKey(), evt.isShiftKey(), evt.isAltKey());
        Events.postEvent((Event)zssKeyEvt);
    }
}

