



zkS = {};


zkS.t = function (val) {
	return val || val === 0;
};

zkS._delayInit = false;
zkS._delayQ = [];
zkS._delayBatchSize = 50;
zkS._delaySched = false;
zkS.addDelayBatch = function(fn, front, arg0, arg1){
	if (front) {
		zkS._delayQ.unshift([fn, arg0, arg1]);
	} else {
		zkS._delayQ.push([fn, arg0, arg1]);
	}
	if (!zkS._delaySched) {
		zkS._delaySched = true;
		setTimeout(zkS._doDelayBatch, 250);
	}
};


zkS._doDelayBatch = function () {
	zkS._delaySched = false;	
	var size = zkS._delayQ.length;
	size = zkS._delayBatchSize > size ? size : zkS._delayBatchSize;
	var batch;

	for (var i = 0; i < size; i++) {
		batch = zkS._delayQ.shift();
		batch[0].call(this,batch[1], batch[2]);
	}
	batch = null;
	if (zkS._delayQ.length > 0 && !zkS._delaySched) {
		zkS._delaySched = true;
		setTimeout(zkS._doDelayBatch, 100);
	}
};



zkS._callbacks = {};
zkS._cbtoken = 0;

zkS.addCallback = function(fn, arg0, arg1){
	var token = (zkS._cbtoken++) + '';
	zkS._callbacks[token] = [fn, arg0, arg1];
	if(zkS._cbtoken > 9999) zkS._cbtoken = 0;
	return  token;
};
zkS.removeCallback = function (token) {
	var r = zkS._callbacks[token];
	if (r)
		delete zkS._callbacks[token];
};
zkS.doCallback = function (token) {
	var r = zkS._callbacks[token];
	if (r) {
		delete zkS._callbacks[token];
		r[0].call(this, r[1], r[2]);
	}
};


zkS.parentByZSType = function(el, type, pathlen) {
	if (el) {
		if (!(type instanceof Array))
			type = [type];
		var i = 0,
			size = type.length, 
			n = el;
		for(; !!n; n = n.parentNode) {
			if (!n.attributes) 
				continue;
			j = size;
			while (j--) {
				if (n.getAttribute('zs.t') == type[j])
					return n;
			}
			if (pathlen && i++ > pathlen)
				break;
		}
	}
	return null;
};

zkS.copyParm = function (src, dest, parms) {
	var i = parms.length;
	while(i--)
		dest[parms[i]] = src[parms[i]];	
};


zkS._getMouseData = function (evt, target) {
	var extra = "";
	if (evt.altKey) extra += "a";
	if (evt.ctrlKey) extra += "c";
	if (evt.shiftKey) extra += "s";
	
	var ofs = zk(target).cmOffset(target),
		x = evt.pageX - ofs[0],
		y = evt.pageY - ofs[1];

	return [x, y, extra];
};


zkS.isEvtKey = function (evt, flag) {
	if (evt && ((flag.indexOf("a") != -1 && evt.altKey) || 
		(flag.indexOf("c") != -1 && evt.ctrlKey) ||
		(flag.indexOf("s") !=- 1 && evt.shiftKey) )) return true;
	return false;
};



zkS._hasScrollBar = function (cmp, vert) {
	var off,
		client;
	if(vert){
		off = cmp.offsetWidth;
		client = cmp.clientWidth;
	}else{
		off = cmp.offsetHeight;
		client = cmp.clientHeight;  
	}
	return (off - client) > 3 ? true : false;
};

zkS._enterChar = String.fromCharCode(13);


zkS.isOverlapByPoint = function(element, x, y) {
	var zkElement = zk(element),
		offset = zkElement.revisedOffset(),
		x1 = offset[0],
		y1 = offset[1],
		x2 = x1 + zkElement.offsetWidth(),
		y2 = y1 + zkElement.offsetHeight();
	return x >= x1 && x <= x2 && y >= y1 && y <= y2;
}


zkS._ZERO = '0'.charAt(0);
zkS._NINE = '9'.charAt(0);

zkS.isSingleDigit = function(val) {
	if (val === undefined || val.length != 1) {
		return false;
	}
	var character = val.charAt(0);
	return zkS._ZERO <= character && character <= zkS._NINE;
}

