/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl;

import io.keikai.ui.impl.MergeMatrixHelper;
import io.keikai.ui.impl.MergedRect;
import io.keikai.ui.impl.StringAggregation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;

public class MergeAggregation
implements Serializable {
    private static final long serialVersionUID = 4027477853452038589L;
    private MergeMatrixHelper _helper;
    private StringAggregation _mergeCSS = new StringAggregation();
    private LinkedHashMap<Integer, Integer> _mergeIds = new LinkedHashMap();

    public MergeAggregation(MergeMatrixHelper helper) {
        this._helper = helper;
    }

    public MergeIndex add(int row, int col) {
        int index = -1;
        MergedRect block = this._helper.getMergeRange(row, col);
        if (block != null) {
            Integer id = block.getId();
            if (this._mergeIds.containsKey(id)) {
                index = this._mergeIds.get(id);
            } else {
                index = this._mergeIds.size();
                this._mergeIds.put(id, index);
            }
            String css = "";
            boolean isLeftTop = this._helper.isMergeRangeLeftTop(row, col);
            css = isLeftTop ? "zsmerge" + id : (block.getRow() == row ? "zsmergee" : "zsmergeeu");
            return new MergeIndex(index, this._mergeCSS.add(css));
        }
        return null;
    }

    public MergedRect getMergedRect(int row, int col) {
        return this._helper.getMergeRange(row, col);
    }

    public JSONObject getJSONObject() {
        JSONObject result = new JSONObject();
        result.put((Object)"r", (Object)this.getMerge());
        result.put((Object)"cs", (Object)this.getMergeCSS());
        return result;
    }

    private JSONArray getMerge() {
        JSONArray ary = new JSONArray();
        for (Integer id : this._mergeIds.keySet()) {
            ary.add(this.newMergeAttributes(this._helper.getMergedRect(id)));
        }
        return ary;
    }

    private HashMap<String, Integer> newMergeAttributes(MergedRect rect) {
        HashMap<String, Integer> attrs = new HashMap<String, Integer>(5);
        attrs.put("i", rect.getId());
        attrs.put("l", rect.getColumn());
        attrs.put("t", rect.getRow());
        attrs.put("r", rect.getLastColumn());
        attrs.put("b", rect.getLastRow());
        return attrs;
    }

    private JSONArray getMergeCSS() {
        return this._mergeCSS.getJSONArray();
    }

    public class MergeIndex {
        int mergeId;
        int mergeCSSId;

        MergeIndex(int id, int cssId) {
            this.mergeId = id;
            this.mergeCSSId = cssId;
        }

        public int getMergeId() {
            return this.mergeId;
        }

        public int getMergeCSSId() {
            return this.mergeCSSId;
        }
    }
}

