/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.api.model.Sheet;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.Command;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class TextWidthCommand
extends AbstractCommand
implements Command {
    public static final String Command = "onZSSTextWidth";

    @Override
    public void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)TextWidthCommand.class.getCanonicalName());
        }
        Map data = request.getData();
        if (data == null || data.size() != 4) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), TextWidthCommand.class.getCanonicalName()});
        }
        String sheetId = (String)data.get("sheetId");
        Sheet sheet = ((Spreadsheet)comp).getSelectedSheet();
        if (!TextWidthCommand.getSheetUuid(sheet).equals(sheetId)) {
            return;
        }
        int row = (Integer)data.get("row");
        int col = (Integer)data.get("col");
        int width = (Integer)data.get("width");
        ((AbstractCellAdv)sheet.getInternalSheet().getCell(row, col)).setTextWidth(width);
    }
}

