/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.ErrorValue;
import io.keikai.model.InvalidFormulaException;
import io.keikai.model.SBook;
import io.keikai.model.SBookSeries;
import io.keikai.model.SCell;
import io.keikai.model.SDataValidation;
import io.keikai.model.SSheet;
import io.keikai.model.impl.AbstractBookSeriesAdv;
import io.keikai.model.impl.AbstractDataValidationAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.EvaluationUtil;
import io.keikai.model.impl.ModelUpdateUtil;
import io.keikai.model.impl.ObjectRefImpl;
import io.keikai.model.impl.RefImpl;
import io.keikai.model.impl.sys.DependencyTableAdv;
import io.keikai.model.impl.sys.FormatEngineImpl;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.dependency.DependencyTable;
import io.keikai.model.sys.dependency.ObjectRef;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.sys.formula.EvaluationResult;
import io.keikai.model.sys.formula.FormulaEngine;
import io.keikai.model.sys.formula.FormulaEvaluationContext;
import io.keikai.model.sys.formula.FormulaExpression;
import io.keikai.model.sys.formula.FormulaParseContext;
import io.keikai.model.sys.input.InputEngine;
import io.keikai.model.sys.input.InputParseContext;
import io.keikai.model.sys.input.InputResult;
import io.keikai.model.util.Validations;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.zkoss.lang.Strings;
import org.zkoss.poi.ss.formula.LazyAreaEval;
import org.zkoss.poi.ss.formula.LazyRefEval;
import org.zkoss.poi.ss.formula.eval.StringEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.ptg.BoolPtg;
import org.zkoss.poi.ss.formula.ptg.ErrPtg;
import org.zkoss.poi.ss.formula.ptg.IntPtg;
import org.zkoss.poi.ss.formula.ptg.NumberPtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.formula.ptg.StringPtg;
import org.zkoss.poi.ss.usermodel.DataFormatter;
import org.zkoss.poi.ss.usermodel.ZssContext;

public class DataValidationImpl
extends AbstractDataValidationAdv {
    private static final long serialVersionUID = 1L;
    private AbstractSheetAdv _sheet;
    private final String _id;
    private SDataValidation.AlertStyle _alertStyle = SDataValidation.AlertStyle.STOP;
    private boolean _ignoreBlank = true;
    private boolean _showInCellDropdown;
    private boolean _showInput;
    private boolean _showError;
    private String _inputTitle;
    private String _inputMessage;
    private String _errorTitle;
    private String _errorMessage;
    private LinkedHashSet<CellRegion> _regions;
    private SDataValidation.ValidationType _validationType = SDataValidation.ValidationType.ANY;
    private SDataValidation.OperatorType _operatorType = SDataValidation.OperatorType.BETWEEN;
    private FormulaExpression _formula1Expr;
    private FormulaExpression _formula2Expr;
    private Object _evalValue1Result;
    private Object _evalValue2Result;
    private ValueEval _evalValue1EvalResult;
    private ValueEval _evalValue2EvalResult;
    private boolean _evaluated = false;

    public DataValidationImpl(AbstractSheetAdv sheet, String id) {
        this._sheet = sheet;
        this._id = id;
    }

    public DataValidationImpl(AbstractSheetAdv sheet, AbstractDataValidationAdv copyFrom) {
        this(sheet, (String)null);
        if (copyFrom != null) {
            this.copyFrom(copyFrom);
        }
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public SSheet getSheet() {
        return this._sheet;
    }

    @Override
    public void checkOrphan() {
        if (this._sheet == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    @Override
    public void destroy() {
        this.checkOrphan();
        this.clearFormulaDependency(true);
        this.clearFormulaResultCache();
        this._sheet = null;
    }

    @Override
    public SDataValidation.AlertStyle getAlertStyle() {
        return this._alertStyle;
    }

    @Override
    public void setAlertStyle(SDataValidation.AlertStyle alertStyle) {
        Validations.argNotNull(new Object[]{alertStyle});
        this._alertStyle = alertStyle;
    }

    @Override
    public void setIgnoreBlank(boolean allowed) {
        this._ignoreBlank = allowed;
    }

    @Override
    public boolean isIgnoreBlank() {
        return this._ignoreBlank;
    }

    @Override
    public void setInCellDropdown(boolean show) {
        this._showInCellDropdown = show;
    }

    @Override
    public boolean isInCellDropdown() {
        return this._showInCellDropdown;
    }

    @Override
    public void setShowInput(boolean show) {
        this._showInput = show;
    }

    @Override
    public boolean isShowInput() {
        return this._showInput;
    }

    @Override
    public void setShowError(boolean show) {
        this._showError = show;
    }

    @Override
    public boolean isShowError() {
        return this._showError;
    }

    @Override
    public void setInputTitle(String title) {
        this._inputTitle = title;
    }

    @Override
    public void setInputMessage(String message) {
        this._inputMessage = message;
    }

    @Override
    public String getInputTitle() {
        return this._inputTitle;
    }

    @Override
    public String getInputMessage() {
        return this._inputMessage;
    }

    @Override
    public void setErrorTitle(String title) {
        this._errorTitle = title;
    }

    @Override
    public void setErrorMessage(String text) {
        this._errorMessage = text;
    }

    @Override
    public String getErrorTitle() {
        return this._errorTitle;
    }

    @Override
    public String getErrorMessage() {
        return this._errorMessage;
    }

    @Override
    public Set<CellRegion> getRegions() {
        return this._regions;
    }

    @Override
    public void addRegion(CellRegion region) {
        Validations.argNotNull(region);
        if (this._regions == null) {
            this._regions = new LinkedHashSet(2);
        }
        for (CellRegion regn : this._regions) {
            if (!regn.contains(region)) continue;
            return;
        }
        this._regions.add(region);
        Ref dependent = this.getRef();
        SBook book = this._sheet.getBook();
        DependencyTable dt = ((AbstractBookSeriesAdv)book.getBookSeries()).getDependencyTable();
        dt.add(dependent, this.newDummyRef(region));
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    @Override
    public void removeRegion(CellRegion region) {
        Validations.argNotNull(region);
        if (this._regions == null || this._regions.isEmpty()) {
            return;
        }
        ArrayList<CellRegion> newRegions = new ArrayList<CellRegion>();
        ArrayList<CellRegion> delRegions = new ArrayList<CellRegion>();
        for (CellRegion regn : this._regions) {
            if (!regn.overlaps(region)) continue;
            newRegions.addAll(regn.diff(region));
            delRegions.add(regn);
        }
        if (newRegions.isEmpty() && delRegions.isEmpty()) {
            return;
        }
        Ref dependent = this.getRef();
        SBook book = this._sheet.getBook();
        DependencyTable dt = ((AbstractBookSeriesAdv)book.getBookSeries()).getDependencyTable();
        Set<Ref> precedents = ((DependencyTableAdv)dt).getDirectPrecedents(dependent);
        dt.clearDependents(dependent);
        for (CellRegion regn : delRegions) {
            this._regions.remove(regn);
            precedents.remove(this.newDummyRef(regn));
        }
        if (precedents != null) {
            for (Ref precedent : precedents) {
                dt.add(dependent, precedent);
            }
        }
        for (CellRegion regn : newRegions) {
            this._regions.add(regn);
            dt.add(dependent, this.newDummyRef(regn));
        }
        if (this._regions.isEmpty()) {
            this._regions = null;
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    @Override
    public void setRegions(Set<CellRegion> regions) {
        this._regions = new LinkedHashSet(regions.size() * 4 / 3 + 1);
        for (CellRegion rgn : regions) {
            this.addRegion(rgn);
        }
    }

    @Override
    public SDataValidation.ValidationType getValidationType() {
        return this._validationType;
    }

    @Override
    public void setValidationType(SDataValidation.ValidationType type) {
        Validations.argNotNull(new Object[]{type});
        this._validationType = type;
    }

    @Override
    public SDataValidation.OperatorType getOperatorType() {
        return this._operatorType;
    }

    @Override
    public void setOperatorType(SDataValidation.OperatorType type) {
        Validations.argNotNull(new Object[]{type});
        this._operatorType = type;
    }

    @Override
    public boolean isFormulaParsingError() {
        boolean r = false;
        if (this._formula1Expr != null) {
            r |= this._formula1Expr.hasError();
        }
        if (!r && this._formula2Expr != null) {
            r |= this._formula2Expr.hasError();
        }
        return r;
    }

    @Override
    public int getNumOfValue() {
        return this.getNumOfValue1();
    }

    @Override
    public Object getValue(int index) {
        return this.getValue1(index);
    }

    @Override
    public int getNumOfValue1() {
        this.evalFormula();
        return EvaluationUtil.sizeOf(this._evalValue1Result);
    }

    @Override
    public Object getValue1(int index) {
        this.evalFormula();
        if (index >= EvaluationUtil.sizeOf(this._evalValue1Result)) {
            return null;
        }
        return EvaluationUtil.valueOf(this._evalValue1Result, index);
    }

    @Override
    public int getNumOfValue2() {
        this.evalFormula();
        return EvaluationUtil.sizeOf(this._evalValue2Result);
    }

    @Override
    public Object getValue2(int index) {
        this.evalFormula();
        if (index >= EvaluationUtil.sizeOf(this._evalValue2Result)) {
            return null;
        }
        return EvaluationUtil.valueOf(this._evalValue2Result, index);
    }

    @Override
    public String getFormula1() {
        return this._unescapeFromPoi(this._formula1Expr);
    }

    @Override
    public String getFormula2() {
        return this._unescapeFromPoi(this._formula2Expr);
    }

    private void clearFormulaDependency(boolean all) {
        if (this._formula1Expr != null || this._formula2Expr != null) {
            Ref dependent = this.getRef();
            DependencyTable dt = ((AbstractBookSeriesAdv)this._sheet.getBook().getBookSeries()).getDependencyTable();
            dt.clearDependents(dependent);
            if (!all && this._regions != null) {
                for (CellRegion regn : this._regions) {
                    dt.add(dependent, this.newDummyRef(regn));
                }
            }
        }
    }

    private Ref getRef() {
        return new ObjectRefImpl(this, this._id);
    }

    private Ref getRef(String sheetName) {
        return new ObjectRefImpl(this._sheet.getBook().getBookName(), sheetName, this._id, ObjectRef.ObjectType.DATA_VALIDATION);
    }

    private Ref newDummyRef(CellRegion regn) {
        return new RefImpl(this._sheet.getBook().getBookName(), this._sheet.getSheetName(), regn.row, regn.column, regn.lastRow, regn.lastColumn);
    }

    private Ref newDummyRef(String sheetName, CellRegion regn) {
        return new RefImpl(this._sheet.getBook().getBookName(), sheetName, regn.row, regn.column, regn.lastRow, regn.lastColumn);
    }

    @Override
    public void setFormula1(String formula1) {
        formula1 = this._escapeToPoi(formula1);
        this.setEscapedFormulas(formula1, this.getEscapedFormula2());
    }

    @Override
    public void setFormula2(String formula2) {
        formula2 = this._escapeToPoi(formula2);
        this.setEscapedFormulas(this.getEscapedFormula1(), formula2);
    }

    private boolean isLiteralPtg(Ptg ptg) {
        return ptg instanceof BoolPtg || ptg instanceof IntPtg || ptg instanceof NumberPtg || ptg instanceof StringPtg || ptg instanceof ErrPtg;
    }

    private String _unescapeFromPoi(FormulaExpression expr) {
        if (expr == null) {
            return null;
        }
        String formula = expr.getFormulaString();
        Ptg[] ptgs = expr.getPtgs();
        if (Strings.isBlank((String)formula)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (!(formula.startsWith("\"") || formula.length() <= 1 || ptgs.length <= 1 && this.isLiteralPtg(ptgs[0]))) {
            return sb.append("=").append(formula).toString();
        }
        if (this._validationType == SDataValidation.ValidationType.LIST) {
            int pre = -2;
            for (int j = 1; j < formula.length() - 1; ++j) {
                char ch = formula.charAt(j);
                if (ch == '\"') {
                    if (pre == j - 1) continue;
                    pre = j;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
        if (this.isNumber()) {
            double val = Double.parseDouble(formula);
            Locale locale = ZssContext.getCurrent().getLocale();
            return this.isDateFormat() ? FormatEngineImpl.getDateTimeString(val, locale) : this.getNumLocaleString(val);
        }
        return null;
    }

    private boolean isNumber() {
        return this._validationType == SDataValidation.ValidationType.DECIMAL || this._validationType == SDataValidation.ValidationType.INTEGER || this._validationType == SDataValidation.ValidationType.TEXT_LENGTH || this.isDateFormat();
    }

    private boolean isDateFormat() {
        return this._validationType == SDataValidation.ValidationType.DATE || this._validationType == SDataValidation.ValidationType.TIME;
    }

    private String _escapeToPoi(String formula) {
        if (Strings.isBlank((String)formula)) {
            return null;
        }
        InputResult input = this.parseInput(formula);
        switch (input.getType()) {
            case FORMULA: {
                return formula.substring(1);
            }
            case STRING: {
                if (this._validationType == SDataValidation.ValidationType.LIST) {
                    StringBuilder sb = new StringBuilder();
                    sb.append('\"');
                    for (int j = 0; j < formula.length(); ++j) {
                        char ch = formula.charAt(j);
                        sb.append(ch);
                        if (ch != '\"') continue;
                        sb.append('\"');
                    }
                    sb.append('\"');
                    return sb.toString();
                }
                return formula;
            }
            case NUMBER: {
                Object val = input.getValue();
                double num = val instanceof Date ? EngineFactory.getInstance().getCalendarUtil().dateToDoubleValue((Date)val) : ((Number)val).doubleValue();
                return this.getNumLocaleString(num);
            }
        }
        return formula;
    }

    private InputResult parseInput(String formula) {
        InputEngine ie = EngineFactory.getInstance().createInputEngine();
        return ie.parseInput(formula == null ? "" : formula, "General", new InputParseContext(ZssContext.getCurrent().getLocale()));
    }

    private FormulaExpression parseFormula(String formula) {
        FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
        Ref ref = this.getRef();
        Locale locale = ZssContext.getCurrent().getLocale();
        FormulaParseContext formulaCtx = new FormulaParseContext(this._sheet.getBook(), this._sheet, null, this._sheet.getSheetName(), ref, locale);
        FormulaExpression expr = fe.parse(formula, formulaCtx);
        if (expr.hasError()) {
            String msg = expr.getErrorMessage();
            throw new InvalidFormulaException(msg == null ? "The formula =" + formula + " contains error" : msg);
        }
        return expr;
    }

    @Override
    public void setFormulas(String formula1, String formula2) {
        formula1 = this._escapeToPoi(formula1);
        formula2 = this._escapeToPoi(formula2);
        this.setEscapedFormulas(formula1, formula2);
    }

    @Override
    public void setEscapedFormulas(String formula1, String formula2) {
        this.checkOrphan();
        this._evaluated = false;
        this.clearFormulaDependency(false);
        this.clearFormulaResultCache();
        this._formula1Expr = formula1 != null ? this.parseFormula(formula1) : null;
        this._formula2Expr = formula2 != null ? this.parseFormula(formula2) : null;
    }

    @Override
    public void clearFormulaResultCache() {
        this._evaluated = false;
        this._evalValue2Result = null;
        this._evalValue1Result = null;
        this._evalValue2EvalResult = null;
        this._evalValue1EvalResult = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evalFormula() {
        if (this._evaluated) {
            return;
        }
        DataValidationImpl dataValidationImpl = this;
        synchronized (dataValidationImpl) {
            if (!this._evaluated) {
                Object val;
                EvaluationResult result;
                Ref ref = this.getRef();
                FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
                if (this._formula1Expr != null) {
                    result = fe.evaluate(this._formula1Expr, new FormulaEvaluationContext(this._sheet, ref));
                    val = result.getValue();
                    if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                        this._evalValue1Result = val;
                        this._evalValue1EvalResult = result.getValueEval();
                        this._evalValue1Result = this.processCommaLiteral(this._evalValue1Result, this._evalValue1EvalResult);
                    } else if (result.getType() == EvaluationResult.ResultType.ERROR) {
                        Object object = this._evalValue1Result = val instanceof ErrorValue ? val : ErrorValue.valueOf((byte)15);
                    }
                }
                if (this._formula2Expr != null) {
                    result = fe.evaluate(this._formula2Expr, new FormulaEvaluationContext(this._sheet, ref));
                    val = result.getValue();
                    if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                        this._evalValue2Result = val;
                        this._evalValue2EvalResult = result.getValueEval();
                        this._evalValue2Result = this.processCommaLiteral(this._evalValue2Result, this._evalValue2EvalResult);
                    } else if (result.getType() == EvaluationResult.ResultType.ERROR) {
                        this._evalValue2Result = val instanceof ErrorValue ? val : ErrorValue.valueOf((byte)15);
                    }
                }
                this._evaluated = true;
            }
        }
    }

    @Override
    public List<SCell> getReferToCellList() {
        if (this._formula1Expr != null && this._formula1Expr.isAreaRefs()) {
            Ref areaRef = this._formula1Expr.getAreaRefs()[0];
            return this.getReferToCellList0(areaRef);
        }
        if (this._evalValue1EvalResult instanceof LazyAreaEval) {
            LazyAreaEval areaEval = (LazyAreaEval)this._evalValue1EvalResult;
            return this.getReferToCellList0(areaEval.getBookName(), areaEval.getSheetName(), areaEval.getFirstRow(), areaEval.getFirstColumn(), areaEval.getLastRow(), areaEval.getLastColumn());
        }
        if (this._evalValue1EvalResult instanceof LazyRefEval) {
            LazyRefEval areaEval = (LazyRefEval)this._evalValue1EvalResult;
            return this.getReferToCellList0(areaEval.getBookName(), areaEval.getSheetName(), areaEval.getRow(), areaEval.getColumn(), areaEval.getRow(), areaEval.getColumn());
        }
        return Collections.emptyList();
    }

    private List<SCell> getReferToCellList0(Ref areaRef) {
        SBookSeries bookSeries = this._sheet.getBook().getBookSeries();
        LinkedList<SCell> list = new LinkedList<SCell>();
        String bookName = areaRef.getBookName();
        String sheetName = areaRef.getSheetName();
        CellRegion region = new CellRegion(areaRef.getRow(), areaRef.getColumn(), areaRef.getLastRow(), areaRef.getLastColumn());
        SBook book = bookSeries.getBook(bookName);
        if (book == null) {
            return list;
        }
        SSheet sheet = book.getSheetByName(sheetName);
        if (sheet == null) {
            return list;
        }
        for (int i = region.getRow(); i <= region.getLastRow(); ++i) {
            for (int j = region.getColumn(); j <= region.getLastColumn(); ++j) {
                list.add(sheet.getCell(i, j));
            }
        }
        return list;
    }

    @Override
    public boolean hasReferToCellList() {
        return this._formula1Expr != null && this._formula1Expr.isAreaRefs() || this._evalValue1EvalResult instanceof LazyAreaEval || this._evalValue1EvalResult instanceof LazyRefEval;
    }

    @Override
    void copyFrom(AbstractDataValidationAdv src) {
        Validations.argInstance(src, DataValidationImpl.class);
        DataValidationImpl srcImpl = (DataValidationImpl)src;
        this._alertStyle = srcImpl._alertStyle;
        this._ignoreBlank = srcImpl._ignoreBlank;
        this._showInCellDropdown = srcImpl._showInCellDropdown;
        this._showInput = srcImpl._showInput;
        this._showError = srcImpl._showError;
        this._inputTitle = srcImpl._inputTitle;
        this._inputMessage = srcImpl._inputMessage;
        this._errorTitle = srcImpl._errorTitle;
        this._errorMessage = srcImpl._errorMessage;
        this._validationType = srcImpl._validationType;
        this._operatorType = srcImpl._operatorType;
        if (srcImpl._formula1Expr != null) {
            this.setEscapedFormulas(srcImpl.getEscapedFormula1(), srcImpl.getEscapedFormula2());
        }
    }

    @Override
    void renameSheet(String oldName, String newName) {
        Validations.argNotNull(oldName);
        Validations.argNotNull(newName);
        if (oldName.equals(newName)) {
            return;
        }
        Ref dependent = this.getRef(oldName);
        SBook book = this._sheet.getBook();
        DependencyTable dt = ((AbstractBookSeriesAdv)book.getBookSeries()).getDependencyTable();
        Set<Ref> precedents = ((DependencyTableAdv)dt).getDirectPrecedents(dependent);
        if (precedents != null && this._regions != null) {
            for (CellRegion regn : this._regions) {
                precedents.remove(this.newDummyRef(oldName, regn));
            }
        }
        dt.clearDependents(dependent);
        dependent = this.getRef(newName);
        if (this._regions != null) {
            for (CellRegion regn : this._regions) {
                dt.add(dependent, this.newDummyRef(newName, regn));
            }
        }
        if (precedents != null) {
            for (Ref precedent : precedents) {
                dt.add(dependent, precedent);
            }
        }
    }

    DataValidationImpl cloneDataValidationImpl(AbstractSheetAdv sheet) {
        String f1;
        DataValidationImpl tgt = new DataValidationImpl(sheet, this._id);
        tgt._alertStyle = this._alertStyle;
        tgt._ignoreBlank = this._ignoreBlank;
        tgt._showInCellDropdown = this._showInCellDropdown;
        tgt._showInput = this._showInput;
        tgt._showError = this._showError;
        tgt._inputTitle = this._inputTitle;
        tgt._inputMessage = this._inputMessage;
        tgt._errorTitle = this._errorTitle;
        tgt._errorMessage = this._errorMessage;
        tgt._validationType = this._validationType;
        tgt._operatorType = this._operatorType;
        if (this._regions != null) {
            tgt._regions = new LinkedHashSet(this._regions.size() * 4 / 3);
            for (CellRegion rgn : this._regions) {
                tgt._regions.add(new CellRegion(rgn.row, rgn.column, rgn.lastRow, rgn.lastColumn));
            }
        }
        if ((f1 = this.getEscapedFormula1()) != null) {
            String f2 = this.getEscapedFormula2();
            tgt.setEscapedFormulas(f1, f2);
        }
        return tgt;
    }

    @Override
    public void setFormulas(FormulaExpression fe1, FormulaExpression fe2) {
        this.checkOrphan();
        this._evaluated = false;
        this.clearFormulaDependency(false);
        this.clearFormulaResultCache();
        this._formula1Expr = fe1;
        this._formula2Expr = fe2;
        FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
        Ref ref = this.getRef();
        FormulaParseContext context = new FormulaParseContext(this._sheet, ref);
        if (fe1 != null) {
            fe.updateDependencyTable(fe1, context);
        }
        if (fe2 != null) {
            fe.updateDependencyTable(fe2, context);
        }
    }

    @Override
    public FormulaExpression getFormulaExpression1() {
        return this._formula1Expr;
    }

    @Override
    public FormulaExpression getFormulaExpression2() {
        return this._formula2Expr;
    }

    @Override
    public void setFormula1(FormulaExpression formula1) {
        this.setFormulas(formula1, this._formula2Expr);
    }

    @Override
    public void setFormula2(FormulaExpression formula2) {
        this.setFormulas(this._formula1Expr, formula2);
    }

    @Override
    public ValueEval getValueEval1() {
        return this._evalValue1EvalResult;
    }

    @Override
    public ValueEval getValueEval2() {
        return this._evalValue2EvalResult;
    }

    private Object processCommaLiteral(Object value, ValueEval valueEval) {
        if (value != null && valueEval instanceof StringEval) {
            String[] strs = ((String)((Object)value)).split(",");
            ArrayList<String> stra = new ArrayList<String>(strs.length);
            for (String s : strs) {
                if ((s = s.trim()).length() == 0) continue;
                stra.add(s);
            }
            return stra.size() <= 1 ? value : stra;
        }
        return value;
    }

    @Override
    public boolean hasReferToRelativeCol() {
        this.evalFormula();
        if (this.hasReferToCellList()) {
            if (this._evalValue1EvalResult instanceof LazyAreaEval) {
                return ((LazyAreaEval)this._evalValue1EvalResult).isFirstColRelative() || ((LazyAreaEval)this._evalValue1EvalResult).isLastColRelative();
            }
            if (this._evalValue1EvalResult instanceof LazyRefEval) {
                return ((LazyRefEval)this._evalValue1EvalResult).isColRelative();
            }
        }
        return false;
    }

    @Override
    public boolean hasReferToRelativeRow() {
        this.evalFormula();
        if (this.hasReferToCellList()) {
            if (this._evalValue1EvalResult instanceof LazyAreaEval) {
                return ((LazyAreaEval)this._evalValue1EvalResult).isFirstRowRelative() || ((LazyAreaEval)this._evalValue1EvalResult).isLastRowRelative();
            }
            if (this._evalValue1EvalResult instanceof LazyRefEval) {
                return ((LazyRefEval)this._evalValue1EvalResult).isRowRelative();
            }
        }
        return false;
    }

    @Override
    public List<SCell> getReferToCellList(int row, int col) {
        if (!this.hasReferToRelativeCol() && !this.hasReferToRelativeRow()) {
            return this.getReferToCellList();
        }
        if (this._regions.isEmpty()) {
            return Collections.emptyList();
        }
        CellRegion rgn = (CellRegion)this._regions.iterator().next();
        int colDiff = col - rgn.getColumn();
        int rowDiff = row - rgn.getRow();
        if (this._evalValue1EvalResult instanceof LazyAreaEval) {
            LazyAreaEval areaEval = (LazyAreaEval)this._evalValue1EvalResult;
            int row1 = areaEval.getFirstRow() + (areaEval.isFirstRowRelative() ? rowDiff : 0);
            int row2 = areaEval.getLastRow() + (areaEval.isLastRowRelative() ? rowDiff : 0);
            int col1 = areaEval.getFirstColumn() + (areaEval.isFirstColRelative() ? colDiff : 0);
            int col2 = areaEval.getLastColumn() + (areaEval.isLastColRelative() ? colDiff : 0);
            if (row1 >= 0 && row2 >= 0 && col1 >= 0 && col2 >= 0) {
                return this.getReferToCellList0(areaEval.getBookName(), areaEval.getSheetName(), row1, col1, row2, col2);
            }
        } else if (this._evalValue1EvalResult instanceof LazyRefEval) {
            LazyRefEval areaEval = (LazyRefEval)this._evalValue1EvalResult;
            int row1 = areaEval.getRow() + (areaEval.isRowRelative() ? rowDiff : 0);
            int col1 = areaEval.getColumn() + (areaEval.isColRelative() ? colDiff : 0);
            if (row1 >= 0 && col1 >= 0) {
                return this.getReferToCellList0(areaEval.getBookName(), areaEval.getSheetName(), row1, col1, row1, col1);
            }
        }
        return Collections.emptyList();
    }

    private List<SCell> getReferToCellList0(String bookName, String sheetName, int row1, int col1, int row2, int col2) {
        SBookSeries bookSeries = this._sheet.getBook().getBookSeries();
        LinkedList<SCell> list = new LinkedList<SCell>();
        SBook book = bookSeries.getBook(bookName);
        if (book == null) {
            return list;
        }
        SSheet sheet = book.getSheetByName(sheetName);
        if (sheet == null) {
            return list;
        }
        for (int i = row1; i <= row2; ++i) {
            for (int j = col1; j <= col2; ++j) {
                list.add(sheet.getCell(i, j));
            }
        }
        return list;
    }

    @Override
    public void addDependency(int row, int col) {
        if (!this.hasReferToRelativeCol() && !this.hasReferToRelativeRow()) {
            return;
        }
        if (this._regions.isEmpty()) {
            return;
        }
        CellRegion rgn = (CellRegion)this._regions.iterator().next();
        int colDiff = col - rgn.getColumn();
        int rowDiff = row - rgn.getRow();
        if (this._evalValue1EvalResult instanceof LazyAreaEval) {
            LazyAreaEval areaEval = (LazyAreaEval)this._evalValue1EvalResult;
            int row1 = areaEval.getFirstRow() + (areaEval.isFirstRowRelative() ? rowDiff : 0);
            int row2 = areaEval.getLastRow() + (areaEval.isLastRowRelative() ? rowDiff : 0);
            int col1 = areaEval.getFirstColumn() + (areaEval.isFirstColRelative() ? colDiff : 0);
            int col2 = areaEval.getLastColumn() + (areaEval.isLastColRelative() ? colDiff : 0);
            if (row1 >= 0 && row2 >= 0 && col1 >= 0 && col2 >= 0) {
                this.addDependency(areaEval.getBookName(), areaEval.getSheetName(), row1, col1, row2, col2);
            }
        } else if (this._evalValue1EvalResult instanceof LazyRefEval) {
            LazyRefEval areaEval = (LazyRefEval)this._evalValue1EvalResult;
            int row1 = areaEval.getRow() + (areaEval.isRowRelative() ? rowDiff : 0);
            int col1 = areaEval.getColumn() + (areaEval.isColRelative() ? colDiff : 0);
            if (row1 >= 0 && col1 >= 0) {
                this.addDependency(areaEval.getBookName(), areaEval.getSheetName(), row1, col1, row1, col1);
            }
        }
    }

    private void addDependency(String bookName, String sheetName, int row1, int col1, int row2, int col2) {
        SBookSeries bookSeries = this._sheet.getBook().getBookSeries();
        SBook book = bookSeries.getBook(bookName);
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(sheetName);
        if (sheet == null) {
            return;
        }
        DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
        table.add(this.getRef(), new RefImpl(bookName, sheetName, row1, col1, row2, col2));
    }

    @Override
    public String getEscapedFormula1() {
        return this._formula1Expr == null ? null : this._formula1Expr.getFormulaString();
    }

    @Override
    public String getEscapedFormula2() {
        return this._formula2Expr == null ? null : this._formula2Expr.getFormulaString();
    }

    private String getNumLocaleString(double num) {
        Locale locale = ZssContext.getCurrent().getLocale();
        DataFormatter df = new DataFormatter(locale);
        Format format = DataFormatter.isWholeNumber((double)num) ? df.getGeneralWholeNumJavaFormat() : df.getGeneralDecimalNumJavaFormat();
        return format.format(num);
    }
}

