/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SBorder;
import io.keikai.model.SBorderLine;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColor;
import io.keikai.model.SExtraStyle;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.impl.AbstractBorderAdv;
import io.keikai.model.impl.AbstractFillAdv;
import io.keikai.model.impl.AbstractFontAdv;
import io.keikai.model.impl.BookImpl;
import io.keikai.model.impl.CellStyleImpl;
import io.keikai.model.impl.ExtraFillImpl;
import io.keikai.model.util.Strings;
import io.keikai.model.util.Validations;

public class ExtraStyleImpl
extends CellStyleImpl
implements SExtraStyle {
    private static final long serialVersionUID = -3304797955338410853L;

    ExtraStyleImpl(ExtraStyleImpl src, BookImpl book) {
        super(src, book);
    }

    public ExtraStyleImpl(SFont font, SFill fill, SBorder border, String dataFormat) {
        super((AbstractFontAdv)font, (AbstractFillAdv)fill, (AbstractBorderAdv)border);
        if (fill != null) {
            Validations.argInstance(fill, ExtraFillImpl.class);
        }
        if (dataFormat != null && !Strings.isBlank(dataFormat)) {
            this.setDataFormat(dataFormat);
        }
    }

    @Override
    public SBorder.BorderType getBorderLeft() {
        if (this._border == null) {
            return null;
        }
        SBorderLine bline = this._border.getLeftLine();
        return bline == null ? null : bline.getBorderType();
    }

    @Override
    public SBorder.BorderType getBorderTop() {
        if (this._border == null) {
            return null;
        }
        SBorderLine bline = this._border.getTopLine();
        return bline == null ? null : bline.getBorderType();
    }

    @Override
    public SBorder.BorderType getBorderRight() {
        if (this._border == null) {
            return null;
        }
        SBorderLine bline = this._border.getRightLine();
        return bline == null ? null : bline.getBorderType();
    }

    @Override
    public SBorder.BorderType getBorderBottom() {
        if (this._border == null) {
            return null;
        }
        SBorderLine bline = this._border.getBottomLine();
        return bline == null ? null : bline.getBorderType();
    }

    @Override
    public SBorder.BorderType getBorderDiagonal() {
        if (this._border == null) {
            return null;
        }
        SBorderLine bline = this._border.getDiagonalLine();
        return bline == null ? null : bline.getBorderType();
    }

    @Override
    public SBorder.BorderType getBorderVertical() {
        if (this._border == null) {
            return null;
        }
        SBorderLine bline = this._border.getVerticalLine();
        return bline == null ? null : bline.getBorderType();
    }

    @Override
    public SBorder.BorderType getBorderHorizontal() {
        if (this._border == null) {
            return null;
        }
        SBorderLine bline = this._border.getHorizontalLine();
        return bline == null ? null : bline.getBorderType();
    }

    @Override
    public String getDataFormat() {
        return this._dataFormat;
    }

    @Override
    public void setBackColor(SColor backColor) {
        Validations.argNotNull(backColor);
        if (this._fill == null) {
            this._fill = new ExtraFillImpl();
        }
        this._fill.setBackColor(backColor);
    }

    @Override
    public void setFillColor(SColor fillColor) {
        Validations.argNotNull(fillColor);
        if (this._fill == null) {
            this._fill = new ExtraFillImpl();
        }
        this._fill.setFillColor(fillColor);
    }

    @Override
    public void setFillPattern(SFill.FillPattern fillPattern) {
        Validations.argNotNull(new Object[]{fillPattern});
        if (this._fill == null) {
            this._fill = new ExtraFillImpl();
        }
        this._fill.setFillPattern(fillPattern);
    }

    @Override
    SCellStyle createCellStyle(SBook book) {
        return new ExtraStyleImpl(this, (BookImpl)book);
    }
}

