/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.usermodel;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.zkoss.poi.hssf.model.InternalSheet;
import org.zkoss.poi.hssf.record.CellValueRecordInterface;
import org.zkoss.poi.hssf.record.ExtendedFormatRecord;
import org.zkoss.poi.hssf.record.RowRecord;
import org.zkoss.poi.hssf.usermodel.HSSFCell;
import org.zkoss.poi.hssf.usermodel.HSSFCellStyle;
import org.zkoss.poi.hssf.usermodel.HSSFHyperlink;
import org.zkoss.poi.hssf.usermodel.HSSFSheet;
import org.zkoss.poi.hssf.usermodel.HSSFWorkbook;
import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.usermodel.Cell;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.Row;

public final class HSSFRow
implements Row {
    public static final int INITIAL_CAPACITY = 5;
    private int rowNum;
    private HSSFCell[] cells;
    private RowRecord row;
    private HSSFWorkbook book;
    private HSSFSheet sheet;

    HSSFRow(HSSFWorkbook book, HSSFSheet sheet, int rowNum) {
        this(book, sheet, new RowRecord(rowNum));
    }

    HSSFRow(HSSFWorkbook book, HSSFSheet sheet, RowRecord record) {
        this.book = book;
        this.sheet = sheet;
        this.row = record;
        this.setRowNum(record.getRowNumber());
        this.cells = new HSSFCell[record.getLastCol() + 5];
        record.setEmpty();
    }

    public HSSFCell createCell(short columnIndex) {
        return this.createCell((int)columnIndex);
    }

    public HSSFCell createCell(short columnIndex, int type) {
        return this.createCell((int)columnIndex, type);
    }

    @Override
    public HSSFCell createCell(int column) {
        return this.createCell(column, 3);
    }

    @Override
    public HSSFCell createCell(int columnIndex, int type) {
        short shortCellNum = (short)columnIndex;
        if (columnIndex > Short.MAX_VALUE) {
            shortCellNum = (short)(65535 - columnIndex);
        }
        HSSFCell cell = new HSSFCell(this.book, this.sheet, this.getRowNum(), shortCellNum, type);
        this.addCell(cell);
        this.sheet.getSheet().addValueRecord(this.getRowNum(), cell.getCellValueRecord());
        return cell;
    }

    @Override
    public void removeCell(Cell cell) {
        if (cell == null) {
            throw new IllegalArgumentException("cell must not be null");
        }
        this.removeCell((HSSFCell)cell, true);
    }

    private void removeCell(HSSFCell cell, boolean alsoRemoveRecords) {
        int column = cell.getColumnIndex();
        if (column < 0) {
            throw new RuntimeException("Negative cell indexes not allowed");
        }
        if (column >= this.cells.length || cell != this.cells[column]) {
            throw new RuntimeException("Specified cell is not from this row");
        }
        if (cell.isPartOfArrayFormulaGroup()) {
            cell.notifyArrayFormulaChanging();
        }
        this.cells[column] = null;
        if (alsoRemoveRecords) {
            CellValueRecordInterface cval = cell.getCellValueRecord();
            this.sheet.getSheet().removeValueRecord(this.getRowNum(), cval);
        }
        if (cell.getColumnIndex() + 1 == this.row.getLastCol()) {
            this.row.setLastCol(this.calculateNewLastCellPlusOne(this.row.getLastCol()));
        }
        if (cell.getColumnIndex() == this.row.getFirstCol()) {
            this.row.setFirstCol(this.calculateNewFirstCell(this.row.getFirstCol()));
        }
    }

    protected void removeAllCells() {
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            this.removeCell(this.cells[i], true);
        }
        this.cells = new HSSFCell[5];
    }

    HSSFCell createCellFromRecord(CellValueRecordInterface cell) {
        HSSFCell hcell = new HSSFCell(this.book, this.sheet, cell);
        this.addCell(hcell);
        short colIx = cell.getColumn();
        if (this.row.isEmpty()) {
            this.row.setFirstCol(colIx);
            this.row.setLastCol(colIx + 1);
        } else if (colIx < this.row.getFirstCol()) {
            this.row.setFirstCol(colIx);
        } else if (colIx > this.row.getLastCol()) {
            this.row.setLastCol(colIx + 1);
        }
        return hcell;
    }

    @Override
    public void setRowNum(int rowIndex) {
        int maxrow = SpreadsheetVersion.EXCEL97.getLastRowIndex();
        if (rowIndex < 0 || rowIndex > maxrow) {
            throw new IllegalArgumentException("Invalid row number (" + rowIndex + ") outside allowable range (0.." + maxrow + ")");
        }
        this.rowNum = rowIndex;
        if (this.row != null) {
            this.row.setRowNumber(rowIndex);
        }
    }

    @Override
    public int getRowNum() {
        return this.rowNum;
    }

    @Override
    public HSSFSheet getSheet() {
        return this.sheet;
    }

    protected int getOutlineLevel() {
        return this.row.getOutlineLevel();
    }

    public void moveCell(HSSFCell cell, short newColumn) {
        if (this.cells.length > newColumn && this.cells[newColumn] != null) {
            throw new IllegalArgumentException("Asked to move cell to column " + newColumn + " but there's already a cell there");
        }
        if (!this.cells[cell.getColumnIndex()].equals(cell)) {
            throw new IllegalArgumentException("Asked to move a cell, but it didn't belong to our row");
        }
        this.removeCell(cell, false);
        cell.updateCellNum(newColumn);
        this.addCell(cell);
    }

    private void addCell(HSSFCell cell) {
        int column = cell.getColumnIndex();
        if (column >= this.cells.length) {
            HSSFCell[] oldCells = this.cells;
            int newSize = oldCells.length * 3 / 2 + 1;
            if (newSize < column + 1) {
                newSize = column + 5;
            }
            this.cells = new HSSFCell[newSize];
            System.arraycopy(oldCells, 0, this.cells, 0, oldCells.length);
        }
        this.cells[column] = cell;
        if (this.row.isEmpty() || column < this.row.getFirstCol()) {
            this.row.setFirstCol((short)column);
        }
        if (this.row.isEmpty() || column >= this.row.getLastCol()) {
            this.row.setLastCol((short)(column + 1));
        }
    }

    private HSSFCell retrieveCell(int cellIndex) {
        if (cellIndex < 0 || cellIndex >= this.cells.length) {
            return null;
        }
        return this.cells[cellIndex];
    }

    public HSSFCell getCell(short cellnum) {
        int ushortCellNum = cellnum & 0xFFFF;
        return this.getCell(ushortCellNum);
    }

    @Override
    public HSSFCell getCell(int cellnum) {
        return this.getCell(cellnum, this.book.getMissingCellPolicy());
    }

    @Override
    public HSSFCell getCell(int cellnum, Row.MissingCellPolicy policy) {
        HSSFCell cell = this.retrieveCell(cellnum);
        if (policy == RETURN_NULL_AND_BLANK) {
            return cell;
        }
        if (policy == RETURN_BLANK_AS_NULL) {
            if (cell == null) {
                return cell;
            }
            if (cell.getCellType() == 3) {
                return null;
            }
            return cell;
        }
        if (policy == CREATE_NULL_AS_BLANK) {
            if (cell == null) {
                return this.createCell(cellnum, 3);
            }
            return cell;
        }
        throw new IllegalArgumentException("Illegal policy " + policy + " (" + policy.id + ")");
    }

    @Override
    public short getFirstCellNum() {
        if (this.row.isEmpty()) {
            return -1;
        }
        return (short)this.row.getFirstCol();
    }

    @Override
    public short getLastCellNum() {
        if (this.row.isEmpty()) {
            return -1;
        }
        return (short)this.row.getLastCol();
    }

    @Override
    public int getPhysicalNumberOfCells() {
        int count = 0;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void setHeight(short height) {
        if (height == -1) {
            this.row.setBadFontHeight(false);
            this.row.setHeight((short)-32513);
            this.row.setBadFontHeight(false);
        } else {
            this.row.setBadFontHeight(true);
            this.row.setHeight(height);
        }
    }

    @Override
    public void setZeroHeight(boolean zHeight) {
        this.row.setZeroHeight(zHeight);
    }

    @Override
    public boolean getZeroHeight() {
        return this.row.getZeroHeight();
    }

    @Override
    public void setHeightInPoints(float height) {
        if (height == -1.0f) {
            this.row.setHeight((short)-32513);
        } else {
            this.row.setBadFontHeight(true);
            this.row.setHeight((short)(height * 20.0f));
        }
    }

    @Override
    public short getHeight() {
        short height = this.row.getHeight();
        height = (height & 0x8000) != 0 ? this.sheet.getSheet().getDefaultRowHeight() : (short)(height & Short.MAX_VALUE);
        return height;
    }

    @Override
    public float getHeightInPoints() {
        return (float)this.getHeight() / 20.0f;
    }

    protected RowRecord getRowRecord() {
        return this.row;
    }

    private int calculateNewLastCellPlusOne(int lastcell) {
        int cellIx = lastcell - 1;
        HSSFCell r = this.retrieveCell(cellIx);
        while (r == null) {
            if (cellIx < 0) {
                return 0;
            }
            r = this.retrieveCell(--cellIx);
        }
        return cellIx + 1;
    }

    private int calculateNewFirstCell(int firstcell) {
        int cellIx = firstcell + 1;
        HSSFCell r = this.retrieveCell(cellIx);
        while (r == null) {
            if (cellIx <= this.cells.length) {
                return 0;
            }
            r = this.retrieveCell(++cellIx);
        }
        return cellIx;
    }

    @Override
    public boolean isFormatted() {
        return this.row.getFormatted();
    }

    @Override
    public HSSFCellStyle getRowStyle() {
        if (!this.isFormatted()) {
            return null;
        }
        short styleIndex = this.row.getXFIndex();
        ExtendedFormatRecord xf = this.book.getWorkbook().getExFormatAt(styleIndex);
        return new HSSFCellStyle(styleIndex, xf, this.book);
    }

    public void setRowStyle(HSSFCellStyle style) {
        this.row.setFormatted(true);
        this.row.setXFIndex((short)style.getIndex());
    }

    @Override
    public void setRowStyle(CellStyle style) {
        this.setRowStyle((HSSFCellStyle)style);
    }

    @Override
    public Iterator<Cell> cellIterator() {
        return new CellIterator();
    }

    @Override
    public Iterator iterator() {
        return this.cellIterator();
    }

    public int compareTo(Object obj) {
        HSSFRow loc = (HSSFRow)obj;
        if (this.getRowNum() == loc.getRowNum()) {
            return 0;
        }
        if (this.getRowNum() < loc.getRowNum()) {
            return -1;
        }
        if (this.getRowNum() > loc.getRowNum()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HSSFRow)) {
            return false;
        }
        HSSFRow loc = (HSSFRow)obj;
        return this.getRowNum() == loc.getRowNum();
    }

    public void shiftCells(int startCol, int endCol, int n, boolean clearRest) {
        block12: {
            int replacedStartCol;
            int maxcol;
            block13: {
                int inc;
                int s;
                InternalSheet internalSheet = this.sheet.getSheet();
                if (endCol < 0) {
                    endCol = this.getLastCellNum() - 1;
                }
                if (n < 0) {
                    if (endCol < startCol + n) {
                        return;
                    }
                    s = startCol;
                    inc = 1;
                } else {
                    if (endCol < startCol) {
                        return;
                    }
                    s = endCol;
                    inc = -1;
                }
                maxcol = SpreadsheetVersion.EXCEL97.getLastColumnIndex();
                int rowNum = this.getRowNum();
                for (int colNum = s; colNum >= startCol && colNum <= endCol && colNum >= 0 && colNum <= maxcol; colNum += inc) {
                    int newColNum;
                    boolean inbound;
                    HSSFCell cell = this.getCell(colNum, RETURN_NULL_AND_BLANK);
                    if (cell != null) {
                        this.notifyCellShifting(cell);
                    }
                    boolean bl = inbound = (newColNum = colNum + n) >= 0 && newColNum <= maxcol;
                    if (!inbound) {
                        if (cell == null) continue;
                        this.removeCell(cell);
                        continue;
                    }
                    HSSFCell replaceCell = this.getCell(newColNum, RETURN_NULL_AND_BLANK);
                    if (replaceCell != null) {
                        this.removeCell(replaceCell);
                    }
                    if (cell == null) continue;
                    CellValueRecordInterface cellRecord = cell.getCellValueRecord();
                    if (cell.isPartOfArrayFormulaGroup()) {
                        cell.notifyArrayFormulaChanging();
                    }
                    this.cells[colNum] = null;
                    internalSheet.removeValueRecord(rowNum, cellRecord);
                    cellRecord.setColumn((short)newColNum);
                    this.addCell(cell);
                    internalSheet.addValueRecord(rowNum, cellRecord);
                    HSSFHyperlink link = cell.getHyperlink();
                    if (link == null) continue;
                    link.setFirstColumn(link.getFirstColumn() + n);
                    link.setLastColumn(link.getLastColumn() + n);
                }
                if (n >= 0) break block12;
                if (endCol >= startCol) break block13;
                for (int colNum = replacedStartCol = startCol + n; colNum >= replacedStartCol && colNum <= endCol && colNum >= 0 && colNum <= maxcol; ++colNum) {
                    HSSFCell cell = this.getCell(colNum, RETURN_NULL_AND_BLANK);
                    if (cell == null) continue;
                    this.removeCell(cell);
                }
                break block12;
            }
            if (!clearRest || (replacedStartCol = endCol + n + 1) > startCol) break block12;
            for (int colNum = replacedStartCol; colNum >= replacedStartCol && colNum <= startCol && colNum >= 0 && colNum <= maxcol; ++colNum) {
                HSSFCell cell = this.getCell(colNum, RETURN_NULL_AND_BLANK);
                if (cell == null) continue;
                this.removeCell(cell);
            }
        }
    }

    private void notifyCellShifting(HSSFCell cell) {
        String msg = "Cell[rownum=" + cell.getRowIndex() + ", columnnum=" + cell.getColumnIndex() + "] included in a multi-cell array formula. You cannot change part of an array.";
        if (cell.isPartOfArrayFormulaGroup()) {
            cell.notifyArrayFormulaChanging(msg);
        }
    }

    @Override
    public boolean isCustomHeight() {
        return this.row.getBadFontHeight();
    }

    @Override
    public void setCustomHeight(boolean b) {
        this.row.setBadFontHeight(b);
    }

    private class CellIterator
    implements Iterator<Cell> {
        int thisId = -1;
        int nextId = -1;

        public CellIterator() {
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextId < HSSFRow.this.cells.length;
        }

        @Override
        public Cell next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            HSSFCell cell = HSSFRow.this.cells[this.nextId];
            this.thisId = this.nextId;
            this.findNext();
            return cell;
        }

        @Override
        public void remove() {
            if (this.thisId == -1) {
                throw new IllegalStateException("remove() called before next()");
            }
            ((HSSFRow)HSSFRow.this).cells[this.thisId] = null;
        }

        private void findNext() {
            int i;
            for (i = this.nextId + 1; i < HSSFRow.this.cells.length && HSSFRow.this.cells[i] == null; ++i) {
            }
            this.nextId = i;
        }
    }
}

