/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.zkoss.poi.hssf.record.BOFRecord;
import org.zkoss.poi.hssf.record.EOFRecord;
import org.zkoss.poi.hssf.record.Record;
import org.zkoss.poi.hssf.record.RecordBase;
import org.zkoss.poi.hssf.record.aggregates.RecordAggregate;

public class BOFRecordAggregate
extends RecordAggregate {
    final BOFRecord bofRecord;
    final EOFRecord eofRecord;
    final List<RecordBase> innerRecords;

    public BOFRecordAggregate(BOFRecord bofRecord, EOFRecord eofRecord, List<RecordBase> innerRecords) {
        this.bofRecord = bofRecord;
        this.eofRecord = eofRecord;
        this.innerRecords = new ArrayList<RecordBase>(innerRecords);
    }

    public List<RecordBase> getInnerRecords() {
        return Collections.unmodifiableList(this.innerRecords);
    }

    @Override
    public void visitContainedRecords(RecordAggregate.RecordVisitor rv) {
        rv.visitRecord(this.bofRecord);
        for (RecordBase r : this.innerRecords) {
            if (r instanceof Record) {
                rv.visitRecord((Record)r);
                continue;
            }
            if (!(r instanceof RecordAggregate)) continue;
            ((RecordAggregate)r).visitContainedRecords(rv);
        }
        rv.visitRecord(this.eofRecord);
    }
}

