/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.common.UnicodeString;
import org.zkoss.poi.util.IntMapper;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;

class SSTDeserializer {
    private static POILogger logger = POILogFactory.getLogger(SSTDeserializer.class);
    private IntMapper<UnicodeString> strings;

    public SSTDeserializer(IntMapper<UnicodeString> strings) {
        this.strings = strings;
    }

    public void manufactureStrings(int stringCount, RecordInputStream in) {
        for (int i = 0; i < stringCount; ++i) {
            UnicodeString str;
            if (in.available() == 0 && !in.hasNextRecord()) {
                logger.log(7, "Ran out of data before creating all the strings! String at index " + i + "");
                str = new UnicodeString("");
            } else {
                str = new UnicodeString(in);
            }
            SSTDeserializer.addToStringTable(this.strings, str);
        }
    }

    public static void addToStringTable(IntMapper<UnicodeString> strings, UnicodeString string) {
        strings.add(string);
    }
}

