/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public final class BOFRecord
extends StandardRecord {
    private static final BitField fWin = BitFieldFactory.getInstance(1);
    private static final BitField fRisc = BitFieldFactory.getInstance(2);
    private static final BitField fBeta = BitFieldFactory.getInstance(4);
    private static final BitField fWinAny = BitFieldFactory.getInstance(8);
    private static final BitField fMacAny = BitFieldFactory.getInstance(16);
    private static final BitField fBetaAny = BitFieldFactory.getInstance(32);
    private static final BitField fUnused = BitFieldFactory.getInstance(192);
    private static final BitField fRiscAny = BitFieldFactory.getInstance(256);
    private static final BitField fOOM = BitFieldFactory.getInstance(512);
    private static final BitField fGIJmp = BitFieldFactory.getInstance(1024);
    private static final BitField fUnused2 = BitFieldFactory.getInstance(6144);
    private static final BitField fFontLimit = BitFieldFactory.getInstance(8192);
    private static final BitField verXLHigh = BitFieldFactory.getInstance(15360);
    private static final BitField verLoestBiff = BitFieldFactory.getInstance(255);
    private static final BitField verLastXLSaved = BitFieldFactory.getInstance(3840);
    public static final short sid = 2057;
    public static final int VERSION = 1536;
    public static final int BUILD = 8107;
    public static final int BUILD_YEAR = 1997;
    public static final int HISTORY_MASK = 65737;
    public static final int REQ_VERSION = 1030;
    public static final int TYPE_WORKBOOK = 5;
    public static final int TYPE_VB_MODULE = 6;
    public static final int TYPE_WORKSHEET = 16;
    public static final int TYPE_CHART = 32;
    public static final int TYPE_EXCEL_4_MACRO = 64;
    public static final int TYPE_WORKSPACE_FILE = 256;
    public static final int EXCEL_97 = 0;
    public static final int EXCEL_2000 = 1;
    public static final int EXCEL_2002 = 2;
    public static final int EXCEL_2003 = 3;
    public static final int EXCEL_2007 = 4;
    public static final int EXCEL_2010 = 6;
    private int field_1_version;
    private int field_2_type;
    private int field_3_build;
    private int field_4_year;
    private int field_5_history;
    private int field_6_rversion;

    public BOFRecord() {
    }

    private BOFRecord(int type) {
        this.field_1_version = 1536;
        this.field_2_type = type;
        this.field_3_build = 8107;
        this.field_4_year = 1997;
        this.field_5_history = 1;
        this.field_6_rversion = 1536;
    }

    public static BOFRecord createSheetBOF() {
        return new BOFRecord(16);
    }

    public BOFRecord(RecordInputStream in) {
        this.field_1_version = in.readShort();
        this.field_2_type = in.readShort();
        if (in.remaining() >= 2) {
            this.field_3_build = in.readShort();
        }
        if (in.remaining() >= 2) {
            this.field_4_year = in.readShort();
        }
        if (in.remaining() >= 4) {
            this.field_5_history = in.readInt();
        }
        if (in.remaining() >= 4) {
            this.field_6_rversion = in.readInt();
        }
    }

    public void setVersion(int version) {
        this.field_1_version = version;
    }

    public void setType(int type) {
        this.field_2_type = type;
    }

    public void setBuild(int build) {
        this.field_3_build = build;
    }

    public void setBuildYear(int year) {
        this.field_4_year = year;
    }

    public void setHistoryBitMask(int bitmask) {
        this.field_5_history = bitmask;
    }

    public void setRequiredVersion(int version) {
        this.field_6_rversion = version;
    }

    public int getVersion() {
        return this.field_1_version;
    }

    public int getType() {
        return this.field_2_type;
    }

    public int getBuild() {
        return this.field_3_build;
    }

    public int getBuildYear() {
        return this.field_4_year;
    }

    public int getHistoryBitMask() {
        return this.field_5_history;
    }

    public int getRequiredVersion() {
        return this.field_6_rversion;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[BOF RECORD]\n");
        buffer.append("    .version  = ").append(HexDump.shortToHex(this.getVersion())).append("\n");
        buffer.append("    .type     = ").append(HexDump.shortToHex(this.getType()));
        buffer.append(" (").append(this.getTypeName()).append(")").append("\n");
        buffer.append("    .build    = ").append(HexDump.shortToHex(this.getBuild())).append("\n");
        buffer.append("    .buildyear= ").append(this.getBuildYear()).append("\n");
        buffer.append("    .history  = ").append(HexDump.intToHex(this.getHistoryBitMask())).append("\n");
        buffer.append("    .reqver   = ").append(HexDump.intToHex(this.getRequiredVersion())).append("\n");
        buffer.append("[/BOF RECORD]\n");
        return buffer.toString();
    }

    private String getTypeName() {
        switch (this.field_2_type) {
            case 32: {
                return "chart";
            }
            case 64: {
                return "excel 4 macro";
            }
            case 6: {
                return "vb module";
            }
            case 5: {
                return "workbook";
            }
            case 16: {
                return "worksheet";
            }
            case 256: {
                return "workspace file";
            }
        }
        return "#error unknown type#";
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.getVersion());
        out.writeShort(this.getType());
        out.writeShort(this.getBuild());
        out.writeShort(this.getBuildYear());
        out.writeInt(this.getHistoryBitMask());
        out.writeInt(this.getRequiredVersion());
    }

    @Override
    protected int getDataSize() {
        return 16;
    }

    @Override
    public short getSid() {
        return 2057;
    }

    @Override
    public Object clone() {
        BOFRecord rec = new BOFRecord();
        rec.field_1_version = this.field_1_version;
        rec.field_2_type = this.field_2_type;
        rec.field_3_build = this.field_3_build;
        rec.field_4_year = this.field_4_year;
        rec.field_5_history = this.field_5_history;
        rec.field_6_rversion = this.field_6_rversion;
        return rec;
    }
}

