/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hdgf.streams;

import java.util.ArrayList;
import org.zkoss.poi.hdgf.chunks.Chunk;
import org.zkoss.poi.hdgf.chunks.ChunkFactory;
import org.zkoss.poi.hdgf.chunks.ChunkHeader;
import org.zkoss.poi.hdgf.pointers.Pointer;
import org.zkoss.poi.hdgf.streams.Stream;
import org.zkoss.poi.hdgf.streams.StreamStore;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;

public final class ChunkStream
extends Stream {
    private static POILogger logger = POILogFactory.getLogger(ChunkStream.class);
    private ChunkFactory chunkFactory;
    private Chunk[] chunks;

    protected ChunkStream(Pointer pointer, StreamStore store, ChunkFactory chunkFactory) {
        super(pointer, store);
        this.chunkFactory = chunkFactory;
        store.copyBlockHeaderToContents();
    }

    public Chunk[] getChunks() {
        return this.chunks;
    }

    public void findChunks() {
        ArrayList<Chunk> chunksA = new ArrayList<Chunk>();
        if (this.getPointer().getOffset() == 25779) {
            int i = 0;
            ++i;
        }
        int pos = 0;
        byte[] contents = this.getStore().getContents();
        try {
            while (pos < contents.length) {
                int headerSize = ChunkHeader.getHeaderSize(this.chunkFactory.getVersion());
                if (pos + headerSize <= contents.length) {
                    Chunk chunk = this.chunkFactory.createChunk(contents, pos);
                    chunksA.add(chunk);
                    pos += chunk.getOnDiskSize();
                    continue;
                }
                logger.log(5, "Needed " + headerSize + " bytes to create the next chunk header, but only found " + (contents.length - pos) + " bytes, ignoring rest of data");
                pos = contents.length;
            }
        }
        catch (Exception e) {
            logger.log(7, "Failed to create chunk at " + pos + ", ignoring rest of data." + e);
        }
        this.chunks = chunksA.toArray(new Chunk[chunksA.size()]);
    }
}

