/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.CellOperationUtil;
import io.keikai.api.IllegalFormulaException;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.impl.RangeImpl;
import io.keikai.api.model.Sheet;
import io.keikai.ui.impl.undo.AbstractEditTextAction;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;

public class CellEditTextAction
extends AbstractEditTextAction {
    private static final long serialVersionUID = -4091069271521601441L;
    private final String _editText;
    private final String[][] _editTexts;
    private static final String ALREADY_PARSE_ERROR = "KEIKAI_ALREADY_PARSE_ERROR";

    public CellEditTextAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, String editText) {
        super(label, sheet, row, column, lastRow, lastColumn);
        this._editText = editText;
        this._editTexts = null;
    }

    public CellEditTextAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, String[][] editTexts) {
        super(label, sheet, row, column, lastRow, lastColumn);
        this._editTexts = editTexts;
        this._editText = null;
    }

    @Override
    protected void applyAction() {
        boolean protect = this.isSheetProtected();
        if (this._editText != null && !protect) {
            Range r = Ranges.range(this._sheet, this._row, this._column, this._lastRow, this._lastColumn);
            try {
                r.setCellEditText(this._editText);
            }
            catch (IllegalFormulaException x) {
                Execution exec = Executions.getCurrent();
                if (exec != null) {
                    if (exec.getAttribute(ALREADY_PARSE_ERROR, false) != null) {
                        ((RangeImpl)r).setStringValue(this._editText);
                        return;
                    }
                    exec.setAttribute(ALREADY_PARSE_ERROR, (Object)Boolean.TRUE, false);
                }
                throw x;
            }
            if (this._editText.contains("\n")) {
                CellOperationUtil.applyWrapText(r, true);
            }
        } else {
            for (int i = this._row; i <= this._lastRow; ++i) {
                for (int j = this._column; j <= this._lastColumn; ++j) {
                    Range r = Ranges.range(this._sheet, i, j);
                    boolean lock = r.getCellStyle().isLocked();
                    if (protect && lock) continue;
                    try {
                        r.setCellEditText(this._editText != null ? this._editText : this._editTexts[i][j]);
                        continue;
                    }
                    catch (IllegalFormulaException illegalFormulaException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

