/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api;

import io.keikai.api.AreaRef;
import io.keikai.api.Range;
import io.keikai.api.impl.RangeImpl;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.impl.BookImpl;
import io.keikai.api.model.impl.SheetImpl;
import io.keikai.model.SBook;
import io.keikai.model.SSheet;
import io.keikai.range.SRanges;
import org.zkoss.poi.ss.util.AreaReference;
import org.zkoss.poi.ss.util.CellReference;

public class Ranges {
    public static Range range(Sheet sheet) {
        return new RangeImpl(SRanges.range((SSheet)((SheetImpl)sheet).getNative()), sheet);
    }

    public static Range range(Sheet sheet, String areaReference) {
        return new RangeImpl(SRanges.range((SSheet)((SheetImpl)sheet).getNative(), (String)areaReference), sheet);
    }

    public static Range rangeByName(Sheet sheet, String name) {
        return new RangeImpl(SRanges.rangeByName((SSheet)((SheetImpl)sheet).getNative(), (String)name), sheet);
    }

    public static Range range(Sheet sheet, int tRow, int lCol, int bRow, int rCol) {
        return new RangeImpl(SRanges.range((SSheet)((SheetImpl)sheet).getNative(), (int)tRow, (int)lCol, (int)bRow, (int)rCol), sheet);
    }

    public static Range range(Sheet sheet, int row, int col) {
        return new RangeImpl(SRanges.range((SSheet)((SheetImpl)sheet).getNative(), (int)row, (int)col), sheet);
    }

    public static Range range(Sheet sheet, AreaRef selection) {
        return Ranges.range(sheet, selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn());
    }

    public static String getCellRefString(int row, int col) {
        return Ranges.getCellRefString(null, row, col);
    }

    public static String getCellRefString(Sheet sheet, int row, int col) {
        CellReference cf = new CellReference(sheet == null ? null : sheet.getSheetName(), row, col, false, false);
        return cf.formatAsString();
    }

    public static String getAreaRefString(int tRow, int lCol, int bRow, int rCol) {
        return Ranges.getAreaRefString(null, tRow, lCol, bRow, rCol);
    }

    public static String getAreaRefString(Sheet sheet, int tRow, int lCol, int bRow, int rCol) {
        String sn = sheet == null ? null : sheet.getSheetName();
        AreaReference af = new AreaReference(new CellReference(sn, tRow, lCol, false, false), new CellReference(sn, bRow, rCol, false, false));
        return af.formatAsString();
    }

    public static String getAreaRefString(Sheet sheet, AreaRef area) {
        return Ranges.getAreaRefString(sheet, area.getRow(), area.getColumn(), area.getLastRow(), area.getLastColumn());
    }

    public static String getColumnRefString(int column) {
        return CellReference.convertNumToColString((int)column);
    }

    public static String getRowRefString(int row) {
        int excelRowNum = row + 1;
        return Integer.toString(excelRowNum);
    }

    public static Range range(Book book) {
        return new RangeImpl(SRanges.range((SBook)((BookImpl)book).getNative()), book);
    }
}

