/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.nio;

import com.hazelcast.internal.tpcengine.net.AcceptRequest;
import com.hazelcast.internal.tpcengine.net.AsyncServerSocket;
import com.hazelcast.internal.tpcengine.net.AsyncSocketOptions;
import com.hazelcast.internal.tpcengine.nio.NioAcceptRequest;
import com.hazelcast.internal.tpcengine.nio.NioAsyncServerSocketBuilder;
import com.hazelcast.internal.tpcengine.nio.NioAsyncServerSocketOptions;
import com.hazelcast.internal.tpcengine.nio.NioHandler;
import com.hazelcast.internal.tpcengine.nio.NioReactor;
import com.hazelcast.internal.tpcengine.util.CloseUtil;
import com.hazelcast.internal.tpcengine.util.ExceptionUtil;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.SocketAddress;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public final class NioAsyncServerSocket
extends AsyncServerSocket {
    private final ServerSocketChannel serverSocketChannel;
    private final NioReactor reactor;
    private final Thread eventloopThread;
    private final SelectionKey key;
    private final NioAsyncServerSocketOptions options;
    private final Consumer<AcceptRequest> consumer;
    private boolean started;

    NioAsyncServerSocket(NioAsyncServerSocketBuilder builder) {
        try {
            this.reactor = builder.reactor;
            this.consumer = builder.acceptConsumer;
            this.options = builder.options;
            this.eventloopThread = this.reactor.eventloopThread();
            this.serverSocketChannel = builder.serverSocketChannel;
            this.key = this.serverSocketChannel.register(this.reactor.selector, 0, new Handler());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public AsyncSocketOptions options() {
        return this.options;
    }

    @Override
    public NioReactor getReactor() {
        return this.reactor;
    }

    @Override
    protected SocketAddress getLocalAddress0() throws IOException {
        return this.serverSocketChannel.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.serverSocketChannel.socket().getLocalPort();
    }

    @Override
    protected void close0() throws IOException {
        CloseUtil.closeQuietly(this.serverSocketChannel);
        this.key.cancel();
    }

    @Override
    public void bind(SocketAddress localAddress, int backlog) {
        Preconditions.checkNotNull(localAddress, "localAddress");
        Preconditions.checkNotNegative(backlog, "backlog");
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.eventloopThread.getName() + " Binding to " + localAddress);
            }
            this.serverSocketChannel.bind(localAddress, backlog);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to bind to " + localAddress, e);
        }
        catch (SecurityException | AlreadyBoundException | UnsupportedAddressTypeException e) {
            throw new UncheckedIOException(new IOException("Failed to bind to " + localAddress, e));
        }
    }

    @Override
    public void start() {
        if (Thread.currentThread() == this.eventloopThread) {
            this.start0();
        } else {
            CompletableFuture future = new CompletableFuture();
            this.reactor.execute(() -> {
                try {
                    this.start0();
                    future.complete(null);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                    throw ExceptionUtil.sneakyThrow(t);
                }
            });
            future.join();
        }
    }

    private void start0() {
        if (this.started) {
            throw new IllegalStateException(this + " is already started");
        }
        this.started = true;
        this.key.interestOps(this.key.interestOps() | 0x10);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.getLocalAddress() + " started accepting");
        }
    }

    private final class Handler
    implements NioHandler {
        private Handler() {
        }

        @Override
        public void close(String reason, Throwable cause) {
            NioAsyncServerSocket.this.close(reason, cause);
        }

        @Override
        public void handle() throws IOException {
            if (!NioAsyncServerSocket.this.key.isValid()) {
                throw new CancelledKeyException();
            }
            SocketChannel socketChannel = NioAsyncServerSocket.this.serverSocketChannel.accept();
            NioAsyncServerSocket.this.metrics.incAccepted();
            if (NioAsyncServerSocket.this.logger.isInfoEnabled()) {
                NioAsyncServerSocket.this.logger.info(NioAsyncServerSocket.this + " accepted: " + socketChannel.getRemoteAddress() + "->" + socketChannel.getLocalAddress());
            }
            NioAcceptRequest acceptRequest = new NioAcceptRequest(socketChannel);
            try {
                NioAsyncServerSocket.this.consumer.accept(acceptRequest);
            }
            catch (Throwable t) {
                CloseUtil.closeQuietly(acceptRequest);
                throw ExceptionUtil.sneakyThrow(t);
            }
        }
    }
}

