/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.membergroup;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.partition.membergroup.BackupSafeMemberGroupFactory;
import com.hazelcast.internal.partition.membergroup.DefaultMemberGroup;
import com.hazelcast.internal.partition.membergroup.MemberGroupFactory;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.spi.partitiongroup.MemberGroup;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ZoneAwareMemberGroupFactory
extends BackupSafeMemberGroupFactory
implements MemberGroupFactory {
    @Override
    protected Set<MemberGroup> createInternalMemberGroups(Collection<? extends Member> allMembers) {
        Map<String, MemberGroup> groups = MapUtil.createHashMap(allMembers.size());
        for (Member member : allMembers) {
            String zoneInfo = member.getAttribute("hazelcast.partition.group.zone");
            if (zoneInfo == null) {
                throw new IllegalArgumentException("Not enough metadata information is provided. Availability zone information must be provided with ZONE_AWARE partition group.");
            }
            MemberGroup group = (MemberGroup)groups.get(zoneInfo);
            if (group == null) {
                group = new DefaultMemberGroup();
                groups.put(zoneInfo, group);
            }
            group.addMember(member);
        }
        return new HashSet<MemberGroup>(groups.values());
    }
}

