/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.nio;

import com.hazelcast.internal.tpcengine.Option;
import com.hazelcast.internal.tpcengine.net.AsyncSocketOptions;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SocketChannel;

public class NioAsyncSocketOptions
implements AsyncSocketOptions {
    private static final SocketOption<Integer> EXT_SOCK_OPTS_TCP_KEEPCOUNT = (SocketOption)ReflectionUtil.findStaticFieldValue("jdk.net.ExtendedSocketOptions", "TCP_KEEPCOUNT");
    private static final SocketOption<Integer> EXT_SOCK_OPTS_TCP_KEEPIDLE = (SocketOption)ReflectionUtil.findStaticFieldValue("jdk.net.ExtendedSocketOptions", "TCP_KEEPIDLE");
    private static final SocketOption<Integer> EXT_SO_OPTS_TCP_KEEPINTERVAL = (SocketOption)ReflectionUtil.findStaticFieldValue("jdk.net.ExtendedSocketOptions", "TCP_KEEPINTERVAL");
    private final SocketChannel socketChannel;

    NioAsyncSocketOptions(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    private static SocketOption toSocketOption(Option option) {
        if (TCP_NODELAY.equals(option)) {
            return StandardSocketOptions.TCP_NODELAY;
        }
        if (SO_RCVBUF.equals(option)) {
            return StandardSocketOptions.SO_RCVBUF;
        }
        if (SO_SNDBUF.equals(option)) {
            return StandardSocketOptions.SO_SNDBUF;
        }
        if (SO_KEEPALIVE.equals(option)) {
            return StandardSocketOptions.SO_KEEPALIVE;
        }
        if (SO_REUSEADDR.equals(option)) {
            return StandardSocketOptions.SO_REUSEADDR;
        }
        if (TCP_KEEPCOUNT.equals(option)) {
            return EXT_SOCK_OPTS_TCP_KEEPCOUNT;
        }
        if (TCP_KEEPINTERVAL.equals(option)) {
            return EXT_SO_OPTS_TCP_KEEPINTERVAL;
        }
        if (TCP_KEEPIDLE.equals(option)) {
            return EXT_SOCK_OPTS_TCP_KEEPIDLE;
        }
        return null;
    }

    @Override
    public boolean isSupported(Option option) {
        Preconditions.checkNotNull(option, "option");
        if (option.equals(SO_TIMEOUT)) {
            return true;
        }
        SocketOption socketOption = NioAsyncSocketOptions.toSocketOption(option);
        return this.isSupported(socketOption);
    }

    private boolean isSupported(SocketOption socketOption) {
        return socketOption != null && this.socketChannel.supportedOptions().contains(socketOption);
    }

    @Override
    public <T> T getIfSupported(Option<T> option) {
        Preconditions.checkNotNull(option, "option");
        try {
            if (option.equals(SO_TIMEOUT)) {
                return (T)Integer.valueOf(this.socketChannel.socket().getSoTimeout());
            }
            SocketOption socketOption = NioAsyncSocketOptions.toSocketOption(option);
            if (this.isSupported(socketOption)) {
                return this.socketChannel.getOption(socketOption);
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public <T> boolean setIfSupported(Option<T> option, T value) {
        Preconditions.checkNotNull(option, "option");
        Preconditions.checkNotNull(value, "value");
        try {
            if (option.equals(SO_TIMEOUT)) {
                this.socketChannel.socket().setSoTimeout((Integer)value);
                return true;
            }
            SocketOption socketOption = NioAsyncSocketOptions.toSocketOption(option);
            if (this.isSupported(socketOption)) {
                this.socketChannel.setOption(socketOption, (Object)value);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

