/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public final class JetUploadJobMetaDataCodec {
    public static final int REQUEST_MESSAGE_TYPE = 16650496;
    public static final int RESPONSE_MESSAGE_TYPE = 16650497;
    private static final int REQUEST_SESSION_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_JAR_ON_MEMBER_FIELD_OFFSET = 33;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 34;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private JetUploadJobMetaDataCodec() {
    }

    public static ClientMessage encodeRequest(UUID sessionId, boolean jarOnMember, String fileName, String sha256Hex, @Nullable String snapshotName, @Nullable String jobName, @Nullable String mainClass, Collection<String> jobParameters) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Jet.UploadJobMetaData");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[34], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16650496);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, sessionId);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 33, jarOnMember);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, fileName);
        StringCodec.encode(clientMessage, sha256Hex);
        CodecUtil.encodeNullable(clientMessage, snapshotName, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, jobName, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, mainClass, StringCodec::encode);
        ListMultiFrameCodec.encode(clientMessage, jobParameters, StringCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.sessionId = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        request.jarOnMember = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 33);
        request.fileName = StringCodec.decode(iterator);
        request.sha256Hex = StringCodec.decode(iterator);
        request.snapshotName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.jobName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.mainClass = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.jobParameters = ListMultiFrameCodec.decode(iterator, StringCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16650497);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public UUID sessionId;
        public boolean jarOnMember;
        public String fileName;
        public String sha256Hex;
        @Nullable
        public String snapshotName;
        @Nullable
        public String jobName;
        @Nullable
        public String mainClass;
        public List<String> jobParameters;
    }
}

