/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import com.lowagie.text.pdf.PdfReader;
import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaymentBatch;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.PaymentExport;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class PayPrint {
    protected int m_WindowNo = 0;
    protected int m_C_BankAccount_ID = -1;
    protected String m_PaymentExportClass = null;
    protected int m_C_PaySelection_ID = 0;
    protected MPaySelectionCheck[] m_checks = null;
    protected MPaymentBatch m_batch = null;
    protected static final CLogger log = CLogger.getCLogger(PayPrint.class);
    protected String bank;
    protected String currency;
    protected BigDecimal balance;
    protected PaymentExport m_PaymentExport;
    protected String noPayments;
    protected Integer documentNo;
    protected Double sumPayments;
    protected Integer printFormatId;

    public void loadPaySelectInfo(int C_PaySelection_ID) {
        block7: {
            this.m_C_BankAccount_ID = -1;
            String sql = "SELECT ps.C_BankAccount_ID, b.Name || ' ' || ba.AccountNo, c.ISO_Code, CurrentBalance, ba.PaymentExportClass FROM C_PaySelection ps INNER JOIN C_BankAccount ba ON (ps.C_BankAccount_ID=ba.C_BankAccount_ID) INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) INNER JOIN C_Currency c ON (ba.C_Currency_ID=c.C_Currency_ID) WHERE ps.C_PaySelection_ID=? AND ps.Processed='Y' AND ba.IsActive='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, C_PaySelection_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_C_BankAccount_ID = rs.getInt(1);
                        this.bank = rs.getString(2);
                        this.currency = rs.getString(3);
                        this.balance = rs.getBigDecimal(4);
                        this.m_PaymentExportClass = rs.getString(5);
                    } else {
                        this.m_C_BankAccount_ID = -1;
                        this.bank = "";
                        this.currency = "";
                        this.balance = Env.ZERO;
                        this.m_PaymentExportClass = null;
                        log.log(Level.SEVERE, "No active BankAccount for C_PaySelection_ID=" + C_PaySelection_ID);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public ArrayList<ValueNamePair> loadPaymentRule(int C_PaySelection_ID) {
        String sql;
        ArrayList<ValueNamePair> data;
        block7: {
            data = new ArrayList<ValueNamePair>();
            int AD_Reference_ID = 195;
            Language language = Language.getLanguage((String)Env.getAD_Language((Properties)Env.getCtx()));
            MLookupInfo info = MLookupFactory.getLookup_List((Language)language, (int)AD_Reference_ID);
            sql = info.Query.substring(0, info.Query.indexOf(" ORDER BY")) + " AND " + info.KeyColumn + " IN (SELECT PaymentRule FROM C_PaySelectionCheck WHERE C_PaySelection_ID=?) " + info.Query.substring(info.Query.indexOf(" ORDER BY"));
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, C_PaySelection_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ValueNamePair pp = new ValueNamePair(rs.getString(2), rs.getString(3));
                        data.add(pp);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (data.size() == 0 && log.isLoggable(Level.CONFIG)) {
            log.config("PaySel=" + C_PaySelection_ID + ", BAcct=" + this.m_C_BankAccount_ID + " - " + sql);
        }
        return data;
    }

    public String loadPaymentRuleInfo(int C_PaySelection_ID, String PaymentRule) {
        String msg;
        block13: {
            ResultSet rs;
            CPreparedStatement pstmt;
            String sql;
            block12: {
                msg = null;
                sql = "SELECT COUNT(*),SUM(payamt) FROM C_PaySelectionCheck WHERE C_PaySelection_ID=? AND PaymentRule=?";
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        pstmt.setInt(1, C_PaySelection_ID);
                        pstmt.setString(2, PaymentRule);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.noPayments = String.valueOf(rs.getInt(1));
                            this.sumPayments = rs.getDouble(2);
                        }
                    }
                    catch (SQLException e) {
                        log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            this.printFormatId = null;
            this.documentNo = null;
            sql = "SELECT CurrentNext, Check_PrintFormat_ID FROM C_BankAccountDoc WHERE C_BankAccount_ID=? AND PaymentRule=? AND IsActive='Y'";
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_C_BankAccount_ID);
                    pstmt.setString(2, PaymentRule);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.documentNo = rs.getInt(1);
                        this.printFormatId = rs.getInt(2);
                        break block13;
                    }
                    log.log(Level.SEVERE, "VPayPrint.loadPaymentRuleInfo - No active BankAccountDoc for C_BankAccount_ID=" + this.m_C_BankAccount_ID + " AND PaymentRule=" + PaymentRule);
                    msg = "VPayPrintNoDoc";
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            finally {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        return msg;
    }

    protected int loadPaymentExportClass(StringBuffer err) {
        this.m_PaymentExport = null;
        if (this.m_PaymentExportClass == null || this.m_PaymentExportClass.trim().length() == 0) {
            this.m_PaymentExportClass = "org.compiere.util.GenericPaymentExport";
        }
        try {
            this.m_PaymentExport = Core.getPaymentExporter((String)this.m_PaymentExportClass);
            if (this.m_PaymentExport == null) {
                Class<?> clazz = Class.forName(this.m_PaymentExportClass);
                this.m_PaymentExport = (PaymentExport)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            if (err != null) {
                err.append("No custom PaymentExport class " + this.m_PaymentExportClass + " - " + e.toString());
                log.log(Level.SEVERE, err.toString(), (Throwable)e);
            }
            return -1;
        }
        catch (Exception e) {
            if (err != null) {
                err.append("Error in " + this.m_PaymentExportClass + " check log, " + e.toString());
                log.log(Level.SEVERE, err.toString(), (Throwable)e);
            }
            return -1;
        }
        return 0;
    }

    protected List<File> createCheckDocuments(int startDocumentNo, String paymentRule) throws Exception {
        ArrayList<File> pdfList = new ArrayList<File>();
        int lastDocumentNo = startDocumentNo;
        int i = 0;
        while (i < this.m_checks.length) {
            MPaySelectionCheck check = this.m_checks[i];
            check.setDocumentNo(String.valueOf(lastDocumentNo));
            check.saveEx();
            MPaySelectionCheck.confirmPrint((MPaySelectionCheck)this.m_checks[i], (MPaymentBatch)this.m_batch);
            ReportEngine re = ReportEngine.get((Properties)Env.getCtx(), (int)6, (int)check.get_ID(), (int)this.m_WindowNo);
            MPrintFormat format = re.getPrintFormat();
            File pdfFile = null;
            if (format.getJasperProcess_ID() > 0) {
                ProcessInfo pi = new ProcessInfo("", format.getJasperProcess_ID());
                pi.setRecord_ID(check.get_ID());
                pi.setIsBatch(true);
                pi.setTransientObject((Object)format);
                ServerProcessCtl.process((ProcessInfo)pi, null);
                pdfFile = pi.getPDFReport();
            } else {
                pdfFile = File.createTempFile("WPayPrint", null);
                re.getPDF(pdfFile);
            }
            if (pdfFile != null) {
                PdfReader document = new PdfReader(pdfFile.getAbsolutePath());
                lastDocumentNo += document.getNumberOfPages();
                pdfList.add(pdfFile);
            }
            ++i;
        }
        if (startDocumentNo != lastDocumentNo) {
            StringBuilder sb = new StringBuilder();
            sb.append("UPDATE C_BankAccountDoc SET CurrentNext=").append(lastDocumentNo).append(" WHERE C_BankAccount_ID=").append(this.m_C_BankAccount_ID).append(" AND PaymentRule='").append(paymentRule).append("'");
            DB.executeUpdate((String)sb.toString(), null);
        }
        return pdfList;
    }

    protected List<File> createRemittanceDocuments() {
        ArrayList<File> pdfList = new ArrayList<File>();
        int i = 0;
        while (i < this.m_checks.length) {
            MPaySelectionCheck check = this.m_checks[i];
            ReportEngine re = ReportEngine.get((Properties)Env.getCtx(), (int)5, (int)check.get_ID(), (int)this.m_WindowNo);
            try {
                MPrintFormat format = re.getPrintFormat();
                if (format.getJasperProcess_ID() > 0) {
                    ProcessInfo pi = new ProcessInfo("", format.getJasperProcess_ID());
                    pi.setRecord_ID(check.get_ID());
                    pi.setIsBatch(true);
                    pi.setTransientObject((Object)format);
                    ServerProcessCtl.process((ProcessInfo)pi, null);
                    pdfList.add(pi.getPDFReport());
                } else {
                    File file = File.createTempFile("WPayPrint", null);
                    re.getPDF(file);
                    pdfList.add(file);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            }
            ++i;
        }
        return pdfList;
    }

    protected boolean getChecks(String PaymentRule, BigDecimal startDocumentNo, AtomicReference<ValueNamePair> error, String trxName) {
        if (this.m_C_PaySelection_ID <= 0 || this.m_C_BankAccount_ID == -1 || Util.isEmpty((String)PaymentRule, (boolean)true) || startDocumentNo == null) {
            error.set(new ValueNamePair("VPayPrintNoRecords", "(" + Msg.translate((Properties)Env.getCtx(), (String)"C_PaySelectionLine_ID") + " #0"));
            return false;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_PaySelection_ID=" + this.m_C_PaySelection_ID + ", PaymentRule=" + PaymentRule);
        }
        this.m_checks = MPaySelectionCheck.get((int)this.m_C_PaySelection_ID, (String)PaymentRule, (String)trxName);
        if (this.m_checks == null || this.m_checks.length == 0) {
            error.set(new ValueNamePair("VPayPrintNoRecords", "(" + Msg.translate((Properties)Env.getCtx(), (String)"C_PaySelectionLine_ID") + " #0"));
            return false;
        }
        this.m_batch = MPaymentBatch.getForPaySelection((Properties)Env.getCtx(), (int)this.m_C_PaySelection_ID, null);
        return true;
    }
}

