/******************************************************************************
 * Copyright (C) 2008 Low Heng Sin                                            *
 * Copyright (C) 2008 Idalica Corporation                                     *
 * This program is free software; you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program; if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 *****************************************************************************/
package org.adempiere.webui.desktop;

import org.adempiere.util.Callback;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.apps.ProcessDialog;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.InfoPanel;
import org.adempiere.webui.part.UIPart;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MQuery;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.EventQueue;

/**
 * Desktop interface
 * @author hengsin
 *
 */
public interface IDesktop extends UIPart {

	public static final String WINDOWNO_ATTRIBUTE = "desktop.windowno";
	/** {@link EventQueue} name for activities (workflow activities, request, notice and unprocessed documents) */
	public static final String ACTIVITIES_EVENT_QUEUE = "ActivitiesEventQueue";
	public static final String ON_ACTIVITIES_CHANGED_EVENT = "onActivitiesChanged";
	/** Event when closing window/tab with shortcut */
    public static final String ON_CLOSE_WINDOW_SHORTCUT_EVENT = "onCloseWindowShortcut";

	/**
	 *
	 * @return ClientInfo
	 */
	public ClientInfo getClientInfo();

	/**
	 * Launch menu item
	 * @param nodeId
	 */
	public void onMenuSelected(int nodeId);

	/**
	 * Launch AD Window in new record mode
	 * @param menuId
	 */
	public void onNewRecord(int menuId);
	
	/**
	 *
	 * @param window
	 * @return windowNo
	 */
	public int registerWindow(Object window);

	/**
	 *
	 * @param WindowNo
	 * @return Object
	 */
	public Object findWindow(int WindowNo);

	/**
	 * @param component
	 * @return register window no or -1 if not found
	 */
	public int findWindowNo(Component component);

	/**
	 * close active window
	 * @return boolean
	 */
	public boolean closeActiveWindow();
	
	/**
	 * get active window
	 * @return Component
	 */
	public Component getActiveWindow();

	/**
	 *
	 * @param windowNo
	 * @return boolean
	 */
	public boolean closeWindow(int windowNo);

	/**
	 *
	 * @param url
	 * @param closeable
	 */
	public void showURL(String url, boolean closeable);

	/**
	 *
	 * @param content
	 * @param title
	 * @param closeable
	 */
	public void showHTMLContent(String content, String title, boolean closeable);

	/**
	 *
	 * @param win
	 */
	public void showWindow(Window win);

	/**
	 *
	 * @param win
	 * @param position
	 */
	public void showWindow(Window win, String position);

	/**
	 *
	 * @param window_ID
	 * @param query
	 */
	public void showZoomWindow(int window_ID, MQuery query);

	/**
	 *
	 * @param window_ID
	 * @param query
	 * @deprecated
	 */
	public void showWindow(int window_ID, MQuery query);

	/**
	 *
	 * @param windowNo
	 */
	public void unregisterWindow(int windowNo);

	/**
     *
     * @param processId
     * @param soTrx
     * @return ProcessDialog
     */
	public ProcessDialog openProcessDialog(int processId, boolean soTrx);

	/**
     *
     * @param formId
     * @return ADWindow
     */
	public ADForm openForm(int formId);
	
	/**
    *
    * @param infoId
    */
	public void openInfo(int infoId);

	/**
	 *
	 * @param windowId
	 * @param callback
	 */
	public void openWindow(int windowId, Callback<ADWindow> callback);

	/**
	 *
	 * @param windowId
	 * @param query
	 * @param callback
	 */
	public void openWindow(int windowId, MQuery query, Callback<ADWindow> callback);

	/**
	 * Open operating system task window
	 * @param task_ID
	 */
	public void openTask(int task_ID);

	/**
	 *
	 * @param workflow_ID
	 */
	public void openWorkflow(int workflow_ID);

	/**
	 * Get the root component of the desktop
	 * @return Component
	 */
	public Component getComponent();

	/**
	 * Attached to page
	 * @param page
	 */
	public void setPage(Page page);

	/**
	 * @param clientInfo
	 */
	public void setClientInfo(ClientInfo clientInfo);

	/**
	 * User logout from desktop, do clean up
	 */
	public void logout();
	
	/**
	 * 
	 * @param callback callback after logout
	 */
	public default void logout(Callback<Boolean> callback) {
		logout();
		if (callback != null) {
			callback.onCallback(Boolean.TRUE);
		}
	}
	
	/**
	 * update help content in help/info panel
	 * @param infoWindowId
	 * @param infoPanel
	 */
	public void updateHelpContext(String ctxType, int infoWindowId, InfoPanel infoPanel);
	
	/**
	 * update help content in help/info panel
	 * @param ctxType
	 * @param recordId
	 */
	public void updateHelpContext(String ctxType, int recordId);
	
	/**
	 * update tooltip content in help/info panel
	 * @param gridField
	 */
	public void updateHelpTooltip(GridField gridField);

	/**
	 * update tooltip content in help/info panel
	 * @param hdr
	 * @param desc
	 * @param help
	 * @param otherContent
	 * @param entityType
	 */
	public void updateHelpTooltip(String hdr, String  desc, String help, String otherContent, String entityType);

	/**
	 * update quick info (status line) in help/info panel
	 * @param gridTab
	 */
	public void updateHelpQuickInfo(GridTab gridTab);
	
	/**
	 * update quick info (status line) in help/info panel
	 * @param infoPanel
	 */
	public void updateHelpQuickInfo(InfoPanel infoPanel);

	/**
	 * 
	 * @return true if there are changes not save yet
	 */
	public boolean isPendingWindow();

	/**
	 * update tab title by windowNo
	 * @param title
	 * @param windowNo
	 */
	public void setTabTitle(String title, int windowNo);
	
	/**
	 * render home tab
	 */
	public void renderHomeTab();
	
	/**
	 * Is closing tab with shortcut allowed
	 * @return true if allowed
	 */
	public boolean isCloseTabWithShortcut();
	
	/**
	 * Set if closing tab with shortcut is allowed
	 * @param isCloseTabWithShortcut
	 */
	public void setCloseTabWithShortcut(boolean isCloseTabWithShortcut);
}
