/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Properties;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.INumberEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public class WNumberEditor
extends WEditor
implements ContextMenuListener {
    public static final String[] LISTENER_EVENTS = new String[]{"onChange", "onOK"};
    public static final int MAX_DISPLAY_LENGTH = 35;
    public static final int MIN_DISPLAY_LENGTH = 11;
    private Object oldValue;
    private int displayType;
    private String originalStyle;

    public WNumberEditor() {
        this(22);
    }

    public WNumberEditor(int displayType) {
        this("Number", false, false, true, displayType, "");
    }

    public WNumberEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WNumberEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)WNumberEditor.newNumberBox(gridField, tableEditor, editorConfiguration), gridField, tableEditor, editorConfiguration);
        INumberEditorConfiguration config;
        this.displayType = gridField.getDisplayType();
        if (editorConfiguration != null && editorConfiguration instanceof INumberEditorConfiguration && (config = (INumberEditorConfiguration)editorConfiguration).getIntegral() != null) {
            this.displayType = config.getIntegral() != false ? 11 : 22;
        }
        this.init();
    }

    protected static NumberBox newNumberBox(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        INumberEditorConfiguration config;
        if (editorConfiguration != null && editorConfiguration instanceof INumberEditorConfiguration && (config = (INumberEditorConfiguration)editorConfiguration).getIntegral() != null) {
            return new NumberBox(config.getIntegral(), tableEditor);
        }
        return new NumberBox(gridField.getDisplayType() == 11, tableEditor);
    }

    public WNumberEditor(GridField gridField, final boolean integral) {
        this(gridField, false, new INumberEditorConfiguration(){

            @Override
            public Boolean getIntegral() {
                return integral;
            }
        });
    }

    public WNumberEditor(String columnName, boolean mandatory, boolean readonly, boolean updateable, int displayType, String title) {
        super((Component)new NumberBox(displayType == 11), columnName, title, null, mandatory, readonly, updateable);
        if (!DisplayType.isNumeric((int)displayType)) {
            throw new IllegalArgumentException("DisplayType must be numeric");
        }
        this.displayType = displayType;
        this.init();
    }

    private void init() {
        this.setChangeEventWhenEditing(true);
        if (this.gridField != null) {
            this.getComponent().setTooltiptext(this.gridField.getDescription());
            int displayLength = this.gridField.getDisplayLength();
            if (displayLength > 35) {
                displayLength = 35;
            } else if (displayLength <= 0 || displayLength < 11) {
                displayLength = 11;
            }
            if (!this.tableEditor) {
                this.getComponent().getDecimalbox().setCols(displayLength);
            }
        }
        if (DisplayType.isID((int)this.displayType)) {
            this.displayType = 11;
        } else if (!DisplayType.isNumeric((int)this.displayType)) {
            this.displayType = 22;
        }
        Language lang = AEnv.getLanguage(Env.getCtx());
        DecimalFormat format = DisplayType.getNumberFormat((int)this.displayType, (Language)lang);
        if (this.gridField != null && this.gridField.getFormatPattern() != null) {
            this.getComponent().getDecimalbox().setFormat(this.gridField.getFormatPattern());
        } else {
            this.getComponent().getDecimalbox().setFormat(format.toPattern());
        }
        this.getComponent().getDecimalbox().setLocale(lang.getLocale());
        this.getComponent().setFormat(format);
        this.popupMenu = new WEditorPopupMenu(false, false, this.isShowPreference());
        this.addChangeLogMenu(this.popupMenu);
        this.originalStyle = this.getComponent().getDecimalbox().getStyle();
        if (ClientInfo.isMobile()) {
            this.getComponent().getButton().setVisible(false);
        }
        if (this.gridField != null) {
            this.getComponent().getDecimalbox().setPlaceholder(this.gridField.getPlaceholder());
        }
    }

    public void onEvent(Event event) {
        if ("onChange".equalsIgnoreCase(event.getName()) || "onOK".equalsIgnoreCase(event.getName())) {
            Number newValue = this.getComponent().getValue();
            if (this.oldValue == null && newValue == null) {
                return;
            }
            if (this.displayType == 11) {
                if (newValue != null && newValue instanceof BigDecimal) {
                    newValue = newValue.intValue();
                }
                if (this.oldValue != null && this.oldValue instanceof BigDecimal) {
                    this.oldValue = ((BigDecimal)this.oldValue).intValue();
                }
            }
            if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
                return;
            }
            if ((this.displayType == 12 || this.displayType == 37) && newValue != null && newValue instanceof BigDecimal) {
                newValue = this.addDecimalPlaces((BigDecimal)newValue);
            }
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
            super.fireValueChange(changeEvent);
            this.oldValue = this.getComponent().getValue();
        }
    }

    public BigDecimal addDecimalPlaces(BigDecimal oldValue) {
        if (oldValue.toString().contains(".")) {
            return oldValue;
        }
        int decimalPlaces = Env.getContextAsInt((Properties)Env.getCtx(), (String)"AutomaticDecimalPlacesForAmoun");
        if (decimalPlaces <= 0) {
            return oldValue;
        }
        BigDecimal divisor = decimalPlaces == 2 ? Env.ONEHUNDRED : (decimalPlaces == 1 ? BigDecimal.TEN : BigDecimal.TEN.pow(decimalPlaces));
        BigDecimal newValue = oldValue.divide(divisor, decimalPlaces, RoundingMode.HALF_UP);
        return newValue;
    }

    public NumberBox getComponent() {
        return (NumberBox)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    @Override
    public BigDecimal getValue() {
        return this.getComponent().getValue();
    }

    @Override
    public void setValue(Object value) {
        this.oldValue = value == null ? null : (value instanceof BigDecimal ? (BigDecimal)value : (value instanceof Number ? BigDecimal.valueOf(((Number)value).doubleValue()) : new BigDecimal(value.toString())));
        this.getComponent().setValue(this.oldValue);
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
            if (this.isShowPreference()) {
                ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
            }
            return;
        }
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        }
    }

    @Override
    public void setTableEditor(boolean b) {
        super.setTableEditor(b);
        this.getComponent().setTableEditorMode(b);
    }

    @Override
    protected void setFieldStyle(String style) {
        StringBuilder s = new StringBuilder(this.originalStyle);
        if (s.charAt(s.length() - 1) != ';') {
            s.append(";");
        }
        if (!Util.isEmpty((String)style)) {
            s.append(style);
        }
        this.getComponent().getDecimalbox().setStyle(s.toString());
    }
}

