/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import com.google.common.net.MediaType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleHtmlReportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import org.adempiere.webui.window.IReportViewerExportSource;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.idempiere.ui.zk.media.Medias;
import org.zkoss.util.media.AMedia;

public class JasperPrintRenderer {
    protected JasperPrint jasperPrint;
    protected final Map<String, Supplier<AMedia>> mediaSuppliers = new HashMap<String, Supplier<AMedia>>();
    private String title;
    private List<JasperPrint> jasperPrintList;
    private boolean isList;
    private static final CLogger log = CLogger.getCLogger(JasperPrintRenderer.class);
    private final IReportViewerExportSource.ExportFormat[] exportFormats = new IReportViewerExportSource.ExportFormat[]{new IReportViewerExportSource.ExportFormat(Msg.getMsg((Properties)Env.getCtx(), (String)"FilePDF"), "pdf", Medias.PDF_MIME_TYPE), new IReportViewerExportSource.ExportFormat(Msg.getMsg((Properties)Env.getCtx(), (String)"FileHTML"), "html", Medias.HTML_MIME_TYPE), new IReportViewerExportSource.ExportFormat(Msg.getMsg((Properties)Env.getCtx(), (String)"FileCSV"), "csv", Medias.CSV_MIME_TYPE), new IReportViewerExportSource.ExportFormat(Msg.getMsg((Properties)Env.getCtx(), (String)"FileXLS"), "xls", Medias.EXCEL_MIME_TYPE), new IReportViewerExportSource.ExportFormat(Msg.getMsg((Properties)Env.getCtx(), (String)"FileXLSX"), "xlsx", Medias.EXCEL_XML_MIME_TYPE), new IReportViewerExportSource.ExportFormat(Msg.getMsg((Properties)Env.getCtx(), (String)"FileSSV"), "ssv", Medias.CSV_MIME_TYPE)};
    private File pdfFile;
    private int rowCount;

    public JasperPrintRenderer(JasperPrint jasperPrint, String title) {
        this.jasperPrint = jasperPrint;
        this.title = title;
        this.isList = false;
        this.initMediaSuppliers();
    }

    public JasperPrintRenderer(List<JasperPrint> jasperPrintList, String title) {
        this.jasperPrintList = jasperPrintList;
        this.title = title;
        this.isList = true;
        this.initMediaSuppliers();
    }

    private void initMediaSuppliers() {
        this.mediaSuppliers.put(this.toMediaType(Medias.PDF_MIME_TYPE, "pdf"), () -> {
            try {
                this.createPDF();
                return new AMedia(this.makePrefix(this.title) + ".pdf", "pdf", Medias.PDF_MIME_TYPE, this.pdfFile, true);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        });
        this.mediaSuppliers.put(this.toMediaType(Medias.HTML_MIME_TYPE, "html"), () -> {
            try {
                String path = System.getProperty("java.io.tmpdir");
                Object prefix = null;
                prefix = this.isList ? this.makePrefix(this.jasperPrintList.get(0).getName()) + "_List" : this.makePrefix(this.jasperPrint.getName());
                if (((String)prefix).length() < 3) {
                    prefix = (String)prefix + "_".repeat(3 - ((String)prefix).length());
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path=" + path + " Prefix=" + (String)prefix);
                }
                File file = File.createTempFile((String)prefix, ".html", new File(path));
                HtmlExporter exporter = new HtmlExporter();
                SimpleHtmlReportConfiguration htmlConfig = new SimpleHtmlReportConfiguration();
                htmlConfig.setEmbedImage(Boolean.valueOf(true));
                htmlConfig.setAccessibleHtml(Boolean.valueOf(true));
                if (!this.isList) {
                    this.jasperPrintList = new ArrayList<JasperPrint>();
                    this.jasperPrintList.add(this.jasperPrint);
                }
                exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                exporter.setExporterOutput((ExporterOutput)new SimpleHtmlExporterOutput(file));
                exporter.setConfiguration((ReportExportConfiguration)htmlConfig);
                exporter.exportReport();
                return new AMedia(this.makePrefix(this.title) + ".html", "html", Medias.HTML_MIME_TYPE, file, false);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        });
        this.mediaSuppliers.put(this.toMediaType(Medias.EXCEL_MIME_TYPE, "xls"), () -> {
            try {
                String path = System.getProperty("java.io.tmpdir");
                Object prefix = null;
                prefix = this.isList ? this.makePrefix(this.jasperPrintList.get(0).getName()) + "_List" : this.makePrefix(this.jasperPrint.getName());
                if (((String)prefix).length() < 3) {
                    prefix = (String)prefix + "_".repeat(3 - ((String)prefix).length());
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path=" + path + " Prefix=" + (String)prefix);
                }
                File file = File.createTempFile((String)prefix, ".xls", new File(path));
                try (FileOutputStream fos = null;){
                    fos = new FileOutputStream(file);
                    JRXlsExporter exporterXLS = new JRXlsExporter();
                    SimpleXlsReportConfiguration xlsConfig = new SimpleXlsReportConfiguration();
                    xlsConfig.setOnePagePerSheet(Boolean.valueOf(false));
                    if (!this.isList) {
                        this.jasperPrintList = new ArrayList<JasperPrint>();
                        this.jasperPrintList.add(this.jasperPrint);
                    }
                    this.validateJasperPrintNameForExcelExporter(this.jasperPrintList);
                    exporterXLS.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                    exporterXLS.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)fos));
                    exporterXLS.setConfiguration((ReportExportConfiguration)xlsConfig);
                    exporterXLS.exportReport();
                }
                return new AMedia(this.makePrefix(this.title) + ".xls", "xls", Medias.EXCEL_MIME_TYPE, file, true);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        });
        this.mediaSuppliers.put(this.toMediaType(Medias.EXCEL_XML_MIME_TYPE, "xlsx"), () -> {
            try {
                String path = System.getProperty("java.io.tmpdir");
                Object prefix = null;
                prefix = this.isList ? this.makePrefix(this.jasperPrintList.get(0).getName()) + "_List" : this.makePrefix(this.jasperPrint.getName());
                if (((String)prefix).length() < 3) {
                    prefix = (String)prefix + "_".repeat(3 - ((String)prefix).length());
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path=" + path + " Prefix=" + (String)prefix);
                }
                File file = File.createTempFile((String)prefix, ".xlsx", new File(path));
                try (FileOutputStream fos = null;){
                    fos = new FileOutputStream(file);
                    JRXlsxExporter exporterXLSX = new JRXlsxExporter();
                    SimpleXlsxReportConfiguration xlsxConfig = new SimpleXlsxReportConfiguration();
                    xlsxConfig.setOnePagePerSheet(Boolean.valueOf(false));
                    if (!this.isList) {
                        this.jasperPrintList = new ArrayList<JasperPrint>();
                        this.jasperPrintList.add(this.jasperPrint);
                    }
                    this.validateJasperPrintNameForExcelExporter(this.jasperPrintList);
                    exporterXLSX.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                    exporterXLSX.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)fos));
                    exporterXLSX.setConfiguration((ReportExportConfiguration)xlsxConfig);
                    exporterXLSX.exportReport();
                }
                return new AMedia(this.makePrefix(this.title) + ".xlsx", "xlsx", Medias.EXCEL_XML_MIME_TYPE, file, true);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        });
        this.mediaSuppliers.put(this.toMediaType(Medias.CSV_MIME_TYPE, "csv"), () -> {
            try {
                String path = System.getProperty("java.io.tmpdir");
                Object prefix = null;
                prefix = this.isList ? this.makePrefix(this.jasperPrintList.get(0).getName()) + "_List" : this.makePrefix(this.jasperPrint.getName());
                if (((String)prefix).length() < 3) {
                    prefix = (String)prefix + "_".repeat(3 - ((String)prefix).length());
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path=" + path + " Prefix=" + (String)prefix);
                }
                File file = File.createTempFile((String)prefix, ".csv", new File(path));
                try (FileOutputStream fos = null;){
                    fos = new FileOutputStream(file);
                    JRCsvExporter exporter = new JRCsvExporter();
                    if (!this.isList) {
                        this.jasperPrintList = new ArrayList<JasperPrint>();
                        this.jasperPrintList.add(this.jasperPrint);
                    }
                    exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                    exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput((OutputStream)fos));
                    exporter.exportReport();
                }
                return new AMedia(this.makePrefix(this.title) + ".csv", "csv", Medias.CSV_MIME_TYPE, file, false);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        });
        this.mediaSuppliers.put(this.toMediaType(Medias.CSV_MIME_TYPE, "ssv"), () -> {
            try {
                String path = System.getProperty("java.io.tmpdir");
                Object prefix = null;
                prefix = this.isList ? this.makePrefix(this.jasperPrintList.get(0).getName()) + "_List" : this.makePrefix(this.jasperPrint.getName());
                if (((String)prefix).length() < 3) {
                    prefix = (String)prefix + "_".repeat(3 - ((String)prefix).length());
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path=" + path + " Prefix=" + (String)prefix);
                }
                File file = File.createTempFile((String)prefix, ".ssv", new File(path));
                try (FileOutputStream fos = null;){
                    fos = new FileOutputStream(file);
                    JRCsvExporter exporter = new JRCsvExporter();
                    SimpleCsvExporterConfiguration csvConfig = new SimpleCsvExporterConfiguration();
                    csvConfig.setFieldDelimiter(";");
                    if (!this.isList) {
                        this.jasperPrintList = new ArrayList<JasperPrint>();
                        this.jasperPrintList.add(this.jasperPrint);
                    }
                    exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                    exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput((OutputStream)fos));
                    exporter.setConfiguration((ExporterConfiguration)csvConfig);
                    exporter.exportReport();
                }
                return new AMedia(this.makePrefix(this.title) + ".ssv", "ssv", Medias.CSV_MIME_TYPE, file, false);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private void validateJasperPrintNameForExcelExporter(List<JasperPrint> jaspers) {
        for (JasperPrint jasper : jaspers) {
            String name = this.makePrefix(jasper.getName());
            if (name.equals(jasper.getName())) continue;
            jasper.setName(name);
        }
    }

    public AMedia getMedia(String contentType, String fileExtension) {
        Supplier<AMedia> supplier = this.mediaSuppliers.get(this.toMediaType(contentType, fileExtension));
        return supplier != null ? supplier.get() : null;
    }

    public IReportViewerExportSource.ExportFormat[] getExportFormats() {
        return this.exportFormats;
    }

    public static ValueNamePair[] getPreviewType(boolean canExport) {
        ArrayList<ValueNamePair> list = new ArrayList<ValueNamePair>();
        if (canExport) {
            list.add(new ValueNamePair("PDF", "PDF"));
            list.add(new ValueNamePair("HTML", "HTML"));
            list.add(new ValueNamePair("XLS", "XLS"));
            list.add(new ValueNamePair("CSV", "CSV"));
            list.add(new ValueNamePair("XLSX", "XLSX"));
        } else {
            list.add(new ValueNamePair("PDF", "PDF"));
            list.add(new ValueNamePair("HTML", "HTML"));
        }
        return list.toArray(new ValueNamePair[0]);
    }

    private String toMediaType(String contentType, String fileExtension) {
        return contentType + ";" + fileExtension;
    }

    private String makePrefix(String name) {
        char[] nameArray;
        StringBuilder prefix = new StringBuilder();
        char[] cArray = nameArray = name.toCharArray();
        int n = nameArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isLetterOrDigit(ch)) {
                prefix.append(ch);
            } else {
                prefix.append("_");
            }
            ++n2;
        }
        return prefix.toString();
    }

    protected File createPDF() throws IOException, JRException {
        String path = System.getProperty("java.io.tmpdir");
        Object prefix = null;
        prefix = this.isList ? this.makePrefix(this.jasperPrintList.get(0).getName()) + "_List" : this.makePrefix(this.jasperPrint.getName());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Path=" + path + " Prefix=" + (String)prefix);
        }
        this.pdfFile = new File(FileUtil.getTempMailName((String)prefix, (String)".pdf"));
        SimpleJasperReportsContext context = new SimpleJasperReportsContext((JasperReportsContext)DefaultJasperReportsContext.getInstance());
        JRPdfExporter exporter = new JRPdfExporter((JasperReportsContext)context);
        if (!this.isList) {
            this.jasperPrintList = new ArrayList<JasperPrint>();
            this.jasperPrintList.add(this.jasperPrint);
        }
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(this.pdfFile));
        exporter.exportReport();
        return this.pdfFile;
    }

    protected File getPDF() {
        return this.pdfFile;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public static String getMIMEType(String outputType) {
        if ("PDF".equals(outputType)) {
            return Medias.PDF_MIME_TYPE;
        }
        if ("HTML".equals(outputType)) {
            return Medias.HTML_MIME_TYPE;
        }
        if ("XLS".equals(outputType)) {
            return Medias.EXCEL_MIME_TYPE;
        }
        if ("XLSX".equals(outputType)) {
            return Medias.EXCEL_XML_MIME_TYPE;
        }
        if ("CSV".equals(outputType)) {
            return Medias.CSV_MIME_TYPE;
        }
        return MediaType.APPLICATION_BINARY.toString();
    }

    public static String getFileExtension(String outputType) {
        if ("PDF".equals(outputType)) {
            return "pdf";
        }
        if ("HTML".equals(outputType)) {
            return "html";
        }
        if ("XLS".equals(outputType)) {
            return "xls";
        }
        if ("XLSX".equals(outputType)) {
            return "xlsx";
        }
        if ("CSV".equals(outputType)) {
            return "csv";
        }
        return ".binary";
    }
}

