/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel.action;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.base.IGridTabImporter;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.AdempiereWebUI;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.adwindow.IADTabbox;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ReaderInputStream;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.GridTab;
import org.compiere.model.MImportTemplate;
import org.compiere.model.MQuery;
import org.compiere.model.MSysConfig;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Vlayout;

public class CSVImportAction
implements EventListener<Event> {
    private AbstractADWindowContent panel;
    IGridTabImporter theCSVImporter = null;
    MImportTemplate theTemplate = null;
    private Window winImportFile = null;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private Button bFile = new Button();
    private Listbox fTemplates = new Listbox();
    private Listbox fImportMode = new Listbox();
    private InputStream m_file_istream = null;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));

    public CSVImportAction(AbstractADWindowContent panel) {
        this.panel = panel;
    }

    public void fileImport() {
        List importerList = EquinoxExtensionLocator.instance().list(IGridTabImporter.class).getExtensions();
        for (IGridTabImporter importer : importerList) {
            String extension = importer.getFileExtension();
            if (!extension.equals("csv")) continue;
            this.theCSVImporter = importer;
            break;
        }
        if (this.theCSVImporter == null) {
            throw new AdempiereException("No CSV importer");
        }
        int tabid = -1;
        if (this.panel != null && this.panel.getActiveGridTab() != null) {
            tabid = this.panel.getActiveGridTab().getAD_Tab_ID();
        }
        for (MImportTemplate it : MImportTemplate.getTemplates((int)Env.getAD_Role_ID((Properties)Env.getCtx()), (int)tabid)) {
            if (this.theTemplate == null) {
                this.theTemplate = it;
            }
            this.fTemplates.appendItem(it.getName(), it);
        }
        this.fTemplates.addEventListener("onSelect", this);
        if (this.fTemplates.getItemCount() <= 0) {
            throw new AdempiereException("No templates for this tab");
        }
        this.fTemplates.setSelectedIndex(0);
        this.setTemplateList();
        if (this.winImportFile == null) {
            this.winImportFile = new Window();
            this.winImportFile.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImport") + ": " + this.panel.getActiveGridTab().getName());
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this.winImportFile, 450);
            this.winImportFile.setClosable(true);
            this.winImportFile.setBorder("normal");
            this.winImportFile.setStyle("position:absolute");
            this.winImportFile.setWidgetAttribute("instanceName", "importAction");
            this.winImportFile.setSclass("popup-dialog");
            Vbox vb = new Vbox();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)vb, "100%");
            this.winImportFile.appendChild((Component)vb);
            Vlayout vlayout = new Vlayout();
            vlayout.setSclass("dialog-content");
            vb.appendChild((Component)vlayout);
            Grid grid = GridFactory.newGridLayout();
            vlayout.appendChild((Component)grid);
            Columns columns = new Columns();
            Column column = new Column();
            ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
            columns.appendChild((Component)column);
            column = new Column();
            ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "1");
            columns.appendChild((Component)column);
            grid.appendChild((Component)columns);
            Rows rows = new Rows();
            grid.appendChild((Component)rows);
            Row row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)new Label(Msg.getElement((Properties)Env.getCtx(), (String)"AD_ImportTemplate_ID") + ": "));
            this.fTemplates.setMold("select");
            this.fTemplates.setRows(0);
            this.fTemplates.setTooltiptext(Msg.getElement((Properties)Env.getCtx(), (String)"AD_ImportTemplate_ID"));
            row.appendChild((Component)this.fTemplates);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fTemplates, "1");
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"import.mode", (boolean)true)));
            this.fImportMode.setMold("select");
            this.fImportMode.setRows(0);
            this.fImportMode.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"import.mode", (boolean)false));
            row.appendChild((Component)this.fImportMode);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fImportMode, "1");
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)new Space());
            this.bFile.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImportFile"));
            this.bFile.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImportFileInfo"));
            this.bFile.setUpload(AdempiereWebUI.getUploadSetting());
            LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.bFile);
            this.bFile.addEventListener("onUpload", this);
            row.appendChild((Component)this.bFile);
            LayoutUtils.addSclass("dialog-footer", (HtmlBasedComponent)this.confirmPanel);
            vb.appendChild((Component)this.confirmPanel);
            this.confirmPanel.addActionListener(this);
            this.winImportFile.addEventListener("onCancel", e -> this.onCancel());
        }
        this.panel.getComponent().getParent().appendChild((Component)this.winImportFile);
        this.panel.showBusyMask(this.winImportFile);
        LayoutUtils.openOverlappedWindow(this.panel.getComponent(), this.winImportFile, "middle_center");
        this.winImportFile.addEventListener("onWindowClose", this);
        this.winImportFile.setFocus(true);
    }

    private void setTemplateList() {
        Charset charset = Charset.forName(this.theTemplate.getCharacterSet());
        Executions.getCurrent().getDesktop().getWebApp().getConfiguration().setUploadCharset(charset.name());
        this.bFile.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImportFile"));
        this.fillImportMode();
    }

    public void onEvent(Event event) throws Exception {
        if (event instanceof UploadEvent) {
            UploadEvent ue = (UploadEvent)event;
            this.processUploadMedia(ue.getMedia());
        } else if (event.getTarget().getId().equals("Cancel")) {
            this.onCancel();
        } else if (event.getTarget() == this.fTemplates) {
            ListItem listitem;
            if (this.m_file_istream != null) {
                this.m_file_istream.close();
                this.m_file_istream = null;
            }
            if ((listitem = this.fTemplates.getSelectedItem()) == null) {
                return;
            }
            this.theTemplate = (MImportTemplate)listitem.getValue();
            this.setTemplateList();
        } else if (event.getTarget().getId().equals("Ok")) {
            if (this.m_file_istream == null || this.fTemplates.getSelectedItem() == null) {
                return;
            }
            this.importFile();
        } else if (event.getName().equals("onWindowClose")) {
            this.panel.hideBusyMask();
            this.panel.focusToLastFocusEditor();
        }
    }

    private void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.winImportFile.onClose();
    }

    private void fillImportMode() {
        List flags = DB.getSQLValueObjectsEx(null, (String)"SELECT MAX(IsAllowInsert),        MAX(IsAllowUpdate),        MAX(IsAllowMerge) FROM   AD_ImportTemplateAccess WHERE  IsActive = 'Y'        AND AD_ImportTemplate_ID = ?        AND ( AD_Role_ID = ?               OR AD_Role_ID IN (SELECT Included_Role_ID                                 FROM   AD_Role_Included                                 WHERE  AD_Role_ID = ?                                        AND IsActive = 'Y') )        AND ( IsAllowInsert = 'Y'               OR IsAllowMerge = 'Y'               OR IsAllowUpdate = 'Y' )", (Object[])new Object[]{this.theTemplate.getAD_ImportTemplate_ID(), Env.getAD_Role_ID((Properties)Env.getCtx()), Env.getAD_Role_ID((Properties)Env.getCtx())});
        this.fImportMode.removeAllItems();
        if (flags.get(0) != null && "Y".equals(flags.get(0).toString())) {
            this.fImportMode.appendItem("Insert", "I");
        }
        if (flags.get(1) != null && "Y".equals(flags.get(1).toString())) {
            this.fImportMode.appendItem("Update", "U");
        }
        if (flags.get(2) != null && "Y".equals(flags.get(2).toString())) {
            this.fImportMode.appendItem("Merge", "M");
        }
        if (this.fImportMode.getItemCount() == 1) {
            this.fImportMode.setSelectedIndex(0);
        }
    }

    private void processUploadMedia(Media media) {
        if (media == null) {
            return;
        }
        if (media.isBinary()) {
            this.m_file_istream = media.getStreamData();
        } else if (this.theTemplate == null) {
            this.m_file_istream = new ReaderInputStream(media.getReaderData());
        } else {
            Charset charset = Charset.forName(this.theTemplate.getCharacterSet());
            this.m_file_istream = new ReaderInputStream(media.getReaderData(), charset.name());
        }
        this.bFile.setLabel(media.getName());
    }

    private void importFile() {
        try {
            String tableName;
            MQuery query = this.panel.getActiveGridTab().getQuery();
            MQuery detailQuery = null;
            if (this.panel.getADTab() != null && this.panel.getADTab().getSelectedDetailADTabpanel() != null && this.panel.getADTab().getSelectedDetailADTabpanel().getGridTab() != null) {
                detailQuery = this.panel.getADTab().getSelectedDetailADTabpanel().getGridTab().getQuery();
            }
            IADTabbox adTab = this.panel.getADTab();
            int selected = adTab.getSelectedIndex();
            int tabLevel = this.panel.getActiveGridTab().getTabLevel();
            HashSet<String> tables = new HashSet<String>();
            ArrayList<GridTab> childs = new ArrayList<GridTab>();
            List includedList = this.panel.getActiveGridTab().getIncludedTabs();
            for (GridTab included : includedList) {
                tableName = included.getTableName();
                if (tables.contains(tableName)) continue;
                tables.add(tableName);
                childs.add(included);
            }
            int i = selected + 1;
            while (i < adTab.getTabCount()) {
                IADTabpanel adTabPanel = adTab.getADTabpanel(i);
                if (!adTabPanel.getGridTab().isSortTab()) {
                    if (adTabPanel.getGridTab().getTabLevel() <= tabLevel) break;
                    tableName = adTabPanel.getGridTab().getTableName();
                    if (!tables.contains(tableName)) {
                        tables.add(tableName);
                        childs.add(adTabPanel.getGridTab());
                    }
                }
                ++i;
            }
            Charset charset = Charset.forName(this.theTemplate.getCharacterSet());
            Executions.getCurrent().getDesktop().getWebApp().getConfiguration().setUploadCharset(charset.name());
            ListItem importItem = this.fImportMode.getSelectedItem();
            if (importItem == null) {
                return;
            }
            try {
                String iMode = (String)importItem.getValue();
                this.m_file_istream = this.theTemplate.validateFile(this.m_file_istream);
                File outFile = this.theCSVImporter.fileImport(this.panel.getActiveGridTab(), childs, this.m_file_istream, charset, iMode, this.theTemplate.getSeparatorChar(), this.theTemplate.getQuoteChar(), null);
                this.winImportFile.onClose();
                this.winImportFile = null;
                AMedia media = null;
                media = new AMedia(this.theCSVImporter.getSuggestedFileName(this.panel.getActiveGridTab()), null, this.theCSVImporter.getContentType(), outFile, true);
                Filedownload.save((Media)media);
                if (query != null) {
                    query.addRestriction("1=1");
                    this.panel.getActiveGridTab().setQuery(query);
                    this.panel.getADTab().getSelectedTabpanel().query(false, 0, this.panel.getActiveGridTab().getMaxQueryRecords());
                }
                this.panel.getActiveGridTab().dataRefresh(false);
                if (detailQuery != null) {
                    detailQuery.addRestriction("1=1");
                    this.panel.getADTab().getSelectedDetailADTabpanel().getGridTab().setQuery(detailQuery);
                    this.panel.getADTab().getSelectedDetailADTabpanel().query(false, 0, this.panel.getActiveGridTab().getMaxQueryRecords());
                    this.panel.getADTab().getSelectedDetailADTabpanel().getGridTab().dataRefresh(false);
                }
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
        finally {
            if (this.winImportFile != null) {
                this.winImportFile.onClose();
            }
        }
    }
}

