/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.event.DialogEvents;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.GridTab;
import org.compiere.model.MClientInfo;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWFActivity;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vlayout;

public class WDocActionPanel
extends Window
implements EventListener<Event>,
DialogEvents {
    private static final long serialVersionUID = -3218367479851088526L;
    private Label lblDocAction;
    private Label label;
    private Listbox lstDocAction;
    private GridTab gridTab;
    private String[] s_value = null;
    private String[] s_name;
    private String[] s_description;
    private String DocStatus;
    private String DocAction;
    private int m_AD_Table_ID;
    private boolean m_OKpressed;
    private ConfirmPanel confirmPanel;
    private static final CLogger logger = CLogger.getCLogger(WDocActionPanel.class);

    public WDocActionPanel(GridTab mgridTab) {
        this(mgridTab, false);
    }

    public WDocActionPanel(GridTab mgridTab, boolean fromMenu) {
        this.gridTab = mgridTab;
        this.DocStatus = (String)this.gridTab.getValue("DocStatus");
        this.DocAction = (String)this.gridTab.getValue("DocAction");
        this.m_AD_Table_ID = mgridTab.getAD_Table_ID();
        this.readReference();
        this.initComponents();
        this.dynInit(fromMenu);
        this.init();
    }

    private void dynInit(boolean fromMenu) {
        Object Processing = this.gridTab.getValue("Processing");
        String OrderType = Env.getContext((Properties)Env.getCtx(), (int)this.gridTab.getWindowNo(), (String)"OrderType");
        String IsSOTrx = Env.getContext((Properties)Env.getCtx(), (int)this.gridTab.getWindowNo(), (String)"IsSOTrx");
        if (this.DocStatus == null) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("DocStatus=" + this.DocStatus + ", DocAction=" + this.DocAction + ", OrderType=" + OrderType + ", IsSOTrx=" + IsSOTrx + ", Processing=" + String.valueOf(Processing) + ", AD_Table_ID=" + this.gridTab.getAD_Table_ID() + ", Record_ID=" + this.gridTab.getRecord_ID());
        }
        int index = 0;
        if (this.lstDocAction.getSelectedItem() != null) {
            String selected = this.lstDocAction.getSelectedItem().getValue().toString();
            int i = 0;
            while (i < this.s_value.length && index == 0) {
                if (this.s_value[i].equals(selected)) {
                    index = i;
                }
                ++i;
            }
        }
        String[] options = new String[this.s_value.length];
        String wfStatus = MWFActivity.getActiveInfo((Properties)Env.getCtx(), (int)this.m_AD_Table_ID, (int)this.gridTab.getRecord_ID());
        if (wfStatus != null) {
            if (!fromMenu) {
                Dialog.error(this.gridTab.getWindowNo(), "WFActiveForRecord", wfStatus);
            }
            return;
        }
        if (!this.checkStatus(this.gridTab.getTableName(), this.gridTab.getRecord_ID(), this.DocStatus)) {
            Dialog.error(this.gridTab.getWindowNo(), "DocumentStatusChanged");
            return;
        }
        MTable table = MTable.get((Properties)Env.getCtx(), (int)this.m_AD_Table_ID);
        PO po = table.getPO(this.gridTab.getRecord_ID(), null);
        boolean periodOpen = true;
        if (po instanceof DocAction) {
            periodOpen = MPeriod.isOpen((Properties)Env.getCtx(), (int)this.m_AD_Table_ID, (int)this.gridTab.getRecord_ID(), null);
        }
        String[] docActionHolder = new String[]{this.DocAction};
        index = DocumentEngine.getValidActions((String)this.DocStatus, (Object)Processing, (String)OrderType, (String)IsSOTrx, (int)this.m_AD_Table_ID, (String[])docActionHolder, (String[])options, (boolean)periodOpen, (PO)po);
        Integer doctypeId = (Integer)this.gridTab.getValue("C_DocTypeTarget_ID");
        if (doctypeId == null || doctypeId == 0) {
            doctypeId = (Integer)this.gridTab.getValue("C_DocType_ID");
        }
        if (doctypeId == null && 735 == this.m_AD_Table_ID) {
            doctypeId = MDocType.getDocType((String)"CMA");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("get doctype: " + String.valueOf(doctypeId));
        }
        if (doctypeId != null) {
            index = DocumentEngine.checkActionAccess((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Role_ID((Properties)Env.getCtx()), (int)doctypeId, (String[])options, (int)index);
        }
        this.DocAction = docActionHolder[0];
        boolean firstadded = true;
        int i = 0;
        while (i < index) {
            boolean added = false;
            int j = 0;
            while (j < this.s_value.length && !added) {
                if (options[i].equals(this.s_value[j])) {
                    Listitem newitem = this.lstDocAction.appendItem(this.s_name[j], this.s_value[j]);
                    if (firstadded) {
                        this.lstDocAction.setSelectedItem(newitem);
                        firstadded = false;
                    }
                    added = true;
                }
                ++j;
            }
            ++i;
        }
        List lst = this.lstDocAction.getItems();
        for (Listitem item : lst) {
            String value = item.getValue().toString();
            if (!this.DocAction.equals(value)) continue;
            this.lstDocAction.setSelectedItem(item);
            this.label.setValue(this.s_description[this.getSelectedIndex()]);
        }
        if (this.DocAction.equals("--")) {
            this.DocAction = "CL";
        }
    }

    public List<Listitem> getDocActionItems() {
        return this.lstDocAction.getItems();
    }

    private boolean checkStatus(String TableName, int Record_ID, String DocStatus) {
        String sql = "SELECT 2 FROM " + TableName + " WHERE " + TableName + "_ID=" + Record_ID + " AND DocStatus='" + DocStatus + "'";
        int result = DB.getSQLValue(null, (String)sql);
        return result == 2;
    }

    private void initComponents() {
        this.lblDocAction = new Label();
        this.lblDocAction.setValue(Msg.translate((Properties)Env.getCtx(), (String)"DocAction"));
        this.label = new Label();
        this.lstDocAction = new Listbox();
        this.lstDocAction.setId("lstDocAction");
        this.lstDocAction.setRows(0);
        this.lstDocAction.setMold("select");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstDocAction, "200px");
        this.lstDocAction.addEventListener("onSelect", (EventListener)this);
        this.confirmPanel = new ConfirmPanel(true);
        this.confirmPanel.addActionListener("onClick", this);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.confirmPanel, "true");
    }

    private void init() {
        this.setSclass("popup-dialog doc-action-dialog");
        Vlayout vlayout = new Vlayout();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)vlayout, "1");
        this.appendChild((Component)vlayout);
        this.setWidgetAttribute("instanceName", "documentAction");
        Grid grid = GridFactory.newGridLayout();
        grid.setStyle("background-image: none;");
        LayoutUtils.addSclass("dialog-content", (HtmlBasedComponent)grid);
        vlayout.appendChild((Component)grid);
        Rows rows = new Rows();
        grid.appendChild((Component)rows);
        Row rowDocAction = new Row();
        Row rowLabel = new Row();
        Row rowSpacer = new Row();
        Panel pnlDocAction = new Panel();
        pnlDocAction.appendChild((Component)this.lblDocAction);
        pnlDocAction.appendChild((Component)new Space());
        pnlDocAction.appendChild((Component)this.lstDocAction);
        rowDocAction.appendChild((Component)pnlDocAction);
        rowLabel.appendChild((Component)this.label);
        rowSpacer.appendChild((Component)new Space());
        rows.appendChild((Component)rowDocAction);
        rows.appendChild((Component)rowLabel);
        rows.appendChild((Component)rowSpacer);
        Div footer = new Div();
        footer.setSclass("dialog-footer");
        vlayout.appendChild((Component)footer);
        footer.appendChild((Component)this.confirmPanel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.confirmPanel, "min");
        this.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"DocAction"));
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 410);
        }
        this.setBorder("normal");
        this.setZindex(1000);
    }

    public boolean isStartProcess() {
        return this.m_OKpressed;
    }

    public void onEvent(Event event) {
        if ("onClick".equals(event.getName())) {
            if (((Object)((Object)this.confirmPanel.getButton("Ok"))).equals(event.getTarget())) {
                this.onOk(null);
            } else if (((Object)((Object)this.confirmPanel.getButton("Cancel"))).equals(event.getTarget())) {
                this.m_OKpressed = false;
                this.detach();
            }
        } else if ("onSelect".equals(event.getName()) && this.lstDocAction.equals(event.getTarget())) {
            this.label.setValue(this.s_description[this.getSelectedIndex()]);
        }
    }

    public void setSelectedItem(String value) {
        this.lstDocAction.setSelectedIndex(-1);
        List lst = this.lstDocAction.getItems();
        for (Listitem item : lst) {
            if (!value.equals(item.getValue())) continue;
            item.setSelected(true);
            break;
        }
    }

    public void onOk(final Callback<Boolean> callback) {
        MClientInfo clientInfo = MClientInfo.get((Properties)Env.getCtx());
        if (clientInfo.isConfirmOnDocClose() || clientInfo.isConfirmOnDocVoid()) {
            String selected = this.lstDocAction.getSelectedItem().getValue().toString();
            if (selected.equals("CL") && clientInfo.isConfirmOnDocClose() || selected.equals("VO") && clientInfo.isConfirmOnDocVoid() || selected.equals("RA") && clientInfo.isConfirmOnDocVoid() || selected.equals("RC") && clientInfo.isConfirmOnDocVoid()) {
                String docAction = this.lstDocAction.getSelectedItem().getLabel();
                MessageFormat mf = new MessageFormat(Msg.getMsg((String)Env.getAD_Language((Properties)Env.getCtx()), (String)"ConfirmOnDocAction"));
                Object[] arguments = new Object[]{docAction};
                Dialog.ask(this.gridTab.getWindowNo(), "", mf.format(arguments), new Callback<Boolean>(){

                    public void onCallback(Boolean result) {
                        if (result.booleanValue()) {
                            WDocActionPanel.this.setValueAndClose();
                            if (callback != null) {
                                callback.onCallback((Object)Boolean.TRUE);
                            }
                        } else {
                            if (callback != null) {
                                callback.onCallback((Object)Boolean.FALSE);
                            }
                            return;
                        }
                    }
                });
            } else {
                this.setValueAndClose();
                if (callback != null) {
                    callback.onCallback((Object)Boolean.TRUE);
                }
            }
        } else {
            this.setValueAndClose();
            if (callback != null) {
                callback.onCallback((Object)Boolean.TRUE);
            }
        }
    }

    private void setValueAndClose() {
        String statusSql = "SELECT DocStatus FROM " + this.gridTab.getTableName() + " WHERE " + this.gridTab.getKeyColumnName() + " = ? ";
        String currentStatus = DB.getSQLValueString(null, (String)statusSql, (int)this.gridTab.getKeyID(this.gridTab.getCurrentRow()));
        if (this.DocStatus != null && !this.DocStatus.equals(currentStatus)) {
            throw new IllegalStateException(Msg.getMsg((Properties)Env.getCtx(), (String)"DocStatusChanged"));
        }
        this.m_OKpressed = true;
        this.setValue();
        this.detach();
    }

    private void setValue() {
        int index = this.getSelectedIndex();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("DocAction=" + this.s_value[index]);
        }
        this.gridTab.setValue("DocAction", (Object)this.s_value[index]);
    }

    private void readReference() {
        ArrayList v_value = new ArrayList();
        ArrayList v_name = new ArrayList();
        ArrayList v_description = new ArrayList();
        DocumentEngine.readReferenceList(v_value, v_name, v_description);
        int size = v_value.size();
        this.s_value = new String[size];
        this.s_name = new String[size];
        this.s_description = new String[size];
        int i = 0;
        while (i < size) {
            this.s_value[i] = (String)v_value.get(i);
            this.s_name[i] = (String)v_name.get(i);
            this.s_description[i] = (String)v_description.get(i);
            ++i;
        }
    }

    public int getSelectedIndex() {
        int index = 0;
        if (this.lstDocAction.getSelectedItem() != null) {
            String selected = this.lstDocAction.getSelectedItem().getValue().toString();
            int i = 0;
            while (i < this.s_value.length && index == 0) {
                if (this.s_value[i].equals(selected)) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    public int getNumberOfOptions() {
        return this.lstDocAction != null ? this.lstDocAction.getItemCount() : 0;
    }
}

