/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor.grid.selection;

import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.adempiere.webui.editor.grid.selection.GridTableRow;
import org.adempiere.webui.util.SortComparator;
import org.compiere.model.GridField;
import org.compiere.model.GridTable;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ListitemComparator;
import org.zkoss.zul.ext.Sortable;

public class SimpleGridTableListModel
extends AbstractListModel<GridTableRow>
implements TableModelListener,
Sortable<Object> {
    private static final long serialVersionUID = 698185856751242764L;
    private GridTable tableModel;
    private GridField[] gridField;
    private int windowNo;

    public SimpleGridTableListModel(GridTable tableModel, int windowNo) {
        this.tableModel = tableModel;
        this.windowNo = windowNo;
        this.gridField = tableModel.getFields();
        tableModel.addTableModelListener((TableModelListener)this);
    }

    public GridTableRow getElementAt(int rowIndex) {
        GridTableRow row = null;
        int columnCount = this.tableModel.getColumnCount();
        Object[] values = new Object[columnCount];
        if (rowIndex < this.tableModel.getRowCount()) {
            int i = 0;
            while (i < columnCount) {
                values[i] = this.tableModel.getValueAt(rowIndex, i);
                ++i;
            }
            row = new GridTableRow(this.tableModel.getKeyID(rowIndex), values);
        }
        return row;
    }

    public int getSize() {
        return this.tableModel.getRowCount();
    }

    public void updateComponent(int row) {
        this.updateComponent(row, row);
    }

    public void updateComponent(int fromRow, int toRow) {
        if (Executions.getCurrent() != null) {
            this.fireEvent(0, fromRow, toRow);
        }
    }

    public void sort(Comparator<Object> cmpr, boolean ascending) {
        if (cmpr instanceof ListitemComparator) {
            ListitemComparator lic = (ListitemComparator)cmpr;
            Integer index = (Integer)lic.getListheader().getAttribute("ColumnIndex");
            if (index != null && index >= 0) {
                this.tableModel.sort(index.intValue(), ascending);
            } else {
                this.tableModel.sort(lic.getListheader().getColumnIndex(), ascending);
            }
        } else if (cmpr instanceof SortComparator) {
            SortComparator sc = (SortComparator)cmpr;
            this.tableModel.sort(sc.getColumnIndex(), ascending);
        }
        this.fireEvent(0, -1, -1);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (Executions.getCurrent() != null) {
            if (e.getType() == -1) {
                this.fireEvent(2, e.getFirstRow(), e.getLastRow());
            } else if (e.getType() == 1) {
                this.fireEvent(1, e.getFirstRow(), e.getLastRow());
            } else if (e.getLastRow() == Integer.MAX_VALUE) {
                this.fireEvent(0, -1, -1);
            } else {
                this.fireEvent(0, e.getFirstRow(), e.getLastRow());
            }
        }
    }

    public String getSortDirection(Comparator<Object> cmpr) {
        return "natural";
    }
}

