/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Properties;
import org.adempiere.base.Core;
import org.adempiere.base.event.EventManager;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ServerPushTemplate;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MQuery;
import org.compiere.model.MRecentItem;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.distributed.IMessageService;
import org.idempiere.distributed.ITopic;
import org.idempiere.distributed.ITopicSubscriber;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zul.A;
import org.zkoss.zul.Box;
import org.zkoss.zul.Image;
import org.zkoss.zul.Label;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Panelchildren;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Vbox;

public class DPRecentItems
extends DashboardPanel
implements EventListener<org.zkoss.zk.ui.event.Event>,
EventHandler {
    private static final long serialVersionUID = 662950038476166515L;
    private static final String AD_RECENT_ITEM_ID_ATTR = "AD_RecentItem_ID";
    public static final String DELETE_RECENTITEMS_DROPPABLE = "deleteRecentItems";
    private static TopicSubscriber topicSubscriber;
    private Box bxRecentItems;
    private int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
    private WeakReference<Desktop> desktop;
    private DesktopCleanup listener;

    public DPRecentItems() {
        Panel panel = new Panel();
        this.appendChild((Component)panel);
        Panelchildren recentItemsContent = new Panelchildren();
        panel.appendChild((Component)recentItemsContent);
        this.bxRecentItems = new Vbox();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.bxRecentItems, "1");
        this.setSclass("recentitems-box");
        recentItemsContent.appendChild((Component)this.bxRecentItems);
        Toolbar recentItemsToolbar = new Toolbar();
        this.appendChild((Component)recentItemsToolbar);
        if (ThemeManager.isUseFontIconForImage()) {
            ToolBarButton btn = new ToolBarButton();
            btn.setIconSclass("z-icon-Refresh");
            btn.setSclass("trash-toolbarbutton");
            recentItemsToolbar.appendChild((Component)btn);
            btn.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh")));
            btn.addEventListener("onClick", this);
        } else {
            Image imgr = new Image(ThemeManager.getThemeResource("images/Refresh24.png"));
            recentItemsToolbar.appendChild((Component)imgr);
            imgr.setStyle("text-align: right; cursor: pointer; width:24px; height:24px;");
            imgr.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh")));
            imgr.addEventListener("onClick", (EventListener)this);
        }
        if (ThemeManager.isUseFontIconForImage()) {
            Label deleteLabel = new Label();
            recentItemsToolbar.appendChild((Component)deleteLabel);
            deleteLabel.setSclass("z-icon-Trash trash-font-icon");
            deleteLabel.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Delete")));
            deleteLabel.setDroppable(DELETE_RECENTITEMS_DROPPABLE);
            deleteLabel.addEventListener("onDrop", (EventListener)this);
        } else {
            Image img = new Image(ThemeManager.getThemeResource("images/Delete24.png"));
            recentItemsToolbar.appendChild((Component)img);
            img.setStyle("text-align: right; width:24px; height:24px;");
            img.setDroppable(DELETE_RECENTITEMS_DROPPABLE);
            img.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Delete")));
            img.addEventListener("onDrop", (EventListener)this);
        }
        DPRecentItems.createTopicSubscriber();
        this.listener = new DesktopCleanup(){

            public void cleanup(Desktop desktop) throws Exception {
                DPRecentItems.this.cleanup();
            }
        };
    }

    protected void cleanup() {
        EventManager.getInstance().unregister((EventHandler)this);
        this.desktop = null;
    }

    private static synchronized void createTopicSubscriber() {
        if (topicSubscriber == null) {
            topicSubscriber = new TopicSubscriber();
            IMessageService service = Core.getMessageService();
            if (service != null) {
                ITopic topic = service.getTopic("onRecentItemChanged");
                topic.subscribe((ITopicSubscriber)topicSubscriber);
            }
        }
    }

    private void riDBremove(int AD_RecentItem_ID) {
        MRecentItem ri = MRecentItem.getCopy((Properties)Env.getCtx(), (int)AD_RecentItem_ID, null);
        if (ri.get_ID() == AD_RecentItem_ID) {
            ri.deleteEx(true);
        }
    }

    public void onEvent(org.zkoss.zk.ui.event.Event event) {
        Component comp = event.getTarget();
        String eventName = event.getName();
        if (eventName.equals("onClick")) {
            this.doOnClick(comp);
        } else if (eventName.equals("onDrop")) {
            DropEvent de = (DropEvent)event;
            Component dragged = de.getDragged();
            if ((comp instanceof Image || comp instanceof Label) && dragged instanceof A) {
                A btn = (A)dragged;
                this.removeLink(btn);
            }
        }
    }

    private void doOnClick(Component comp) {
        if (comp instanceof A) {
            A btn = (A)comp;
            int AD_RecentItem_ID = 0;
            try {
                AD_RecentItem_ID = Integer.valueOf((String)btn.getAttribute(AD_RECENT_ITEM_ID_ATTR));
            }
            catch (Exception exception) {}
            if (AD_RecentItem_ID > 0) {
                MRecentItem ri = MRecentItem.get((Properties)Env.getCtx(), (int)AD_RecentItem_ID);
                MTable table = MTable.get((int)ri.getAD_Table_ID());
                String TableName = table.getTableName();
                MQuery query = ri.getRecord_UU() != null ? MQuery.getEqualQuery((String)PO.getUUIDColumnName((String)TableName), (Object)ri.getRecord_UU()) : MQuery.getEqualQuery((String)table.getKeyColumns()[0], (int)ri.getRecord_ID());
                SessionManager.getAppDesktop().openWindow(ri.getAD_Window_ID(), query, null);
            }
        }
        if (comp instanceof Image || comp instanceof ToolBarButton) {
            this.refresh();
        }
    }

    private synchronized void refresh() {
        List childs = this.bxRecentItems.getChildren();
        int childCount = childs.size();
        int c = childCount - 1;
        while (c >= 0) {
            Component comp = (Component)childs.get(c);
            if (comp instanceof A) {
                comp.removeEventListener("onClick", (EventListener)this);
                comp.removeEventListener("onDrop", (EventListener)this);
            }
            this.bxRecentItems.removeChild(comp);
            --c;
        }
        int maxri = MSysConfig.getIntValue((String)"RecentItems_MaxShown", (int)10, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (maxri <= 0) {
            return;
        }
        List ris = MRecentItem.getFromUser((Properties)Env.getCtx(), (int)this.AD_User_ID);
        int riShown = 0;
        for (MRecentItem ri : ris) {
            String label;
            if (ri.getAD_Window_ID() > 0 && MRole.getDefault().getWindowAccess(ri.getAD_Window_ID()) == null || ri.getAD_Window_ID() > 0 && ri.getRecord_ID() > 0 && !MRole.getDefault().isRecordAccess(ri.getAD_Table_ID(), ri.getRecord_ID(), true) || (label = ri.getLabel()) == null) continue;
            A btnrecentItem = new A();
            btnrecentItem.setAttribute(AD_RECENT_ITEM_ID_ATTR, (Object)String.valueOf(ri.getAD_RecentItem_ID()));
            this.bxRecentItems.appendChild((Component)btnrecentItem);
            btnrecentItem.setLabel(label);
            if (ThemeManager.isUseFontIconForImage()) {
                btnrecentItem.setIconSclass(this.getIconFile());
            } else {
                btnrecentItem.setImage(ThemeManager.getThemeResource(this.getIconFile()));
            }
            btnrecentItem.setDraggable(DELETE_RECENTITEMS_DROPPABLE);
            btnrecentItem.addEventListener("onClick", (EventListener)this);
            btnrecentItem.addEventListener("onDrop", (EventListener)this);
            btnrecentItem.setSclass("menu-href");
            ZKUpdateUtil.setHflex((HtmlBasedComponent)btnrecentItem, "1");
            if (++riShown >= maxri) break;
        }
    }

    private void removeLink(A btn) {
        String value = (String)btn.getAttribute(AD_RECENT_ITEM_ID_ATTR);
        if (value != null) {
            int AD_RecentItem_ID = Integer.valueOf(value.toString());
            this.riDBremove(AD_RecentItem_ID);
            this.bxRecentItems.removeChild((Component)btn);
            this.bxRecentItems.invalidate();
        }
    }

    private String getIconFile() {
        if (ThemeManager.isUseFontIconForImage()) {
            return "z-icon-Window";
        }
        return "images/mWindow.png";
    }

    @Override
    public void refresh(ServerPushTemplate template) {
        template.executeAsync(this);
    }

    @Override
    public void updateUI() {
        this.refresh();
        if (this.bxRecentItems != null) {
            this.bxRecentItems.invalidate();
        }
        this.updateDesktopReference();
    }

    protected void updateDesktopReference() {
        if (this.desktop == null || this.desktop.get() == null || this.desktop.get() != null && this.desktop.get() != this.getDesktop()) {
            if (this.desktop != null && this.desktop.get() != null) {
                ((Desktop)this.desktop.get()).removeListener((Object)this.listener);
            }
            this.desktop = new WeakReference<Desktop>(this.getDesktop());
            if (this.desktop != null && this.desktop.get() != null) {
                ((Desktop)this.desktop.get()).addListener((Object)this.listener);
            }
        }
    }

    public void handleEvent(Event event) {
        int id;
        Object property;
        if (event.getTopic().equals("onRecentItemChanged") && event.getProperty("AD_User_ID") != null && (property = event.getProperty("AD_User_ID")) instanceof Number && (id = ((Number)property).intValue()) == this.AD_User_ID) {
            try {
                if (this.desktop != null && this.desktop.get() != null && ((Desktop)this.desktop.get()).isAlive()) {
                    ServerPushTemplate template = new ServerPushTemplate((Desktop)this.desktop.get());
                    this.refresh(template);
                }
            }
            catch (Exception exception) {
                EventManager.getInstance().unregister((EventHandler)this);
            }
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null) {
            EventManager.getInstance().register("onRecentItemChanged", (EventHandler)this);
            this.updateDesktopReference();
        }
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        this.cleanup();
    }

    @Override
    public boolean isLazy() {
        return true;
    }

    static class TopicSubscriber
    implements ITopicSubscriber<Integer> {
        TopicSubscriber() {
        }

        public void onMessage(Integer message) {
            MRecentItem.postOnChangedEvent((int)message);
        }
    }
}

