/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.FavoriteSimpleTreeModel;
import org.adempiere.webui.dashboard.DPFavourites;
import org.adempiere.webui.desktop.FavouriteController;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.TreeUtils;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.MTable;
import org.compiere.model.MTreeFavoriteNode;
import org.compiere.model.MTreeNode;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.MouseEvent;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;

public class ADTreeFavoriteOnDropListener
implements EventListener<Event> {
    public static final String MENU_ITEM_DELETE = "DELETE";
    public static final String NODE_MOVEINTO = "MoveInto";
    public static final String NODE_INSERTAFTER = "InsertAfter";
    public static final String MENU_ITEM_DEFAULT_EXPANDED = "DefaultExpanded";
    public static final String MENU_ITEM_DEFAULT_COLLAPSED = "DefaultCollapsed";
    private FavoriteSimpleTreeModel treeModel;
    private Tree tree;
    private int mTreeFavID;

    public ADTreeFavoriteOnDropListener(Tree tree, FavoriteSimpleTreeModel treeModel) {
        this.tree = tree;
        this.treeModel = treeModel;
        FavouriteController controller = FavouriteController.getInstance(Executions.getCurrent().getDesktop().getSession());
        this.mTreeFavID = controller.getAD_Tree_Favorite_ID();
    }

    public void onEvent(Event event) throws Exception {
        DropEvent de;
        if ("onRightClick".equals(event.getName()) || "onClick".equals(event.getName()) && event.getTarget() instanceof Toolbarbutton && ((Boolean)((Toolbarbutton)event.getTarget()).getAttribute("MobileFavCtxMenu")).booleanValue()) {
            MouseEvent me = (MouseEvent)event;
            Treeitem target = event.getTarget() instanceof Toolbarbutton ? (Treeitem)((Treerow)me.getTarget().getParent().getParent()).getParent() : (Treeitem)((Treerow)me.getTarget()).getParent();
            this.menuItemList(target);
        } else if (event instanceof DropEvent && (de = (DropEvent)event).getDragged() != de.getTarget()) {
            if (!(de.getDragged() instanceof Treerow) || !(de.getTarget() instanceof Treerow)) {
                Dialog.error(0, "DragItemMenu");
                return;
            }
            Treeitem src = (Treeitem)((Treerow)de.getDragged()).getParent();
            Treeitem target = (Treeitem)((Treerow)de.getTarget()).getParent();
            Treerow tr = (Treerow)de.getDragged();
            String strDraggable = tr.getDraggable();
            if (!strDraggable.equals("favourite")) {
                DefaultTreeNode stn_src = (DefaultTreeNode)src.getValue();
                DefaultTreeNode stn_target = (DefaultTreeNode)target.getValue();
                MTreeNode nd_src = (MTreeNode)stn_src.getData();
                MTreeNode nd_target = (MTreeNode)stn_target.getData();
                if (!nd_src.isSummary()) {
                    int menuID = nd_src.getMenu_ID();
                    if (!nd_target.isSummary()) {
                        boolean menuAvailable = MTreeFavoriteNode.isMenuExists((int)menuID, (int)nd_target.getParent_ID(), (int)this.mTreeFavID);
                        if (nd_src.getParent_ID() == nd_target.getParent_ID()) {
                            this.moveNode((DefaultTreeNode<Object>)((DefaultTreeNode)src.getValue()), (DefaultTreeNode<Object>)((DefaultTreeNode)target.getValue()));
                        } else if (menuAvailable) {
                            this.showWarningDialog();
                        } else {
                            this.moveNode((DefaultTreeNode<Object>)((DefaultTreeNode)src.getValue()), (DefaultTreeNode<Object>)((DefaultTreeNode)target.getValue()));
                        }
                    } else {
                        boolean menuAvailable = MTreeFavoriteNode.isMenuExists((int)menuID, (int)nd_target.getNode_ID(), (int)this.mTreeFavID);
                        if (menuAvailable) {
                            this.showWarningDialog();
                        } else {
                            this.moveNode((DefaultTreeNode<Object>)((DefaultTreeNode)src.getValue()), (DefaultTreeNode<Object>)((DefaultTreeNode)target.getValue()));
                        }
                    }
                } else {
                    this.moveNode((DefaultTreeNode<Object>)((DefaultTreeNode)src.getValue()), (DefaultTreeNode<Object>)((DefaultTreeNode)target.getValue()));
                }
            } else {
                int mID = Integer.valueOf(src.getValue().toString());
                DefaultTreeNode stn_target = (DefaultTreeNode)target.getValue();
                MTreeNode nd = (MTreeNode)stn_target.getData();
                if (nd.isSummary()) {
                    if (MTreeFavoriteNode.isMenuExists((int)mID, (int)nd.getNode_ID(), (int)this.mTreeFavID)) {
                        this.showWarningDialog();
                    } else {
                        this.insertMenuInTree(mID, nd.getNode_ID(), (DefaultTreeNode<Object>)stn_target);
                    }
                } else {
                    DefaultTreeNode<Object> dtn_target_parent = this.treeModel.getParent((DefaultTreeNode<Object>)stn_target);
                    int pID = ((MTreeNode)dtn_target_parent.getData()).getNode_ID();
                    if (MTreeFavoriteNode.isMenuExists((int)mID, (int)pID, (int)this.mTreeFavID)) {
                        this.showWarningDialog();
                    } else {
                        this.insertMenuInTree(mID, pID, dtn_target_parent);
                    }
                }
            }
        }
    }

    private void showWarningDialog() {
        Dialog.warn(0, Msg.getMsg((Properties)Env.getCtx(), (String)"AlreadyExists"));
    }

    private void menuItemList(Treeitem toItem) {
        DefaultTreeNode toNode = (DefaultTreeNode)toItem.getValue();
        Menupopup popup = new Menupopup();
        Menuitem menuItem = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"delete"));
        menuItem.setParent((Component)popup);
        menuItem.setValue(MENU_ITEM_DELETE);
        menuItem.addEventListener("onClick", (EventListener)new DeleteListener((DefaultTreeNode<Object>)toNode));
        if (ThemeManager.isUseFontIconForImage()) {
            menuItem.setIconSclass("z-icon-Delete");
        } else {
            menuItem.setImage(ThemeManager.getThemeResource("images/Delete24.png"));
        }
        MTreeNode mtn = (MTreeNode)toNode.getData();
        if (mtn.isSummary()) {
            MTreeFavoriteNode favNode = (MTreeFavoriteNode)MTable.get((Properties)Env.getCtx(), (int)200221).getPO(mtn.getNode_ID(), null);
            if (favNode.isCollapsible()) {
                menuItem = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)MENU_ITEM_DEFAULT_EXPANDED));
                menuItem.setValue(MENU_ITEM_DEFAULT_EXPANDED);
                if (ThemeManager.isUseFontIconForImage()) {
                    menuItem.setIconSclass("z-icon-Expand");
                } else {
                    menuItem.setImage(ThemeManager.getThemeResource("images/expand-header.png"));
                }
            } else {
                menuItem = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)MENU_ITEM_DEFAULT_COLLAPSED));
                menuItem.setValue(MENU_ITEM_DEFAULT_COLLAPSED);
                if (ThemeManager.isUseFontIconForImage()) {
                    menuItem.setIconSclass("z-icon-Parent");
                } else {
                    menuItem.setImage(ThemeManager.getThemeResource("images/collapse-header.png"));
                }
            }
            menuItem.setParent((Component)popup);
            menuItem.addEventListener("onClick", (EventListener)new CollExpdListener(favNode));
        }
        popup.setPage(this.tree.getPage());
        if (ClientInfo.isMobile()) {
            popup.open((Component)toItem, "after_start");
        } else {
            popup.open((Component)toItem, "after_pointer");
        }
    }

    public void insertMenuInTree(int menuID, int parentNodeID, DefaultTreeNode<Object> stn) {
        MTreeFavoriteNode favNode = MTreeFavoriteNode.create((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Org_ID"), (int)this.mTreeFavID, (int)menuID, (int)parentNodeID, (int)0, null, (boolean)false, (boolean)true, (boolean)false);
        DPFavourites.addNodeInTree(this.treeModel, this.tree, stn, favNode);
    }

    private void moveNode(DefaultTreeNode<Object> movingNode, DefaultTreeNode<Object> toNode) {
        if (movingNode == toNode) {
            return;
        }
        MTreeNode toMNode = (MTreeNode)toNode.getData();
        if (!toMNode.isSummary()) {
            this.moveNode(movingNode, toNode, false);
        } else {
            int[] path = this.treeModel.getPath((TreeNode)toNode);
            Treeitem toItem = this.tree.renderItemByPath(path);
            this.tree.setSelectedItem(toItem);
            Events.sendEvent((Component)this.tree, (Event)new Event("onSelect", (Component)this.tree));
            MenuListener listener = new MenuListener(movingNode, toNode);
            Menupopup popup = new Menupopup();
            Menuitem menuItem = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)NODE_INSERTAFTER));
            menuItem.setValue(NODE_INSERTAFTER);
            menuItem.setParent((Component)popup);
            menuItem.addEventListener("onClick", (EventListener)listener);
            menuItem = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)NODE_MOVEINTO));
            menuItem.setValue(NODE_MOVEINTO);
            menuItem.setParent((Component)popup);
            menuItem.addEventListener("onClick", (EventListener)listener);
            popup.setPage(this.tree.getPage());
            popup.open((Component)toItem.getTreerow(), "overlap");
        }
    }

    private void moveNode(DefaultTreeNode<Object> movingNode, DefaultTreeNode<Object> toNode, boolean isMoveInto) {
        int index;
        DefaultTreeNode<Object> newParent;
        DefaultTreeNode<Object> oldParent = this.treeModel.getParent(movingNode);
        this.treeModel.removeNode(movingNode);
        if (!isMoveInto) {
            newParent = this.treeModel.getParent(toNode);
            index = newParent.getChildren().indexOf(toNode) + 1;
        } else {
            newParent = toNode;
            index = 0;
        }
        this.treeModel.addNode(newParent, movingNode, index);
        int[] path = this.treeModel.getPath((TreeNode)movingNode);
        if (TreeUtils.isOnInitRenderPosted(this.tree) || this.tree.getTreechildren() == null) {
            this.tree.onInitRender();
        }
        Treeitem movingItem = this.tree.renderItemByPath(path);
        if (((MTreeNode)movingNode.getData()).isSummary()) {
            this.tree.setSelectedItem(movingItem);
        } else {
            this.tree.setSelectedItem(movingItem.getParentItem());
        }
        Events.sendEvent((Component)this.tree, (Event)new Event("onSelect", (Component)this.tree));
        MTreeNode newParentTNode = (MTreeNode)newParent.getData();
        MTreeNode moveTNode = (MTreeNode)movingNode.getData();
        this.updateTFNParentAndSeqNo(newParentTNode, moveTNode, index);
        moveTNode.setParent_ID(newParentTNode.getNode_ID());
        MTreeNode oldMParent = (MTreeNode)oldParent.getData();
        int i = 0;
        while (i < oldParent.getChildCount()) {
            DefaultTreeNode oldChildNode = (DefaultTreeNode)oldParent.getChildAt(i);
            MTreeNode oldTNode = (MTreeNode)oldChildNode.getData();
            this.updateTFNParentAndSeqNo(oldMParent, oldTNode, i);
            ++i;
        }
        if (oldParent != newParent) {
            MTreeNode newMParent = (MTreeNode)newParent.getData();
            int i2 = 0;
            while (i2 < newParent.getChildCount()) {
                DefaultTreeNode newChildNode = (DefaultTreeNode)newParent.getChildAt(i2);
                MTreeNode newTNode = (MTreeNode)newChildNode.getData();
                this.updateTFNParentAndSeqNo(newMParent, newTNode, i2);
                ++i2;
            }
        }
    }

    private void updateTFNParentAndSeqNo(MTreeNode parentTNode, MTreeNode moveTNode, int seqNo) {
        MTreeFavoriteNode favNode = (MTreeFavoriteNode)MTable.get((Properties)Env.getCtx(), (int)200221).getPO(moveTNode.getNode_ID(), null);
        if (favNode.getParent_ID() != parentTNode.getNode_ID() || favNode.getSeqNo() != seqNo) {
            favNode.setParent_ID(parentTNode.getNode_ID());
            favNode.setSeqNo(seqNo);
            favNode.saveCrossTenantSafeEx();
        }
    }

    class CollExpdListener
    implements EventListener<Event> {
        private MTreeFavoriteNode favNode;

        CollExpdListener(MTreeFavoriteNode favNode) {
            this.favNode = favNode;
        }

        public void onEvent(Event event) throws Exception {
            if ("onClick".equals(event.getName()) && event.getTarget() instanceof Menuitem) {
                Menuitem menuItem = (Menuitem)event.getTarget();
                if (ADTreeFavoriteOnDropListener.MENU_ITEM_DEFAULT_EXPANDED.equals(menuItem.getValue())) {
                    this.favNode.setIsCollapsible(false);
                } else if (ADTreeFavoriteOnDropListener.MENU_ITEM_DEFAULT_COLLAPSED.equals(menuItem.getValue())) {
                    this.favNode.setIsCollapsible(true);
                }
                this.favNode.saveEx();
            }
        }
    }

    class DeleteListener
    implements EventListener<Event> {
        private DefaultTreeNode<Object> toNode;

        DeleteListener(DefaultTreeNode<Object> toNode) {
            this.toNode = toNode;
        }

        public void onEvent(Event event) throws Exception {
            Menuitem menuItem;
            if ("onClick".equals(event.getName()) && event.getTarget() instanceof Menuitem && ADTreeFavoriteOnDropListener.MENU_ITEM_DELETE.equals((menuItem = (Menuitem)event.getTarget()).getValue())) {
                this.deleteNodeItem(this.toNode);
            }
        }

        private void deleteNodeItem(DefaultTreeNode<Object> toNode) {
            int nodeID = ((MTreeNode)toNode.getData()).getNode_ID();
            MTreeFavoriteNode favNode = (MTreeFavoriteNode)MTable.get((Properties)Env.getCtx(), (int)200221).getPO(nodeID, null);
            if (favNode.getAD_Menu_ID() > 0 && favNode.isFavourite()) {
                FavouriteController controller = FavouriteController.getInstance(Executions.getCurrent().getDesktop().getSession());
                if (!controller.removeNode(favNode.getAD_Menu_ID())) {
                    throw new AdempiereException(Msg.getMsg((Properties)favNode.getCtx(), (String)CLogger.retrieveError().getValue()));
                }
            } else if (favNode.delete(true)) {
                ADTreeFavoriteOnDropListener.this.treeModel.removeNode(toNode);
            } else {
                throw new AdempiereException(Msg.getMsg((Properties)favNode.getCtx(), (String)CLogger.retrieveError().getValue()));
            }
        }
    }

    class MenuListener
    implements EventListener<Event> {
        private DefaultTreeNode<Object> movingNode;
        private DefaultTreeNode<Object> toNode;

        MenuListener(DefaultTreeNode<Object> movingNode, DefaultTreeNode<Object> toNode) {
            this.movingNode = movingNode;
            this.toNode = toNode;
        }

        public void onEvent(Event event) throws Exception {
            if ("onClick".equals(event.getName()) && event.getTarget() instanceof Menuitem) {
                Menuitem menuItem = (Menuitem)event.getTarget();
                if (ADTreeFavoriteOnDropListener.NODE_INSERTAFTER.equals(menuItem.getValue())) {
                    ADTreeFavoriteOnDropListener.this.moveNode(this.movingNode, this.toNode, false);
                } else if (ADTreeFavoriteOnDropListener.NODE_MOVEINTO.equals(menuItem.getValue())) {
                    ADTreeFavoriteOnDropListener.this.moveNode(this.movingNode, this.toNode, true);
                }
            }
        }
    }
}

