/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.model.MRecordAccess;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Space;
import org.zkoss.zul.Toolbarbutton;

public class WRecordAccessDialog
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -3591753244744022795L;
    private int m_AD_Table_ID;
    private int m_Record_ID;
    private ArrayList<MRecordAccess> m_recordAccesss = new ArrayList();
    private int m_currentRow = 0;
    private MRecordAccess m_currentData = null;
    private static final CLogger log = CLogger.getCLogger(WRecordAccessDialog.class);
    private Label roleLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"AD_Role_ID"));
    private Listbox roleField = null;
    private Checkbox cbActive = new Checkbox();
    private Checkbox cbExclude = new Checkbox();
    private Checkbox cbReadOnly = new Checkbox();
    private Checkbox cbDependent = new Checkbox();
    private Toolbarbutton bDelete = new Toolbarbutton();
    private Toolbarbutton bNew = new Toolbarbutton();
    private Label rowNoLabel = new Label();
    private Toolbarbutton bUp = new Toolbarbutton();
    private Toolbarbutton bDown = new Toolbarbutton();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);

    public WRecordAccessDialog(Window parent, int AD_Table_ID, int Record_ID) {
        this.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"RecordAccessDialog"));
        this.setAttribute("mode", "highlighted");
        this.setBorder("normal");
        this.setSizable(true);
        if (log.isLoggable(Level.INFO)) {
            log.info("AD_Table_ID=" + AD_Table_ID + ", Record_ID=" + Record_ID);
        }
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_Record_ID = Record_ID;
        try {
            this.dynInit();
            this.jbInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void dynInit() {
        block7: {
            String sql = MRole.getDefault().addAccessSQL("SELECT AD_Role_ID, Name FROM AD_Role WHERE AD_Client_ID=? ORDER BY 2", "AD_Role", false, false);
            this.roleField = new Listbox(DB.getKeyNamePairs((String)sql, (boolean)false, (Object[])new Object[]{Env.getAD_Client_ID((Properties)Env.getCtx())}));
            this.roleField.setMold("select");
            sql = "SELECT * FROM AD_Record_Access WHERE AD_Table_ID=? AND Record_ID=? AND AD_Client_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_AD_Table_ID);
                    pstmt.setInt(2, this.m_Record_ID);
                    pstmt.setInt(3, Env.getAD_Client_ID((Properties)Env.getCtx()));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.m_recordAccesss.add(new MRecordAccess(Env.getCtx(), rs, null));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("#" + this.m_recordAccesss.size());
        }
        this.setLine(0, false);
    }

    private void jbInit() throws Exception {
        if (ThemeManager.isUseFontIconForImage()) {
            this.bDelete.setIconSclass("z-icon-Delete");
        } else {
            this.bDelete.setImage(ThemeManager.getThemeResource("images/Delete16.png"));
        }
        this.bDelete.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Delete"));
        if (ThemeManager.isUseFontIconForImage()) {
            this.bNew.setIconSclass("z-icon-New");
        } else {
            this.bNew.setImage(ThemeManager.getThemeResource("images/New16.png"));
        }
        this.bNew.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"New"));
        if (ThemeManager.isUseFontIconForImage()) {
            this.bUp.setIconSclass("z-icon-Previous");
        } else {
            this.bUp.setImage(ThemeManager.getThemeResource("images/Previous16.png"));
        }
        this.bUp.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Previous"));
        if (ThemeManager.isUseFontIconForImage()) {
            this.bDown.setIconSclass("z-icon-Next");
        } else {
            this.bDown.setImage(ThemeManager.getThemeResource("images/Next16.png"));
        }
        this.bDown.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Next"));
        this.cbActive.setText(Msg.translate((Properties)Env.getCtx(), (String)"IsActive"));
        this.cbExclude.setText(Msg.translate((Properties)Env.getCtx(), (String)"IsExclude"));
        this.cbReadOnly.setText(Msg.translate((Properties)Env.getCtx(), (String)"IsReadOnly"));
        this.cbDependent.setText(Msg.translate((Properties)Env.getCtx(), (String)"IsDependentEntities"));
        Grid grid = GridFactory.newGridLayout();
        this.appendChild((Component)grid);
        grid.setHflex("min");
        Rows rows = new Rows();
        grid.appendChild((Component)rows);
        Row row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.bUp);
        row.appendChild((Component)new Space());
        row.appendCellChild((Component)this.bDown);
        row.getLastCell().setStyle("text-align: right;");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.roleLabel);
        row.appendCellChild((Component)this.roleField, 2);
        if (ClientInfo.maxWidth(499)) {
            this.roleField.setWidth("220px");
        }
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.cbActive);
        row.appendChild((Component)this.cbExclude);
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.cbReadOnly);
        row.appendChild((Component)this.cbDependent);
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.bNew);
        row.appendChild((Component)this.bDelete);
        row.appendCellChild((Component)this.rowNoLabel);
        row.getLastCell().setStyle("text-align: right;");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendCellChild((Component)this.confirmPanel, 3);
        this.bUp.addEventListener("onClick", (EventListener)this);
        this.bDown.addEventListener("onClick", (EventListener)this);
        this.bDelete.addEventListener("onClick", (EventListener)this);
        this.bNew.addEventListener("onClick", (EventListener)this);
        this.confirmPanel.addActionListener(this);
    }

    private void setLine(int rowDelta, boolean newRecord) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("delta=" + rowDelta + ", new=" + newRecord + " - currentRow=" + this.m_currentRow + ", size=" + this.m_recordAccesss.size());
        }
        int maxIndex = 0;
        if (this.m_recordAccesss.size() == 0) {
            this.m_currentRow = 0;
            maxIndex = 0;
            newRecord = true;
            this.setLine(null);
        } else if (newRecord) {
            maxIndex = this.m_currentRow = this.m_recordAccesss.size();
            this.setLine(null);
        } else {
            this.m_currentRow += rowDelta;
            maxIndex = this.m_recordAccesss.size() - 1;
            if (this.m_currentRow < 0) {
                this.m_currentRow = 0;
            } else if (this.m_currentRow > maxIndex) {
                this.m_currentRow = maxIndex;
            }
            MRecordAccess ra = this.m_recordAccesss.get(this.m_currentRow);
            this.setLine(ra);
        }
        StringBuilder txt = new StringBuilder();
        if (newRecord) {
            txt.append("+");
        }
        txt.append(this.m_currentRow + 1).append("/").append(maxIndex + 1);
        this.rowNoLabel.setText(txt.toString());
        this.bUp.setDisabled(this.m_currentRow <= 0);
        this.bDown.setDisabled(this.m_currentRow >= maxIndex);
    }

    private void setLine(MRecordAccess ra) {
        int AD_Role_ID = 0;
        boolean active = true;
        boolean exclude = true;
        boolean readonly = false;
        boolean dependent = false;
        if (ra != null) {
            AD_Role_ID = ra.getAD_Role_ID();
            active = ra.isActive();
            exclude = ra.isExclude();
            readonly = ra.isReadOnly();
            dependent = ra.isDependentEntities();
        }
        this.cbActive.setSelected(active);
        this.cbExclude.setSelected(exclude);
        this.cbReadOnly.setSelected(readonly);
        this.cbDependent.setSelected(dependent);
        this.bDelete.setDisabled(ra == null);
        ListItem selection = null;
        int i = 0;
        while (i < this.roleField.getItemCount()) {
            ListItem pp = this.roleField.getItemAtIndex(i);
            if (pp != null && (Integer)pp.getValue() != null && (Integer)pp.getValue() == AD_Role_ID) {
                selection = pp;
            }
            ++i;
        }
        if (selection != null && ra != null) {
            this.roleField.setSelectedItem(selection);
            this.m_currentData = ra;
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.valueOf(ra));
            }
        } else {
            this.m_currentData = null;
        }
    }

    public void onEvent(Event e) throws Exception {
        if (e.getTarget() == this.bUp) {
            this.setLine(-1, false);
        } else if (e.getTarget() == this.bDown) {
            this.setLine(1, false);
        } else if (e.getTarget() == this.bNew) {
            this.setLine(0, true);
        } else {
            if (e.getTarget() == this.bDelete) {
                this.cmd_delete();
            } else if (e.getTarget().getId().equals("Ok") && !this.cmd_save()) {
                return;
            }
            this.dispose();
        }
    }

    private boolean cmd_save() {
        ListItem pp = this.roleField.getSelectedItem();
        if (pp == null) {
            return false;
        }
        int AD_Role_ID = (Integer)pp.getValue();
        boolean isActive = this.cbActive.isSelected();
        boolean isExclude = this.cbExclude.isSelected();
        boolean isReadOnly = this.cbReadOnly.isSelected();
        boolean isDependentEntities = this.cbDependent.isSelected();
        if (this.m_currentData == null) {
            this.m_currentData = new MRecordAccess(Env.getCtx(), AD_Role_ID, this.m_AD_Table_ID, this.m_Record_ID, null);
            this.m_recordAccesss.add(this.m_currentData);
            this.m_currentRow = this.m_recordAccesss.size() - 1;
        }
        this.m_currentData.setIsActive(isActive);
        this.m_currentData.setIsExclude(isExclude);
        this.m_currentData.setIsReadOnly(isReadOnly);
        this.m_currentData.setIsDependentEntities(isDependentEntities);
        boolean success = this.m_currentData.save();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Success=" + success);
        }
        return success;
    }

    private boolean cmd_delete() {
        boolean success = false;
        if (this.m_currentData == null) {
            log.log(Level.SEVERE, "No data");
        } else {
            success = this.m_currentData.delete(true);
            this.m_currentData = null;
            this.m_recordAccesss.remove(this.m_currentRow);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Success=" + success);
            }
        }
        return success;
    }
}

