/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Datebox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.panel.InfoPanel;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Vbox;

@Deprecated
public class InfoInvoicePanel
extends InfoPanel
implements ValueChangeListener {
    private static final long serialVersionUID = 5632526399922930978L;
    private Label lblDocumentNo;
    private Label lblDescription;
    private Label lblDateInvoiced;
    private Label lblGrandTotal;
    private Textbox txtDocumentNo;
    private Textbox txtDescription;
    private Datebox dateFrom;
    private Datebox dateTo;
    private NumberBox amountFrom;
    private NumberBox amountTo;
    private WSearchEditor editorBPartner;
    private WSearchEditor editorOrder;
    private Checkbox isSoTrx;
    private Checkbox isPaid;
    private Borderlayout layout;
    private Vbox southBody;
    private static final ColumnInfo[] s_invoiceLayout = new ColumnInfo[]{new ColumnInfo(" ", "i.C_Invoice_ID", IDColumn.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"), "(SELECT Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=i.C_BPartner_ID)", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"DateInvoiced"), "i.DateInvoiced", Timestamp.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"DueDate"), "i.DueDate", Timestamp.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"), "i.DocumentNo", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"), "(SELECT ISO_Code FROM C_Currency c WHERE c.C_Currency_ID=i.C_Currency_ID)", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"GrandTotal"), "i.GrandTotal", BigDecimal.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"ConvertedAmount"), "currencyBase(i.GrandTotal, i.C_Currency_ID, i.DateAcct, i.AD_Client_ID, i.AD_Org_ID)", BigDecimal.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"OpenAmt"), "invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID)", BigDecimal.class, true, true, null), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"IsPaid"), "i.IsPaid", Boolean.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"IsSOTrx"), "i.IsSOTrx", Boolean.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Description"), "i.Description", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"POReference"), "i.POReference", String.class), new ColumnInfo("", "''", KeyNamePair.class, "i.C_InvoicePaySchedule_ID")};
    private static int INDEX_PAYSCHEDULE = s_invoiceLayout.length - 1;

    public InfoInvoicePanel(int WindowNo, String value, boolean multiSelection, String whereClause) {
        this(WindowNo, value, multiSelection, whereClause, true);
    }

    public InfoInvoicePanel(int WindowNo, String value, boolean multiSelection, String whereClause, boolean lookup) {
        super(WindowNo, "i", "C_Invoice_ID", multiSelection, whereClause, lookup);
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"InfoInvoice"));
        this.initComponents();
        this.init();
        this.p_loadedOK = this.initInfo();
        int no = this.contentPanel.getRowCount();
        this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (value != null && value.length() > 0) {
            String[] values = value.split("_");
            this.txtDocumentNo.setText(values[0]);
            this.executeQuery();
            this.renderItems();
        }
    }

    private void initComponents() {
        this.lblDocumentNo = new Label(Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo")));
        this.lblDescription = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
        this.lblDateInvoiced = new Label(Msg.translate((Properties)Env.getCtx(), (String)"DateInvoiced"));
        this.lblGrandTotal = new Label(Msg.translate((Properties)Env.getCtx(), (String)"GrandTotal"));
        this.txtDocumentNo = new Textbox();
        this.txtDescription = new Textbox();
        this.txtDocumentNo.setWidgetAttribute("instanceName", "documentNo");
        this.txtDescription.setWidgetAttribute("instanceName", "description");
        this.dateFrom = new Datebox();
        this.dateTo = new Datebox();
        this.dateFrom.setWidgetAttribute("instanceName", "dateFrom");
        this.dateTo.setWidgetAttribute("instanceName", "dateTo");
        this.amountFrom = new NumberBox(false);
        this.amountTo = new NumberBox(false);
        this.amountFrom.setWidgetAttribute("instanceName", "amountFrom");
        this.amountTo.setWidgetAttribute("instanceName", "amountTo");
        this.isPaid = new Checkbox();
        this.isPaid.setLabel(Msg.translate((Properties)Env.getCtx(), (String)"IsPaid"));
        this.isPaid.setChecked(false);
        this.isSoTrx = new Checkbox();
        this.isSoTrx.setLabel(Msg.translate((Properties)Env.getCtx(), (String)"IsSOTrx"));
        this.isSoTrx.setChecked(!"N".equals(Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"IsSOTrx")));
        MLookup lookupBP = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)3499, (int)30);
        this.editorBPartner = new WSearchEditor((Lookup)lookupBP, Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"), "", false, false, true);
        this.editorBPartner.addValueChangeListener(this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.editorBPartner.getComponent(), "1");
        this.editorBPartner.getComponent().setWidgetAttribute("instanceName", "bpartnerLookup");
        MLookup lookupOrder = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)4247, (int)30);
        this.editorOrder = new WSearchEditor((Lookup)lookupOrder, Msg.translate((Properties)Env.getCtx(), (String)"C_Order_ID"), "", false, false, true);
        this.editorOrder.addValueChangeListener(this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.editorOrder.getComponent(), "1");
        this.editorOrder.getComponent().setWidgetAttribute("instanceName", "orderLookup");
    }

    private void init() {
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtDocumentNo, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtDescription, "1");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.dateFrom, "165px");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.dateTo, "165px");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.amountFrom.getDecimalbox(), "155px");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.amountTo.getDecimalbox(), "155px");
        Grid grid = GridFactory.newGridLayout();
        Rows rows = new Rows();
        grid.appendChild((Component)rows);
        Row row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(this.lblDocumentNo.rightAlign());
        row.appendChild((Component)this.txtDocumentNo);
        row.appendChild(this.editorBPartner.getLabel().rightAlign());
        row.appendChild((Component)this.editorBPartner.getComponent());
        row.appendChild((Component)this.isSoTrx);
        row.appendChild((Component)this.isPaid);
        row = new Row();
        row.appendCellChild(this.lblDescription.rightAlign(), 1);
        row.appendCellChild((Component)this.txtDescription, 1);
        row.appendCellChild(this.lblDateInvoiced.rightAlign(), 1);
        Hbox hbox = new Hbox();
        hbox.appendChild((Component)this.dateFrom);
        hbox.appendChild((Component)new Label("-"));
        hbox.appendChild((Component)this.dateTo);
        row.appendCellChild((Component)hbox, 3);
        rows.appendChild((Component)row);
        row = new Row();
        row.appendCellChild(this.editorOrder.getLabel().rightAlign(), 1);
        row.appendCellChild((Component)this.editorOrder.getComponent(), 1);
        row.appendCellChild(this.lblGrandTotal.rightAlign(), 1);
        hbox = new Hbox();
        hbox.appendChild((Component)this.amountFrom);
        hbox.appendChild((Component)new Label("-"));
        hbox.appendChild((Component)this.amountTo);
        row.appendCellChild((Component)hbox, 3);
        rows.appendChild((Component)row);
        this.layout = new Borderlayout();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.layout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.layout, "100%");
        if (!this.isLookup()) {
            this.layout.setStyle("position: absolute");
        }
        this.appendChild((Component)this.layout);
        North north = new North();
        this.layout.appendChild((Component)north);
        north.appendChild((Component)grid);
        Center center = new Center();
        this.layout.appendChild((Component)center);
        Div div = new Div();
        div.appendChild((Component)this.contentPanel);
        if (this.isLookup()) {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.contentPanel, "99%");
        } else {
            this.contentPanel.setStyle("width: 99%; margin: 0px auto;");
        }
        ZKUpdateUtil.setVflex(this.contentPanel, true);
        div.setStyle("width :100%; height: 100%");
        center.appendChild((Component)div);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)div, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)div, "1");
        South south = new South();
        this.layout.appendChild((Component)south);
        this.southBody = new Vbox();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.southBody, "100%");
        south.appendChild((Component)this.southBody);
        this.southBody.appendChild((Component)new Separator());
        this.southBody.appendChild((Component)this.confirmPanel);
        this.southBody.appendChild((Component)this.statusBar);
    }

    private boolean initInfo() {
        String bp = Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_BPartner_ID");
        if (bp != null && bp.length() != 0) {
            this.editorBPartner.setValue(Integer.valueOf(bp));
        }
        StringBuilder where = new StringBuilder("i.IsActive='Y'");
        if (this.p_whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace((String)this.p_whereClause, (String)"C_Invoice.", (String)"i."));
        }
        this.prepareTable(s_invoiceLayout, " C_Invoice_v i", where.toString(), "2,3,4,5");
        return true;
    }

    @Override
    public String getSQLWhere() {
        StringBuilder sql = new StringBuilder();
        if (this.txtDocumentNo.getText().length() > 0) {
            sql.append(" AND UPPER(i.DocumentNo) LIKE ?");
        }
        if (this.txtDescription.getText().length() > 0) {
            sql.append(" AND UPPER(i.Description) LIKE ?");
        }
        if (this.editorBPartner.getValue() != null) {
            sql.append(" AND i.C_BPartner_ID=?");
        }
        if (this.editorOrder.getValue() != null) {
            sql.append(" AND i.C_Order_ID=?");
        }
        Date fromDate = null;
        Date toDate = null;
        try {
            fromDate = this.dateFrom.getValue();
        }
        catch (WrongValueException wrongValueException) {}
        try {
            toDate = this.dateTo.getValue();
        }
        catch (WrongValueException wrongValueException) {}
        if (fromDate == null && toDate != null) {
            sql.append(" AND TRUNC(i.DateInvoiced) <= ?");
        } else if (fromDate != null && toDate == null) {
            sql.append(" AND TRUNC(i.DateInvoiced) >= ?");
        } else if (fromDate != null && toDate != null) {
            sql.append(" AND TRUNC(i.DateInvoiced) BETWEEN ? AND ?");
        }
        Double fromAmount = null;
        Double toAmount = null;
        if (!Util.isEmpty((String)this.amountFrom.getText())) {
            try {
                fromAmount = Double.parseDouble(this.amountFrom.getText());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!Util.isEmpty((String)this.amountTo.getText())) {
            try {
                toAmount = Double.parseDouble(this.amountTo.getText());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (fromAmount == null && toAmount != null) {
            sql.append(" AND i.GrandTotal <= ?");
        } else if (fromAmount != null && toAmount == null) {
            sql.append(" AND i.GrandTotal >= ?");
        } else if (fromAmount != null && toAmount != null) {
            sql.append(" AND i.GrandTotal BETWEEN ? AND ?");
        }
        sql.append(" AND i.IsPaid=? AND i.IsSOTrx=?");
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(sql.toString());
        }
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        int index = 1;
        if (this.txtDocumentNo.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.txtDocumentNo));
        }
        if (this.txtDescription.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.txtDescription));
        }
        if (this.editorBPartner.getValue() != null) {
            Integer bp = (Integer)this.editorBPartner.getValue();
            pstmt.setInt(index++, bp);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("BPartner=" + String.valueOf(bp));
            }
        }
        if (this.editorOrder.getValue() != null) {
            Integer order = (Integer)this.editorOrder.getValue();
            pstmt.setInt(index++, order);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Order=" + String.valueOf(order));
            }
        }
        Date fromD = null;
        Date toD = null;
        Timestamp from = null;
        Timestamp to = null;
        try {
            if (this.dateFrom.getValue() != null) {
                fromD = this.dateFrom.getValue();
                from = new Timestamp(fromD.getTime());
            }
        }
        catch (WrongValueException wrongValueException) {}
        try {
            if (this.dateTo.getValue() != null) {
                toD = this.dateTo.getValue();
                to = new Timestamp(toD.getTime());
            }
        }
        catch (WrongValueException wrongValueException) {}
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Date From=" + String.valueOf(from) + ", To=" + String.valueOf(to));
        }
        if (from == null && to != null) {
            pstmt.setTimestamp(index++, to);
        } else if (from != null && to == null) {
            pstmt.setTimestamp(index++, from);
        } else if (from != null && to != null) {
            pstmt.setTimestamp(index++, from);
            pstmt.setTimestamp(index++, to);
        }
        BigDecimal fromBD = null;
        BigDecimal toBD = null;
        Double fromAmt = null;
        Double toAmt = null;
        if (!Util.isEmpty((String)this.amountFrom.getText())) {
            try {
                fromAmt = Double.parseDouble(this.amountFrom.getText());
                fromBD = BigDecimal.valueOf(fromAmt);
            }
            catch (Exception exception) {}
        }
        if (!Util.isEmpty((String)this.amountTo.getText())) {
            try {
                toAmt = Double.parseDouble(this.amountTo.getText());
                toBD = BigDecimal.valueOf(toAmt);
            }
            catch (Exception exception) {}
        }
        if (fromBD == null && toBD != null) {
            pstmt.setBigDecimal(index++, toBD);
        } else if (fromBD != null && toBD == null) {
            pstmt.setBigDecimal(index++, fromBD);
        } else if (fromBD != null && toBD != null) {
            pstmt.setBigDecimal(index++, fromBD);
            pstmt.setBigDecimal(index++, toBD);
        }
        pstmt.setString(index++, this.isPaid.isChecked() ? "Y" : "N");
        pstmt.setString(index++, this.isSoTrx.isChecked() ? "Y" : "N");
    }

    private String getSQLText(Textbox f) {
        Object s = f.getText().toUpperCase();
        if (!((String)s).endsWith("%")) {
            s = (String)s + "%";
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("String=" + (String)s);
        }
        return s;
    }

    @Override
    public void zoom() {
        this.log.info("InfoInvoice.zoom");
        Integer C_Invoice_ID = this.getIntSelectedRowKey(318);
        if (C_Invoice_ID == null) {
            return;
        }
        MQuery query = new MQuery("C_Invoice");
        query.addRestriction("C_Invoice_ID", "=", (Object)C_Invoice_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("C_Invoice", this.isSoTrx.isSelected());
        AEnv.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }

    @Override
    public void tableChanged(WTableModelEvent event) {
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        if (this.editorBPartner.equals(evt.getSource())) {
            this.editorBPartner.setValue(evt.getNewValue());
        }
        if (this.editorOrder.equals(evt.getSource())) {
            this.editorOrder.setValue(evt.getNewValue());
        }
    }

    @Override
    protected void saveSelectionDetail() {
        Object value;
        Integer ID = this.getIntSelectedRowKey(318);
        Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"C_Invoice_ID", (String)(ID == null ? "0" : ID.toString()));
        int C_InvoicePaySchedule_ID = 0;
        int row = this.contentPanel.getSelectedRow();
        if (row >= 0 && (value = this.contentPanel.getValueAt(row, INDEX_PAYSCHEDULE)) != null && value instanceof KeyNamePair) {
            C_InvoicePaySchedule_ID = ((KeyNamePair)value).getKey();
        }
        if (C_InvoicePaySchedule_ID <= 0) {
            Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"C_InvoicePaySchedule_ID", (String)"0");
        } else {
            Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"C_InvoicePaySchedule_ID", (String)String.valueOf(C_InvoicePaySchedule_ID));
        }
    }

    @Override
    protected void insertPagingComponent() {
        this.southBody.insertBefore((Component)this.paging, this.southBody.getFirstChild());
        this.layout.invalidate();
    }
}

