/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.Properties;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.adwindow.ADTabpanel;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.form.WPaymentFormFactory;
import org.adempiere.webui.apps.form.WPaymentFormWindow;
import org.adempiere.webui.component.Paymentbox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.grid.IPaymentForm;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MPaymentLookup;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Comboitem;

public class WPaymentEditor
extends WEditor
implements ListDataListener,
ContextMenuListener {
    public static final String ON_SAVE_PAYMENT = "onSavePayment";
    public static final String[] LISTENER_EVENTS = new String[]{"onSelect"};
    private MPaymentLookup lookup;
    private Object oldValue;

    public WPaymentEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WPaymentEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new Paymentbox(), gridField, tableEditor, editorConfiguration);
        this.lookup = (MPaymentLookup)gridField.getLookup();
        this.init();
    }

    private void init() {
        this.getComponent().getCombobox().setAutocomplete(true);
        this.getComponent().getCombobox().setAutodrop(true);
        this.getComponent().getCombobox().addEventListener("onBlur", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass("z-icon-Payment");
        } else {
            this.getComponent().setButtonImage(ThemeManager.getThemeResource("images/Payment16.png"));
        }
        this.getComponent().getButton().addActionListener(this);
        if (this.lookup != null) {
            this.lookup.addListDataListener((ListDataListener)this);
            this.lookup.setMandatory(false);
            if (this.isReadWrite()) {
                this.lookup.refresh();
            }
            this.refreshList();
        }
        this.popupMenu = new WEditorPopupMenu(false, true, this.isShowPreference());
        this.addChangeLogMenu(this.popupMenu);
        if (this.gridField != null) {
            this.getComponent().getCombobox().setPlaceholder(this.gridField.getPlaceholder());
        }
    }

    @Override
    public String getDisplay() {
        String display = null;
        Comboitem selItem = this.getComponent().getCombobox().getSelectedItem();
        if (selItem != null) {
            display = selItem.getLabel();
        }
        return display;
    }

    @Override
    public Object getValue() {
        Object retVal = null;
        Comboitem selItem = this.getComponent().getCombobox().getSelectedItem();
        if (selItem != null && (retVal = selItem.getValue()) instanceof Integer && (Integer)retVal == -1) {
            retVal = null;
        }
        return retVal;
    }

    @Override
    public void setValue(Object value) {
        if (value != null && (value instanceof Integer || value instanceof String)) {
            this.getComponent().getCombobox().setValue(value);
            if (!this.getComponent().getCombobox().isSelected(value)) {
                if (this.isReadWrite() && this.lookup != null) {
                    this.lookup.refresh();
                }
                Object curValue = this.oldValue;
                this.oldValue = value;
                this.refreshList();
                if (!this.getComponent().getCombobox().isSelected(value) && value instanceof Integer && this.gridField != null && this.gridField.getDisplayType() != 13) {
                    this.getComponent().getCombobox().setValue(null);
                    if (curValue == null) {
                        curValue = value;
                    }
                    ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), curValue, null);
                    super.fireValueChange(changeEvent);
                    this.oldValue = null;
                }
            } else {
                this.oldValue = value;
            }
        } else {
            this.getComponent().getCombobox().setValue(null);
            this.oldValue = value;
        }
    }

    public Paymentbox getComponent() {
        return (Paymentbox)super.getComponent();
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        GridTab m_mTab = this.gridField.getGridTab();
        boolean m_onlyRule = false;
        if (m_mTab != null) {
            String m_DocStatus = (String)m_mTab.getValue("DocStatus");
            if (m_DocStatus == null) {
                m_DocStatus = "";
            }
            if (m_DocStatus.equals("RE") || m_DocStatus.equals("VO") || m_DocStatus.equals("CL")) {
                this.getComponent().setEnabled(readWrite, false);
                return;
            }
            m_onlyRule = !m_DocStatus.equals("CO") && !m_DocStatus.equals("WP");
            boolean m_isSOTrx = "Y".equals(Env.getContext((Properties)Env.getCtx(), (int)this.gridField.getWindowNo(), (String)"IsSOTrx"));
            if (!m_onlyRule && !m_isSOTrx && m_mTab.getValue("M_Warehouse_ID") != null) {
                m_onlyRule = true;
            }
            if (!m_onlyRule && m_mTab.needSave(true, false)) {
                m_onlyRule = true;
            }
        }
        this.getComponent().setEnabled(readWrite, readWrite && !m_onlyRule);
    }

    private void refreshList() {
        NamePair pair;
        if (this.getComponent().getCombobox().getItemCount() > 0) {
            this.getComponent().getCombobox().removeAllItems();
        }
        if (this.isReadWrite()) {
            if (this.lookup != null) {
                NamePair pair2;
                int size = this.lookup.getSize();
                boolean found = false;
                int i = 0;
                while (i < size) {
                    Object obj = this.lookup.getElementAt(i);
                    if (obj instanceof KeyNamePair) {
                        lookupKNPair = (KeyNamePair)obj;
                        this.getComponent().getCombobox().appendItem(lookupKNPair.getName(), lookupKNPair.getKey());
                        if (!found && this.oldValue != null && this.oldValue instanceof Integer && lookupKNPair.getKey() == ((Integer)this.oldValue).intValue()) {
                            found = true;
                        }
                    } else if (obj instanceof ValueNamePair) {
                        lookupKNPair = (ValueNamePair)obj;
                        this.getComponent().getCombobox().appendItem(lookupKNPair.getName(), lookupKNPair.getValue());
                        if (!found && this.oldValue != null && lookupKNPair.getValue().equals(this.oldValue.toString())) {
                            found = true;
                        }
                    }
                    ++i;
                }
                if (!found && this.oldValue != null && (pair2 = this.lookup.getDirect(this.oldValue, false, false)) != null) {
                    if (pair2 instanceof KeyNamePair) {
                        int key = ((KeyNamePair)pair2).getKey();
                        this.getComponent().getCombobox().appendItem(pair2.getName(), key);
                    } else if (pair2 instanceof ValueNamePair) {
                        ValueNamePair valueNamePair = (ValueNamePair)pair2;
                        this.getComponent().getCombobox().appendItem(valueNamePair.getName(), valueNamePair.getValue());
                    }
                }
            }
        } else if (this.lookup != null && (pair = this.lookup.getDirect(this.oldValue, false, false)) != null) {
            if (pair instanceof KeyNamePair) {
                int key = ((KeyNamePair)pair).getKey();
                this.getComponent().getCombobox().appendItem(pair.getName(), key);
            } else if (pair instanceof ValueNamePair) {
                ValueNamePair valueNamePair = (ValueNamePair)pair;
                this.getComponent().getCombobox().appendItem(valueNamePair.getName(), valueNamePair.getValue());
            }
        }
        this.getComponent().getCombobox().setValue(this.oldValue);
    }

    public void onEvent(Event event) throws Exception {
        if ("onSelect".equalsIgnoreCase(event.getName())) {
            Object newValue = this.getValue();
            if (this.isValueChange(newValue)) {
                ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
                super.fireValueChange(changeEvent);
                this.oldValue = newValue;
            }
            if (newValue != null) {
                this.focusNext();
            }
        } else if ("onBlur".equalsIgnoreCase(event.getName())) {
            Object newValue;
            Comboitem item = this.getComponent().getCombobox().getSelectedItem();
            if (item == null) {
                this.setValue(this.oldValue);
            } else if (item.getLabel().equals("") && this.isValueChange(newValue = this.getValue())) {
                ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
                super.fireValueChange(changeEvent);
                this.oldValue = newValue;
            }
        } else if ("onClick".equalsIgnoreCase(event.getName())) {
            IPaymentForm pf;
            int windowNo = this.lookup == null ? 0 : this.lookup.getWindowNo();
            Object newValue = this.getValue();
            if (newValue != null && this.getGridField().getGridTab() != null && (pf = WPaymentFormFactory.create(windowNo, this.getGridField().getGridTab(), (String)newValue)) != null) {
                WPaymentFormWindow window = (WPaymentFormWindow)pf.getWindow();
                window.setWidgetAttribute("instanceName", "paymentForm");
                if (window.isInitOK()) {
                    window.setAttribute("mode", "highlighted");
                    window.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                        public void onEvent(Event event) throws Exception {
                            if (pf.needSave()) {
                                Paymentbox comp = WPaymentEditor.this.getComponent();
                                while (comp != null) {
                                    if (!((comp = comp.getParent()) instanceof ADTabpanel)) continue;
                                    Events.sendEvent((Component)comp, (Event)new Event(WPaymentEditor.ON_SAVE_PAYMENT, (Component)comp));
                                    return;
                                }
                            }
                        }
                    });
                    pf.showWindow();
                    AEnv.showWindow(window);
                }
            }
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.refreshList();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    private boolean isValueChange(Object newValue) {
        return this.oldValue == null && newValue != null || this.oldValue != null && newValue == null || this.oldValue != null && newValue != null && !this.oldValue.equals(newValue);
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    protected void setFieldStyle(String style) {
        this.getComponent().getCombobox().setStyle(style);
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("REQUERY".equals(evt.getContextEvent())) {
            this.actionRefresh();
        } else {
            if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
                if (this.isShowPreference()) {
                    ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
                }
                return;
            }
            if ("CHANGE_LOG".equals(evt.getContextEvent())) {
                WFieldRecordInfo.start(this.gridField);
            }
        }
    }

    public void actionRefresh() {
        if (this.lookup != null) {
            Object curValue = this.getValue();
            if (this.isReadWrite()) {
                this.lookup.refresh();
            } else {
                this.refreshList();
            }
            if (curValue != null) {
                this.setValue(curValue);
            }
        }
    }
}

