/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow;

import java.util.Properties;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.editor.IProcessButton;
import org.adempiere.webui.event.ActionEvent;
import org.adempiere.webui.event.ActionListener;
import org.compiere.model.MProcess;
import org.compiere.model.MToolBarButton;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Button;

public class ToolbarProcessButton
implements IProcessButton,
Evaluatee {
    private MToolBarButton mToolbarButton;
    private IADTabpanel adTabpanel;
    private String name;
    private String description;
    private ActionListener actionListener;
    private Button button;
    private int windowNo;

    public ToolbarProcessButton(MToolBarButton mToolbarButton, IADTabpanel adTabpanel, ActionListener listener, int windowNo) {
        this.mToolbarButton = mToolbarButton;
        this.adTabpanel = adTabpanel;
        this.actionListener = listener;
        this.windowNo = windowNo;
        MProcess process = MProcess.get((Properties)Env.getCtx(), (int)this.getProcess_ID());
        this.name = process.get_Translation("Name");
        this.description = process.get_Translation("Description");
        this.button = new Button();
        this.button.setLabel(this.name);
        if (this.description != null && this.description.trim().length() > 0) {
            this.button.setTooltiptext(this.description);
        }
        this.button.setAttribute("component.name", (Object)mToolbarButton.getComponentName());
        this.button.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (ToolbarProcessButton.this.actionListener != null) {
                    ActionEvent actionEvent = new ActionEvent(ToolbarProcessButton.this, ToolbarProcessButton.this.getColumnName(), "onClick");
                    ToolbarProcessButton.this.actionListener.actionPerformed(actionEvent);
                }
            }
        });
    }

    @Override
    public int getProcess_ID() {
        return this.mToolbarButton.getAD_Process_ID();
    }

    @Override
    public int getInfoWindow_ID() {
        return 0;
    }

    @Override
    public IADTabpanel getADTabpanel() {
        return this.adTabpanel;
    }

    @Override
    public String getColumnName() {
        return this.mToolbarButton.getComponentName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDisplay() {
        return this.name;
    }

    public Button getButton() {
        return this.button;
    }

    public void dynamicDisplay() {
        String displayLogic = this.mToolbarButton.getDisplayLogic();
        if (displayLogic == null || displayLogic.trim().length() == 0) {
            return;
        }
        boolean visible = this.validateLogic(displayLogic, this.adTabpanel.getTabNo());
        this.button.setVisible(visible);
    }

    public String get_ValueAsString(String variableName) {
        int tabNo = this.adTabpanel.getTabNo();
        if (tabNo == 0) {
            return this.adTabpanel.get_ValueAsString(variableName);
        }
        return Env.getContext((Properties)Env.getCtx(), (int)this.windowNo, (int)tabNo, (String)variableName, (boolean)false, (boolean)true);
    }

    public void readOnlyLogic() {
        String readOnlyLogic = this.mToolbarButton.getReadOnlyLogic();
        if (readOnlyLogic == null || readOnlyLogic.trim().length() == 0) {
            return;
        }
        boolean disabled = this.validateLogic(readOnlyLogic, this.adTabpanel.getTabNo());
        this.button.setDisabled(disabled);
    }

    public void pressedLogic() {
        String pressedLogic = this.mToolbarButton.getPressedLogic();
        if (pressedLogic == null || pressedLogic.trim().length() == 0) {
            return;
        }
        boolean isPressed = this.validateLogic(pressedLogic, this.adTabpanel.getTabNo());
        this.button.setAttribute("buttonPressed", (Object)(isPressed ? "Y" : "N"));
    }

    private boolean validateLogic(String logic, int tabNo) {
        boolean isValid = false;
        isValid = logic.startsWith("@SQL=") ? Evaluator.parseSQLLogic((String)logic, (Properties)Env.getCtx(), (int)this.windowNo, (int)tabNo, (String)this.getColumnName()) : Evaluator.evaluateLogic((Evaluatee)this, (String)logic);
        return isValid;
    }
}

