/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.ui.zk.report;

import com.google.common.net.MediaType;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.webui.report.HTMLExtension;
import org.adempiere.webui.window.ZkReportViewer;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.ReportEngine;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.print.renderer.HTMLReportRendererConfiguration;
import org.idempiere.print.renderer.IReportRenderer;
import org.idempiere.print.renderer.IReportRendererConfiguration;
import org.idempiere.ui.zk.report.IReportViewerRenderer;
import org.osgi.service.component.annotations.Component;
import org.zkoss.util.media.AMedia;
import org.zkoss.zk.ui.Executions;

@Component(service={IReportViewerRenderer.class}, immediate=true)
public class HTMLReportViewerRenderer
implements IReportViewerRenderer {
    private static final CLogger log = CLogger.getCLogger(HTMLReportViewerRenderer.class);

    @Override
    public String getId() {
        return "HTML";
    }

    @Override
    public String getExportLabel() {
        return Msg.getMsg((Properties)Env.getCtx(), (String)"FileHTML");
    }

    @Override
    public String getContentType() {
        return MediaType.HTML_UTF_8.toString();
    }

    @Override
    public String getFileExtension() {
        return "html";
    }

    @Override
    public boolean isExport() {
        return true;
    }

    @Override
    public boolean isPreview(boolean roleCanExport) {
        return true;
    }

    @Override
    public AMedia renderMedia(ZkReportViewer viewer, boolean export) {
        ReportEngine reportEngine = viewer.getReportEngine();
        try {
            String path = System.getProperty("java.io.tmpdir");
            Object prefix = this.makePrefix(reportEngine.getName());
            if (((String)prefix).length() < 3) {
                prefix = (String)prefix + "_".repeat(3 - ((String)prefix).length());
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Path=" + path + " Prefix=" + (String)prefix);
            }
            File file = FileUtil.createTempFile((String)prefix, (String)("." + this.getFileExtension()), (File)new File(path));
            String contextPath = Executions.getCurrent().getContextPath();
            IReportRenderer renderer = Core.getReportRenderer((String)this.getId());
            HTMLReportRendererConfiguration config = new HTMLReportRendererConfiguration().setLanguage(reportEngine.getPrintFormat().getLanguage()).setOutputFile(file).setExport(export).setExtension((IHTMLExtension)new HTMLExtension(contextPath, "rp", viewer.getUuid()));
            renderer.renderReport(reportEngine, (IReportRendererConfiguration)config);
            return new AMedia(file.getName(), this.getFileExtension(), this.getContentType(), file, false);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isSameContentForExportAndPreview() {
        return false;
    }
}

