/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.functions.standard;

import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.data.HierarchicalDataSource;
import net.sf.jasperreports.engine.fill.SortedDataSource;
import net.sf.jasperreports.functions.AbstractFunctionSupport;
import net.sf.jasperreports.functions.annotations.Function;
import net.sf.jasperreports.functions.annotations.FunctionCategories;
import net.sf.jasperreports.functions.annotations.FunctionParameter;
import net.sf.jasperreports.functions.annotations.FunctionParameters;
import net.sf.jasperreports.functions.standard.ReportCategory;

@FunctionCategories(value={ReportCategory.class})
public class ReportFunctions
extends AbstractFunctionSupport {
    public static final String EXCEPTION_DATA_SOURCE_NOT_HIERARCHICAL = "data.source.not.hierarchical";

    @Function(value="ORIGINAL_DATA_SOURCE")
    public JRDataSource ORIGINAL_DATA_SOURCE() {
        try {
            return this.originalDataSource();
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    protected JRDataSource originalDataSource() throws JRException {
        JRDataSource dataSource = (JRDataSource)this.getContext().getParameterValue("REPORT_DATA_SOURCE");
        if (dataSource instanceof SortedDataSource) {
            dataSource = ((SortedDataSource)dataSource).getOriginalDataSource();
        }
        return dataSource;
    }

    @Function(value="SUB_DATA_SOURCE")
    public JRDataSource SUB_DATA_SOURCE() {
        try {
            HierarchicalDataSource<?> hierarchicalDataSource = this.hierarchicalDataSource();
            return hierarchicalDataSource.subDataSource();
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    @Function(value="SUB_DATA_SOURCE")
    @FunctionParameters(value={@FunctionParameter(value="expression")})
    public JRDataSource SUB_DATA_SOURCE(String expression) {
        try {
            HierarchicalDataSource<?> hierarchicalDataSource = this.hierarchicalDataSource();
            return hierarchicalDataSource.subDataSource(expression);
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    protected HierarchicalDataSource<?> hierarchicalDataSource() throws JRException {
        JRDataSource dataSource = this.originalDataSource();
        if (dataSource == null) {
            throw new NullPointerException();
        }
        if (!(dataSource instanceof HierarchicalDataSource)) {
            throw new JRRuntimeException(EXCEPTION_DATA_SOURCE_NOT_HIERARCHICAL, new Object[]{dataSource.getClass().getName()});
        }
        HierarchicalDataSource hierarchicalDataSource = (HierarchicalDataSource)dataSource;
        return hierarchicalDataSource;
    }
}

