/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.adempiere.util.ContextRunnable;
import org.compiere.Adempiere;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MQuery;
import org.compiere.model.MReference;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public final class MLookup
extends Lookup
implements Serializable {
    private static final long serialVersionUID = 2288661955135689187L;
    public static final String INACTIVE_S = "~";
    public static final String INACTIVE_E = "~";
    private static Integer MINUS_ONE = -1;
    private MLookupInfo m_info = null;
    private int m_tabNo = 0;
    private volatile LinkedHashMap<Object, Object> m_lookup = new LinkedHashMap();
    private MLoader m_loader;
    private boolean m_allLoaded = false;
    private boolean m_hasInactive = false;
    private boolean m_refreshing = false;
    private boolean m_refreshCache = false;
    private long m_nextRead = 0L;
    public static final String SHORTLIST_S = "*";
    public static final String SHORTLIST_E = "*";
    private boolean m_hasShortListItems = false;
    private static final int MAX_NAMEPAIR_CACHE_SIZE = 1000;
    private HashMap<Object, Object> m_lookupDirect = null;
    private Future<?> m_loaderFuture;
    private static final CCache<String, CCache<String, List<KeyNamePair>>> s_keyNamePairCache = new CCache(null, "MLookup.KeyNamePairCache", 100, CCache.DEFAULT_EXPIRE_MINUTE, false, 500);
    private static final CCache<String, CCache<String, List<ValueNamePair>>> s_valueNamePairCache = new CCache(null, "MLookup.ValueNamePairCache", 100, CCache.DEFAULT_EXPIRE_MINUTE, false, 500);
    private static final CCache<String, CCache<Integer, KeyNamePair>> s_directKeyNamePairCache = new CCache(null, "MLookup.DirectKeyNamePairCache", 100, CCache.DEFAULT_EXPIRE_MINUTE, false, 500);
    private static final CCache<String, CCache<String, ValueNamePair>> s_directValueNamePairCache = new CCache(null, "MLookup.DirectValueNamePairCache", 100, CCache.DEFAULT_EXPIRE_MINUTE, false, 500);

    public MLookup(MLookupInfo info, int TabNo) {
        super(info.DisplayType, info.WindowNo);
        this.m_info = info;
        this.m_tabNo = TabNo;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.m_info.KeyColumn);
        }
        if (this.m_info.DisplayType == 30 || this.m_info.DisplayType == 200235 || this.m_info.IsCreadedUpdatedBy) {
            return;
        }
        if (this.m_info.IsParent || this.m_info.IsKey) {
            this.m_hasInactive = true;
            return;
        }
    }

    @Override
    public void dispose() {
        if (this.m_info != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.m_info.KeyColumn + ": dispose");
        }
        if (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
            this.m_loaderFuture.cancel(true);
        }
        this.m_loader = null;
        this.m_loaderFuture = null;
        if (this.m_lookup != null) {
            this.m_lookup.clear();
        }
        this.m_lookup = null;
        if (this.m_lookupDirect != null) {
            this.m_lookupDirect.clear();
        }
        this.m_lookupDirect = null;
        this.m_info = null;
        super.dispose();
    }

    @Override
    public void loadComplete() {
        if (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
            try {
                this.m_loaderFuture.get();
            }
            catch (Exception ie) {
                this.log.log(Level.SEVERE, this.m_info.KeyColumn + ": Interrupted", ie);
            }
            this.m_loader = null;
            this.m_loaderFuture = null;
        }
    }

    public NamePair get(Object key, boolean includeDirect) {
        NamePair retValue;
        if (key == null || MINUS_ONE.equals(key)) {
            return null;
        }
        if (this.m_info.IsParent) {
            if (this.m_nextRead > 0L && this.m_nextRead < System.currentTimeMillis()) {
                this.m_lookup.clear();
                if (this.m_lookupDirect != null) {
                    this.m_lookupDirect.clear();
                }
            }
            this.m_nextRead = System.currentTimeMillis() + 5000L;
        }
        if ((retValue = (NamePair)this.m_lookup.get(key)) != null) {
            return retValue;
        }
        if (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer((String)(this.m_info.KeyColumn == null ? "ID=" + this.m_info.Column_ID : this.m_info.KeyColumn) + ": waiting for Loader");
            }
            this.loadComplete();
            retValue = (NamePair)this.m_lookup.get(key);
            if (retValue != null) {
                return retValue;
            }
        }
        if (includeDirect) {
            boolean cacheLocal = this.m_info.IsValidated;
            return this.getDirect(key, false, cacheLocal);
        }
        return null;
    }

    @Override
    public NamePair get(Object key) {
        return this.get(key, true);
    }

    public NamePair getNoDirect(Object key) {
        return this.get(key, false);
    }

    @Override
    public String getDisplay(Object key) {
        if (key == null) {
            return "";
        }
        if (this.m_info.DisplayType == 200161 || this.m_info.DisplayType == 200163 || this.m_info.DisplayType == 200162) {
            String[] keys;
            StringBuilder builder = new StringBuilder();
            String[] stringArray = keys = key.toString().split("[,]");
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                NamePair display;
                String k = stringArray[n2];
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                if ((display = this.get(k)) == null) {
                    builder.append("<").append(k).append(">");
                } else {
                    builder.append(((Object)display).toString());
                }
                ++n2;
            }
            return builder.toString();
        }
        NamePair display = this.get(key);
        if (display == null) {
            StringBuilder msgreturn = new StringBuilder("<").append(key.toString()).append(">");
            return msgreturn.toString();
        }
        return ((Object)display).toString();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.m_lookup.containsKey(key)) {
            return true;
        }
        if (this.m_lookup.size() > 0) {
            return false;
        }
        return this.get(key) != null;
    }

    @Override
    public boolean containsKeyNoDirect(Object key) {
        if (this.m_lookup.containsKey(key)) {
            return true;
        }
        if (this.m_lookup.size() > 0) {
            return false;
        }
        return this.getNoDirect(key) != null;
    }

    public String toString() {
        StringBuilder msgreturn = new StringBuilder("MLookup[").append(this.m_info.KeyColumn).append(",Column_ID=").append(this.m_info.Column_ID).append(",Size=").append(this.m_lookup.size()).append(",Validated=").append(this.isValidated()).append("-").append(this.getValidation()).append("]");
        return msgreturn.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MLookup) {
            MLookup ll = (MLookup)obj;
            if (ll.m_info.Column_ID == this.m_info.Column_ID) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public int size() {
        return this.m_lookup.size();
    }

    public boolean isAllLoaded() {
        return this.m_allLoaded;
    }

    @Override
    public boolean isValidated() {
        if (this.m_info == null) {
            return false;
        }
        return this.isValidated(this.m_info);
    }

    @Override
    public String getValidation() {
        return this.m_info.ValidationCode;
    }

    public int getAD_Reference_Value_ID() {
        return this.m_info.AD_Reference_Value_ID;
    }

    @Override
    public boolean hasInactive() {
        return this.m_hasInactive;
    }

    public int getAD_InfoWindow_ID() {
        return this.m_info.InfoWindowId;
    }

    private ArrayList<Object> getData(boolean onlyValidated, boolean loadParent) {
        boolean validated;
        if (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine((String)(this.m_info.KeyColumn == null ? "ID=" + this.m_info.Column_ID : this.m_info.KeyColumn) + ": waiting for Loader");
            }
            this.loadComplete();
        }
        if (!this.m_allLoaded || this.m_lookup.size() == 0) {
            this.loadData(loadParent);
        }
        if (validated = this.isValidated(this.m_info)) {
            return new ArrayList<Object>(this.m_lookup.values());
        }
        if (!validated && onlyValidated) {
            this.loadData(loadParent);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.m_info.KeyColumn + ": Validated - #" + this.m_lookup.size());
            }
        }
        return new ArrayList<Object>(this.m_lookup.values());
    }

    @Override
    public ArrayList<Object> getData(boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary, boolean shortlist) {
        String s;
        Object o;
        int i;
        ArrayList<Object> list = this.getData(onlyValidated, true);
        if (onlyActive && this.m_hasInactive) {
            i = list.size();
            while (i > 0) {
                o = list.get(i - 1);
                if (o != null && (s = o.toString()).startsWith("~") && s.endsWith("~")) {
                    list.remove(i - 1);
                }
                --i;
            }
        }
        if (shortlist && this.m_hasShortListItems) {
            i = list.size();
            while (i > 0) {
                o = list.get(i - 1);
                if (o != null && (s = o.toString()).startsWith("*") && s.endsWith("*")) {
                    list.remove(i - 1);
                }
                --i;
            }
        }
        if (!mandatory) {
            NamePair p2 = null;
            p2 = this.m_info.KeyColumn != null && this.m_info.KeyColumn.endsWith("_ID") ? new KeyNamePair(-1, "") : new ValueNamePair("", "");
            list.add(0, p2);
        }
        return list;
    }

    @Override
    public NamePair getDirect(Object key, boolean saveInCache, boolean cacheLocal) {
        return this.getDirect(key, saveInCache, cacheLocal, null);
    }

    @Override
    public NamePair getDirect(Object key, boolean saveInCache, boolean cacheLocal, String trxName) {
        NamePair directValue;
        block30: {
            if (key == null || this.m_info.QueryDirect == null || this.m_info.QueryDirect.length() == 0) {
                return null;
            }
            if (key.toString().trim().length() == 0) {
                return null;
            }
            directValue = null;
            if (this.m_lookupDirect != null && (directValue = (NamePair)this.m_lookupDirect.get(key)) != null) {
                return directValue;
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(this.m_info.KeyColumn + ": " + String.valueOf(key) + ", SaveInCache=" + saveInCache + ",Local=" + cacheLocal);
            }
            String cacheKey = this.m_info.TableName + "|" + this.m_info.KeyColumn + "|" + this.m_info.AD_Reference_Value_ID + "|" + Env.getAD_Language(Env.getCtx());
            boolean isNumber = this.m_info.KeyColumn.endsWith("_ID");
            CCache<Integer, KeyNamePair> knpCache = null;
            CCache<String, ValueNamePair> vnpCache = null;
            if (isNumber) {
                knpCache = MLookup.getDirectKeyNamePairCache(this.m_info, cacheKey);
                KeyNamePair knp = knpCache.get(Integer.parseInt(key.toString()));
                if (knp != null) {
                    return knp;
                }
            } else {
                vnpCache = MLookup.getDirectValueNamePairCache(this.m_info, cacheKey);
                ValueNamePair vnp = vnpCache.get(key.toString());
                if (vnp != null) {
                    return vnp;
                }
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(this.m_info.QueryDirect, trxName);
                    if (isNumber) {
                        pstmt.setInt(1, Integer.parseInt(key.toString()));
                    } else {
                        pstmt.setString(1, key.toString());
                    }
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        StringBuilder name = new StringBuilder().append(rs.getString(3));
                        boolean isActive = rs.getString(4).equals("Y");
                        if (!isActive) {
                            name.insert(0, "~").append("~");
                        }
                        if (isNumber) {
                            int keyValue = rs.getInt(1);
                            KeyNamePair p2 = new KeyNamePair(keyValue, name.toString());
                            if (saveInCache) {
                                this.m_lookup.put(keyValue, p2);
                            }
                            directValue = p2;
                            knpCache.put(p2.getKey(), p2);
                        } else {
                            String value = this.m_info.KeyColumn.endsWith("_UU") ? rs.getString(1) : rs.getString(2);
                            ValueNamePair p3 = new ValueNamePair(value, name.toString());
                            if (saveInCache) {
                                this.m_lookup.put(value, p3);
                            }
                            directValue = p3;
                            vnpCache.put(p3.getValue(), p3);
                        }
                        if (rs.next()) {
                            Level level = Level.SEVERE;
                            if ("AD_ChangeLog".equals(this.m_info.TableName)) {
                                level = Level.INFO;
                            }
                            if (this.log.isLoggable(level)) {
                                this.log.log(level, this.m_info.KeyColumn + ": Not unique (first returned) for " + String.valueOf(key) + " SQL=" + this.m_info.QueryDirect);
                            }
                        }
                    } else {
                        directValue = null;
                    }
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest(this.m_info.KeyColumn + ": " + String.valueOf(directValue) + " - " + String.valueOf(this.m_info));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, this.m_info.KeyColumn + ": SQL=" + this.m_info.QueryDirect + "; Key=" + String.valueOf(key), e);
                    directValue = null;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block30;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (cacheLocal && !saveInCache && directValue != null) {
            if (this.m_lookupDirect == null) {
                this.m_lookupDirect = new HashMap();
            } else if (!this.m_lookupDirect.containsKey(key)) {
                this.m_lookupDirect.clear();
                this.m_lookupDirect.put(key, directValue);
            }
        }
        this.m_hasInactive = true;
        return directValue;
    }

    @Override
    public NamePair[] getDirect(Object[] keys) {
        ValueNamePair vnp22;
        ArrayList<NamePair> list = new ArrayList<NamePair>();
        String cacheKey = this.m_info.TableName + "|" + this.m_info.KeyColumn + "|" + this.m_info.AD_Reference_Value_ID + "|" + Env.getAD_Language(Env.getCtx());
        boolean isNumber = this.m_info.KeyColumn.endsWith("_ID");
        CCache<Integer, KeyNamePair> knpCache = null;
        CCache<String, ValueNamePair> vnpCache = null;
        HashMap<Object, Integer> notInCaches = new HashMap<Object, Integer>();
        int i = 0;
        while (i < keys.length) {
            Object key = keys[i];
            if (isNumber) {
                KeyNamePair knp = null;
                int id = Integer.parseInt(key.toString());
                knpCache = MLookup.getDirectKeyNamePairCache(this.m_info, cacheKey);
                knp = knpCache.get(id);
                if (knp == null) {
                    knp = new KeyNamePair(id, null);
                    notInCaches.put(id, i);
                }
                list.add(knp);
            } else {
                vnp22 = null;
                vnpCache = MLookup.getDirectValueNamePairCache(this.m_info, cacheKey);
                vnp22 = vnpCache.get(key.toString());
                if (vnp22 == null) {
                    vnp22 = new ValueNamePair(key.toString(), null);
                    notInCaches.put(key.toString(), i);
                }
                list.add(vnp22);
            }
            ++i;
        }
        if (notInCaches.size() > 0) {
            StringBuilder builder = new StringBuilder();
            int i22 = 0;
            while (i22 < notInCaches.size()) {
                if (builder.length() > 0) {
                    builder.append(" UNION ALL ");
                }
                builder.append(this.m_info.QueryDirect);
                ++i22;
            }
            try {
                Throwable i22 = null;
                vnp22 = null;
                try (CPreparedStatement pstmt = DB.prepareStatement(builder.toString(), null);){
                    Set keySet = notInCaches.keySet();
                    int i3 = 0;
                    for (Object id : keySet) {
                        ++i3;
                        if (id instanceof Integer) {
                            pstmt.setInt(i3, (Integer)id);
                            continue;
                        }
                        pstmt.setString(i3, id.toString());
                    }
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Integer idx;
                        NamePair p2;
                        StringBuilder name = new StringBuilder().append(rs.getString(3));
                        boolean isActive = rs.getString(4).equals("Y");
                        if (!isActive) {
                            name.insert(0, "~").append("~");
                        }
                        if (isNumber) {
                            int keyValue = rs.getInt(1);
                            p2 = new KeyNamePair(keyValue, name.toString());
                            knpCache.put(((KeyNamePair)p2).getKey(), (KeyNamePair)p2);
                            idx = (Integer)notInCaches.get(((KeyNamePair)p2).getKey());
                            if (idx == null) continue;
                            list.set(idx, p2);
                            continue;
                        }
                        String value = this.m_info.KeyColumn.endsWith("_UU") ? rs.getString(1) : rs.getString(2);
                        p2 = new ValueNamePair(value, name.toString());
                        vnpCache.put(((ValueNamePair)p2).getValue(), (ValueNamePair)p2);
                        idx = (Integer)notInCaches.get(((ValueNamePair)p2).getValue());
                        if (idx == null) continue;
                        list.set(idx, p2);
                    }
                }
                catch (Throwable vnp22) {
                    if (i22 == null) {
                        i22 = vnp22;
                    } else if (i22 != vnp22) {
                        i22.addSuppressed(vnp22);
                    }
                    throw i22;
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
            int i4 = list.size() - 1;
            while (i4 >= 0) {
                NamePair np = (NamePair)list.get(i4);
                if (np.getName() == null) {
                    list.remove(i4);
                }
                --i4;
            }
        }
        return list.toArray(new NamePair[0]);
    }

    @Override
    public int getZoom() {
        return this.m_info.ZoomWindow;
    }

    @Override
    public int getZoom(MQuery query) {
        if (this.m_info.ZoomWindowPO == 0 || query == null) {
            return this.m_info.ZoomWindow;
        }
        boolean isSOTrx = DB.isSOTrx(this.m_info.TableName, query.getWhereClause(false), this.m_info.WindowNo);
        return this.getZoom(isSOTrx);
    }

    @Override
    public int getZoom(boolean isSOTrx) {
        if (this.m_info.ZoomWindowPO == 0) {
            return this.m_info.ZoomWindow;
        }
        return isSOTrx ? this.m_info.ZoomWindow : this.m_info.ZoomWindowPO;
    }

    @Override
    public MQuery getZoomQuery() {
        return this.m_info.ZoomQuery;
    }

    @Override
    public String getColumnName() {
        return this.m_info.KeyColumn;
    }

    @Override
    public int refresh() {
        if (this.m_refreshing) {
            return 0;
        }
        return this.refresh(true);
    }

    public int refreshItemsAndCache() {
        if (this.m_refreshing) {
            return 0;
        }
        this.m_refreshCache = true;
        try {
            int n = this.refresh();
            return n;
        }
        finally {
            this.m_refreshCache = false;
        }
    }

    public int refresh(boolean loadParent) {
        if (this.m_refreshing) {
            return 0;
        }
        if (!loadParent && this.m_info.IsParent) {
            return 0;
        }
        if (this.m_info.DisplayType == 30 || this.m_info.IsCreadedUpdatedBy) {
            this.removeAllElements();
            return 0;
        }
        this.m_refreshing = true;
        try {
            this.m_lookup.clear();
            MReference ref = this.m_info.AD_Reference_Value_ID > 0 ? MReference.get(Env.getCtx(), this.m_info.AD_Reference_Value_ID) : null;
            boolean onlyActive = ref == null || !ref.isShowInactiveRecords();
            this.fillComboBox(this.isMandatory(), true, onlyActive, false, this.isShortList());
            int n = this.m_lookup.size();
            return n;
        }
        finally {
            this.m_refreshing = false;
        }
    }

    private int loadData(boolean loadParent) {
        if (!loadParent && this.m_info.IsParent) {
            return 0;
        }
        if (this.m_info.DisplayType == 30 || this.m_info.IsCreadedUpdatedBy) {
            return 0;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.m_info.KeyColumn + ": start");
        }
        this.m_loader = new MLoader();
        this.m_loaderFuture = Adempiere.getThreadPoolExecutor().submit(this.m_loader);
        this.loadComplete();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.m_info.KeyColumn + ": #" + this.m_lookup.size());
        }
        return this.m_lookup.size();
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        this.m_lookup.clear();
        if (this.m_lookupDirect != null) {
            this.m_lookupDirect.clear();
        }
    }

    private boolean isValidated(MLookupInfo info) {
        if (info.IsValidated) {
            return true;
        }
        if (info.ValidationCode.length() == 0) {
            return true;
        }
        String validation = Env.parseContext(this.m_info.ctx, this.m_info.WindowNo, this.m_tabNo, this.m_info.ValidationCode, false);
        return validation.equals(info.parsedValidationCode);
    }

    public MLookupInfo getLookupInfo() {
        return this.m_info;
    }

    private static synchronized List<KeyNamePair> getKeyNamePairCache(MLookupInfo lookupInfo, String cacheKey) {
        List<KeyNamePair> list;
        CCache<String, List<KeyNamePair>> knpCache = s_keyNamePairCache.get(lookupInfo.TableName);
        if (knpCache == null) {
            knpCache = new CCache(lookupInfo.TableName, cacheKey + " KeyNamePair Cache", 100, CCache.DEFAULT_EXPIRE_MINUTE, false, 500);
            s_keyNamePairCache.put(lookupInfo.TableName, knpCache);
        }
        if ((list = knpCache.get(cacheKey)) == null) {
            list = new ArrayList<KeyNamePair>();
            knpCache.put(cacheKey, list);
        }
        return list;
    }

    private static synchronized List<ValueNamePair> getValueNamePairCache(MLookupInfo lookupInfo, String cacheKey) {
        List<ValueNamePair> list;
        CCache<String, List<ValueNamePair>> vnpCache = s_valueNamePairCache.get(lookupInfo.TableName);
        if (vnpCache == null) {
            vnpCache = new CCache(lookupInfo.TableName, cacheKey + " ValueNamePair Cache", 100, CCache.DEFAULT_EXPIRE_MINUTE, false, 500);
            s_valueNamePairCache.put(lookupInfo.TableName, vnpCache);
        }
        if ((list = vnpCache.get(cacheKey)) == null) {
            list = new ArrayList<ValueNamePair>();
            vnpCache.put(cacheKey, list);
        }
        return list;
    }

    private static synchronized CCache<Integer, KeyNamePair> getDirectKeyNamePairCache(MLookupInfo lookupInfo, String cacheKey) {
        CCache<Integer, KeyNamePair> knpCache = s_directKeyNamePairCache.get(cacheKey);
        if (knpCache == null) {
            knpCache = new CCache(lookupInfo.TableName, cacheKey + " DirectKeyNamePairCache", 100, CCache.DEFAULT_EXPIRE_MINUTE, false, 1000);
            s_directKeyNamePairCache.put(cacheKey, knpCache);
        }
        return knpCache;
    }

    private static synchronized CCache<String, ValueNamePair> getDirectValueNamePairCache(MLookupInfo lookupInfo, String cacheKey) {
        CCache<String, ValueNamePair> vnpCache = s_directValueNamePairCache.get(cacheKey);
        if (vnpCache == null) {
            vnpCache = new CCache(lookupInfo.TableName, cacheKey + " DirectValueNamePairCache", 100, CCache.DEFAULT_EXPIRE_MINUTE, false, 1000);
            s_directValueNamePairCache.put(cacheKey, vnpCache);
        }
        return vnpCache;
    }

    public static MLookup getRecordsLookup(int tableID, int windowNo, int tabNo) {
        return MLookup.getRecordsLookup(tableID, windowNo, tabNo, false);
    }

    public static MLookup getRecordsLookup(int tableID, int windowNo, int tabNo, boolean useUUIDKey) {
        String[] keyColumns;
        if (tableID <= 0) {
            return null;
        }
        MTable mTable = MTable.get(Env.getCtx(), tableID, null);
        String keyColumn = "";
        if (!useUUIDKey && (keyColumns = mTable.getKeyColumns()) != null && keyColumns.length == 1) {
            keyColumn = keyColumns[0];
        }
        if (Util.isEmpty(keyColumn)) {
            keyColumn = PO.getUUIDColumnName(mTable.getTableName());
        }
        if (Util.isEmpty(keyColumn)) {
            return null;
        }
        MColumn mColumn = MColumn.get(Env.getCtx(), mTable.getTableName(), keyColumn);
        MLookupInfo lookupInfo = MLookupFactory.getLookupInfo(Env.getCtx(), windowNo, tabNo, mColumn.getAD_Column_ID(), 30);
        return new MLookup(lookupInfo, tabNo);
    }

    public static String getIdentifier(int tableID, Serializable recordID) {
        return MLookup.getIdentifier(tableID, recordID, 0, 0);
    }

    public static String getIdentifier(int tableID, Serializable recordID, int windowNo, int tabNo) {
        return MLookup.getIdentifier(tableID, recordID, windowNo, tabNo, false);
    }

    public static String getIdentifier(int tableID, Serializable recordID, int windowNo, int tabNo, boolean useUUIDKey) {
        MLookup lookup = MLookup.getRecordsLookup(tableID, windowNo, tabNo, useUUIDKey);
        return lookup != null ? lookup.getDisplay(recordID) : "";
    }

    protected class MLoader
    extends ContextRunnable
    implements Serializable {
        private static final long serialVersionUID = -7868426685745727939L;
        private long m_startTime = System.currentTimeMillis();

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void doRun() {
            block30: {
                block32: {
                    block34: {
                        block31: {
                            block33: {
                                MAX_ROWS = MSysConfig.getIntValue("MAX_ROWS_IN_TABLE_COMBOLIST", 10000, Env.getAD_Client_ID(Env.getCtx()));
                                if (MAX_ROWS > 50000) {
                                    MLookup.this.log.warning("SysConfig MAX_ROWS_IN_TABLE_COMBOLIST set back to maximum allowed value of 50.000");
                                    MAX_ROWS = 50000;
                                }
                                startTime = System.currentTimeMillis();
                                sql = new StringBuilder().append(MLookup.this.m_info.Query);
                                if (MLookup.this.isShortList()) {
                                    posFirstPoint = sql.indexOf(".");
                                    tableName = sql.substring(7, posFirstPoint);
                                    posFirstFrom = sql.indexOf(tableName + ".IsActive FROM " + tableName) + tableName.length() + 9;
                                    ClauseFromWhereOrder = sql.substring(posFirstFrom, sql.length());
                                    sql = new StringBuilder(sql.substring(0, posFirstFrom) + ", " + tableName + ".IsShortList" + ClauseFromWhereOrder);
                                }
                                if (!MLookup.this.m_info.IsValidated) {
                                    MLookup.this.m_info.parsedValidationCode = validation = Env.parseContext(MLookup.this.m_info.ctx, MLookup.this.m_info.WindowNo, MLookup.this.m_tabNo, MLookup.this.m_info.ValidationCode, false);
                                    if (validation.length() == 0 && MLookup.this.m_info.ValidationCode.length() > 0) {
                                        if (MLookup.this.log.isLoggable(Level.FINE)) {
                                            MLookup.this.log.fine(MLookup.this.m_info.KeyColumn + ": Loader NOT Validated: " + MLookup.this.m_info.ValidationCode);
                                        }
                                        if (!(isReportViewer = Env.getContext(MLookup.this.m_info.ctx, MLookup.this.m_info.WindowNo, "_WinInfo_IsReportViewer").equals("Y"))) {
                                            MLookup.this.m_lookup.clear();
                                            return;
                                        }
                                    } else {
                                        if (MLookup.this.log.isLoggable(Level.FINE)) {
                                            MLookup.this.log.fine(MLookup.this.m_info.KeyColumn + ": Loader Validated: " + validation);
                                        }
                                        hasWhere = sql.indexOf(" WHERE ", posFrom = sql.lastIndexOf(" FROM ")) != -1;
                                        posOrder = sql.lastIndexOf(" ORDER BY ");
                                        if (posOrder != -1) {
                                            sql = new StringBuilder(sql.substring(0, posOrder)).append(hasWhere != false ? " AND " : " WHERE ").append(validation).append(sql.substring(posOrder));
                                        } else {
                                            sql.append(hasWhere != false ? " AND " : " WHERE ").append(validation);
                                        }
                                        if (CLogMgt.isLevelFinest() && MLookup.this.log.isLoggable(Level.FINE)) {
                                            MLookup.this.log.fine(MLookup.this.m_info.KeyColumn + ": Validation=" + validation);
                                        }
                                    }
                                }
                                if (Thread.interrupted()) {
                                    MLookup.this.log.log(Level.WARNING, MLookup.this.m_info.KeyColumn + ": Loader interrupted");
                                    return;
                                }
                                if (MLookup.this.log.isLoggable(Level.FINER)) {
                                    MLookup.this.log.finer(MLookup.this.m_info.Column_ID + ", " + MLookup.this.m_info.KeyColumn + ": " + sql.toString());
                                }
                                if (MLookup.this.log.isLoggable(Level.FINEST)) {
                                    MLookup.this.log.finest(MLookup.this.m_info.KeyColumn + ": " + String.valueOf(sql));
                                }
                                MLookup.this.m_lookup.clear();
                                isNumber = MLookup.this.m_info.KeyColumn.endsWith("_ID");
                                cacheKey = sql.toString();
                                knpCache = null;
                                vnpCache = null;
                                if (!isNumber) break block31;
                                knpCache = MLookup.getKeyNamePairCache(MLookup.this.m_info, cacheKey);
                                if (knpCache.size() <= 0) break block32;
                                if (!MLookup.this.m_refreshCache) break block33;
                                knpCache.clear();
                                break block32;
                            }
                            var10_13 = knpCache.iterator();
                            if (true) ** GOTO lbl135
                        }
                        vnpCache = MLookup.getValueNamePairCache(MLookup.this.m_info, cacheKey);
                        if (vnpCache.size() <= 0) break block32;
                        if (!MLookup.this.m_refreshCache) break block34;
                        vnpCache.clear();
                        break block32;
                    }
                    var10_14 = vnpCache.iterator();
                    if (true) ** GOTO lbl144
                }
                MLookup.this.m_hasInactive = false;
                rows = 0;
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql.toString(), null);
                        rs = pstmt.executeQuery();
                        MLookup.this.m_allLoaded = true;
                        while (rs.next()) {
                            if (rows++ > MAX_ROWS) {
                                s = new StringBuilder().append(MLookup.this.m_info.KeyColumn).append(": Loader - Too many records");
                                if (MLookup.this.m_info.Column_ID > 0) {
                                    mColumn = MColumn.get(MLookup.this.m_info.ctx, MLookup.this.m_info.Column_ID);
                                    column = mColumn.getColumnName();
                                    s.append(", Column=").append(column);
                                    tableName = MTable.getTableName(MLookup.this.m_info.ctx, mColumn.getAD_Table_ID());
                                    s.append(", Table=").append(tableName);
                                }
                                MLookup.this.log.warning(s.toString());
                            } else if (rows % 20 != 0 || !Thread.interrupted()) {
                                name = new StringBuilder().append(rs.getString(3));
                                isActive = rs.getString(4).equals("Y");
                                if (!isActive) {
                                    name.insert(0, "~").append("~");
                                    MLookup.this.m_hasInactive = true;
                                }
                                if (MLookup.this.isShortList() && !(isShortListItem = rs.getString(5).equals("Y"))) {
                                    name = new StringBuilder("*").append((CharSequence)name).append("*");
                                    MLookup.this.m_hasShortListItems = true;
                                }
                                if (isNumber) {
                                    key = rs.getInt(1);
                                    p /* !! */  = new KeyNamePair(key, name.toString());
                                    MLookup.this.m_lookup.put(key, p /* !! */ );
                                    knpCache.add(p /* !! */ );
                                    continue;
                                }
                                value = MLookup.this.m_info.KeyColumn.endsWith("_UU") != false ? rs.getString(1) : rs.getString(2);
                                p /* !! */  = new ValueNamePair(value, name.toString());
                                MLookup.this.m_lookup.put(value, p /* !! */ );
                                vnpCache.add((ValueNamePair)p /* !! */ );
                                continue;
                            }
                            break;
                        }
                    }
                    catch (SQLException e) {
                        MLookup.this.log.log(Level.SEVERE, MLookup.this.m_info.KeyColumn + ", " + MLookup.this.m_info.Column_ID + " : Loader - " + String.valueOf(sql), e);
                        MLookup.this.m_allLoaded = false;
                        DB.close(rs, pstmt);
                        break block30;
                    }
                }
                catch (Throwable var16_32) {
                    DB.close(rs, pstmt);
                    throw var16_32;
                }
                DB.close(rs, pstmt);
            }
            size = MLookup.this.m_lookup.size();
            if (MLookup.this.log.isLoggable(Level.FINER)) {
                MLookup.this.log.finer(MLookup.this.m_info.KeyColumn + " (" + MLookup.this.m_info.Column_ID + "): - Loader complete #" + size + " - all=" + MLookup.this.m_allLoaded + " - ms=" + String.valueOf(System.currentTimeMillis() - this.m_startTime) + " (" + String.valueOf(System.currentTimeMillis() - startTime) + ")");
            }
            return;
            do {
                knp = var10_13.next();
                MLookup.this.m_lookup.put(knp.getKey(), knp);
                name = knp.getName();
                if (!name.startsWith("~") || !name.endsWith("~")) continue;
                MLookup.this.m_hasInactive = true;
lbl135:
                // 3 sources

            } while (var10_13.hasNext());
            return;
            do {
                vnp = var10_14.next();
                MLookup.this.m_lookup.put(vnp.getValue(), vnp);
                name = vnp.getName();
                if (!name.startsWith("~") || !name.endsWith("~")) continue;
                MLookup.this.m_hasInactive = true;
lbl144:
                // 3 sources

            } while (var10_14.hasNext());
        }
    }
}

