/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.MSequence;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Trx;
import org.compiere.util.Util;

@Process
public class MigraID
extends SvrProcess {
    private int p_AD_Table_ID = -1;
    private int p_ID_From = -1;
    private int p_ID_To = -1;
    private String p_UUID_From = null;
    private String p_UUID_To = null;
    private MTable l_table = null;
    private String l_tableName = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if ("AD_Table_ID".equals(name)) {
                this.p_AD_Table_ID = para.getParameterAsInt();
            } else if ("Record_ID".equals(name)) {
                this.p_ID_From = para.getParameterAsInt();
            } else if ("To_Record_ID".equals(name)) {
                this.p_ID_To = para.getParameterAsInt();
            } else if ("Source_UUID".equals(name)) {
                this.p_UUID_From = para.getParameterAsString();
            } else if ("Target_UUID".equals(name)) {
                this.p_UUID_To = para.getParameterAsString();
            } else {
                MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_ID_From <= 0 && Util.isEmpty(this.p_UUID_From)) {
            throw new AdempiereUserError("Fill Record ID or UUID to convert");
        }
        if (this.p_ID_From > 0 && !Util.isEmpty(this.p_UUID_From)) {
            throw new AdempiereUserError("Record ID and UUID are excluyent, just one can be converted at the same time");
        }
        if (this.p_ID_From > 0 && this.p_ID_From == this.p_ID_To) {
            throw new AdempiereUserError("Same ID");
        }
        if (!Util.isEmpty(this.p_UUID_From) && this.p_UUID_From.equals(this.p_UUID_To)) {
            throw new AdempiereUserError("Same UUID");
        }
        this.l_table = MTable.get(this.getCtx(), this.p_AD_Table_ID, this.get_TrxName());
        this.l_tableName = this.l_table.getTableName();
        Object msg = "";
        if (!Util.isEmpty(this.p_UUID_From)) {
            StringBuilder updUUIDSB;
            int cnt;
            String uuidCol = PO.getUUIDColumnName(this.l_tableName);
            if (Util.isEmpty(this.p_UUID_To)) {
                this.p_UUID_To = UUID.randomUUID().toString();
            }
            if ((cnt = DB.executeUpdateEx((updUUIDSB = new StringBuilder().append("UPDATE ").append(this.l_tableName).append(" SET ").append(uuidCol).append("=?").append(" WHERE ").append(uuidCol).append("=?")).toString(), new Object[]{this.p_UUID_To, this.p_UUID_From}, this.get_TrxName())) <= 0) {
                msg = "@Error@: UUID " + this.p_UUID_From + " not found on table " + this.l_tableName;
            } else {
                int id = -1;
                msg = "UUID changed on table " + this.l_tableName + " from " + this.p_UUID_From + " to " + this.p_UUID_To;
                if (this.l_table.isIDKeyTable()) {
                    StringBuilder sqlSB = new StringBuilder().append("SELECT  ").append(this.l_tableName).append("_ID").append(" FROM ").append(this.l_tableName).append(" WHERE ").append(uuidCol).append("=?");
                    id = DB.getSQLValueEx(this.get_TrxName(), sqlSB.toString(), this.p_UUID_To);
                }
                this.addBufferLog(0, null, null, (String)msg, this.p_AD_Table_ID, id);
                msg = "@OK@";
                this.migrateChildren(false);
                this.migrateRecordUU();
                this.migrateMultiIDs();
                this.migratePackageUUIDMap();
            }
        } else {
            boolean seqCheck = false;
            String idCol = this.l_tableName + "_ID";
            if (this.p_ID_To <= 0) {
                this.p_ID_To = DB.getNextID(this.getAD_Client_ID(), this.l_tableName, this.get_TrxName());
            } else {
                StringBuilder sqlMaxSB = new StringBuilder().append("SELECT  MAX(").append(this.l_tableName).append("_ID)").append(" FROM ").append(this.l_tableName);
                int maxID = DB.getSQLValueEx(this.get_TrxName(), sqlMaxSB.toString(), new Object[0]);
                if (this.p_ID_To > maxID) {
                    seqCheck = true;
                }
            }
            int cnt = this.updID(this.l_tableName, idCol, true);
            if (cnt <= 0) {
                msg = "@Error@: ID " + this.p_ID_From + " not found on table " + this.l_tableName;
            } else {
                MSequence seq;
                msg = "ID changed on table " + this.l_tableName + " from " + this.p_ID_From + " to " + this.p_ID_To;
                this.addBufferLog(0, null, null, (String)msg, this.p_AD_Table_ID, this.p_ID_To);
                msg = "@OK@";
                this.migrateDirectReference();
                this.migrateChildren(true);
                this.migrateRecordID();
                this.migrateAD_Preference(idCol);
                this.migrateTrees();
                if ("C_DocType_ID".equals(idCol)) {
                    this.migrateAD_Preference("C_DocTypeTarget_ID");
                }
                this.migrateMultiIDs();
                if (seqCheck && (seq = MSequence.get(this.getCtx(), this.l_tableName, this.get_TrxName())) != null) {
                    seq.validateTableIDValue(this.get_TrxName());
                }
            }
        }
        Trx.get(this.get_TrxName(), false).commit(true);
        return msg;
    }

    private int updID(String tableName, String idCol, boolean idKey) {
        StringBuilder updIDSB = new StringBuilder().append("UPDATE ").append(tableName).append(" SET ").append(idCol).append("=?").append(" WHERE ").append(idCol).append("=?");
        int cnt = idKey ? DB.executeUpdateEx(updIDSB.toString(), new Object[]{this.p_ID_To, this.p_ID_From}, this.get_TrxName()) : DB.executeUpdateEx(updIDSB.toString(), new Object[]{this.p_UUID_To, this.p_UUID_From}, this.get_TrxName());
        return cnt;
    }

    private void migrateDirectReference() {
        List<List<Object>> rows;
        int refID = -1;
        switch (this.l_tableName) {
            case "C_Location": {
                refID = 21;
                break;
            }
            case "C_ValidCombination": {
                refID = 25;
                break;
            }
            case "M_Locator": {
                refID = 31;
                break;
            }
            case "M_AttributeSetInstance": {
                refID = 35;
                break;
            }
            case "S_ResourceAssignment": {
                refID = 33;
                break;
            }
            case "AD_Image": {
                refID = 32;
                break;
            }
            case "AD_Color": {
                refID = 27;
                break;
            }
            case "AD_Chart": {
                refID = 53370;
            }
        }
        if (refID > 0 && (rows = DB.getSQLArrayObjectsEx(this.get_TrxName(), "SELECT t.TableName, c.ColumnName FROM AD_Table t JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE t.IsView='N' AND t.IsActive='Y' AND c.IsActive='Y' AND c.ColumnSQL IS NULL AND c.AD_Reference_ID=? ORDER BY t.TableName, c.ColumnName", refID)) != null && rows.size() > 0) {
            for (List<Object> row : rows) {
                String columnRef;
                String tableRef = (String)row.get(0);
                int cnt = this.updID(tableRef, columnRef = (String)row.get(1), true);
                if (cnt <= 0) continue;
                String msg = cnt + " reference records updated in " + tableRef + "." + columnRef;
                this.addBufferLog(0, null, null, msg, 0, 0);
            }
        }
    }

    private void migrateChildren(boolean idKey) {
        String columnRef;
        String tableRef;
        int cnt;
        Object foreignColName;
        int tableRefId;
        int searchRefId;
        int tableDirRefId;
        if (idKey) {
            tableDirRefId = 19;
            searchRefId = 30;
            tableRefId = 18;
            foreignColName = this.l_tableName + "_ID";
        } else {
            tableDirRefId = 200234;
            searchRefId = 200235;
            tableRefId = 200233;
            foreignColName = PO.getUUIDColumnName(this.l_tableName);
        }
        List<List<Object>> rows = DB.getSQLArrayObjectsEx(this.get_TrxName(), "SELECT t.TableName, c.ColumnName FROM   AD_Table t, AD_Column c WHERE  t.AD_Table_ID = c.AD_Table_ID        AND t.IsActive = 'Y' AND t.IsView = 'N'        AND c.IsActive = 'Y' AND c.ColumnSql IS NULL        AND ( c.AD_Reference_ID=?               OR ( c.AD_Reference_ID=?                    AND c.AD_Reference_Value_ID IS NULL ) )        AND UPPER(c.ColumnName) = UPPER(?) UNION SELECT t.TableName, c.ColumnName FROM   AD_Table t, AD_Column c, AD_Ref_Table rt, AD_Table tr WHERE  t.AD_Table_ID = c.AD_Table_ID        AND t.IsActive = 'Y' AND t.IsView = 'N'        AND c.IsActive = 'Y' AND c.ColumnSql IS NULL        AND ( c.AD_Reference_ID=?               OR ( c.AD_Reference_ID=?                    AND c.AD_Reference_Value_ID IS NOT NULL ) )        AND c.AD_Reference_Value_ID = rt.AD_Reference_ID        AND rt.AD_Table_ID = tr.AD_Table_ID        AND UPPER(tr.TableName) = UPPER(?) ORDER  BY 1, 2", tableDirRefId, searchRefId, foreignColName, tableRefId, searchRefId, this.l_tableName);
        if (rows != null && rows.size() > 0) {
            for (List<Object> row : rows) {
                int cnt2;
                String tableRef2 = (String)row.get(0);
                String columnRef2 = (String)row.get(1);
                if ("EntityType".equals(columnRef2) || "AD_Language".equals(columnRef2) || (cnt2 = this.updID(tableRef2, columnRef2, idKey)) <= 0) continue;
                String msg = cnt2 + " children records updated in " + tableRef2 + "." + columnRef2;
                this.addBufferLog(0, null, null, msg, 0, 0);
            }
        }
        if (idKey && "AD_Org".equalsIgnoreCase(this.l_tableName) && (cnt = this.updID(tableRef = "C_BPartner", columnRef = "AD_OrgBP_ID", idKey)) > 0) {
            String msg = cnt + " children records updated in " + tableRef + "." + columnRef;
            this.addBufferLog(0, null, null, msg, 0, 0);
        }
    }

    private void migrateRecordID() {
        List tablesWithRecordID = new Query(this.getCtx(), "AD_Table", "IsView='N' AND IsActive='Y' AND EXISTS (SELECT 1 FROM AD_Column ct WHERE ct.AD_Table_ID=AD_Table.AD_Table_ID AND ct.ColumnName='AD_Table_ID' AND ct.ColumnSQL IS NULL AND ct.IsActive='Y') AND EXISTS (SELECT 1 FROM AD_Column cr WHERE cr.AD_Table_ID=AD_Table.AD_Table_ID AND cr.ColumnName='Record_ID'   AND cr.ColumnSQL IS NULL AND cr.IsActive='Y')", this.get_TrxName()).setOrderBy("TableName").list();
        for (MTable table2 : tablesWithRecordID) {
            String tableName = table2.getTableName();
            StringBuilder updRISB = new StringBuilder().append("UPDATE ").append(tableName).append(" SET Record_ID=?").append(" WHERE Record_ID=? AND AD_Table_ID=?");
            int cnt = DB.executeUpdateEx(updRISB.toString(), new Object[]{this.p_ID_To, this.p_ID_From, this.p_AD_Table_ID}, this.get_TrxName());
            if (cnt <= 0) continue;
            String msg = cnt + " weak reference records updated in " + tableName;
            this.addBufferLog(0, null, null, msg, 0, 0);
        }
    }

    private void migrateRecordUU() {
        List tablesWithRecordID = new Query(this.getCtx(), "AD_Table", "IsView='N' AND IsActive='Y' AND EXISTS (SELECT 1 FROM AD_Column ct WHERE ct.AD_Table_ID=AD_Table.AD_Table_ID AND ct.ColumnName='AD_Table_ID' AND ct.ColumnSQL IS NULL AND ct.IsActive='Y') AND EXISTS (SELECT 1 FROM AD_Column cr WHERE cr.AD_Table_ID=AD_Table.AD_Table_ID AND cr.ColumnName='Record_UU'   AND cr.ColumnSQL IS NULL AND cr.IsActive='Y')", this.get_TrxName()).setOrderBy("TableName").list();
        for (MTable table2 : tablesWithRecordID) {
            String tableName = table2.getTableName();
            StringBuilder updRISB = new StringBuilder().append("UPDATE ").append(tableName).append(" SET Record_UU=?").append(" WHERE Record_UU=? AND AD_Table_ID=?");
            int cnt = DB.executeUpdateEx(updRISB.toString(), new Object[]{this.p_UUID_To, this.p_UUID_From, this.p_AD_Table_ID}, this.get_TrxName());
            if (cnt <= 0) continue;
            String msg = cnt + " weak reference records updated in " + tableName;
            this.addBufferLog(0, null, null, msg, 0, 0);
        }
    }

    private void migrateAD_Preference(String columnName) {
        int cnt = DB.executeUpdateEx("UPDATE AD_Preference SET Value=? WHERE Value=? AND Attribute=?", new Object[]{String.valueOf(this.p_ID_To), String.valueOf(this.p_ID_From), columnName}, this.get_TrxName());
        if (cnt > 0) {
            String msg = cnt + " preference records updated in AD_Preference for " + columnName;
            this.addBufferLog(0, null, null, msg, 0, 0);
        }
    }

    private void migrateTrees() {
        switch (this.l_tableName) {
            case "AD_Menu": {
                this.migraTree("AD_TreeBar", "MM");
                this.migraTree("AD_TreeNodeMM", "MM");
                break;
            }
            case "C_BPartner": {
                this.migraTree("AD_TreeNodeBP", "BP");
                break;
            }
            case "CM_Container": {
                this.migraTree("AD_TreeNodeCMC", "CC");
                break;
            }
            case "CM_Media": {
                this.migraTree("AD_TreeNodeCMM", "CM");
                break;
            }
            case "CM_CStage": {
                this.migraTree("AD_TreeNodeCMS", "CS");
                break;
            }
            case "CM_Template": {
                this.migraTree("AD_TreeNodeCMT", "CT");
                break;
            }
            case "M_Product": {
                this.migraTree("AD_TreeNodePR", "PR");
                break;
            }
            case "C_ElementValue": {
                this.migraTree("AD_TreeNodeU1", "U1");
                this.migraTree("AD_TreeNodeU2", "U2");
                this.migraTree("AD_TreeNodeU3", "U3");
                this.migraTree("AD_TreeNodeU4", "U4");
                break;
            }
            case "AD_Org": {
                this.migraTree("AD_TreeNode", "OO");
                break;
            }
            case "M_Product_Category": {
                this.migraTree("AD_TreeNode", "PC");
                break;
            }
            case "M_BOM": {
                this.migraTree("AD_TreeNode", "BB");
                break;
            }
            case "C_Campaign": {
                this.migraTree("AD_TreeNode", "MC");
                break;
            }
            case "C_Project": {
                this.migraTree("AD_TreeNode", "PJ");
                break;
            }
            case "C_Activity": {
                this.migraTree("AD_TreeNode", "AY");
                break;
            }
            case "C_SalesRegion": {
                this.migraTree("AD_TreeNode", "SR");
                break;
            }
            case "AD_Tree_Favorite_Node": {
                this.migraFavTree();
            }
        }
        this.migraTree("AD_TreeNode", "TL");
    }

    private void migraTree(String menuTable, String treeType) {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("Node_ID");
        if (!"AD_TreeBar".equalsIgnoreCase(menuTable)) {
            columns.add("Parent_ID");
        }
        for (String col : columns) {
            StringBuilder sqlUpdTreeSB = new StringBuilder().append("UPDATE ").append(menuTable).append(" SET ").append(col).append("=? WHERE ").append(col).append("=? AND AD_Tree_ID IN (SELECT AD_Tree_ID FROM AD_Tree WHERE TreeType=?");
            if ("TL".equals(treeType)) {
                sqlUpdTreeSB.append(" AND AD_Table_ID=").append(this.p_AD_Table_ID);
            }
            sqlUpdTreeSB.append(")");
            int cnt = DB.executeUpdateEx(sqlUpdTreeSB.toString(), new Object[]{this.p_ID_To, this.p_ID_From, treeType}, this.get_TrxName());
            if (cnt <= 0) continue;
            String msg = cnt + " tree records updated in " + menuTable + "." + col;
            this.addBufferLog(0, null, null, msg, 0, 0);
        }
    }

    private void migraFavTree() {
        int cnt = DB.executeUpdateEx("UPDATE AD_Tree_Favorite_Node SET Parent_ID=? WHERE Parent_ID=?".toString(), new Object[]{this.p_ID_To, this.p_ID_From}, this.get_TrxName());
        if (cnt > 0) {
            String msg = cnt + " tree favourite records updated in AD_Tree_Favorite_Node.Parent_ID";
            this.addBufferLog(0, null, null, msg, 0, 0);
        }
    }

    private void migrateMultiIDs() {
        List<List<Object>> rows = DB.getSQLArrayObjectsEx(this.get_TrxName(), "SELECT t.TableName, c.ColumnName FROM   AD_Table t, AD_Column c, AD_Ref_Table rt, AD_Table tr WHERE  t.AD_Table_ID = c.AD_Table_ID        AND t.IsActive = 'Y' AND t.IsView = 'N'        AND c.IsActive = 'Y' AND c.ColumnSql IS NULL        AND c.AD_Reference_ID IN (?, ?)        AND c.AD_Reference_Value_ID = rt.AD_Reference_ID        AND rt.AD_Table_ID = tr.AD_Table_ID        AND UPPER(tr.TableName) = UPPER(?)UNION SELECT t.TableName, c.ColumnName FROM   AD_Table t, AD_Column c, AD_Field f, AD_Tab tb, AD_Table tr WHERE  t.AD_Table_ID = c.AD_Table_ID        AND t.IsActive = 'Y' AND t.IsView = 'N'        AND f.AD_Column_ID = c.AD_Column_ID        AND f.Included_Tab_ID = tb.AD_Tab_ID        AND tb.AD_Table_ID = tr.AD_Table_ID        AND c.IsActive = 'Y' AND c.ColumnSql IS NULL        AND c.AD_Reference_ID IN (?, ?)        AND UPPER(tr.TableName) = UPPER(?)ORDER  BY 1, 2", 200162, 200163, this.l_tableName, 200127, 200128, this.l_tableName);
        if (rows != null && rows.size() > 0) {
            boolean idKey = !this.l_table.isUUIDKeyTable();
            for (List<Object> row : rows) {
                String columnRef;
                String tableRef = (String)row.get(0);
                int cnt = this.updMultiID(tableRef, columnRef = (String)row.get(1), idKey);
                if (cnt <= 0) continue;
                String msg = cnt + " children records updated in multi-ID " + tableRef + "." + columnRef;
                this.addBufferLog(0, null, null, msg, 0, 0);
            }
        }
    }

    private int updMultiID(String tableRef, String columnRef, boolean idKey) {
        String idFrom;
        StringBuilder toReplace = new StringBuilder("(^|,)");
        StringBuilder replacement = new StringBuilder("\\1");
        if (idKey) {
            toReplace.append(this.p_ID_From);
            replacement.append(this.p_ID_To);
            idFrom = String.valueOf(this.p_ID_From);
        } else {
            toReplace.append(this.p_UUID_From);
            replacement.append(this.p_UUID_To);
            idFrom = this.p_UUID_From;
        }
        String matchIni = idFrom + ",%";
        String matchMid = "%," + idFrom + ",%";
        String matchEnd = "%," + idFrom;
        toReplace.append("($|,)");
        replacement.append("\\2");
        StringBuilder updMultiIDSB = new StringBuilder("UPDATE ").append(tableRef).append(" SET ").append(columnRef).append("=REGEXP_REPLACE(").append(columnRef).append(",?,?) WHERE ").append(columnRef).append("=?").append(" OR ").append(columnRef).append(" LIKE ?").append(" OR ").append(columnRef).append(" LIKE ?").append(" OR ").append(columnRef).append(" LIKE ?");
        int cnt = DB.executeUpdateEx(updMultiIDSB.toString(), new Object[]{toReplace.toString(), replacement.toString(), idFrom, matchIni, matchMid, matchEnd}, this.get_TrxName());
        return cnt;
    }

    private void migratePackageUUIDMap() {
        int cntTarget;
        int cntSource = DB.executeUpdateEx("UPDATE AD_Package_UUID_Map SET Source_UUID=? WHERE Source_UUID=?", new Object[]{this.p_UUID_To, this.p_UUID_From}, this.get_TrxName());
        if (cntSource > 0) {
            String msg = cntSource + " records updated in AD_Package_UUID_Map.Source_UUID";
            this.addBufferLog(0, null, null, msg, 0, 0);
        }
        if ((cntTarget = DB.executeUpdateEx("UPDATE AD_Package_UUID_Map SET Target_UUID=? WHERE Target_UUID=?", new Object[]{this.p_UUID_To, this.p_UUID_From}, this.get_TrxName())) > 0) {
            String msg = cntTarget + " records updated in AD_Package_UUID_Map.Target_UUID";
            this.addBufferLog(0, null, null, msg, 0, 0);
        }
    }
}

