/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttachment;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MConversionRate;
import org.compiere.model.MMailText;
import org.compiere.model.MNote;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRefList;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.MUserRoles;
import org.compiere.model.MWFActivityApprover;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_WF_Activity;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfo;
import org.compiere.process.StateEngine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trace;
import org.compiere.util.Trx;
import org.compiere.util.TrxEventListener;
import org.compiere.util.Util;
import org.compiere.wf.MWFEventAudit;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodePara;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWFResponsible;

public class MWFActivity
extends X_AD_WF_Activity
implements Runnable {
    private static final long serialVersionUID = -9119089506977887142L;
    private static final String CURRENT_WORKFLOW_PROCESS_INFO_ATTR = "Workflow.ProcessInfo";
    private StateEngine m_state = null;
    private MWFNode m_node = null;
    private MWFEventAudit m_audit = null;
    private PO m_po = null;
    private String m_docStatus = null;
    private String m_newValue = null;
    private MWFProcess m_process = null;
    private ArrayList<String> m_emails = new ArrayList();

    public static MWFActivity[] get(Properties ctx, int AD_Table_ID, int Record_ID, boolean activeOnly) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder("AD_Table_ID=? AND Record_ID=?");
        params.add(AD_Table_ID);
        params.add(Record_ID);
        if (activeOnly) {
            whereClause.append(" AND Processed<>?");
            params.add(true);
        }
        List<MWFActivity> list = new Query(ctx, "AD_WF_Activity", whereClause.toString(), null).setParameters(params).setOrderBy("AD_WF_Activity_ID").list();
        MWFActivity[] retValue = new MWFActivity[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static String getActiveInfo(Properties ctx, int AD_Table_ID, int Record_ID) {
        MWFActivity[] acts = MWFActivity.get(ctx, AD_Table_ID, Record_ID, true);
        if (acts == null || acts.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < acts.length) {
            if (i2 > 0) {
                sb.append("\n");
            }
            MWFActivity activity = acts[i2];
            sb.append(activity.toStringX());
            ++i2;
        }
        return sb.toString();
    }

    public MWFActivity(Properties ctx, String AD_WF_Activity_UU, String trxName) {
        super(ctx, AD_WF_Activity_UU, trxName);
        if (Util.isEmpty(AD_WF_Activity_UU)) {
            throw new IllegalArgumentException("Cannot create new WF Activity directly");
        }
        this.m_state = new StateEngine(this.getWFState());
    }

    public MWFActivity(Properties ctx, int AD_WF_Activity_ID, String trxName) {
        super(ctx, AD_WF_Activity_ID, trxName);
        if (AD_WF_Activity_ID == 0) {
            throw new IllegalArgumentException("Cannot create new WF Activity directly");
        }
        this.m_state = new StateEngine(this.getWFState());
    }

    public MWFActivity(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.m_state = new StateEngine(this.getWFState());
    }

    public MWFActivity(MWFProcess process, int AD_WF_Node_ID) {
        super(process.getCtx(), 0, process.get_TrxName());
        long limitMS;
        this.setAD_WF_Process_ID(process.getAD_WF_Process_ID());
        this.setPriority(process.getPriority());
        this.setAD_Table_ID(process.getAD_Table_ID());
        this.setRecord_ID(process.getRecord_ID());
        if (process.getPO() != null) {
            this.m_po = process.getPO();
        }
        this.setAD_Client_ID(process.getAD_Client_ID());
        this.setAD_Org_ID(process.getAD_Org_ID());
        super.setWFState("ON");
        this.m_state = new StateEngine(this.getWFState());
        this.setProcessed(false);
        this.setAD_Workflow_ID(process.getAD_Workflow_ID());
        this.setAD_WF_Node_ID(AD_WF_Node_ID);
        MWFNode node = MWFNode.get(this.getCtx(), AD_WF_Node_ID);
        int priority = node.getPriority();
        if (priority != 0 && priority != this.getPriority()) {
            this.setPriority(priority);
        }
        if ((limitMS = node.getLimitMS()) != 0L) {
            this.setEndWaitTime(new Timestamp(limitMS + System.currentTimeMillis()));
        }
        this.setResponsible(process);
        this.saveCrossTenantSafeEx();
        this.m_audit = new MWFEventAudit(this);
        this.m_audit.setAD_Org_ID(this.getAD_Org_ID());
        this.m_audit.saveEx();
        this.m_process = process;
    }

    public MWFActivity(MWFProcess process, Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.m_process = process;
    }

    public MWFActivity(MWFProcess process, int next_ID, PO lastPO) {
        this(process, next_ID);
        if (lastPO != null && lastPO.get_Table_ID() == this.getAD_Table_ID() && lastPO.get_ID() == this.getRecord_ID()) {
            this.m_po = lastPO;
        }
    }

    public StateEngine getState() {
        return this.m_state;
    }

    @Override
    public void setWFState(String WFState) {
        if (this.m_state == null) {
            this.m_state = new StateEngine(this.getWFState());
        }
        if (this.m_state.isClosed()) {
            return;
        }
        if (this.getWFState().equals(WFState)) {
            return;
        }
        if (this.m_state.isValidNewState(WFState)) {
            String oldState = this.getWFState();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(oldState + "->" + WFState + ", Msg=" + this.getTextMsg());
            }
            super.setWFState(WFState);
            this.m_state = new StateEngine(this.getWFState());
            boolean valid = this.save();
            if (!valid) {
                this.setAD_WF_Activity_ID(0);
                this.saveEx();
            }
            this.updateEventAudit();
            if (this.m_process == null) {
                this.m_process = new MWFProcess(this.getCtx(), this.getAD_WF_Process_ID(), this.get_TrxName());
            }
            this.m_process.checkActivities(this.get_TrxName(), this.m_po);
        } else {
            String msg = "Set WFState - Ignored Invalid Transformation - New=" + WFState + ", Current=" + this.getWFState();
            this.log.log(Level.SEVERE, msg);
            Trace.printStack();
            this.setTextMsg(msg);
            this.saveEx();
        }
    }

    public boolean isClosed() {
        return this.m_state.isClosed();
    }

    private void updateEventAudit() {
        this.getEventAudit();
        this.m_audit.setTextMsg(this.getTextMsg());
        this.m_audit.setWFState(this.getWFState());
        if (this.m_newValue != null) {
            this.m_audit.setNewValue(this.m_newValue);
        }
        if (this.m_state.isClosed()) {
            this.m_audit.setEventType("PX");
            long ms = System.currentTimeMillis() - this.m_audit.getCreated().getTime();
            this.m_audit.setElapsedTimeMS(new BigDecimal(ms));
        } else {
            this.m_audit.setEventType("SC");
        }
        boolean valid = this.m_audit.save();
        if (!valid) {
            this.m_audit.setAD_WF_EventAudit_ID(0);
            this.m_audit.saveEx();
        }
    }

    public MWFEventAudit getEventAudit() {
        if (this.m_audit != null) {
            return this.m_audit;
        }
        MWFEventAudit[] events = MWFEventAudit.get(this.getCtx(), this.getAD_WF_Process_ID(), this.getAD_WF_Node_ID(), this.get_TrxName());
        this.m_audit = events == null || events.length == 0 ? new MWFEventAudit(this) : events[events.length - 1];
        return this.m_audit;
    }

    public PO getPO(Trx trx) {
        if (this.m_po != null) {
            if (trx != null) {
                this.m_po.set_TrxName(trx.getTrxName());
            }
            return this.m_po;
        }
        MTable table2 = MTable.get(this.getCtx(), this.getAD_Table_ID());
        this.m_po = trx != null ? table2.getPO(this.getRecord_ID(), trx.getTrxName()) : table2.getPO(this.getRecord_ID(), null);
        return this.m_po;
    }

    public PO getPO() {
        return this.getPO(this.get_TrxName() != null ? Trx.get(this.get_TrxName(), false) : null);
    }

    public int getPO_AD_Client_ID() {
        if (this.m_po == null) {
            this.getPO(this.get_TrxName() != null ? Trx.get(this.get_TrxName(), false) : null);
        }
        if (this.m_po != null) {
            return this.m_po.getAD_Client_ID();
        }
        return 0;
    }

    public Object getAttributeValue() {
        MWFNode node = this.getNode();
        if (node == null) {
            return null;
        }
        int AD_Column_ID = node.getAD_Column_ID();
        if (AD_Column_ID == 0) {
            return null;
        }
        PO po = this.getPO();
        if (po.get_ID() == 0) {
            return null;
        }
        return po.get_ValueOfColumn(AD_Column_ID);
    }

    public boolean isSOTrx() {
        PO po = this.getPO();
        if (po.get_ID() == 0) {
            return true;
        }
        int index = po.get_ColumnIndex("IsSOTrx");
        if (index < 0) {
            return !po.get_TableName().startsWith("M_");
        }
        try {
            Boolean IsSOTrx = (Boolean)po.get_Value(index);
            return IsSOTrx;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            return true;
        }
    }

    @Override
    public void setAD_WF_Node_ID(int AD_WF_Node_ID) {
        if (AD_WF_Node_ID == 0) {
            throw new IllegalArgumentException("Workflow Node is not defined");
        }
        super.setAD_WF_Node_ID(AD_WF_Node_ID);
        if (!"ON".equals(this.getWFState())) {
            super.setWFState("ON");
            this.m_state = new StateEngine(this.getWFState());
        }
        if (this.isProcessed()) {
            this.setProcessed(false);
        }
    }

    public MWFNode getNode() {
        if (this.m_node == null) {
            this.m_node = MWFNode.getCopy(this.getCtx(), this.getAD_WF_Node_ID(), this.get_TrxName());
        }
        return this.m_node;
    }

    public String getNodeName() {
        return this.getNode().getName(true);
    }

    public String getNodeDescription() {
        return this.getNode().getDescription(true);
    }

    public String getNodeHelp() {
        return this.getNode().getHelp(true);
    }

    public boolean isUserApproval() {
        return this.getNode().isUserApproval();
    }

    public boolean isUserManual() {
        return this.getNode().isUserManual();
    }

    public boolean isUserChoice() {
        return this.getNode().isUserChoice();
    }

    @Override
    public void setTextMsg(String TextMsg) {
        if (TextMsg == null || TextMsg.length() == 0) {
            return;
        }
        String oldText = this.getTextMsg();
        if (oldText == null || oldText.length() == 0) {
            super.setTextMsg(Util.trimSize(TextMsg, 1000));
        } else if (TextMsg != null && TextMsg.length() > 0) {
            super.setTextMsg(Util.trimSize(oldText + "\n - " + TextMsg, 1000));
        }
    }

    public void addTextMsg(Object obj) {
        if (obj == null) {
            return;
        }
        StringBuilder TextMsg = new StringBuilder();
        if (obj instanceof Exception) {
            Exception ex = (Exception)obj;
            if (ex.getMessage() != null && ex.getMessage().trim().length() > 0) {
                TextMsg.append(ex.toString());
            } else if (ex instanceof NullPointerException) {
                TextMsg.append(ex.getClass().getName());
            }
            while (ex != null) {
                StackTraceElement[] st = ex.getStackTrace();
                int i2 = 0;
                while (i2 < st.length) {
                    StackTraceElement ste = st[i2];
                    if (i2 == 0 || ste.getClassName().startsWith("org.compiere") || ste.getClassName().startsWith("org.adempiere")) {
                        TextMsg.append(" (").append(i2).append("): ").append(ste.toString()).append("\n");
                    }
                    ++i2;
                }
                ex = ex.getCause() instanceof Exception ? (Exception)ex.getCause() : null;
            }
        } else {
            TextMsg.append(obj.toString());
        }
        String oldText = this.getTextMsg();
        if (oldText == null || oldText.length() == 0) {
            super.setTextMsg(Util.trimSize(TextMsg.toString(), 1000));
        } else if (TextMsg != null && TextMsg.length() > 0) {
            super.setTextMsg(Util.trimSize(oldText + "\n - " + TextMsg.toString(), 1000));
        }
    }

    public String getWFStateText() {
        return MRefList.getListName(this.getCtx(), 305, this.getWFState());
    }

    private void setResponsible(MWFProcess process) {
        int AD_WF_Responsible_ID = this.getNode().getAD_WF_Responsible_ID();
        if (AD_WF_Responsible_ID == 0) {
            AD_WF_Responsible_ID = process.getAD_WF_Responsible_ID();
        }
        this.setAD_WF_Responsible_ID(AD_WF_Responsible_ID);
        MWFResponsible resp = this.getResponsible();
        int AD_User_ID = resp.getAD_User_ID();
        if (AD_User_ID == 0 && resp.isInvoker()) {
            AD_User_ID = process.getAD_User_ID();
        }
        this.setAD_User_ID(AD_User_ID);
    }

    public MWFResponsible getResponsible() {
        MWFResponsible resp = MWFResponsible.getCopy(this.getCtx(), this.getAD_WF_Responsible_ID(), this.get_TrxName());
        return resp;
    }

    public boolean isInvoker() {
        return this.getResponsible().isInvoker();
    }

    public int getApprovalUser(int AD_User_ID, int C_Currency_ID, BigDecimal amount, int AD_Org_ID, boolean ownDocument) {
        if (amount == null || amount.signum() == 0) {
            return AD_User_ID;
        }
        MUser user = MUser.get(this.getCtx(), AD_User_ID);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("For User=" + String.valueOf(user) + ", Amt=" + String.valueOf(amount) + ", Own=" + ownDocument);
        }
        MUser oldUser = null;
        while (user != null) {
            if (user.equals(oldUser)) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Loop - " + user.getName());
                }
                user = null;
                break;
            }
            oldUser = user;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("User=" + user.getName());
            }
            MRole[] roles = user.getRoles(AD_Org_ID);
            int i2 = 0;
            while (i2 < roles.length) {
                BigDecimal roleAmt;
                MRole role = roles[i2];
                if ((!ownDocument || role.isCanApproveOwnDoc()) && (roleAmt = role.getAmtApproval()) != null && roleAmt.signum() != 0 && (C_Currency_ID == role.getC_Currency_ID() || role.getC_Currency_ID() == 0 || (roleAmt = MConversionRate.convert(this.getCtx(), roleAmt, role.getC_Currency_ID(), C_Currency_ID, this.getAD_Client_ID(), AD_Org_ID)) != null && roleAmt.signum() != 0)) {
                    boolean approved;
                    boolean bl = approved = amount.compareTo(roleAmt) <= 0;
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Approved=" + approved + " - User=" + user.getName() + ", Role=" + role.getName() + ", ApprovalAmt=" + String.valueOf(roleAmt));
                    }
                    if (approved) {
                        BigDecimal roleAmtAcc = role.getAmtApprovalAccum();
                        Integer daysAmtAcc = role.getDaysApprovalAccum();
                        if (roleAmtAcc != null && roleAmtAcc.signum() > 0 && daysAmtAcc != null && daysAmtAcc > 0) {
                            BigDecimal amtApprovedAccum = this.getAmtAccum(this.m_po, daysAmtAcc, user.getAD_User_ID());
                            boolean bl2 = approved = (amtApprovedAccum = amtApprovedAccum.add(amount)).compareTo(roleAmtAcc) <= 0;
                            if (this.log.isLoggable(Level.INFO)) {
                                this.log.info("ApprovedAccum=" + approved + " - User=" + user.getName() + ", Role=" + role.getName() + ", ApprovalAmtAccum=" + String.valueOf(roleAmtAcc) + ", AccumDocsApproved=" + String.valueOf(amtApprovedAccum) + " in past " + daysAmtAcc + " days");
                            }
                        }
                    }
                    if (approved) {
                        return user.getAD_User_ID();
                    }
                }
                ++i2;
            }
            if (user.getSupervisor_ID() != 0) {
                user = MUser.get(this.getCtx(), user.getSupervisor_ID());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Supervisor: " + user.getName());
                }
            } else {
                MOrg org;
                MOrgInfo orgInfo;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("No Supervisor");
                }
                if ((orgInfo = (org = MOrg.get(this.getCtx(), AD_Org_ID)).getInfo()).getSupervisor_ID() != 0) {
                    user = MUser.get(this.getCtx(), orgInfo.getSupervisor_ID());
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Org=" + org.getName() + ",Supervisor: " + user.getName());
                    }
                } else {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("No Org Supervisor");
                    }
                    if (orgInfo.getParent_Org_ID() != 0 && (orgInfo = (org = MOrg.get(this.getCtx(), orgInfo.getParent_Org_ID())).getInfo()).getSupervisor_ID() != 0) {
                        user = MUser.get(this.getCtx(), orgInfo.getSupervisor_ID());
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Parent Org Supervisor: " + user.getName());
                        }
                    }
                }
            }
            ownDocument = false;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("No user found");
        }
        return -1;
    }

    private BigDecimal getAmtAccum(PO po, int days, int userid) {
        BigDecimal amtaccum;
        block9: {
            amtaccum = Env.ZERO;
            String tablename = po.get_TableName();
            MTable tablepo = MTable.get(this.getCtx(), po.get_Table_ID());
            Object checkSameSO = "";
            if (po.get_ColumnIndex("IsSOTrx") > 0) {
                checkSameSO = " AND doc.IsSOTrx='" + ((Boolean)po.get_Value("IsSOTrx") != false ? "Y" : "N") + "'";
            }
            Object checkSameReceipt = "";
            if (po.get_ColumnIndex("IsReceipt") > 0) {
                checkSameReceipt = " AND doc.IsReceipt='" + ((Boolean)po.get_Value("IsReceipt") != false ? "Y" : "N") + "'";
            }
            String checkDocAction = "";
            if (po.get_ColumnIndex("DocStatus") > 0) {
                checkDocAction = " AND DocStatus IN ('CO','CL')";
            }
            String sql = "SELECT DISTINCT doc." + tablename + "_ID  FROM  " + tablename + " doc,        AD_WF_Activity a,        AD_WF_Node n,        AD_Column c  WHERE a.AD_WF_Node_ID = n.AD_WF_Node_ID        AND n.AD_Column_ID = c.AD_Column_ID        AND a.AD_Table_ID = " + po.get_Table_ID() + "       AND a.Record_ID = doc." + tablename + "_ID        AND a.Record_ID != " + po.get_ID() + "       AND c.ColumnName = 'IsApproved'        AND n.Action = 'C'        AND a.WFState = 'CC'        AND a.UpdatedBy = " + userid + "       AND a.Updated > Trunc(getDate()) - " + (days - 1) + (String)checkSameSO + (String)checkSameReceipt + checkDocAction;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int doc_id = rs.getInt(1);
                        PO doc = tablepo.getPO(doc_id, this.get_TrxName());
                        BigDecimal docamt = ((DocAction)((Object)doc)).getApprovalAmt();
                        if (docamt == null) continue;
                        amtaccum = amtaccum.add(docamt);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return amtaccum;
    }

    @Override
    public void run() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Node=" + String.valueOf(this.getNode()));
        }
        this.m_newValue = null;
        Trx trx = null;
        boolean localTrx = false;
        if (this.get_TrxName() == null) {
            this.set_TrxName(Trx.createTrxName("WFA"));
            localTrx = true;
        }
        trx = Trx.get(this.get_TrxName(), true);
        if (localTrx) {
            trx.setDisplayName(this.getClass().getName() + "_run");
        }
        Savepoint savepoint = null;
        try {
            if (this.m_process.getProcessInfo() != null) {
                Env.getCtx().put(CURRENT_WORKFLOW_PROCESS_INFO_ATTR, this.m_process.getProcessInfo());
            }
            if (!localTrx && (savepoint = trx.getLastWFSavepoint()) == null) {
                savepoint = trx.setSavepoint(null);
                trx.setLastWFSavepoint(savepoint);
            }
            if (!this.m_state.isValidAction("Start")) {
                this.setTextMsg("State=" + this.getWFState() + " - cannot start");
                this.addTextMsg(new Exception(""));
                this.setWFState("CT");
                return;
            }
            this.setWFState("OR");
            if (this.getNode().get_ID() == 0) {
                this.setTextMsg("Node not found - AD_WF_Node_ID=" + this.getAD_WF_Node_ID());
                this.setWFState("CA");
                return;
            }
            try {
                boolean done = this.performWork(Trx.get(this.get_TrxName(), false));
                if (localTrx) {
                    try {
                        trx.commit(true);
                    }
                    catch (Exception e) {
                        if (this.m_docStatus != null) {
                            this.m_docStatus = "IN";
                        }
                        throw e;
                    }
                }
                this.setWFState(done ? "CC" : "OS");
            }
            catch (Exception e) {
                String processMsg;
                this.log.log(Level.WARNING, String.valueOf(this.getNode()), e);
                if (localTrx) {
                    trx.rollback();
                } else if (savepoint != null) {
                    try {
                        trx.rollback(savepoint);
                        trx.setLastWFSavepoint(null);
                    }
                    catch (SQLException sQLException) {}
                }
                if (e.getCause() != null) {
                    this.log.log(Level.WARNING, "Cause", e.getCause());
                }
                if ((processMsg = e.getLocalizedMessage()) == null || processMsg.length() == 0) {
                    processMsg = e.getMessage();
                }
                this.setTextMsg(processMsg);
                boolean contextLost = false;
                if (e instanceof AdempiereException && "Context lost".equals(e.getMessage())) {
                    contextLost = true;
                    this.m_docStatus = "IN";
                }
                try {
                    if (contextLost) {
                        Env.getCtx().setProperty("#AD_Client_ID", this.m_po != null ? Integer.toString(this.m_po.getAD_Client_ID()) : "0");
                        this.m_state = new StateEngine("OR");
                        this.setProcessed(true);
                        this.setWFState("CA");
                    } else {
                        this.setWFState("CT");
                    }
                    if (this.m_po != null && this.m_po instanceof DocAction && this.m_docStatus != null) {
                        this.m_po.load(this.get_TrxName(), new String[0]);
                        DocAction doc = (DocAction)((Object)this.m_po);
                        doc.setDocStatus(this.m_docStatus);
                        this.m_po.saveEx();
                    }
                    if (this.m_process != null) {
                        this.m_process.setProcessMsg(this.getTextMsg());
                        try {
                            this.m_process.saveEx();
                        }
                        catch (Exception ex) {
                            this.log.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                }
                finally {
                    if (contextLost) {
                        Env.getCtx().remove("#AD_Client_ID");
                    }
                }
            }
        }
        finally {
            if (localTrx && trx != null) {
                trx.close();
            }
            Env.getCtx().remove(CURRENT_WORKFLOW_PROCESS_INFO_ATTR);
        }
    }

    public static ProcessInfo getCurrentWorkflowProcessInfo() {
        Object o = Env.getCtx().get(CURRENT_WORKFLOW_PROCESS_INFO_ATTR);
        if (o != null && o instanceof ProcessInfo) {
            return (ProcessInfo)o;
        }
        return null;
    }

    private boolean performWork(Trx trx) throws Exception {
        String action;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(this.m_node) + " [" + (trx != null ? trx.getTrxName() : "") + "]");
        }
        this.m_docStatus = null;
        if (this.m_node.getPriority() != 0) {
            this.setPriority(this.m_node.getPriority());
        }
        if ("Z".equals(action = this.m_node.getAction())) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Sleep:WaitTime=" + this.m_node.getWaitTime());
            }
            if (this.m_node.getWaitTime() == 0) {
                return true;
            }
            Calendar cal = Calendar.getInstance();
            cal.add(12, this.m_node.getWaitTime());
            this.setEndWaitTime(new Timestamp(cal.getTimeInMillis()));
            if (this.m_node.getWaitTime() == -1) {
                this.prepareCommitEvent();
            }
            return false;
        }
        if ("D".equals(action)) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("DocumentAction=" + this.m_node.getDocAction());
            }
            this.getPO(trx);
            if (this.m_po == null) {
                throw new Exception("Persistent Object not found - AD_Table_ID=" + this.getAD_Table_ID() + ", Record_ID=" + this.getRecord_ID());
            }
            boolean success = false;
            Object processMsg = null;
            DocAction doc = null;
            if (this.m_po instanceof DocAction) {
                doc = (DocAction)((Object)this.m_po);
                try {
                    success = doc.processIt(this.m_node.getDocAction());
                    this.setTextMsg(doc.getSummary());
                    processMsg = doc.getProcessMsg();
                    if ("PR".equals(this.m_node.getDocAction()) || "CO".equals(this.m_node.getDocAction()) || success) {
                        this.m_docStatus = doc.getDocStatus();
                    }
                }
                catch (Exception e) {
                    if (this.m_process != null) {
                        this.m_process.setProcessMsg(e.getLocalizedMessage());
                    }
                    throw e;
                }
                if (this.m_process != null) {
                    this.m_process.setProcessMsg((String)processMsg);
                }
            } else {
                throw new IllegalStateException("Persistent Object not DocAction - " + this.m_po.getClass().getName() + " - AD_Table_ID=" + this.getAD_Table_ID() + ", Record_ID=" + this.getRecord_ID());
            }
            if (!this.m_po.save()) {
                success = false;
                this.m_docStatus = null;
                processMsg = "SaveError";
            }
            if (!success) {
                if (processMsg == null || ((String)processMsg).length() == 0) {
                    processMsg = "PerformWork Error - " + this.m_node.toStringX();
                    if (doc != null) {
                        processMsg = (String)processMsg + " - DocStatus=" + doc.getDocStatus();
                    }
                }
                throw new Exception((String)processMsg);
            }
            return success;
        }
        if ("R".equals(action)) {
            MProcess process;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Report:AD_Process_ID=" + this.m_node.getAD_Process_ID());
            }
            if (!(process = MProcess.getCopy(this.getCtx(), this.m_node.getAD_Process_ID(), trx != null ? trx.getTrxName() : null)).isReport() || process.getAD_ReportView_ID() == 0) {
                throw new IllegalStateException("Not a Report AD_Process_ID=" + this.m_node.getAD_Process_ID());
            }
            ProcessInfo pi = new ProcessInfo(this.m_node.getName(true), this.m_node.getAD_Process_ID(), this.getAD_Table_ID(), this.getRecord_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setAD_Client_ID(this.getAD_Client_ID());
            MPInstance pInstance = new MPInstance(this.getCtx(), process.getAD_Process_ID(), this.getAD_Table_ID(), this.getRecord_ID(), null);
            pInstance.saveEx();
            this.fillParameter(pInstance, trx);
            pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
            ReportEngine re = ReportEngine.get(this.getCtx(), pi);
            if (re == null) {
                throw new IllegalStateException("Cannot create Report AD_Process_ID=" + this.m_node.getAD_Process_ID());
            }
            File report = re.getPDF();
            int AD_Message_ID = 753;
            MNote note = new MNote(this.getCtx(), AD_Message_ID, this.getAD_User_ID(), trx.getTrxName());
            note.setTextMsg(this.m_node.getName(true));
            note.setDescription(this.m_node.getDescription(true));
            note.setRecord(this.getAD_Table_ID(), this.getRecord_ID());
            note.saveEx();
            MAttachment attachment = new MAttachment(this.getCtx(), 389, note.getAD_Note_ID(), note.getAD_Note_UU(), this.get_TrxName());
            attachment.addEntry(report);
            attachment.setTextMsg(this.m_node.getName(true));
            attachment.saveEx();
            return true;
        }
        if ("P".equals(action)) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Process:AD_Process_ID=" + this.m_node.getAD_Process_ID());
            }
            MProcess process = MProcess.get(this.getCtx(), this.m_node.getAD_Process_ID());
            MPInstance pInstance = new MPInstance(this.getCtx(), process.getAD_Process_ID(), this.getAD_Table_ID(), this.getRecord_ID(), null);
            pInstance.setIsProcessing(true);
            pInstance.saveEx();
            try {
                MWFNodePara[] nParams;
                this.fillParameter(pInstance, trx);
                ProcessInfo pi = new ProcessInfo(this.m_node.getName(true), this.m_node.getAD_Process_ID(), this.getAD_Table_ID(), this.getRecord_ID());
                MWFNodePara[] mWFNodeParaArray = nParams = this.m_node.getParameters();
                int n = nParams.length;
                int n2 = 0;
                while (n2 < n) {
                    MWFNodePara p2 = mWFNodeParaArray[n2];
                    if (p2.getAD_Process_Para_ID() == 0 && p2.getAttributeName().equalsIgnoreCase("Record_ID") && !Util.isEmpty(p2.getAttributeValue(), true)) {
                        try {
                            Object value = this.parseNodeParaAttribute(p2);
                            if (value == p2 || value == null) break;
                            int recordId = Integer.valueOf(value.toString());
                            pi.setRecord_ID(recordId);
                        }
                        catch (NumberFormatException e) {
                            this.log.log(Level.WARNING, e.getMessage(), e);
                        }
                        break;
                    }
                    ++n2;
                }
                pi.setAD_User_ID(this.getAD_User_ID());
                pi.setAD_Client_ID(this.getAD_Client_ID());
                pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
                boolean success = process.processItWithoutTrxClose(pi, trx);
                this.setTextMsg(pi.getSummary());
                boolean bl = success;
                return bl;
            }
            finally {
                pInstance.setIsProcessing(false);
                pInstance.saveEx();
            }
        }
        if ("M".equals(action)) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("EMail:EMailRecipient=" + this.m_node.getEMailRecipient());
            }
            this.getPO(trx);
            if (this.m_po == null) {
                throw new Exception("Persistent Object not found - AD_Table_ID=" + this.getAD_Table_ID() + ", Record_ID=" + this.getRecord_ID());
            }
            if (this.m_po instanceof DocAction) {
                this.m_emails = new ArrayList();
                this.sendEMail();
                this.setTextMsg(this.m_emails.toString());
            } else {
                MClient client = MClient.get(this.getCtx(), this.getAD_Client_ID());
                MMailText mailtext = new MMailText(this.getCtx(), this.getNode().getR_MailText_ID(), null);
                mailtext.setPO(this.m_po);
                String subject = this.getNode().getDescription() + ": " + mailtext.getMailHeader();
                String message = mailtext.getMailText(true) + "\n-----\n" + this.getNodeHelp();
                String to = this.getNode().getEMail();
                client.sendEMail(to, subject, message, null);
            }
            return true;
        }
        if ("V".equals(action)) {
            String value = this.m_node.getAttributeValue();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("SetVariable:AD_Column_ID=" + this.m_node.getAD_Column_ID() + " to " + value);
            }
            MColumn column = this.m_node.getColumn();
            int dt = column.getAD_Reference_ID();
            return this.setVariable(value, dt, null, trx);
        }
        if ("F".equals(action)) {
            this.log.warning("Workflow:AD_Workflow_ID=" + this.m_node.getAD_Workflow_ID());
            this.log.warning("Start WF Instance is not implemented yet");
        } else {
            if ("C".equals(action)) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("UserChoice:AD_Column_ID=" + this.m_node.getAD_Column_ID());
                }
                if (this.m_node.isUserApproval() && this.getPO(trx) instanceof DocAction) {
                    DocAction doc = (DocAction)((Object)this.m_po);
                    boolean autoApproval = false;
                    if (this.isInvoker()) {
                        int nextAD_User_ID;
                        int startAD_User_ID = Env.getAD_User_ID(this.getCtx());
                        if (startAD_User_ID == 0) {
                            startAD_User_ID = doc.getDoc_User_ID();
                        }
                        if ((nextAD_User_ID = this.getApprovalUser(startAD_User_ID, doc.getC_Currency_ID(), doc.getApprovalAmt(), doc.getAD_Org_ID(), startAD_User_ID == doc.getDoc_User_ID())) <= 0) {
                            this.m_docStatus = "IN";
                            throw new AdempiereException(Msg.getMsg(this.getCtx(), "NoApprover"));
                        }
                        boolean bl = autoApproval = startAD_User_ID == nextAD_User_ID;
                        if (!autoApproval) {
                            this.setAD_User_ID(nextAD_User_ID);
                        }
                    } else {
                        MWFResponsible resp = this.getResponsible();
                        if (resp.isHuman()) {
                            boolean bl = autoApproval = resp.getAD_User_ID() == Env.getAD_User_ID(this.getCtx());
                            if (!autoApproval && resp.getAD_User_ID() != 0) {
                                this.setAD_User_ID(resp.getAD_User_ID());
                            }
                        } else if (resp.isRole()) {
                            MUserRoles[] urs = MUserRoles.getOfRole(this.getCtx(), resp.getAD_Role_ID());
                            int i2 = 0;
                            while (i2 < urs.length) {
                                if (urs[i2].getAD_User_ID() == Env.getAD_User_ID(this.getCtx()) && urs[i2].isActive()) {
                                    autoApproval = true;
                                    break;
                                }
                                ++i2;
                            }
                        } else if (resp.isManual()) {
                            MWFActivityApprover[] approvers = MWFActivityApprover.getOfActivity(this.getCtx(), this.getAD_WF_Activity_ID(), this.get_TrxName());
                            int i3 = 0;
                            while (i3 < approvers.length) {
                                if (approvers[i3].getAD_User_ID() == Env.getAD_User_ID(this.getCtx())) {
                                    autoApproval = true;
                                    break;
                                }
                                ++i3;
                            }
                        } else {
                            if (resp.isOrganization()) {
                                throw new AdempiereException("Support not implemented for " + String.valueOf(resp));
                            }
                            throw new AdempiereException("@NotSupported@ " + String.valueOf(resp));
                        }
                    }
                    if (autoApproval && doc.processIt("AP") && doc.save()) {
                        return true;
                    }
                }
                return false;
            }
            if ("X".equals(action)) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Form:AD_Form_ID=" + this.m_node.getAD_Form_ID());
                }
                return false;
            }
            if ("W".equals(action)) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Window:AD_Window_ID=" + this.m_node.getAD_Window_ID());
                }
                return false;
            }
            if ("I".equals(action)) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("InfoWindow:AD_InfoWindow_ID=" + this.m_node.getAD_InfoWindow_ID());
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid Action (Not Implemented) =" + action);
    }

    private boolean setVariable(String value, int displayType, String textMsg, Trx trx) throws Exception {
        this.m_newValue = null;
        this.getPO(trx);
        if (this.m_po == null) {
            throw new Exception("Persistent Object not found - AD_Table_ID=" + this.getAD_Table_ID() + ", Record_ID=" + this.getRecord_ID());
        }
        Object dbValue = null;
        if (value != null) {
            if (displayType == 20) {
                dbValue = "Y".equals(value);
            } else if (DisplayType.isNumeric(displayType)) {
                dbValue = new BigDecimal(value);
            } else if (DisplayType.isID(displayType)) {
                MColumn column = MColumn.get(Env.getCtx(), this.getNode().getAD_Column_ID());
                String referenceTableName = column.getReferenceTableName();
                if (referenceTableName != null) {
                    MTable refTable = MTable.get(Env.getCtx(), referenceTableName);
                    dbValue = Integer.valueOf(value);
                    boolean validValue = true;
                    PO po = refTable.getPO((Integer)dbValue, trx.getTrxName());
                    if (po == null || po.get_ID() == 0) {
                        validValue = false;
                    }
                    if (validValue && po.getAD_Client_ID() != Env.getAD_Client_ID(Env.getCtx())) {
                        String accessLevel;
                        validValue = false;
                        if (po.getAD_Client_ID() == 0 && ("7".equals(accessLevel = refTable.getAccessLevel()) || "6".equals(accessLevel))) {
                            validValue = true;
                        }
                    }
                    if (!validValue) {
                        throw new Exception("Persistent Object not updated - AD_Table_ID=" + this.getAD_Table_ID() + ", Record_ID=" + this.getRecord_ID() + " - Value=" + value + " is not valid for a foreign key");
                    }
                }
            } else {
                dbValue = value;
            }
        }
        if (!this.m_po.set_ValueOfColumnReturningBoolean(this.getNode().getAD_Column_ID(), dbValue)) {
            throw new Exception("Persistent Object not updated - AD_Table_ID=" + this.getAD_Table_ID() + ", Record_ID=" + this.getRecord_ID() + " - Value=" + value + " error : " + CLogger.retrieveErrorString("check logs"));
        }
        this.m_po.saveEx();
        if (dbValue != null && !dbValue.equals(this.m_po.get_ValueOfColumn(this.getNode().getAD_Column_ID()))) {
            throw new Exception("Persistent Object not updated - AD_Table_ID=" + this.getAD_Table_ID() + ", Record_ID=" + this.getRecord_ID() + " - Should=" + value + ", Is=" + String.valueOf(this.m_po.get_ValueOfColumn(this.m_node.getAD_Column_ID())));
        }
        String msg = this.getNode().getAttributeName() + "=" + value;
        if (textMsg != null && textMsg.length() > 0) {
            msg = msg + " - " + textMsg;
        }
        this.setTextMsg(msg);
        this.m_newValue = value;
        return true;
    }

    public boolean setUserChoice(int AD_User_ID, String value, int displayType, String textMsg) throws Exception {
        this.setWFState("OR");
        this.setAD_User_ID(AD_User_ID);
        Trx trx = this.get_TrxName() != null ? Trx.get(this.get_TrxName(), false) : null;
        boolean ok = this.setVariable(value, displayType, textMsg, trx);
        if (!ok) {
            return false;
        }
        String newState = "CC";
        if (this.getNode().isUserApproval() && this.getPO(trx) instanceof DocAction) {
            DocAction doc = (DocAction)((Object)this.m_po);
            try {
                if (!"Y".equals(value)) {
                    newState = "CA";
                    if (!doc.processIt("RJ")) {
                        this.setTextMsg("Cannot Reject - Document Status: " + doc.getDocStatus());
                    }
                } else if (this.isInvoker()) {
                    int nextAD_User_ID;
                    int startAD_User_ID = Env.getAD_User_ID(this.getCtx());
                    if (startAD_User_ID == 0) {
                        startAD_User_ID = doc.getDoc_User_ID();
                    }
                    if ((nextAD_User_ID = this.getApprovalUser(startAD_User_ID, doc.getC_Currency_ID(), doc.getApprovalAmt(), doc.getAD_Org_ID(), startAD_User_ID == doc.getDoc_User_ID())) <= 0) {
                        newState = "CA";
                        this.setTextMsg(Msg.getMsg(this.getCtx(), "NoApprover"));
                        doc.processIt("RJ");
                    } else if (startAD_User_ID != nextAD_User_ID) {
                        this.forwardTo(nextAD_User_ID, "Next Approver");
                        newState = "OS";
                    } else if (!doc.processIt("AP")) {
                        newState = "CA";
                        this.setTextMsg("Cannot Approve - Document Status: " + doc.getDocStatus());
                    }
                } else if (!doc.processIt("AP")) {
                    newState = "CA";
                    this.setTextMsg("Cannot Approve - Document Status: " + doc.getDocStatus());
                }
                doc.saveEx();
            }
            catch (Exception e) {
                newState = "CT";
                this.setTextMsg("User Choice: " + e.toString());
                this.addTextMsg(e);
                this.log.log(Level.WARNING, "", e);
            }
            if (newState.equals("CA")) {
                MUser to = new MUser(this.getCtx(), doc.getDoc_User_ID(), null);
                if (to.isNotificationEMail()) {
                    MClient client = MClient.get(this.getCtx(), doc.getAD_Client_ID());
                    client.sendEMail(doc.getDoc_User_ID(), Msg.getMsg(this.getCtx(), "NotApproved") + ": " + doc.getDocumentNo(), (String)(doc.getSummary() != null ? doc.getSummary() + "\n" : "") + (String)(doc.getProcessMsg() != null ? doc.getProcessMsg() + "\n" : "") + (this.getTextMsg() != null ? this.getTextMsg() : ""), null);
                }
                if (to.isNotificationNote()) {
                    MNote note = new MNote(this.getCtx(), "NotApproved", doc.getDoc_User_ID(), null);
                    note.setTextMsg((String)(doc.getSummary() != null ? doc.getSummary() + "\n" : "") + (String)(doc.getProcessMsg() != null ? doc.getProcessMsg() + "\n" : "") + (this.getTextMsg() != null ? this.getTextMsg() : ""));
                    note.setRecord(this.m_po.get_Table_ID(), this.m_po.get_ID());
                    note.saveEx();
                }
            }
        }
        this.setWFState(newState);
        return ok;
    }

    public boolean forwardTo(int AD_User_ID, String textMsg) {
        if (AD_User_ID == this.getAD_User_ID()) {
            this.log.log(Level.WARNING, "Same User - AD_User_ID=" + AD_User_ID);
            return false;
        }
        MUser oldUser = MUser.get(this.getCtx(), this.getAD_User_ID());
        MUser user = MUser.get(this.getCtx(), AD_User_ID);
        if (user == null || user.get_ID() == 0) {
            this.log.log(Level.WARNING, "Does not exist - AD_User_ID=" + AD_User_ID);
            return false;
        }
        this.setAD_User_ID(user.getAD_User_ID());
        this.setTextMsg(textMsg);
        this.saveEx();
        this.getEventAudit();
        this.m_audit.setAD_User_ID(oldUser.getAD_User_ID());
        this.m_audit.setTextMsg(this.getTextMsg());
        this.m_audit.setAttributeName("AD_User_ID");
        this.m_audit.setOldValue(oldUser.getName() + "(" + oldUser.getAD_User_ID() + ")");
        this.m_audit.setNewValue(user.getName() + "(" + user.getAD_User_ID() + ")");
        this.m_audit.setWFState(this.getWFState());
        this.m_audit.setEventType("SC");
        long ms = System.currentTimeMillis() - this.m_audit.getCreated().getTime();
        this.m_audit.setElapsedTimeMS(new BigDecimal(ms));
        this.m_audit.saveEx();
        this.m_audit = new MWFEventAudit(this);
        this.m_audit.saveEx();
        return true;
    }

    public void setUserConfirmation(int AD_User_ID, String textMsg) {
        this.log.fine(textMsg);
        this.setWFState("OR");
        this.setAD_User_ID(AD_User_ID);
        if (textMsg != null) {
            this.setTextMsg(textMsg);
        }
        this.setWFState("CC");
    }

    private void fillParameter(MPInstance pInstance, Trx trx) {
        this.getPO(trx);
        MWFNodePara[] nParams = this.m_node.getParameters();
        MProcessPara[] processParams = pInstance.getProcessParameters();
        int pi = 0;
        while (pi < processParams.length) {
            MPInstancePara iPara = new MPInstancePara(pInstance, processParams[pi].getSeqNo());
            iPara.setParameterName(processParams[pi].getColumnName());
            iPara.setInfo(processParams[pi].getName());
            iPara.setParameterName(processParams[pi].getColumnName());
            iPara.setInfo(processParams[pi].getName());
            int np = 0;
            while (np < nParams.length) {
                MWFNodePara nPara = nParams[np];
                if (iPara.getParameterName().equals(nPara.getAttributeName())) {
                    String variableName = nPara.getAttributeValue();
                    Object value = this.parseNodeParaAttribute(nPara);
                    if (value == nPara) break;
                    if (value == null) {
                        if (nPara.isMandatory()) {
                            this.log.warning(nPara.getAttributeName() + " - empty - mandatory!");
                            break;
                        }
                        if (!this.log.isLoggable(Level.FINE)) break;
                        this.log.fine(nPara.getAttributeName() + " - empty");
                        break;
                    }
                    if (DisplayType.isText(nPara.getDisplayType()) && Util.isEmpty(String.valueOf(value))) {
                        if (!this.log.isLoggable(Level.FINE)) break;
                        this.log.fine(nPara.getAttributeName() + " - empty string");
                        break;
                    }
                    try {
                        if (DisplayType.isNumeric(nPara.getDisplayType()) || DisplayType.isID(nPara.getDisplayType())) {
                            BigDecimal bd = null;
                            bd = value instanceof BigDecimal ? (BigDecimal)value : (value instanceof Integer ? new BigDecimal((Integer)value) : new BigDecimal(value.toString()));
                            iPara.setP_Number(bd);
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(nPara.getAttributeName() + " = " + variableName + " (=" + String.valueOf(bd) + "=)");
                            }
                        } else if (DisplayType.isDate(nPara.getDisplayType())) {
                            Timestamp ts = null;
                            ts = value instanceof Timestamp ? (Timestamp)value : Timestamp.valueOf(value.toString());
                            iPara.setP_Date(ts);
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(nPara.getAttributeName() + " = " + variableName + " (=" + String.valueOf(ts) + "=)");
                            }
                        } else {
                            iPara.setP_String(value.toString());
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(nPara.getAttributeName() + " = " + variableName + " (=" + String.valueOf(value) + "=) " + value.getClass().getName());
                            }
                        }
                        if (iPara.save()) break;
                        this.log.warning("Not Saved - " + nPara.getAttributeName());
                    }
                    catch (Exception e) {
                        this.log.warning(nPara.getAttributeName() + " = " + variableName + " (" + String.valueOf(value) + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
                    }
                    break;
                }
                ++np;
            }
            ++pi;
        }
    }

    private Object parseNodeParaAttribute(MWFNodePara nPara) {
        String variableName = nPara.getAttributeValue();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(nPara.getAttributeName() + " = " + variableName);
        }
        Object value = variableName;
        if (variableName == null || variableName != null && variableName.length() == 0) {
            value = null;
        } else if (variableName.indexOf(64) != -1 && this.m_po != null) {
            int index = variableName.indexOf(64);
            String columnName = variableName.substring(index + 1);
            if ((index = columnName.indexOf(64)) == -1) {
                this.log.warning(nPara.getAttributeName() + " - cannot evaluate=" + variableName);
                return nPara;
            }
            if ((index = this.m_po.get_ColumnIndex(columnName = columnName.substring(0, index))) != -1) {
                value = this.m_po.get_Value(index);
            } else {
                String env = Env.getContext(this.getCtx(), columnName);
                if (env.length() == 0) {
                    this.log.warning(nPara.getAttributeName() + " - not column nor environment =" + columnName + "(" + variableName + ")");
                    return nPara;
                }
                value = env;
            }
        }
        return value;
    }

    private void sendEMail() {
        DocAction doc = (DocAction)((Object)this.m_po);
        MMailText text = new MMailText(this.getCtx(), this.m_node.getR_MailText_ID(), null);
        text.setPO(this.m_po, true);
        Object subject = null;
        String raw = text.getMailHeader(false);
        subject = raw != null && raw.contains("@_noDocInfo_@") ? text.getMailHeader().replaceAll("@_noDocInfo_@", "") : doc.getDocumentInfo() + ": " + text.getMailHeader();
        Object message = null;
        raw = text.getMailText(true, false);
        message = raw != null && (raw.contains("@=DocumentInfo") || raw.contains("@=documentInfo") || raw.contains("@=Summary") || raw.contains("@=summary") || raw.contains("@_noDocInfo_@")) ? text.getMailText(true).replaceAll("@_noDocInfo_@", "") : text.getMailText(true) + "\n-----\n" + doc.getDocumentInfo() + "\n" + doc.getSummary();
        File pdf = doc != null && this.m_node.isAttachedDocumentToEmail() ? doc.createPDF() : null;
        MClient client = MClient.get(doc.getCtx(), doc.getAD_Client_ID());
        this.sendEMail(client, 0, this.m_node.getEMail(), (String)subject, (String)message, pdf, text.isHtml());
        String recipient = this.m_node.getEMailRecipient();
        if (recipient == null || recipient.length() == 0) {
            this.sendEMail(client, doc.getDoc_User_ID(), null, (String)subject, (String)message, pdf, text.isHtml());
        } else if (recipient.equals("B")) {
            int index = this.m_po.get_ColumnIndex("AD_User_ID");
            if (index > 0) {
                Object oo = this.m_po.get_Value(index);
                if (oo instanceof Integer) {
                    int AD_User_ID = (Integer)oo;
                    if (AD_User_ID != 0) {
                        this.sendEMail(client, AD_User_ID, null, (String)subject, (String)message, pdf, text.isHtml());
                    } else {
                        this.log.fine("No User in Document");
                    }
                } else {
                    this.log.fine("Empty User in Document");
                }
            } else {
                this.log.fine("No User Field in Document");
            }
        } else if (recipient.equals("D")) {
            this.sendEMail(client, doc.getDoc_User_ID(), null, (String)subject, (String)message, pdf, text.isHtml());
        } else if (recipient.equals("R")) {
            MWFResponsible resp = this.getResponsible();
            if (resp.isInvoker()) {
                this.sendEMail(client, doc.getDoc_User_ID(), null, (String)subject, (String)message, pdf, text.isHtml());
            } else if (resp.isHuman()) {
                this.sendEMail(client, resp.getAD_User_ID(), null, (String)subject, (String)message, pdf, text.isHtml());
            } else if (resp.isRole()) {
                MRole role = resp.getRole();
                if (role != null) {
                    MUser[] users = MUser.getWithRole(role);
                    int i2 = 0;
                    while (i2 < users.length) {
                        this.sendEMail(client, users[i2].getAD_User_ID(), null, (String)subject, (String)message, pdf, text.isHtml());
                        ++i2;
                    }
                }
            } else if (resp.isOrganization()) {
                MOrgInfo org = MOrgInfo.get(this.getCtx(), this.m_po.getAD_Org_ID(), this.get_TrxName());
                if (org.getSupervisor_ID() == 0) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("No Supervisor for AD_Org_ID=" + this.m_po.getAD_Org_ID());
                    }
                } else {
                    this.sendEMail(client, org.getSupervisor_ID(), null, (String)subject, (String)message, pdf, text.isHtml());
                }
            }
        }
    }

    private void sendEMail(MClient client, int AD_User_ID, String email, String subject, String message, File pdf, boolean isHtml) {
        block7: {
            block5: {
                MUser user;
                block6: {
                    if (AD_User_ID == 0) break block5;
                    user = new MUser(this.getCtx(), AD_User_ID, this.get_TrxName());
                    email = user.getEMail();
                    if (email == null || email.length() <= 0) break block6;
                    if (!this.m_emails.contains(email = email.trim())) {
                        client.sendEMail(null, user, subject, message, pdf, isHtml);
                        this.m_emails.add(email);
                    }
                    break block7;
                }
                if (!this.log.isLoggable(Level.INFO)) break block7;
                this.log.info("No EMail for User " + user.getName());
                break block7;
            }
            if (email != null && email.length() > 0) {
                if (email.indexOf(59) == -1) {
                    if (!this.m_emails.contains(email = email.trim())) {
                        client.sendEMail(email, subject, message, pdf, isHtml);
                        this.m_emails.add(email);
                    }
                    return;
                }
                StringTokenizer st = new StringTokenizer(email, ";");
                while (st.hasMoreTokens()) {
                    String email1 = st.nextToken().trim();
                    if (email1.length() == 0 || this.m_emails.contains(email1)) continue;
                    client.sendEMail(email1, subject, message, pdf, isHtml);
                    this.m_emails.add(email1);
                }
            }
        }
    }

    public String getHistoryHTML() {
        SimpleDateFormat format = DisplayType.getDateFormat(16);
        StringBuilder sb = new StringBuilder();
        MWFEventAudit[] events = MWFEventAudit.get(this.getCtx(), this.getAD_WF_Process_ID(), this.get_TrxName());
        int i2 = 0;
        while (i2 < events.length) {
            MWFEventAudit audit = events[i2];
            sb.append("<p>");
            sb.append(format.format(audit.getCreated())).append(" ").append(this.getHTMLpart("b", audit.getNodeName())).append(": ").append(this.getHTMLpart(null, audit.getDescription())).append(this.getHTMLpart("i", audit.getTextMsg()));
            sb.append("</p>");
            ++i2;
        }
        return sb.toString();
    }

    private StringBuffer getHTMLpart(String tag, String content) {
        StringBuffer sb = new StringBuffer();
        if (content == null || content.length() == 0) {
            return sb;
        }
        if (tag != null && tag.length() > 0) {
            sb.append("<").append(tag).append(">");
        }
        sb.append(content);
        if (tag != null && tag.length() > 0) {
            sb.append("</").append(tag).append(">");
        }
        return sb;
    }

    @Override
    public boolean isPdfAttachment() {
        if (this.getPO() == null) {
            return false;
        }
        return this.m_po.isPdfAttachment();
    }

    @Override
    public byte[] getPdfAttachment() {
        if (this.getPO() == null) {
            return null;
        }
        return this.m_po.getPdfAttachment();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MWFActivity[");
        sb.append(this.get_ID()).append(",Node=");
        if (this.m_node == null) {
            sb.append(this.getAD_WF_Node_ID());
        } else {
            sb.append(this.m_node.getName());
        }
        sb.append(",State=").append(this.getWFState()).append(",AD_User_ID=").append(this.getAD_User_ID()).append(",").append(this.getCreated()).append("]");
        return sb.toString();
    }

    public String toStringX() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getWFStateText()).append(": ").append(this.getNode().getName());
        if (this.getAD_User_ID() > 0) {
            MUser user = MUser.get(this.getCtx(), this.getAD_User_ID());
            sb.append(" (").append(user.getName()).append(")");
        }
        return sb.toString();
    }

    public String getSummary() {
        MBPartner partner;
        Integer bp;
        MUser user;
        int index;
        PO po = this.getPO();
        if (po == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] keyColumns = po.get_KeyColumns();
        if (keyColumns != null && keyColumns.length > 0) {
            sb.append(Msg.getElement(this.getCtx(), keyColumns[0])).append(" ");
        }
        if ((index = po.get_ColumnIndex("DocumentNo")) != -1) {
            sb.append(po.get_Value(index)).append(": ");
        }
        index = po.get_ColumnIndex("SalesRep_ID");
        Integer sr = null;
        if (index != -1) {
            sr = (Integer)po.get_Value(index);
        } else {
            index = po.get_ColumnIndex("AD_User_ID");
            if (index != -1) {
                sr = (Integer)po.get_Value(index);
            }
        }
        if (sr != null && (user = MUser.get(this.getCtx(), sr)) != null) {
            sb.append(user.getName()).append(" ");
        }
        if ((index = po.get_ColumnIndex("C_BPartner_ID")) != -1 && (bp = (Integer)po.get_Value(index)) != null && (partner = MBPartner.get(this.getCtx(), bp)) != null) {
            sb.append(partner.getName()).append(" ");
        }
        return sb.toString();
    }

    private void prepareCommitEvent() {
        Trx trx = null;
        if (this.get_TrxName() == null) {
            return;
        }
        MWFActivity activity = new MWFActivity(this.getCtx(), this.get_ID(), this.get_TrxName());
        trx = Trx.get(this.get_TrxName(), true);
        trx.addTrxEventListener(new TrxListener(activity));
    }

    public static String getWhereUserPendingActivities() {
        return "AD_WF_Activity.Processed='N' AND AD_WF_Activity.WFState='OS' AND ( AD_WF_Activity.AD_User_ID=? OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE AD_WF_Activity.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='H' AND COALESCE(r.AD_User_ID,0)=0 AND COALESCE(r.AD_Role_ID,0)=0 AND (AD_WF_Activity.AD_User_ID=? OR AD_WF_Activity.AD_User_ID IS NULL)) OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE AD_WF_Activity.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='H' AND r.AD_User_ID=?) OR EXISTS (SELECT * FROM AD_WF_Responsible r INNER JOIN AD_User_Roles ur ON (r.AD_Role_ID=ur.AD_Role_ID) WHERE AD_WF_Activity.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='R' AND ur.AD_User_ID=? AND ur.isActive = 'Y') OR EXISTS (SELECT * FROM AD_WF_ActivityApprover r  WHERE AD_WF_Activity.AD_WF_Activity_ID=r.AD_WF_Activity_ID AND r.AD_User_ID=? AND r.isActive = 'Y')) AND AD_WF_Activity.AD_Client_ID=?";
    }

    public String getProcessMsg() {
        if (this.m_process == null) {
            return null;
        }
        return this.m_process.getProcessMsg();
    }

    static class TrxListener
    implements TrxEventListener {
        private MWFActivity activity;

        protected TrxListener(MWFActivity activity) {
            this.activity = activity;
        }

        @Override
        public void afterRollback(Trx trx, boolean success) {
        }

        @Override
        public void afterCommit(Trx trx, boolean success) {
            if (success) {
                trx.removeTrxEventListener(this);
                this.activity.setWFState("CC");
            }
        }

        @Override
        public void afterClose(Trx trx) {
            trx.removeTrxEventListener(this);
        }
    }
}

