/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.ComponentOrientation;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import javax.print.attribute.standard.MediaSize;
import org.compiere.model.MLanguage;
import org.compiere.print.MPrintPaper;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Language
implements Serializable {
    private static final long serialVersionUID = 7039775951366180267L;
    private static final String AD_Language_en_US = "en_US";
    private static List<Language> s_languages = new ArrayList<Language>();
    private static Language s_baseLanguage = null;
    private static boolean isBaseLanguageSet = false;
    private static CLogger log;
    private String m_name;
    private String m_AD_Language;
    private Locale m_locale;
    private Boolean m_decimalPoint;
    private Boolean m_leftToRight;
    private SimpleDateFormat m_dateFormat;
    private String m_dbDateFormat;
    private MediaSize m_mediaSize = MediaSize.ISO.A4;
    private boolean m_fromDB = false;

    static {
        s_languages.add(new Language("English", AD_Language_en_US, Locale.US, null, null, MediaSize.NA.LETTER));
        s_baseLanguage = s_languages.get(0);
        log = CLogger.getCLogger(Language.class.getName());
    }

    public static int getLanguageCount() {
        return s_languages.size();
    }

    public static Language getLanguage(int index) {
        if (index < 0 || index >= s_languages.size()) {
            return s_baseLanguage;
        }
        return s_languages.get(index);
    }

    public static synchronized Language getLanguage(String langInfo) {
        int idxReplace = -1;
        String lang = langInfo;
        if (lang == null || lang.length() == 0) {
            lang = System.getProperty("user.language", "");
        }
        int i2 = 0;
        while (i2 < s_languages.size()) {
            if (lang.equals(s_languages.get(i2).getAD_Language()) || lang.equals(s_languages.get(i2).getLanguageCode()) || lang.equals(s_languages.get(i2).getName())) {
                if (!Language.s_languages.get((int)i2).m_fromDB && DB.isConnected()) {
                    idxReplace = i2;
                    break;
                }
                return s_languages.get(i2);
            }
            ++i2;
        }
        if (lang.length() == 5) {
            Language ll = null;
            String language = lang.substring(0, 2);
            String country = lang.substring(3);
            Locale locale = new Locale(language, country);
            if (DB.isConnected()) {
                MLanguage dblang;
                if (!isBaseLanguageSet) {
                    Language.setBaseLanguage();
                }
                if ((dblang = MLanguage.get(Env.getCtx(), langInfo)) != null) {
                    if (!(language.equals(dblang.getLanguageISO()) && country.equals(dblang.getCountryCode()) || dblang.getLanguageISO() == null || dblang.getCountryCode() == null)) {
                        locale = new Locale(dblang.getLanguageISO(), dblang.getCountryCode());
                    }
                    MediaSize mediaSize = MediaSize.ISO.A4;
                    if (dblang.getAD_PrintPaper_ID() > 0) {
                        MPrintPaper pp = MPrintPaper.get(dblang.getAD_PrintPaper_ID());
                        mediaSize = pp.getMediaSize();
                    }
                    ll = new Language(dblang.getPrintName(), langInfo, locale, null, dblang.getDatePattern(), mediaSize);
                    ll.m_fromDB = true;
                    if (dblang.isBaseLanguage()) {
                        idxReplace = 0;
                        s_baseLanguage = dblang.isSystemLanguage() ? new Language("no-base", "xx_XX", locale) : ll;
                    }
                }
            }
            if (ll == null) {
                ll = new Language(lang, lang, locale);
            }
            if (log.isLoggable(Level.INFO)) {
                StringBuilder msglog = new StringBuilder("Adding Language=").append(language).append(", Country=").append(country).append(", Locale=").append(locale);
                log.info(msglog.toString());
            }
            if (idxReplace >= 0) {
                s_languages.set(idxReplace, ll);
            } else {
                s_languages.add(ll);
            }
            return ll;
        }
        return s_baseLanguage;
    }

    private static void setBaseLanguage() {
        isBaseLanguageSet = true;
        String baselang = DB.getSQLValueStringEx(null, "SELECT AD_Language FROM AD_Language WHERE IsActive='Y' AND IsBaseLanguage = 'Y'", new Object[0]);
        if (baselang != null) {
            Language.getLanguage(baselang);
        }
    }

    public static void setBaseLanguage(String baselang) {
        Language lang;
        s_baseLanguage = lang = Language.getLanguage(baselang);
    }

    public static boolean isBaseLanguage(String langInfo) {
        return langInfo == null || langInfo.length() == 0 || langInfo.equals(s_baseLanguage.getName()) || langInfo.equals(s_baseLanguage.getLanguageCode()) || langInfo.equals(s_baseLanguage.getAD_Language());
    }

    public static Language getBaseLanguage() {
        return s_baseLanguage;
    }

    public static String getBaseAD_Language() {
        return s_baseLanguage.getAD_Language();
    }

    public static Locale getLocale(String langInfo) {
        return Language.getLanguage(langInfo).getLocale();
    }

    public static String getAD_Language(String langInfo) {
        return Language.getLanguage(langInfo).getAD_Language();
    }

    public static String getAD_Language(Locale locale) {
        if (locale != null) {
            int i2 = 0;
            while (i2 < s_languages.size()) {
                if (locale.getLanguage().equals(s_languages.get(i2).getLocale().getLanguage())) {
                    return s_languages.get(i2).getAD_Language();
                }
                ++i2;
            }
        }
        return s_baseLanguage.getAD_Language();
    }

    public static String getName(String langInfo) {
        return Language.getLanguage(langInfo).getName();
    }

    public static boolean isDecimalPoint(String langInfo) {
        return Language.getLanguage(langInfo).isDecimalPoint();
    }

    public static String[] getNames() {
        String[] retValue = new String[s_languages.size()];
        int i2 = 0;
        while (i2 < s_languages.size()) {
            retValue[i2] = s_languages.get(i2).getName();
            ++i2;
        }
        return retValue;
    }

    public static Language getLoginLanguage() {
        return Env.getLanguage(Env.getCtx());
    }

    public static void setLoginLanguage(Language language) {
        if (language != null) {
            Env.setContext(Env.getCtx(), "#AD_Language", language.getAD_Language());
            if (log.isLoggable(Level.CONFIG)) {
                log.config(language.toString());
            }
        }
    }

    public Language(String name, String AD_Language, Locale locale, Boolean decimalPoint, String javaDatePattern, MediaSize mediaSize) {
        if (name == null || AD_Language == null || locale == null) {
            throw new IllegalArgumentException("Language - parameter is null");
        }
        this.m_name = name;
        this.m_AD_Language = AD_Language;
        this.m_locale = locale;
        this.m_decimalPoint = decimalPoint;
        this.setDateFormat(javaDatePattern);
        this.setMediaSize(mediaSize);
    }

    public Language(String name, String AD_Language, Locale locale) {
        this(name, AD_Language, locale, null, null, null);
    }

    public Language(Language copy) {
        this.m_AD_Language = copy.m_AD_Language;
        this.m_dateFormat = copy.m_dateFormat;
        this.m_dbDateFormat = copy.m_dbDateFormat;
        this.m_decimalPoint = copy.m_decimalPoint;
        this.m_fromDB = copy.m_fromDB;
        this.m_leftToRight = copy.m_leftToRight;
        this.m_locale = copy.m_locale;
        this.m_mediaSize = copy.m_mediaSize;
        this.m_name = copy.m_name;
    }

    public String getName() {
        return this.m_name;
    }

    public String getAD_Language() {
        return this.m_AD_Language;
    }

    public void setAD_Language(String AD_Language) {
        if (AD_Language != null) {
            this.m_AD_Language = AD_Language;
            if (log.isLoggable(Level.CONFIG)) {
                log.config(this.toString());
            }
        }
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.m_locale = locale;
        this.m_decimalPoint = null;
    }

    public String getLanguageCode() {
        return this.m_locale.getLanguage();
    }

    public boolean isLeftToRight() {
        if (this.m_leftToRight == null) {
            this.m_leftToRight = ComponentOrientation.getOrientation(this.m_locale).isLeftToRight();
        }
        return this.m_leftToRight;
    }

    public boolean isDecimalPoint() {
        if (this.m_decimalPoint == null) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(this.m_locale);
            this.m_decimalPoint = dfs.getDecimalSeparator() == '.';
        }
        return this.m_decimalPoint;
    }

    public boolean isBaseLanguage() {
        return this.equals(Language.getBaseLanguage());
    }

    public synchronized void setDateFormat(String javaDatePattern) {
        if (javaDatePattern == null) {
            return;
        }
        this.m_dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.m_locale);
        try {
            this.m_dateFormat.applyPattern(javaDatePattern);
        }
        catch (Exception e) {
            log.severe(javaDatePattern + " - " + String.valueOf(e));
            this.m_dateFormat = null;
        }
    }

    public synchronized SimpleDateFormat getDateFormat() {
        if (this.m_dateFormat == null) {
            this.m_dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.m_locale);
            String sFormat = this.m_dateFormat.toPattern();
            if (sFormat.indexOf("MM") == -1 || sFormat.indexOf("dd") == -1) {
                sFormat = sFormat.replaceFirst("d+", "dd");
                sFormat = sFormat.replaceFirst("M+", "MM");
                this.m_dateFormat.applyPattern(sFormat);
            }
            if (this.m_dateFormat.toPattern().length() != 8) {
                this.m_dateFormat.applyPattern("yyyy-MM-dd");
            }
            if (this.m_dateFormat.toPattern().indexOf("yyyy") == -1) {
                sFormat = this.m_dateFormat.toPattern();
                StringBuilder nFormat = new StringBuilder();
                int i2 = 0;
                while (i2 < sFormat.length()) {
                    if (sFormat.charAt(i2) == 'y') {
                        nFormat.append("yy");
                    } else {
                        nFormat.append(sFormat.charAt(i2));
                    }
                    ++i2;
                }
                this.m_dateFormat.applyPattern(nFormat.toString());
            }
            this.m_dateFormat.setLenient(true);
        }
        return (SimpleDateFormat)this.m_dateFormat.clone();
    }

    public SimpleDateFormat getDateTimeFormat() {
        SimpleDateFormat retValue = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 1, this.m_locale);
        return retValue;
    }

    public SimpleDateFormat getTimeFormat() {
        return (SimpleDateFormat)DateFormat.getTimeInstance(1, this.m_locale);
    }

    public String getDBdatePattern() {
        if (this.m_dbDateFormat == null) {
            this.m_dbDateFormat = this.getDateFormat().toPattern().toUpperCase(this.m_locale);
            this.m_dbDateFormat = this.m_dbDateFormat.replaceFirst("MMM*", "MM");
        }
        return this.m_dbDateFormat;
    }

    public MediaSize getMediaSize() {
        return this.m_mediaSize;
    }

    public void setMediaSize(MediaSize size) {
        if (size != null) {
            this.m_mediaSize = size;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Language=[");
        sb.append(this.m_name).append(",Locale=").append(this.m_locale.toString()).append(",AD_Language=").append(this.m_AD_Language).append(",DatePattern=").append(this.getDBdatePattern()).append(",DecimalPoint=").append(this.isDecimalPoint()).append("]");
        return sb.toString();
    }

    public int hashCode() {
        return this.m_AD_Language.hashCode();
    }

    public boolean equals(Object obj) {
        Language cmp;
        return obj instanceof Language && (cmp = (Language)obj).getAD_Language().equals(this.m_AD_Language);
    }
}

