/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import java.util.logging.Level;
import org.adempiere.base.IDisplayTypeFactory;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.Database;
import org.compiere.model.MLanguage;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;

public final class DisplayType {
    public static final int String = 10;
    public static final int Integer = 11;
    public static final int Amount = 12;
    public static final int ID = 13;
    public static final int UUID = 200231;
    public static final int Text = 14;
    public static final int Date = 15;
    public static final int DateTime = 16;
    public static final int List = 17;
    public static final int Table = 18;
    public static final int TableUU = 200233;
    public static final int TableDir = 19;
    public static final int TableDirUU = 200234;
    public static final int YesNo = 20;
    public static final int Location = 21;
    public static final int Number = 22;
    public static final int Binary = 23;
    public static final int Time = 24;
    public static final int Account = 25;
    public static final int RowID = 26;
    public static final int Color = 27;
    public static final int Button = 28;
    public static final int Quantity = 29;
    public static final int Search = 30;
    public static final int SearchUU = 200235;
    public static final int Locator = 31;
    public static final int Image = 32;
    public static final int Assignment = 33;
    public static final int Memo = 34;
    public static final int PAttribute = 35;
    public static final int TextLong = 36;
    public static final int CostPrice = 37;
    public static final int FilePath = 38;
    public static final int FileName = 39;
    public static final int URL = 40;
    public static final int PrinterName = 42;
    public static final int Payment = 200012;
    public static final int Chart = 53370;
    public static final int DashboardContent = 200122;
    public static final int SingleSelectionGrid = 200127;
    public static final int MultipleSelectionGrid = 200128;
    public static final int RadiogroupList = 200152;
    public static final int ChosenMultipleSelectionList = 200161;
    public static final int ChosenMultipleSelectionTable = 200162;
    public static final int ChosenMultipleSelectionSearch = 200163;
    public static final int SchedulerState = 200173;
    public static final int RecordID = 200202;
    public static final int RecordUU = 200240;
    public static final int JSON = 200267;
    public static final int TimestampWithTimeZone = 200133;
    public static final int TimeZoneId = 200135;
    private static final int MAX_DIGITS = 28;
    private static final int INTEGER_DIGITS = 10;
    private static final int MAX_FRACTION = 12;
    private static final int AMOUNT_FRACTION = 2;
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static CLogger s_log = CLogger.getCLogger(DisplayType.class);
    private static final CCache<String, Boolean> s_customDisplayTypeNegativeCache = new CCache(null, "CustomDisplayTypeNegativeCache", 100, false);
    private static final CCache<Integer, IServiceReferenceHolder<IDisplayTypeFactory>> s_displayTypeFactoryCache = new CCache(null, "IDisplayTypeFactory", 100, false);

    public static boolean isID(int displayType) {
        String customTypeKey;
        if (displayType == 13 || displayType == 18 || displayType == 19 || displayType == 30 || displayType == 21 || displayType == 31 || displayType == 25 || displayType == 33 || displayType == 35 || displayType == 32 || displayType == 53370 || displayType == 200202) {
            return true;
        }
        if (displayType <= 999999) {
            return false;
        }
        IServiceReferenceHolder<IDisplayTypeFactory> cache = s_displayTypeFactoryCache.get(displayType);
        if (cache != null) {
            IDisplayTypeFactory service = cache.getService();
            if (service != null) {
                return service.isID(displayType);
            }
            s_displayTypeFactoryCache.remove(displayType);
        }
        if (!s_customDisplayTypeNegativeCache.containsKey(customTypeKey = displayType + "|isID")) {
            Optional<IServiceReferenceHolder> found = DisplayType.getDisplayTypeFactories().stream().filter(e -> e.getService() != null && ((IDisplayTypeFactory)e.getService()).isID(displayType)).findFirst();
            if (found.isPresent()) {
                s_displayTypeFactoryCache.put(displayType, found.get());
                return true;
            }
            s_customDisplayTypeNegativeCache.put(customTypeKey, Boolean.TRUE);
        }
        return false;
    }

    public static boolean isUUID(int displayType) {
        String customTypeKey;
        if (displayType == 200231 || displayType == 200233 || displayType == 200234 || displayType == 200235 || displayType == 200240) {
            return true;
        }
        if (displayType <= 999999) {
            return false;
        }
        IServiceReferenceHolder<IDisplayTypeFactory> cache = s_displayTypeFactoryCache.get(displayType);
        if (cache != null) {
            IDisplayTypeFactory service = cache.getService();
            if (service != null) {
                return service.isUUID(displayType);
            }
            s_displayTypeFactoryCache.remove(displayType);
        }
        if (!s_customDisplayTypeNegativeCache.containsKey(customTypeKey = displayType + "|isUUID")) {
            Optional<IServiceReferenceHolder> found = DisplayType.getDisplayTypeFactories().stream().filter(e -> e.getService() != null && ((IDisplayTypeFactory)e.getService()).isUUID(displayType)).findFirst();
            if (found.isPresent()) {
                s_displayTypeFactoryCache.put(displayType, found.get());
                return true;
            }
            s_customDisplayTypeNegativeCache.put(customTypeKey, Boolean.TRUE);
        }
        return false;
    }

    public static boolean isNumeric(int displayType) {
        String customTypeKey;
        if (displayType == 12 || displayType == 22 || displayType == 37 || displayType == 11 || displayType == 29) {
            return true;
        }
        if (displayType <= 999999) {
            return false;
        }
        IServiceReferenceHolder<IDisplayTypeFactory> cache = s_displayTypeFactoryCache.get(displayType);
        if (cache != null) {
            IDisplayTypeFactory service = cache.getService();
            if (service != null) {
                return service.isNumeric(displayType);
            }
            s_displayTypeFactoryCache.remove(displayType);
        }
        if (!s_customDisplayTypeNegativeCache.containsKey(customTypeKey = displayType + "|isNumeric")) {
            Optional<IServiceReferenceHolder> found = DisplayType.getDisplayTypeFactories().stream().filter(e -> e.getService() != null && ((IDisplayTypeFactory)e.getService()).isNumeric(displayType)).findFirst();
            if (found.isPresent()) {
                s_displayTypeFactoryCache.put(displayType, found.get());
                return true;
            }
            s_customDisplayTypeNegativeCache.put(customTypeKey, Boolean.TRUE);
        }
        return false;
    }

    public static int getDefaultPrecision(int displayType) {
        String customTypeKey;
        if (displayType == 12) {
            return 2;
        }
        if (displayType == 22) {
            return 6;
        }
        if (displayType == 37 || displayType == 29) {
            return 4;
        }
        if (displayType <= 999999) {
            return 0;
        }
        IServiceReferenceHolder<IDisplayTypeFactory> cache = s_displayTypeFactoryCache.get(displayType);
        if (cache != null) {
            IDisplayTypeFactory service = cache.getService();
            if (service != null) {
                Integer v = service.getDefaultPrecision(displayType);
                return v != null ? v : 0;
            }
            s_displayTypeFactoryCache.remove(displayType);
        }
        if (!s_customDisplayTypeNegativeCache.containsKey(customTypeKey = displayType + "|getDefaultPrecision")) {
            Optional<IServiceReferenceHolder> found = DisplayType.getDisplayTypeFactories().stream().filter(e -> e.getService() != null && ((IDisplayTypeFactory)e.getService()).getDefaultPrecision(displayType) != null).findFirst();
            if (found.isPresent()) {
                s_displayTypeFactoryCache.put(displayType, found.get());
                Integer v = ((IDisplayTypeFactory)found.get().getService()).getDefaultPrecision(displayType);
                return v != null ? v : 0;
            }
            s_customDisplayTypeNegativeCache.put(customTypeKey, Boolean.TRUE);
        }
        return 0;
    }

    public static boolean isText(int displayType) {
        String customTypeKey;
        if (displayType == 10 || displayType == 14 || displayType == 36 || displayType == 200267 || displayType == 34 || displayType == 38 || displayType == 39 || displayType == 40 || displayType == 42 || displayType == 200127 || displayType == 27 || displayType == 200128 || displayType == 200152 || displayType == 200161 || displayType == 200162 || displayType == 200163 || displayType == 200135 || displayType == 200231 || displayType == 200240 || displayType == 200234 || displayType == 200233 || displayType == 200235) {
            return true;
        }
        if (displayType <= 999999) {
            return false;
        }
        IServiceReferenceHolder<IDisplayTypeFactory> cache = s_displayTypeFactoryCache.get(displayType);
        if (cache != null) {
            IDisplayTypeFactory service = cache.getService();
            if (service != null) {
                return service.isText(displayType);
            }
            s_displayTypeFactoryCache.remove(displayType);
        }
        if (!s_customDisplayTypeNegativeCache.containsKey(customTypeKey = displayType + "|isText")) {
            Optional<IServiceReferenceHolder> found = DisplayType.getDisplayTypeFactories().stream().filter(e -> e.getService() != null && ((IDisplayTypeFactory)e.getService()).isText(displayType)).findFirst();
            if (found.isPresent()) {
                s_displayTypeFactoryCache.put(displayType, found.get());
                return true;
            }
            s_customDisplayTypeNegativeCache.put(customTypeKey, Boolean.TRUE);
        }
        return false;
    }

    public static boolean isDate(int displayType) {
        String customTypeKey;
        if (displayType == 15 || displayType == 16 || displayType == 24) {
            return true;
        }
        if (DisplayType.isTimestampWithTimeZone(displayType)) {
            return true;
        }
        if (displayType <= 999999) {
            return false;
        }
        IServiceReferenceHolder<IDisplayTypeFactory> cache = s_displayTypeFactoryCache.get(displayType);
        if (cache != null) {
            IDisplayTypeFactory service = cache.getService();
            if (service != null) {
                return service.isDate(displayType);
            }
            s_displayTypeFactoryCache.remove(displayType);
        }
        if (!s_customDisplayTypeNegativeCache.containsKey(customTypeKey = displayType + "|isDate")) {
            Optional<IServiceReferenceHolder> found = DisplayType.getDisplayTypeFactories().stream().filter(e -> e.getService() != null && ((IDisplayTypeFactory)e.getService()).isDate(displayType)).findFirst();
            if (found.isPresent()) {
                s_displayTypeFactoryCache.put(displayType, found.get());
                return true;
            }
            s_customDisplayTypeNegativeCache.put(customTypeKey, Boolean.TRUE);
        }
        return false;
    }

    public static boolean isList(int displayType) {
        String customTypeKey;
        if (17 == displayType || 200152 == displayType || 200161 == displayType || 200012 == displayType) {
            return true;
        }
        if (displayType <= 999999) {
            return false;
        }
        IServiceReferenceHolder<IDisplayTypeFactory> cache = s_displayTypeFactoryCache.get(displayType);
        if (cache != null) {
            IDisplayTypeFactory service = cache.getService();
            if (service != null) {
                return service.isList(displayType);
            }
            s_displayTypeFactoryCache.remove(displayType);
        }
        if (!s_customDisplayTypeNegativeCache.containsKey(customTypeKey = displayType + "|isList")) {
            Optional<IServiceReferenceHolder> found = DisplayType.getDisplayTypeFactories().stream().filter(e -> e.getService() != null && ((IDisplayTypeFactory)e.getService()).isList(displayType)).findFirst();
            if (found.isPresent()) {
                s_displayTypeFactoryCache.put(displayType, found.get());
                return true;
            }
            s_customDisplayTypeNegativeCache.put(customTypeKey, Boolean.TRUE);
        }
        return false;
    }

    public static boolean isLookup(int displayType) {
        String customTypeKey;
        if (displayType == 17 || displayType == 18 || displayType == 200233 || displayType == 19 || displayType == 200234 || displayType == 30 || displayType == 200235 || displayType == 200152 || displayType == 200162 || displayType == 200163 || displayType == 200161) {
            return true;
        }
        if (displayType <= 999999) {
            return false;
        }
        IServiceReferenceHolder<IDisplayTypeFactory> cache = s_displayTypeFactoryCache.get(displayType);
        if (cache != null) {
            IDisplayTypeFactory service = cache.getService();
            if (service != null) {
                return service.isLookup(displayType);
            }
            s_displayTypeFactoryCache.remove(displayType);
        }
        if (!s_customDisplayTypeNegativeCache.containsKey(customTypeKey = displayType + "|isLookup")) {
            Optional<IServiceReferenceHolder> found = DisplayType.getDisplayTypeFactories().stream().filter(e -> e.getService() != null && ((IDisplayTypeFactory)e.getService()).isLookup(displayType)).findFirst();
            if (found.isPresent()) {
                s_displayTypeFactoryCache.put(displayType, found.get());
                return true;
            }
            s_customDisplayTypeNegativeCache.put(customTypeKey, Boolean.TRUE);
        }
        return false;
    }

    public static boolean isLOB(int displayType) {
        String customTypeKey;
        if (displayType == 23 || displayType == 36 || displayType == 200267 && DB.isOracle()) {
            return true;
        }
        if (displayType <= 999999) {
            return false;
        }
        IServiceReferenceHolder<IDisplayTypeFactory> cache = s_displayTypeFactoryCache.get(displayType);
        if (cache != null) {
            IDisplayTypeFactory service = cache.getService();
            if (service != null) {
                return service.isLOB(displayType);
            }
            s_displayTypeFactoryCache.remove(displayType);
        }
        if (!s_customDisplayTypeNegativeCache.containsKey(customTypeKey = displayType + "|isLOB")) {
            Optional<IServiceReferenceHolder> found = DisplayType.getDisplayTypeFactories().stream().filter(e -> e.getService() != null && ((IDisplayTypeFactory)e.getService()).isLOB(displayType)).findFirst();
            if (found.isPresent()) {
                s_displayTypeFactoryCache.put(displayType, found.get());
                return true;
            }
            s_customDisplayTypeNegativeCache.put(customTypeKey, Boolean.TRUE);
        }
        return false;
    }

    public static boolean isTimestampWithTimeZone(int displayType) {
        return displayType == 200133;
    }

    public static boolean isChosenMultipleSelection(int displayType) {
        return displayType == 200161 || displayType == 200163 || displayType == 200162;
    }

    public static boolean isMultiID(int displayType) {
        return displayType == 200163 || displayType == 200162 || displayType == 200127 || displayType == 200128;
    }

    public static DecimalFormat getNumberFormat(int displayType, Language language, String pattern) {
        Language myLanguage = language;
        if (myLanguage == null) {
            myLanguage = Env.getLocaleLanguage(Env.getCtx());
        }
        Locale locale = myLanguage.getLocale();
        DecimalFormat format = null;
        format = locale != null ? (DecimalFormat)NumberFormat.getNumberInstance(locale) : (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        if (pattern != null && pattern.length() > 0) {
            try {
                format.applyPattern(pattern);
                return format;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                s_log.log(Level.WARNING, "Invalid number format: " + pattern);
            }
        } else if (displayType == 11) {
            format.setParseIntegerOnly(true);
            format.setMaximumIntegerDigits(10);
            format.setMaximumFractionDigits(0);
        } else if (displayType == 29) {
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
        } else if (displayType == 12) {
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
            format.setMinimumFractionDigits(2);
        } else if (displayType == 37) {
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
            format.setMinimumFractionDigits(2);
        } else {
            String customTypeKey;
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
            format.setMinimumFractionDigits(1);
            if (displayType <= 999999) {
                return format;
            }
            IServiceReferenceHolder<IDisplayTypeFactory> cache = s_displayTypeFactoryCache.get(displayType);
            if (cache != null) {
                IDisplayTypeFactory service = cache.getService();
                if (service != null) {
                    DecimalFormat f = service.getNumberFormat(displayType, language, pattern);
                    if (f != null) {
                        return f;
                    }
                } else {
                    s_displayTypeFactoryCache.remove(displayType);
                }
            }
            if (!s_customDisplayTypeNegativeCache.containsKey(customTypeKey = displayType + "|getNumberFormat")) {
                Optional<IServiceReferenceHolder> found = DisplayType.getDisplayTypeFactories().stream().filter(e -> e.getService() != null && ((IDisplayTypeFactory)e.getService()).getNumberFormat(displayType, language, pattern) != null).findFirst();
                if (found.isPresent()) {
                    s_displayTypeFactoryCache.put(displayType, found.get());
                    return ((IDisplayTypeFactory)found.get().getService()).getNumberFormat(displayType, language, pattern);
                }
                s_customDisplayTypeNegativeCache.put(customTypeKey, Boolean.TRUE);
            }
        }
        return format;
    }

    public static DecimalFormat getNumberFormat(int displayType, Language language) {
        return DisplayType.getNumberFormat(displayType, language, null);
    }

    public static DecimalFormat getNumberFormat(int displayType) {
        return DisplayType.getNumberFormat(displayType, null);
    }

    public static SimpleDateFormat getDateFormat() {
        return DisplayType.getDateFormat(15, null);
    }

    public static SimpleDateFormat getDateFormat(Language language) {
        return DisplayType.getDateFormat(15, language);
    }

    public static SimpleDateFormat getDateFormat(int displayType) {
        return DisplayType.getDateFormat(displayType, null);
    }

    public static SimpleDateFormat getDateFormat(int displayType, Language language) {
        return DisplayType.getDateFormat(displayType, language, null);
    }

    public static SimpleDateFormat getDateFormat(int displayType, Language language, String pattern) {
        Language myLanguage = language;
        if (myLanguage == null) {
            myLanguage = Env.getLanguage(Env.getCtx());
        }
        if (pattern != null && pattern.length() > 0) {
            SimpleDateFormat format = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, language.getLocale());
            try {
                format.applyPattern(pattern);
                return displayType == 200135 ? DisplayType.setTimeZone(format) : format;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                s_log.log(Level.WARNING, "Invalid date pattern: " + pattern);
            }
        }
        MLanguage lang = MLanguage.get(Env.getCtx(), myLanguage);
        if (displayType == 16) {
            if (!Util.isEmpty(lang.getDatePattern()) && !Util.isEmpty(lang.getTimePattern())) {
                return new SimpleDateFormat(lang.getDatePattern() + " " + lang.getTimePattern());
            }
            return myLanguage.getDateTimeFormat();
        }
        if (displayType == 24) {
            if (!Util.isEmpty(lang.getTimePattern())) {
                return new SimpleDateFormat(lang.getTimePattern());
            }
            return myLanguage.getTimeFormat();
        }
        if (displayType == 200133) {
            SimpleDateFormat format = null;
            format = !Util.isEmpty(lang.getDatePattern()) && !Util.isEmpty(lang.getTimePattern()) ? new SimpleDateFormat(lang.getDatePattern() + " " + lang.getTimePattern()) : myLanguage.getDateTimeFormat();
            return DisplayType.setTimeZone(format);
        }
        if (displayType > 999999) {
            String customTypeKey;
            IServiceReferenceHolder<IDisplayTypeFactory> cache = s_displayTypeFactoryCache.get(displayType);
            if (cache != null) {
                IDisplayTypeFactory service = cache.getService();
                if (service != null) {
                    SimpleDateFormat v = service.getDateFormat(displayType, language, pattern);
                    if (v != null) {
                        return v;
                    }
                } else {
                    s_displayTypeFactoryCache.remove(displayType);
                }
            }
            if (!s_customDisplayTypeNegativeCache.containsKey(customTypeKey = displayType + "|getDateFormat")) {
                Optional<IServiceReferenceHolder> found = DisplayType.getDisplayTypeFactories().stream().filter(e -> e.getService() != null && ((IDisplayTypeFactory)e.getService()).getDateFormat(displayType, language, pattern) != null).findFirst();
                if (found.isPresent()) {
                    s_displayTypeFactoryCache.put(displayType, found.get());
                    return ((IDisplayTypeFactory)found.get().getService()).getDateFormat(displayType, language, pattern);
                }
                s_customDisplayTypeNegativeCache.put(customTypeKey, Boolean.TRUE);
            }
        }
        if (!Util.isEmpty(lang.getDatePattern())) {
            return new SimpleDateFormat(lang.getDatePattern());
        }
        return myLanguage.getDateFormat();
    }

    private static SimpleDateFormat setTimeZone(SimpleDateFormat dateFormat) {
        TimeZone tz;
        String timezoneId = Env.getContext(Env.getCtx(), "#clientInfo_timeZone");
        if (!Util.isEmpty(timezoneId, true) && (tz = TimeZone.getTimeZone(timezoneId)) != null && timezoneId.equals(tz.getID())) {
            dateFormat = new SimpleDateFormat(dateFormat.toPattern());
            dateFormat.setTimeZone(tz);
        }
        return dateFormat;
    }

    public static SimpleDateFormat getDateFormat_JDBC() {
        return new SimpleDateFormat(DEFAULT_DATE_FORMAT);
    }

    public static SimpleDateFormat getTimestampFormat_Default() {
        return new SimpleDateFormat(DEFAULT_TIMESTAMP_FORMAT);
    }

    public static SimpleDateFormat getTimeFormat_Default() {
        return new SimpleDateFormat(DEFAULT_TIME_FORMAT);
    }

    public static Class<?> getClass(int displayType, boolean yesNoAsBoolean) {
        if (DisplayType.isText(displayType) || displayType == 17 || displayType == 200012 || displayType == 200152 || displayType == 200267) {
            return String.class;
        }
        if (DisplayType.isID(displayType) || displayType == 11) {
            return Integer.class;
        }
        if (DisplayType.isNumeric(displayType)) {
            return BigDecimal.class;
        }
        if (DisplayType.isDate(displayType)) {
            return Timestamp.class;
        }
        if (displayType == 20) {
            return yesNoAsBoolean ? Boolean.class : String.class;
        }
        if (displayType == 28) {
            return String.class;
        }
        if (DisplayType.isLOB(displayType)) {
            return byte[].class;
        }
        if (displayType > 999999) {
            String customTypeKey;
            IServiceReferenceHolder<IDisplayTypeFactory> cache = s_displayTypeFactoryCache.get(displayType);
            if (cache != null) {
                IDisplayTypeFactory service = cache.getService();
                if (service != null) {
                    Class<?> v = service.getClass(displayType, yesNoAsBoolean);
                    if (v != null) {
                        return v;
                    }
                } else {
                    s_displayTypeFactoryCache.remove(displayType);
                }
            }
            if (!s_customDisplayTypeNegativeCache.containsKey(customTypeKey = displayType + "|getClass")) {
                Optional<IServiceReferenceHolder> found = DisplayType.getDisplayTypeFactories().stream().filter(e -> e.getService() != null && ((IDisplayTypeFactory)e.getService()).getClass(displayType, yesNoAsBoolean) != null).findFirst();
                if (found.isPresent()) {
                    s_displayTypeFactoryCache.put(displayType, found.get());
                    return ((IDisplayTypeFactory)found.get().getService()).getClass(displayType, yesNoAsBoolean);
                }
                s_customDisplayTypeNegativeCache.put(customTypeKey, Boolean.TRUE);
            }
        }
        return Object.class;
    }

    private static final AdempiereDatabase getDatabase() {
        AdempiereDatabase db = DB.getDatabase();
        if (db.isNativeMode()) {
            return db;
        }
        return Database.getDatabase(Database.DB_ORACLE);
    }

    public static String getSQLDataType(int displayType, String columnName, int fieldLength) {
        String customTypeKey;
        if (columnName.equals("EntityType") || columnName.equals("AD_Language")) {
            return DisplayType.getDatabase().getVarcharDataType() + "(" + fieldLength + DisplayType.getDatabase().getVarcharLengthSuffix() + ")";
        }
        if (DisplayType.isID(displayType)) {
            if (displayType == 32 && columnName.equals("BinaryData")) {
                return DisplayType.getDatabase().getBlobDataType();
            }
            if (columnName.endsWith("_ID") || columnName.endsWith("_ID_To") || columnName.endsWith("tedBy") || columnName.endsWith("_Acct")) {
                return DisplayType.getDatabase().getNumericDataType() + "(10)";
            }
            if (fieldLength < 4) {
                return DisplayType.getDatabase().getCharacterDataType() + "(" + fieldLength + ")";
            }
            return DisplayType.getDatabase().getVarcharDataType() + "(" + fieldLength + DisplayType.getDatabase().getVarcharLengthSuffix() + ")";
        }
        if (displayType == 11) {
            return DisplayType.getDatabase().getNumericDataType() + "(10)";
        }
        if (DisplayType.isTimestampWithTimeZone(displayType)) {
            return DisplayType.getDatabase().getTimestampWithTimezoneDataType();
        }
        if (DisplayType.isDate(displayType)) {
            return DisplayType.getDatabase().getTimestampDataType();
        }
        if (DisplayType.isNumeric(displayType)) {
            return DisplayType.getDatabase().getNumericDataType();
        }
        if (displayType == 23) {
            return DisplayType.getDatabase().getBlobDataType();
        }
        if (displayType == 36 || displayType == 14 && (fieldLength == 0 || fieldLength >= 4000)) {
            return DisplayType.getDatabase().getClobDataType();
        }
        if (displayType == 20) {
            return DisplayType.getDatabase().getCharacterDataType() + "(1)";
        }
        if (displayType == 17 || displayType == 200012 || displayType == 200152) {
            if (fieldLength == 1) {
                return DisplayType.getDatabase().getCharacterDataType() + "(" + fieldLength + ")";
            }
            return DisplayType.getDatabase().getVarcharDataType() + "(" + fieldLength + DisplayType.getDatabase().getVarcharLengthSuffix() + ")";
        }
        if (displayType == 27) {
            return DisplayType.getDatabase().getVarcharDataType() + "(" + fieldLength + DisplayType.getDatabase().getVarcharLengthSuffix() + ")";
        }
        if (displayType == 28) {
            if (columnName.endsWith("_ID")) {
                return DisplayType.getDatabase().getNumericDataType() + "(10)";
            }
            return DisplayType.getDatabase().getCharacterDataType() + "(" + fieldLength + ")";
        }
        if (displayType == 200267) {
            return DisplayType.getDatabase().getJsonDataType();
        }
        IServiceReferenceHolder<IDisplayTypeFactory> cache = s_displayTypeFactoryCache.get(displayType);
        if (cache != null) {
            IDisplayTypeFactory service = cache.getService();
            if (service != null) {
                String v = service.getSQLDataType(displayType, columnName, fieldLength);
                if (v != null) {
                    return v;
                }
            } else {
                s_displayTypeFactoryCache.remove(displayType);
            }
        }
        if (!s_customDisplayTypeNegativeCache.containsKey(customTypeKey = displayType + "|getSQLDataType")) {
            Optional<IServiceReferenceHolder> found = DisplayType.getDisplayTypeFactories().stream().filter(e -> e.getService() != null && ((IDisplayTypeFactory)e.getService()).getSQLDataType(displayType, columnName, fieldLength) != null).findFirst();
            if (found.isPresent()) {
                s_displayTypeFactoryCache.put(displayType, found.get());
                return ((IDisplayTypeFactory)found.get().getService()).getSQLDataType(displayType, columnName, fieldLength);
            }
            s_customDisplayTypeNegativeCache.put(customTypeKey, Boolean.TRUE);
        }
        if (!DisplayType.isText(displayType)) {
            s_log.severe("Unhandled Data Type = " + displayType);
        }
        if (columnName.endsWith("_ID")) {
            return DisplayType.getDatabase().getNumericDataType() + "(10)";
        }
        return DisplayType.getDatabase().getVarcharDataType() + "(" + fieldLength + DisplayType.getDatabase().getVarcharLengthSuffix() + ")";
    }

    public static String getDescription(int displayType) {
        String customTypeKey;
        switch (displayType) {
            case 25: {
                return "Account";
            }
            case 12: {
                return "Amount";
            }
            case 33: {
                return "Assignment";
            }
            case 23: {
                return "Binary";
            }
            case 28: {
                return "Button";
            }
            case 53370: {
                return "Chart";
            }
            case 200161: {
                return "ChosenMultipleSelectionList";
            }
            case 200163: {
                return "ChosenMultipleSelectionSearch";
            }
            case 200162: {
                return "ChosenMultipleSelectionTable";
            }
            case 27: {
                return "Color";
            }
            case 37: {
                return "CostPrice";
            }
            case 200122: {
                return "DashboardContent";
            }
            case 15: {
                return "Date";
            }
            case 16: {
                return "DateTime";
            }
            case 39: {
                return "FileName";
            }
            case 38: {
                return "FilePath";
            }
            case 13: {
                return "ID";
            }
            case 32: {
                return "Image";
            }
            case 11: {
                return "Integer";
            }
            case 17: {
                return "List";
            }
            case 21: {
                return "Location";
            }
            case 31: {
                return "Locator";
            }
            case 34: {
                return "Memo";
            }
            case 200128: {
                return "MultipleSelectionGrid";
            }
            case 22: {
                return "Number";
            }
            case 35: {
                return "PAttribute";
            }
            case 200012: {
                return "Payment";
            }
            case 42: {
                return "PrinterName";
            }
            case 29: {
                return "Quantity";
            }
            case 200152: {
                return "RadiogroupList";
            }
            case 200202: {
                return "RecordID";
            }
            case 200240: {
                return "RecordUUID";
            }
            case 26: {
                return "RowID";
            }
            case 200173: {
                return "SchedulerState";
            }
            case 30: {
                return "Search";
            }
            case 200235: {
                return "SearchUU";
            }
            case 200127: {
                return "SingleSelectionGrid";
            }
            case 10: {
                return "String";
            }
            case 18: {
                return "Table";
            }
            case 19: {
                return "TableDir";
            }
            case 200234: {
                return "TableDirUU";
            }
            case 200233: {
                return "TableUU";
            }
            case 14: {
                return "Text";
            }
            case 36: {
                return "TextLong";
            }
            case 200267: {
                return "JSON";
            }
            case 24: {
                return "Time";
            }
            case 200133: {
                return "TimestampWithTimeZone";
            }
            case 200135: {
                return "TimeZoneId";
            }
            case 40: {
                return "URL";
            }
            case 200231: {
                return "UUID";
            }
            case 20: {
                return "YesNo";
            }
        }
        IServiceReferenceHolder<IDisplayTypeFactory> cache = s_displayTypeFactoryCache.get(displayType);
        if (cache != null) {
            IDisplayTypeFactory service = cache.getService();
            if (service != null) {
                String v = service.getDescription(displayType);
                if (v != null) {
                    return v;
                }
            } else {
                s_displayTypeFactoryCache.remove(displayType);
            }
        }
        if (!s_customDisplayTypeNegativeCache.containsKey(customTypeKey = displayType + "|getDescription")) {
            Optional<IServiceReferenceHolder> found = DisplayType.getDisplayTypeFactories().stream().filter(e -> e.getService() != null && ((IDisplayTypeFactory)e.getService()).getDescription(displayType) != null).findFirst();
            if (found.isPresent()) {
                s_displayTypeFactoryCache.put(displayType, found.get());
                return ((IDisplayTypeFactory)found.get().getService()).getDescription(displayType);
            }
            s_customDisplayTypeNegativeCache.put(customTypeKey, Boolean.TRUE);
        }
        return "UNKNOWN DisplayType=" + displayType;
    }

    public static NumberFormat getCurrencyFormat(String langcode, String currencyCode) {
        Locale locale = Language.getLocale(langcode);
        NumberFormat currencyFormatter = NumberFormat.getCurrencyInstance(locale);
        Currency currency = Currency.getInstance(currencyCode);
        currencyFormatter.setCurrency(currency);
        return currencyFormatter;
    }

    private static List<IServiceReferenceHolder<IDisplayTypeFactory>> getDisplayTypeFactories() {
        return Service.locator().list(IDisplayTypeFactory.class).getServiceReferences();
    }
}

