/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.base.event.EventManager;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.process.UUIDGenerator;
import org.compiere.Adempiere;
import org.compiere.acct.Doc;
import org.compiere.model.DocWorkflowMgr;
import org.compiere.model.I_C_ElementValue;
import org.compiere.model.Lookup;
import org.compiere.model.MAttachment;
import org.compiere.model.MChangeLog;
import org.compiere.model.MClient;
import org.compiere.model.MClientShare;
import org.compiere.model.MColumn;
import org.compiere.model.MElement;
import org.compiere.model.MMessage;
import org.compiere.model.MRecentItem;
import org.compiere.model.MRefList;
import org.compiere.model.MSequence;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MTableIndex;
import org.compiere.model.MTree_Base;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Null;
import org.compiere.model.POInfo;
import org.compiere.model.PO_LOB;
import org.compiere.model.Query;
import org.compiere.model.SystemProperties;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.SecureEngine;
import org.compiere.util.Trace;
import org.compiere.util.Trx;
import org.compiere.util.TrxEventListener;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.osgi.service.event.Event;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PO
implements Serializable,
Comparator<Object>,
Evaluatee,
Cloneable {
    private static final long serialVersionUID = 6591172659109078284L;
    public static final String UUID_NEW_RECORD = "";
    public static final String LOCAL_TRX_PREFIX = "POSave";
    private static final int QUERY_TIME_OUT = 300;
    private static DocWorkflowMgr s_docWFMgr = null;
    public static final String ENTITYTYPE_UserMaintained = "U";
    public static final String ENTITYTYPE_Dictionary = "D";
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    private static CLogger s_log = CLogger.getCLogger(PO.class);
    protected transient Properties p_ctx;
    protected volatile transient POInfo p_info = null;
    private Object[] m_oldValues = null;
    private Object[] m_newValues = null;
    private ValueNamePair[] m_setErrors = null;
    private boolean m_setErrorsFilled = false;
    private Object[] m_IDs = new Object[]{I_ZERO};
    private String[] m_KeyColumns = null;
    private boolean m_createNew = false;
    private MAttachment m_attachment = null;
    private int m_idOld = 0;
    private HashMap<String, String> m_custom = null;
    private HashMap<String, Object> m_attributes = null;
    protected static final Integer I_ZERO = 0;
    private ArrayList<String> s_acctColumns = null;
    private boolean m_isReplication = false;
    private boolean m_isImmutable = false;
    private String[] m_optimisticLockingColumns = new String[]{"Updated"};
    private Boolean m_useOptimisticLocking = null;
    private Set<Integer> loadedVirtualColumns = new HashSet<Integer>();
    public static final int ACCESSLEVEL_SYSTEM = 4;
    public static final int ACCESSLEVEL_CLIENT = 2;
    public static final int ACCESSLEVEL_ORG = 1;
    public static final int ACCESSLEVEL_ALL = 7;
    public static final int ACCESSLEVEL_SYSTEMCLIENT = 6;
    public static final int ACCESSLEVEL_CLIENTORG = 3;
    private static CCache<String, String> trl_cache = new CCache("PO_Trl", 5);
    private static CCache<Integer, List<ValueNamePair>> fks_cache = new CCache("FKs", 5);
    private String m_trxName = null;
    private ArrayList<PO_LOB> m_lobInfo = null;
    protected static final String XML_ATTRIBUTE_AD_Table_ID = "AD_Table_ID";
    protected static final String XML_ATTRIBUTE_Record_ID = "Record_ID";
    private Doc m_doc;
    private static ThreadLocal<Boolean> isSafeCrossTenant = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public static void setDocWorkflowMgr(DocWorkflowMgr docWFMgr) {
        s_docWFMgr = docWFMgr;
        s_log.config(s_docWFMgr.toString());
    }

    public PO(Properties ctx) {
        this(ctx, 0, (String)null, (ResultSet)null, (String[])null);
    }

    public PO(Properties ctx, int ID, String trxName) {
        this(ctx, ID, trxName, (ResultSet)null, (String[])null);
    }

    public PO(Properties ctx, String UUID2, String trxName) {
        this(ctx, UUID2, trxName, (ResultSet)null, (String[])null);
    }

    public PO(Properties ctx, int ID, String trxName, String ... virtualColumns) {
        this(ctx, ID, trxName, (ResultSet)null, virtualColumns);
    }

    public PO(Properties ctx, String UUID2, String trxName, String ... virtualColumns) {
        this(ctx, UUID2, trxName, (ResultSet)null, virtualColumns);
    }

    public PO(Properties ctx, ResultSet rs, String trxName) {
        this(ctx, 0, trxName, rs, new String[0]);
    }

    public PO(Properties ctx, int ID, String trxName, ResultSet rs, String ... virtualColumns) {
        this.p_ctx = ctx != null ? ctx : Env.getCtx();
        this.m_trxName = trxName;
        this.p_info = this.initPO(ctx);
        if (this.p_info == null || this.p_info.getTableName() == null) {
            throw new IllegalArgumentException("Invalid PO Info - " + String.valueOf(this.p_info));
        }
        int size = this.p_info.getColumnCount();
        this.m_oldValues = new Object[size];
        this.m_newValues = new Object[size];
        this.m_setErrors = new ValueNamePair[size];
        this.m_setErrorsFilled = false;
        if (rs != null) {
            this.load(rs);
        } else {
            this.load(ID, trxName, virtualColumns);
        }
        this.checkCrossTenant(false);
    }

    public PO(Properties ctx, String UUID2, String trxName, ResultSet rs, String ... virtualColumns) {
        this.p_ctx = ctx != null ? ctx : Env.getCtx();
        this.m_trxName = trxName;
        this.p_info = this.initPO(ctx);
        if (this.p_info == null || this.p_info.getTableName() == null) {
            throw new IllegalArgumentException("Invalid PO Info - " + String.valueOf(this.p_info));
        }
        int size = this.p_info.getColumnCount();
        this.m_oldValues = new Object[size];
        this.m_newValues = new Object[size];
        this.m_setErrors = new ValueNamePair[size];
        this.m_setErrorsFilled = false;
        if (rs != null) {
            this.load(rs);
        } else if (UUID2 != null && UUID2.length() == 0) {
            this.initNewRecord();
        } else {
            this.loadPO(UUID2, trxName, virtualColumns);
        }
        this.checkCrossTenant(false);
    }

    public PO(Properties ctx, PO source, int AD_Client_ID, int AD_Org_ID) {
        this(ctx, 0, null, null);
        if (source != null) {
            PO.copyValues(source, this);
        }
        this.setAD_Client_ID(AD_Client_ID);
        this.setAD_Org_ID(AD_Org_ID);
    }

    protected void copyPO(PO copy) {
        this.m_attachment = copy.m_attachment != null ? new MAttachment(copy.m_attachment) : null;
        this.m_attributes = copy.m_attributes != null ? new HashMap<String, Object>(copy.m_attributes) : null;
        this.m_createNew = copy.m_createNew;
        this.m_custom = copy.m_custom != null ? new HashMap<String, String>(copy.m_custom) : null;
        this.m_IDs = copy.m_IDs != null ? Arrays.copyOf(copy.m_IDs, copy.m_IDs.length) : null;
        this.m_KeyColumns = copy.m_KeyColumns != null ? Arrays.copyOf(copy.m_KeyColumns, copy.m_KeyColumns.length) : null;
        this.m_lobInfo = copy.m_lobInfo != null ? copy.m_lobInfo.stream().map(PO_LOB::new).collect(Collectors.toCollection(ArrayList::new)) : null;
        this.m_newValues = copy.m_newValues != null ? Arrays.copyOf(copy.m_newValues, copy.m_newValues.length) : null;
        this.m_oldValues = copy.m_oldValues != null ? Arrays.copyOf(copy.m_oldValues, copy.m_oldValues.length) : null;
        this.s_acctColumns = copy.s_acctColumns != null ? copy.s_acctColumns.stream().collect(Collectors.toCollection(ArrayList::new)) : null;
    }

    protected abstract POInfo initPO(Properties var1);

    protected abstract int get_AccessLevel();

    public String toString() {
        StringBuilder sb = new StringBuilder("PO[").append(this.get_WhereClause(true)).append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object cmp) {
        if (cmp == null) {
            return false;
        }
        if (!(cmp instanceof PO)) {
            return false;
        }
        if (cmp.getClass().equals(this.getClass())) {
            if (((PO)cmp).get_ID() == 0 && this.get_ID() == 0) {
                return super.equals(cmp);
            }
            return ((PO)cmp).get_ID() == this.get_ID();
        }
        return super.equals(cmp);
    }

    public int hashCode() {
        return 42;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (!(o1 instanceof PO)) {
            throw new ClassCastException("Not PO -1- " + String.valueOf(o1));
        }
        if (!(o2 instanceof PO)) {
            throw new ClassCastException("Not PO -2- " + String.valueOf(o2));
        }
        Collator collator = Collator.getInstance();
        if (o1.getClass().equals(o2.getClass())) {
            int index = this.get_ColumnIndex("DocumentNo");
            if (index == -1) {
                index = this.get_ColumnIndex("Value");
            }
            if (index == -1) {
                index = this.get_ColumnIndex("Name");
            }
            if (index == -1) {
                index = this.get_ColumnIndex("Description");
            }
            if (index != -1) {
                PO po1 = (PO)o1;
                Object comp1 = po1.get_Value(index);
                PO po2 = (PO)o2;
                Object comp2 = po2.get_Value(index);
                if (comp1 == null) {
                    return -1;
                }
                if (comp2 == null) {
                    return 1;
                }
                return collator.compare(comp1.toString(), comp2.toString());
            }
        }
        return collator.compare(o1.toString(), o2.toString());
    }

    public String get_TableName() {
        return this.p_info.getTableName();
    }

    public String[] get_KeyColumns() {
        return this.m_KeyColumns;
    }

    public int get_Table_ID() {
        return this.p_info.getAD_Table_ID();
    }

    public int get_ID() {
        Object oo = this.m_IDs[0];
        if (oo != null && oo instanceof Integer) {
            return (Integer)oo;
        }
        return 0;
    }

    public int get_IDOld() {
        return this.m_idOld;
    }

    public String get_UUID() {
        String uidColumn = this.getUUIDColumnName();
        if (this.p_info.getColumnIndex(uidColumn) >= 0) {
            return this.get_ValueAsString(uidColumn);
        }
        return null;
    }

    public Properties getCtx() {
        return this.p_ctx;
    }

    public CLogger get_Logger() {
        return this.log;
    }

    public final Object get_Value(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        if (this.m_newValues[index] != null) {
            if (this.m_newValues[index].equals(Null.NULL)) {
                return null;
            }
            return this.m_newValues[index];
        }
        if (this.p_info.isVirtualColumn(index) && this.p_info.isVirtualDBColumn(index)) {
            this.loadVirtualColumn(index);
        }
        return this.m_oldValues[index];
    }

    public int get_ValueAsInt(int index) {
        Object value = this.get_Value(index);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException ex) {
            this.log.warning(this.p_info.getColumnName(index) + " - " + ex.getMessage());
            return 0;
        }
    }

    public final Object get_Value(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + this.get_TableName() + "." + columnName);
            Trace.printStack();
            return null;
        }
        return this.get_Value(index);
    }

    protected final Object get_ValueE(String columnName) {
        return this.get_Value(columnName);
    }

    @Override
    public String get_ValueAsString(String columnName) {
        int idx = this.get_ColumnIndex(columnName);
        if (idx < 0) {
            return UUID_NEW_RECORD;
        }
        return this.get_ValueAsString(idx);
    }

    public String get_ValueAsString(int idx) {
        Object value = this.get_Value(idx);
        if (value == null) {
            return UUID_NEW_RECORD;
        }
        return value.toString();
    }

    public final Object get_ValueOfColumn(int AD_Column_ID) {
        int index = this.p_info.getColumnIndex(AD_Column_ID);
        if (index < 0) {
            this.log.log(Level.WARNING, "Not found - AD_Column_ID=" + AD_Column_ID);
            return null;
        }
        return this.get_Value(index);
    }

    public final Object get_ValueOld(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        return this.m_oldValues[index];
    }

    public final Object get_ValueOld(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + this.get_TableName() + "." + columnName);
            return null;
        }
        return this.get_ValueOld(index);
    }

    public int get_ValueOldAsInt(String columnName) {
        Object value = this.get_ValueOld(columnName);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException ex) {
            this.log.warning(columnName + " - " + ex.getMessage());
            return 0;
        }
    }

    public final boolean is_ValueChanged(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return false;
        }
        if (this.m_newValues[index] == null) {
            return false;
        }
        if (this.m_newValues[index] == Null.NULL && this.m_oldValues[index] == null) {
            return false;
        }
        return !this.m_newValues[index].equals(this.m_oldValues[index]);
    }

    public final boolean is_ValueChanged(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + this.get_TableName() + "." + columnName);
            return false;
        }
        return this.is_ValueChanged(index);
    }

    public final Object get_ValueDifference(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        Object nValue = this.m_newValues[index];
        if (nValue == null || nValue == Null.NULL) {
            return null;
        }
        Object oValue = this.m_oldValues[index];
        if (oValue == null || oValue == Null.NULL) {
            return nValue;
        }
        if (nValue instanceof BigDecimal) {
            BigDecimal obd = (BigDecimal)oValue;
            return ((BigDecimal)nValue).subtract(obd);
        }
        if (nValue instanceof Integer) {
            int result = (Integer)nValue;
            return result -= ((Integer)oValue).intValue();
        }
        this.log.warning("Invalid type - New=" + String.valueOf(nValue));
        return null;
    }

    public final Object get_ValueDifference(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + this.get_TableName() + "." + columnName);
            return null;
        }
        return this.get_ValueDifference(index);
    }

    protected final boolean set_Value(String ColumnName, Object value) {
        return this.set_Value(ColumnName, value, true);
    }

    protected final boolean set_Value(String ColumnName, Object value, boolean checkWritable) {
        Class<?> clazz;
        int index;
        this.checkImmutable();
        if (value instanceof String && ColumnName.equals("WhereClause") && value.toString().toUpperCase().indexOf("=NULL") != -1) {
            this.log.warning("Invalid Null Value - " + ColumnName + "=" + String.valueOf(value));
        }
        if ((index = this.get_ColumnIndex(ColumnName)) < 0) {
            this.log.log(Level.SEVERE, "Column not found - " + this.get_TableName() + "." + ColumnName);
            this.log.saveError("ColumnNotFound", this.get_TableName() + "." + ColumnName);
            return false;
        }
        if (ColumnName.endsWith("_ID") && value instanceof String && Integer.class == (clazz = this.p_info.getColumnClass(this.p_info.getColumnIndex(ColumnName)))) {
            this.log.severe("Invalid Data Type for " + ColumnName + "=" + String.valueOf(value));
            value = Integer.parseInt((String)value);
        }
        return this.set_Value(index, value, checkWritable);
    }

    protected final boolean set_ValueE(String ColumnName, Object value) {
        return this.set_Value(ColumnName, value);
    }

    protected final boolean set_Value(int index, Object value) {
        return this.set_Value(index, value, true);
    }

    protected final boolean set_Value(int index, Object value, boolean checkWritable) {
        this.checkImmutable();
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return false;
        }
        String ColumnName = this.p_info.getColumnName(index);
        String colInfo = " - " + ColumnName;
        this.m_setErrors[index] = null;
        if (checkWritable) {
            if (this.p_info.isVirtualColumn(index)) {
                this.log.log(Level.WARNING, "Virtual Column" + colInfo);
                this.log.saveError("VirtualColumn", "Virtual Column" + colInfo);
                this.m_setErrors[index] = new ValueNamePair("VirtualColumn", "Virtual Column" + colInfo);
                this.m_setErrorsFilled = true;
                return false;
            }
            if (!this.p_info.isColumnUpdateable(index) && !this.is_new()) {
                colInfo = colInfo + " - NewValue=" + String.valueOf(value) + " - OldValue=" + String.valueOf(this.get_Value(index));
                this.log.log(Level.WARNING, "Column not updateable" + colInfo);
                this.log.saveError("ColumnReadonly", "Column not updateable" + colInfo);
                this.m_setErrors[index] = new ValueNamePair("ColumnReadonly", "Column not updateable" + colInfo);
                this.m_setErrorsFilled = true;
                return false;
            }
        }
        if (value == null) {
            if (checkWritable && this.p_info.isColumnMandatory(index)) {
                this.log.saveError("FillMandatory", ColumnName);
                this.m_setErrors[index] = new ValueNamePair("FillMandatory", ColumnName);
                this.m_setErrorsFilled = true;
                return false;
            }
            this.m_newValues[index] = Null.NULL;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(ColumnName + " = null");
            }
        } else {
            if (value.getClass().equals(this.p_info.getColumnClass(index)) || this.p_info.getColumnClass(index) == Object.class) {
                this.m_newValues[index] = value;
            } else if (value.getClass() == BigDecimal.class && this.p_info.getColumnClass(index) == Integer.class) {
                this.m_newValues[index] = ((BigDecimal)value).intValue();
            } else if (this.p_info.getColumnClass(index) == Boolean.class && ("Y".equals(value) || "N".equals(value))) {
                this.m_newValues[index] = "Y".equals(value);
            } else if (value.getClass() == Integer.class && this.p_info.getColumnClass(index) == String.class) {
                this.m_newValues[index] = value;
            } else if (value.getClass() == String.class && this.p_info.getColumnClass(index) == Integer.class) {
                try {
                    this.m_newValues[index] = Integer.valueOf((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    String errmsg = ColumnName + " - Class invalid: " + value.getClass().toString() + ", Should be " + this.p_info.getColumnClass(index).toString() + ": " + String.valueOf(value);
                    this.log.log(Level.SEVERE, errmsg);
                    this.log.saveError("WrongDataType", errmsg);
                    this.m_setErrors[index] = new ValueNamePair("WrongDataType", errmsg);
                    this.m_setErrorsFilled = true;
                    return false;
                }
            } else {
                String errmsg = ColumnName + " - Class invalid: " + value.getClass().toString() + ", Should be " + this.p_info.getColumnClass(index).toString() + ": " + String.valueOf(value);
                this.log.log(Level.SEVERE, errmsg);
                this.log.saveError("WrongDataType", errmsg);
                this.m_setErrors[index] = new ValueNamePair("WrongDataType", errmsg);
                this.m_setErrorsFilled = true;
                return false;
            }
            String error = this.p_info.validate(index, value);
            if (error != null) {
                this.log.log(Level.WARNING, ColumnName + "=" + String.valueOf(value) + " - " + error);
                int separatorIndex = error.indexOf(";");
                if (separatorIndex > 0) {
                    this.log.saveError(error.substring(0, separatorIndex), error.substring(separatorIndex + 1));
                    this.m_setErrors[index] = new ValueNamePair(error.substring(0, separatorIndex), error.substring(separatorIndex + 1));
                } else {
                    this.log.saveError(error, ColumnName);
                    this.m_setErrors[index] = new ValueNamePair(error, ColumnName);
                }
                this.m_setErrorsFilled = true;
                return false;
            }
            if (this.p_info.getColumnClass(index) == String.class) {
                String stringValue = value.toString();
                int length = this.p_info.getFieldLength(index);
                if (stringValue.length() > length && length > 0) {
                    this.log.warning(ColumnName + " - Value too long - truncated to length=" + length);
                    this.m_newValues[index] = stringValue.substring(0, length);
                }
            }
            if (this.p_info.getColumn((int)index).DisplayType == 17 && this.p_info.getColumn((int)index).AD_Reference_Value_ID > 0 && value instanceof String && MRefList.get(this.getCtx(), this.p_info.getColumn((int)index).AD_Reference_Value_ID, (String)value, this.get_TrxName()) == null) {
                StringBuilder validValues = new StringBuilder();
                ValueNamePair[] valueNamePairArray = MRefList.getList(this.getCtx(), this.p_info.getColumn((int)index).AD_Reference_Value_ID, false);
                int n = valueNamePairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ValueNamePair vp = valueNamePairArray[n2];
                    validValues.append(" - ").append(vp.getValue());
                    ++n2;
                }
                String errmsg = ColumnName + " Invalid value - " + String.valueOf(value) + " - Reference_ID=" + this.p_info.getColumn((int)index).AD_Reference_Value_ID + validValues.toString();
                this.log.saveError("Validate", errmsg);
                this.m_setErrors[index] = new ValueNamePair("Validate", errmsg);
                this.m_setErrorsFilled = true;
                return false;
            }
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(ColumnName + " = " + String.valueOf(this.m_newValues[index]) + " (OldValue=" + String.valueOf(this.m_oldValues[index]) + ")");
            }
        }
        this.set_Keys(ColumnName, this.m_newValues[index]);
        this.setProcessedOn(ColumnName, value, this.m_oldValues[index]);
        return true;
    }

    public void setProcessedOn(String ColumnName, Object value, Object oldValue) {
        this.checkImmutable();
        if ("Processed".equals(ColumnName) && value instanceof Boolean && ((Boolean)value).booleanValue() && (oldValue == null || oldValue instanceof Boolean && !((Boolean)oldValue).booleanValue()) && this.get_ColumnIndex("ProcessedOn") > 0) {
            Timestamp ts = DB.getSQLValueTS(null, "SELECT CURRENT_TIMESTAMP FROM DUAL", new Object[0]);
            long mili = ts.getTime();
            int nano = ts.getNanos();
            double doublets = Double.parseDouble(Long.toString(mili) + "." + Integer.toString(nano));
            BigDecimal bdtimestamp = BigDecimal.valueOf(doublets);
            this.set_Value("ProcessedOn", (Object)bdtimestamp);
        }
    }

    public final boolean set_ValueNoCheck(String ColumnName, Object value) {
        return this.set_Value(ColumnName, value, false);
    }

    protected final boolean set_ValueNoCheckE(String ColumnName, Object value) {
        return this.set_ValueNoCheck(ColumnName, value);
    }

    public final void set_ValueOfColumn(String columnName, Object value) {
        this.set_ValueOfColumnReturningBoolean(columnName, value);
    }

    public final boolean set_ValueOfColumnReturningBoolean(String columnName, Object value) {
        int AD_Column_ID = this.p_info.getAD_Column_ID(columnName);
        if (AD_Column_ID > 0) {
            return this.set_ValueOfColumnReturningBoolean(AD_Column_ID, value);
        }
        return false;
    }

    public final void set_ValueOfColumn(int AD_Column_ID, Object value) {
        this.set_ValueOfColumnReturningBoolean(AD_Column_ID, value);
    }

    public final boolean set_ValueOfColumnReturningBoolean(int AD_Column_ID, Object value) {
        int index = this.p_info.getColumnIndex(AD_Column_ID);
        if (index < 0) {
            throw new AdempiereUserError("Not found - AD_Column_ID=" + AD_Column_ID);
        }
        String ColumnName = this.p_info.getColumnName(index);
        if (ColumnName.equals("IsApproved")) {
            return this.set_ValueNoCheck(ColumnName, value);
        }
        return this.set_Value(index, value);
    }

    public final void set_CustomColumn(String columnName, Object value) {
        this.set_CustomColumnReturningBoolean(columnName, value);
    }

    public final boolean set_CustomColumnReturningBoolean(String columnName, Object value) {
        this.checkImmutable();
        int poIndex = this.get_ColumnIndex(columnName);
        if (poIndex > 0) {
            return this.set_Value(columnName, value);
        }
        if (this.m_custom == null) {
            this.m_custom = new HashMap();
        }
        String valueString = "NULL";
        if (value != null) {
            valueString = value instanceof Number ? value.toString() : (value instanceof Boolean ? ((Boolean)value != false ? "'Y'" : "'N'") : (value instanceof Timestamp ? DB.TO_DATE((Timestamp)value, false) : DB.TO_STRING(value.toString())));
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.log(Level.INFO, columnName + "=" + valueString);
        }
        this.m_custom.put(columnName, valueString);
        return true;
    }

    private void set_Keys(String ColumnName, Object value) {
        this.checkImmutable();
        int i = 0;
        while (i < this.m_IDs.length) {
            if (ColumnName.equals(this.m_KeyColumns[i])) {
                this.m_IDs[i] = value;
            }
            ++i;
        }
    }

    public int get_ColumnCount() {
        return this.p_info.getColumnCount();
    }

    public String get_ColumnName(int index) {
        return this.p_info.getColumnName(index);
    }

    protected String get_ColumnLabel(int index) {
        return this.p_info.getColumnLabel(index);
    }

    protected String get_ColumnDescription(int index) {
        return this.p_info.getColumnDescription(index);
    }

    protected boolean isColumnMandatory(int index) {
        return this.p_info.isColumnMandatory(index);
    }

    protected boolean isColumnUpdateable(int index) {
        return this.p_info.isColumnUpdateable(index);
    }

    protected void set_ColumnUpdateable(int index, boolean updateable) {
        this.p_info.setColumnUpdateable(index, updateable);
    }

    protected void setUpdateable(boolean updateable) {
        this.p_info.setUpdateable(updateable);
    }

    protected int get_ColumnDisplayType(int index) {
        return this.p_info.getColumnDisplayType(index);
    }

    protected Lookup get_ColumnLookup(int index) {
        return this.p_info.getColumnLookup(index);
    }

    public final int get_ColumnIndex(String columnName) {
        return this.p_info.getColumnIndex(columnName);
    }

    public String get_DisplayValue(String columnName, boolean currentValue) {
        Object value;
        Object object = value = currentValue ? this.get_Value(columnName) : this.get_ValueOld(columnName);
        if (value == null) {
            return "./.";
        }
        String retValue = value.toString();
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            return retValue;
        }
        int dt = this.get_ColumnDisplayType(index);
        if (DisplayType.isText(dt) || 20 == dt) {
            return retValue;
        }
        Lookup lookup = this.get_ColumnLookup(index);
        if (lookup != null) {
            return lookup.getDisplay(value);
        }
        return retValue;
    }

    protected static void copyValues(PO from, PO to, int AD_Client_ID, int AD_Org_ID) {
        PO.copyValues(from, to);
        to.setAD_Client_ID(AD_Client_ID);
        to.setAD_Org_ID(AD_Org_ID);
    }

    public static void copyValues(PO from, PO to) {
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("From ID=" + from.get_ID() + " - To ID=" + to.get_ID());
        }
        if (from.getClass() != to.getClass()) {
            int i1 = 0;
            while (i1 < from.m_oldValues.length) {
                String colName = from.p_info.getColumnName(i1);
                MColumn column = MColumn.get(from.getCtx(), from.p_info.getAD_Column_ID(colName));
                if (!(column.isVirtualColumn() || column.isKey() || column.isUUIDColumn() || column.isStandardColumn() || !column.isAllowCopy())) {
                    int i2 = 0;
                    while (i2 < to.m_oldValues.length) {
                        if (to.p_info.getColumnName(i2).equals(colName)) {
                            to.m_newValues[i2] = from.m_oldValues[i1];
                            break;
                        }
                        ++i2;
                    }
                }
                ++i1;
            }
        } else {
            int i = 0;
            while (i < from.m_oldValues.length) {
                String colName = from.p_info.getColumnName(i);
                MColumn column = MColumn.get(from.getCtx(), from.p_info.getAD_Column_ID(colName));
                if (!(column.isVirtualColumn() || column.isKey() || column.isUUIDColumn() || column.isStandardColumn() || !column.isAllowCopy())) {
                    to.m_newValues[i] = from.m_oldValues[i];
                }
                ++i;
            }
        }
    }

    protected void load(int ID, String trxName, String ... virtualColumns) {
        this.checkImmutable();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("ID=" + ID);
        }
        if (ID > 0) {
            this.setKeyInfo();
            this.m_IDs = new Object[]{ID};
            this.load(trxName, virtualColumns);
        } else {
            this.initNewRecord();
        }
    }

    private void initNewRecord() {
        this.loadDefaults();
        this.m_createNew = true;
        this.setKeyInfo();
        this.loadComplete(true);
    }

    public void loadByUU(String uuID, String trxName, String ... virtualColumns) {
        if (Util.isEmpty(uuID, true)) {
            throw new IllegalArgumentException("Invalid null or blank UU - Must pass valid UU");
        }
        this.m_newValues = new Object[this.get_ColumnCount()];
        this.checkImmutable();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("uuID=" + uuID);
        }
        this.loadPO(uuID, trxName, virtualColumns);
    }

    public boolean load(String trxName, String ... virtualColumns) {
        return this.loadPO(null, trxName, virtualColumns);
    }

    protected boolean loadPO(String uuID, String trxName, String ... virtualColumns) {
        boolean success;
        block27: {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("UU=" + uuID);
            }
            this.m_trxName = trxName;
            success = true;
            StringBuilder sql = new StringBuilder("SELECT ");
            int size = this.get_ColumnCount();
            int i = 0;
            while (i < size) {
                block30: {
                    String columnSQL;
                    block29: {
                        block28: {
                            columnSQL = this.p_info.getColumnSQL(i);
                            if (!this.p_info.isVirtualColumn(i)) break block28;
                            boolean lazyLoad = true;
                            if (virtualColumns != null) {
                                String[] stringArray = virtualColumns;
                                int n = virtualColumns.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String virtualColumn = stringArray[n2];
                                    if (this.p_info.getColumnName(i).equalsIgnoreCase(virtualColumn)) {
                                        lazyLoad = false;
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            if (!lazyLoad) break block29;
                            break block30;
                        }
                        columnSQL = DB.getDatabase().quoteColumnName(columnSQL);
                    }
                    if (i != 0) {
                        sql.append(",");
                    }
                    sql.append(columnSQL);
                }
                ++i;
            }
            sql.append(" FROM ").append(this.p_info.getTableName()).append(" WHERE ").append(this.get_WhereClause(false, uuID));
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(this.get_WhereClause(true, uuID));
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.m_trxName);
                    if (!Util.isEmpty(uuID, true)) {
                        pstmt.setString(1, uuID);
                    } else {
                        int i2 = 0;
                        while (i2 < this.m_IDs.length) {
                            Object oo = this.m_IDs[i2];
                            if (oo instanceof Integer) {
                                pstmt.setInt(i2 + 1, (Integer)this.m_IDs[i2]);
                            } else if (oo instanceof Boolean) {
                                pstmt.setString(i2 + 1, (Boolean)this.m_IDs[i2] != false ? "Y" : "N");
                            } else if (oo instanceof Timestamp) {
                                pstmt.setTimestamp(i2 + 1, (Timestamp)this.m_IDs[i2]);
                            } else {
                                pstmt.setString(i2 + 1, this.m_IDs[i2].toString());
                            }
                            ++i2;
                        }
                    }
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        success = this.load(rs);
                    } else {
                        this.log.log(Level.SEVERE, "NO Data found for " + this.get_WhereClause(true, uuID), new Exception());
                        this.m_IDs = new Object[]{I_ZERO};
                        success = false;
                    }
                    this.m_createNew = false;
                    this.m_newValues = new Object[size];
                }
                catch (Exception e) {
                    Object msg = UUID_NEW_RECORD;
                    if (this.m_trxName != null) {
                        msg = "[" + this.m_trxName + "] - ";
                    }
                    msg = (String)msg + this.get_WhereClause(true, uuID) + ", SQL=" + sql.toString();
                    success = false;
                    this.m_IDs = new Object[]{I_ZERO};
                    this.log.log(Level.SEVERE, (String)msg, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    if (this.is_Immutable()) {
                        this.m_trxName = null;
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                if (this.is_Immutable()) {
                    this.m_trxName = null;
                }
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (this.is_Immutable()) {
                this.m_trxName = null;
            }
        }
        this.loadComplete(success);
        return success;
    }

    protected boolean load(ResultSet rs) {
        int size = this.get_ColumnCount();
        boolean success = true;
        int index = 0;
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("(rs)");
        }
        this.loadedVirtualColumns.clear();
        index = 0;
        while (index < size) {
            if (!this.loadColumn(rs, index) && success) {
                success = false;
            }
            ++index;
        }
        this.m_createNew = false;
        this.setKeyInfo();
        this.loadComplete(success);
        return success;
    }

    private boolean loadColumn(ResultSet rs, int index) {
        Optional<String> optional;
        boolean success = true;
        String columnName = this.p_info.getColumnName(index);
        String[] selectColumns = MTable.getPartialPOResultSetColumns();
        if (selectColumns != null && selectColumns.length > 0 && !this.p_info.isColumnAlwaysLoadedForPartialPO(index) && !(optional = Arrays.stream(selectColumns).filter(e -> e.equalsIgnoreCase(columnName)).findFirst()).isPresent()) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "Partial PO, Column not loaded: " + columnName);
            }
            return true;
        }
        Class<?> clazz = this.p_info.getColumnClass(index);
        int dt = this.p_info.getColumnDisplayType(index);
        try {
            if (clazz == Integer.class) {
                this.m_oldValues[index] = this.decrypt(index, rs.getInt(columnName));
            } else if (clazz == BigDecimal.class) {
                this.m_oldValues[index] = this.decrypt(index, rs.getBigDecimal(columnName));
            } else if (clazz == Boolean.class) {
                this.m_oldValues[index] = "Y".equals(this.decrypt(index, rs.getString(columnName)));
            } else if (clazz == Timestamp.class) {
                this.m_oldValues[index] = this.decrypt(index, rs.getTimestamp(columnName));
            } else if (DisplayType.isLOB(dt)) {
                this.m_oldValues[index] = this.get_LOB(rs.getObject(columnName));
            } else if (clazz == String.class) {
                String value = (String)this.decrypt(index, rs.getString(columnName));
                if (value != null && (this.get_Table_ID() == 101 || this.get_Table_ID() == 276 || this.get_Table_ID() == 107) && ("Description".equals(columnName) || "Help".equals(columnName))) {
                    value = value.intern();
                }
                this.m_oldValues[index] = value;
            } else {
                this.m_oldValues[index] = this.loadSpecial(rs, index);
            }
            if (rs.wasNull() && this.m_oldValues[index] != null) {
                this.m_oldValues[index] = null;
            }
            if (this.p_info.isVirtualColumn(index)) {
                this.loadedVirtualColumns.add(index);
            }
            if (CLogMgt.isLevelAll()) {
                this.log.finest(String.valueOf(index) + ": " + this.p_info.getColumnName(index) + "(" + String.valueOf(this.p_info.getColumnClass(index)) + ") = " + String.valueOf(this.m_oldValues[index]));
            }
        }
        catch (SQLException e2) {
            if (this.p_info.isVirtualColumn(index)) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.log(Level.FINER, "Virtual Column not loaded: " + columnName);
                }
            }
            this.log.log(Level.SEVERE, "(rs) - " + String.valueOf(index) + ": " + this.p_info.getTableName() + "." + this.p_info.getColumnName(index) + " (" + String.valueOf(this.p_info.getColumnClass(index)) + ") - " + String.valueOf(e2));
            success = false;
        }
        return success;
    }

    private void loadVirtualColumn(int index) {
        block7: {
            if (!this.m_createNew && !this.loadedVirtualColumns.contains(index)) {
                StringBuilder sql = new StringBuilder("SELECT ").append(this.p_info.getColumnSQL(index)).append(" FROM ").append(this.p_info.getTableName()).append(" WHERE ").append(this.get_WhereClause(true, null));
                ResultSet rs = null;
                CPreparedStatement pstmt = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql.toString(), this.m_trxName);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.loadColumn(rs, index);
                        }
                        this.loadedVirtualColumns.add(index);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "(rs) - " + String.valueOf(index) + ": " + this.p_info.getTableName() + "." + this.p_info.getColumnName(index) + " (" + String.valueOf(this.p_info.getColumnClass(index)) + ") - " + String.valueOf(e));
                        DB.close(rs, pstmt);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
        }
    }

    protected boolean load(HashMap<String, String> hmIn) {
        this.checkImmutable();
        int size = this.get_ColumnCount();
        boolean success = true;
        int index = 0;
        this.log.finest("(hm)");
        index = 0;
        while (index < size) {
            String columnName = this.p_info.getColumnName(index);
            String value = hmIn.get(columnName);
            if (value != null) {
                Class<?> clazz = this.p_info.getColumnClass(index);
                int dt = this.p_info.getColumnDisplayType(index);
                try {
                    this.m_oldValues[index] = clazz == Integer.class ? Integer.valueOf(value) : (clazz == BigDecimal.class ? new BigDecimal(value) : (clazz == Boolean.class ? Boolean.valueOf("Y".equals(value)) : (clazz == Timestamp.class ? Timestamp.valueOf(value) : (DisplayType.isLOB(dt) ? null : (clazz == String.class ? value : null)))));
                    if (CLogMgt.isLevelAll()) {
                        this.log.finest(String.valueOf(index) + ": " + this.p_info.getColumnName(index) + "(" + String.valueOf(this.p_info.getColumnClass(index)) + ") = " + String.valueOf(this.m_oldValues[index]));
                    }
                }
                catch (Exception e) {
                    if (this.p_info.isVirtualColumn(index)) {
                        if (this.log.isLoggable(Level.FINER)) {
                            this.log.log(Level.FINER, "Virtual Column not loaded: " + columnName);
                        }
                    }
                    this.log.log(Level.SEVERE, "(ht) - " + String.valueOf(index) + ": " + this.p_info.getTableName() + "." + this.p_info.getColumnName(index) + " (" + String.valueOf(this.p_info.getColumnClass(index)) + ") - " + String.valueOf(e));
                    success = false;
                }
            }
            ++index;
        }
        this.m_createNew = false;
        this.setStandardDefaults();
        this.setKeyInfo();
        this.loadComplete(success);
        return success;
    }

    protected void checkImmutable() {
        if (this.is_Immutable()) {
            throw new IllegalStateException("PO is Immutable: " + this.getClass().getName());
        }
    }

    protected HashMap<String, String> get_HashMap() {
        HashMap<String, String> hmOut = new HashMap<String, String>();
        int size = this.get_ColumnCount();
        int i = 0;
        while (i < size) {
            Object value = this.get_Value(i);
            if (value != null && !this.p_info.isVirtualColumn(i)) {
                int dt = this.p_info.getColumnDisplayType(i);
                Class<?> c = this.p_info.getColumnClass(i);
                String stringValue = null;
                if (c != Object.class && value != null && !value.equals(Null.NULL)) {
                    if (value instanceof Integer || value instanceof BigDecimal) {
                        stringValue = value.toString();
                    } else if (c == Boolean.class) {
                        boolean bValue = false;
                        bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                        stringValue = bValue ? "Y" : "N";
                    } else if (value instanceof Timestamp) {
                        stringValue = value.toString();
                    } else if (c == String.class) {
                        stringValue = (String)value;
                    } else if (DisplayType.isLOB(dt)) {
                        // empty if block
                    }
                }
                if (stringValue != null) {
                    hmOut.put(this.p_info.getColumnName(i), stringValue);
                }
            }
            ++i;
        }
        if (this.m_custom != null) {
            for (String column : this.m_custom.keySet()) {
                String value = this.m_custom.get(column);
                if (value == null) continue;
                hmOut.put(column, value);
            }
            this.m_custom = null;
        }
        return hmOut;
    }

    protected Object loadSpecial(ResultSet rs, int index) throws SQLException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("(NOP) - " + this.p_info.getColumnName(index));
        }
        return null;
    }

    protected void loadComplete(boolean success) {
    }

    protected void loadDefaults() {
        this.setStandardDefaults();
    }

    protected void setStandardDefaults() {
        int size = this.get_ColumnCount();
        int i = 0;
        while (i < size) {
            if (!this.p_info.isVirtualColumn(i)) {
                String colName = this.p_info.getColumnName(i);
                if (colName.endsWith("tedBy")) {
                    this.m_newValues[i] = Env.getContextAsInt(this.p_ctx, "#AD_User_ID");
                } else if (colName.equals("Created") || colName.equals("Updated")) {
                    this.m_newValues[i] = new Timestamp(System.currentTimeMillis());
                } else if (colName.equals(this.p_info.getTableName() + "_ID")) {
                    this.m_newValues[i] = I_ZERO;
                } else if (colName.equals("IsActive")) {
                    this.m_newValues[i] = Boolean.TRUE;
                } else if (colName.equals("AD_Client_ID")) {
                    this.m_newValues[i] = Env.getAD_Client_ID(this.p_ctx);
                } else if (colName.equals("AD_Org_ID")) {
                    this.m_newValues[i] = Env.getAD_Org_ID(this.p_ctx);
                } else if (colName.equals("Processed")) {
                    this.m_newValues[i] = Boolean.FALSE;
                } else if (colName.equals("Processing")) {
                    this.m_newValues[i] = Boolean.FALSE;
                } else if (colName.equals("Posted")) {
                    this.m_newValues[i] = Boolean.FALSE;
                }
            }
            ++i;
        }
    }

    private void setKeyInfo() {
        int i;
        int i2 = 0;
        while (i2 < this.p_info.getColumnCount()) {
            if (this.p_info.isKey(i2)) {
                String ColumnName = this.p_info.getColumnName(i2);
                this.m_KeyColumns = new String[]{ColumnName};
                if (this.p_info.getColumnName(i2).endsWith("_ID")) {
                    Integer ii = (Integer)this.get_Value(i2);
                    this.m_IDs = ii == null ? new Object[]{I_ZERO} : new Object[]{ii};
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("(PK) " + ColumnName + "=" + String.valueOf(ii));
                    }
                } else {
                    Object oo = this.get_Value(i2);
                    this.m_IDs = oo == null ? new Object[1] : new Object[]{oo};
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("(PK) " + ColumnName + "=" + String.valueOf(oo));
                    }
                }
                return;
            }
            ++i2;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        int i3 = 0;
        while (i3 < this.p_info.getColumnCount()) {
            if (this.p_info.isColumnParent(i3)) {
                columnNames.add(this.p_info.getColumnName(i3));
            }
            ++i3;
        }
        int size = columnNames.size();
        if (size > 0) {
            this.m_IDs = new Object[size];
            this.m_KeyColumns = new String[size];
            i = 0;
            while (i < size) {
                this.m_KeyColumns[i] = (String)columnNames.get(i);
                if (this.m_KeyColumns[i].endsWith("_ID")) {
                    Integer ii = null;
                    try {
                        ii = (Integer)this.get_Value(this.m_KeyColumns[i]);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, UUID_NEW_RECORD, e);
                    }
                    if (ii != null) {
                        this.m_IDs[i] = ii;
                    }
                } else {
                    this.m_IDs[i] = this.get_Value(this.m_KeyColumns[i]);
                }
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("(FK) " + this.m_KeyColumns[i] + "=" + String.valueOf(this.m_IDs[i]));
                }
                ++i;
            }
        }
        if (this.m_KeyColumns == null || this.m_KeyColumns.length == 0) {
            i = 0;
            while (i < this.p_info.getColumnCount()) {
                String ColumnName = this.p_info.getColumnName(i);
                if (ColumnName.equals(PO.getUUIDColumnName(this.get_TableName()))) {
                    this.m_KeyColumns = new String[]{ColumnName};
                    Object oo = this.get_Value(i);
                    this.m_IDs = oo == null ? new Object[1] : new Object[]{oo};
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("(UU) " + ColumnName + "=" + String.valueOf(oo));
                    }
                    return;
                }
                ++i;
            }
        }
        if (this.m_KeyColumns == null || this.m_KeyColumns.length == 0) {
            throw new IllegalStateException("No PK, UU nor FK - " + this.p_info.getTableName());
        }
    }

    protected boolean isMandatoryOK() {
        int size = this.get_ColumnCount();
        int i = 0;
        while (i < size) {
            if (this.p_info.isColumnMandatory(i) && !this.p_info.isVirtualColumn(i) && (this.get_Value(i) == null || this.get_Value(i).equals(Null.NULL))) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info(this.p_info.getColumnName(i));
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    protected final void setAD_Client_ID(int AD_Client_ID) {
        this.set_ValueNoCheck("AD_Client_ID", AD_Client_ID);
    }

    public final int getAD_Client_ID() {
        Integer ii = (Integer)this.get_Value("AD_Client_ID");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    public final void setAD_Org_ID(int AD_Org_ID) {
        this.set_ValueNoCheck("AD_Org_ID", AD_Org_ID);
    }

    public int getAD_Org_ID() {
        Integer ii = (Integer)this.get_Value("AD_Org_ID");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    protected void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        if (AD_Client_ID != this.getAD_Client_ID()) {
            this.setAD_Client_ID(AD_Client_ID);
        }
        if (AD_Org_ID != this.getAD_Org_ID()) {
            this.setAD_Org_ID(AD_Org_ID);
        }
    }

    protected void setClientOrg(PO po) {
        this.setClientOrg(po.getAD_Client_ID(), po.getAD_Org_ID());
    }

    public final void setIsActive(boolean active) {
        this.set_Value("IsActive", (Object)active);
    }

    public final boolean isActive() {
        Boolean bb = (Boolean)this.get_Value("IsActive");
        if (bb != null) {
            return bb;
        }
        return false;
    }

    public final Timestamp getCreated() {
        return (Timestamp)this.get_Value("Created");
    }

    public final Timestamp getUpdated() {
        return (Timestamp)this.get_Value("Updated");
    }

    public final int getCreatedBy() {
        Integer ii = (Integer)this.get_Value("CreatedBy");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    public final int getUpdatedBy() {
        Integer ii = (Integer)this.get_Value("UpdatedBy");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    protected final void setUpdatedBy(int AD_User_ID) {
        this.set_ValueNoCheck("UpdatedBy", AD_User_ID);
    }

    public String get_Translation(String columnName, String AD_Language) {
        return this.get_Translation(columnName, AD_Language, false, true);
    }

    public String get_Translation(String columnName, String AD_Language, boolean reload, boolean fallback) {
        if (columnName == null || AD_Language == null || this.m_IDs.length > 1 || this.m_IDs[0] instanceof Integer && this.m_IDs[0].equals(I_ZERO) && !MTable.isZeroIDTable(this.get_TableName()) || this.m_IDs[0] instanceof String && Util.isEmpty((String)this.m_IDs[0]) || !(this.m_IDs[0] instanceof Integer) && !(this.m_IDs[0] instanceof String)) {
            throw new IllegalArgumentException("ColumnName=" + columnName + ", AD_Language=" + AD_Language + ", ID.length=" + this.m_IDs.length + ", ID=" + String.valueOf(this.m_IDs[0]));
        }
        String key = this.getTrlCacheKey(columnName, AD_Language);
        String retValue = null;
        if (!reload && trl_cache.containsKey(key)) {
            retValue = trl_cache.get(key);
            return retValue;
        }
        if (!Env.isBaseLanguage(AD_Language, this.get_TableName()) && this.p_info.isColumnTranslated(this.p_info.getColumnIndex(columnName))) {
            int ID = (Integer)this.m_IDs[0];
            StringBuilder sql = new StringBuilder("SELECT ").append(columnName).append(" FROM ").append(this.p_info.getTableName()).append("_Trl WHERE ").append(this.m_KeyColumns[0]).append("=?").append(" AND AD_Language=?");
            retValue = DB.getSQLValueString(this.get_TrxName(), sql.toString(), ID, AD_Language);
        }
        if (retValue == null && fallback) {
            Object val = this.get_Value(columnName);
            retValue = val != null ? val.toString() : null;
        }
        trl_cache.put(key, retValue);
        return retValue;
    }

    private String getTrlCacheKey(String columnName, String AD_Language) {
        return this.get_TableName() + "." + columnName + "|" + this.get_ID() + "|" + AD_Language;
    }

    public String get_Translation(String columnName) {
        return this.get_Translation(columnName, true);
    }

    public String get_Translation(String columnName, String AD_Language, boolean reload) {
        return this.get_Translation(columnName, AD_Language, reload, true);
    }

    public String get_Translation(String columnName, boolean fallback) {
        return this.get_Translation(columnName, Env.getAD_Language(this.getCtx()), false, fallback);
    }

    public boolean is_new() {
        if (this.m_createNew) {
            return true;
        }
        int i = 0;
        while (i < this.m_IDs.length) {
            if (!this.m_IDs[i].equals(I_ZERO) && this.m_IDs[i] != Null.NULL) {
                return false;
            }
            ++i;
        }
        return !MTable.isZeroIDTable(this.get_TableName());
    }

    public boolean save() {
        CLogger.resetLast();
        boolean newRecord = this.is_new();
        if (!newRecord && !this.is_Changed()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Nothing changed - " + this.p_info.getTableName());
            }
            return true;
        }
        this.checkImmutable();
        this.checkValidContext();
        this.checkCrossTenant(true);
        this.checkRecordIDCrossTenant();
        this.checkRecordUUCrossTenant();
        if (this.m_setErrorsFilled) {
            int i = 0;
            while (i < this.m_setErrors.length) {
                ValueNamePair setError = this.m_setErrors[i];
                if (setError != null) {
                    this.log.saveError(setError.getValue(), Msg.getElement(this.getCtx(), this.p_info.getColumnName(i)) + " - " + setError.getName());
                    return false;
                }
                ++i;
            }
        }
        Trx localTrx = null;
        Trx trx = null;
        Savepoint savepoint = null;
        if (this.m_trxName == null) {
            StringBuilder l_trxname = new StringBuilder(LOCAL_TRX_PREFIX).append(this.get_TableName());
            if (l_trxname.length() > 23) {
                l_trxname.setLength(23);
            }
            this.m_trxName = Trx.createTrxName(l_trxname.toString());
            localTrx = Trx.get(this.m_trxName, true);
            if (newRecord) {
                localTrx.setDisplayName(this.getClass().getName() + "_insert");
            } else {
                localTrx.setDisplayName(this.getClass().getName() + "_update_ID" + this.get_ID());
            }
            localTrx.getConnection();
        } else {
            trx = Trx.get(this.m_trxName, false);
            if (trx == null) {
                trx = Trx.get(this.m_trxName, true);
                this.log.severe("Transaction closed or never opened (" + this.m_trxName + ") => starting now --> " + this.toString());
            }
        }
        try {
            if (localTrx == null) {
                savepoint = trx.setSavepoint(null);
            }
            if (!this.beforeSave(newRecord)) {
                this.log.warning("beforeSave failed - " + this.toString());
                if (localTrx != null) {
                    localTrx.rollback();
                    localTrx.close();
                    this.m_trxName = null;
                } else {
                    trx.rollback(savepoint);
                    savepoint = null;
                }
                return false;
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "beforeSave - " + this.toString(), e);
            String msg = DBException.getDefaultDBExceptionMessage(e);
            this.log.saveError(msg != null ? msg : "Error", e, false);
            if (localTrx != null) {
                localTrx.rollback();
                localTrx.close();
                this.m_trxName = null;
            } else if (savepoint != null) {
                try {
                    trx.rollback(savepoint);
                }
                catch (SQLException sQLException) {}
                savepoint = null;
            }
            return false;
        }
        try {
            boolean b2;
            String errorMsg = ModelValidationEngine.get().fireModelChange(this, newRecord ? 1 : 2);
            if (errorMsg != null) {
                this.log.warning("Validation failed - " + errorMsg);
                this.log.saveError("Error", errorMsg);
                if (localTrx != null) {
                    localTrx.rollback();
                    this.m_trxName = null;
                } else {
                    trx.rollback(savepoint);
                }
                return false;
            }
            if (this.getAD_Org_ID() == 0 && (this.get_AccessLevel() == 1 || this.get_AccessLevel() == 3 && MClientShare.isOrgLevelOnly(this.getAD_Client_ID(), this.get_Table_ID()))) {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "AD_Org_ID"));
                return false;
            }
            if (this.getAD_Org_ID() != 0) {
                boolean reset;
                boolean bl = reset = this.get_AccessLevel() == 4;
                if (!reset && MClientShare.isClientLevelOnly(this.getAD_Client_ID(), this.get_Table_ID())) {
                    boolean bl2 = reset = this.get_AccessLevel() == 2 || this.get_AccessLevel() == 6 || this.get_AccessLevel() == 7 || this.get_AccessLevel() == 3;
                }
                if (reset) {
                    this.log.warning("Set Org to 0");
                    this.setAD_Org_ID(0);
                }
            }
            if (newRecord) {
                b2 = this.saveNew();
                if (b2) {
                    if (localTrx != null) {
                        boolean bl = localTrx.commit();
                        return bl;
                    }
                    boolean bl = b2;
                    return bl;
                }
                this.validateUniqueIndex();
                if (localTrx != null) {
                    localTrx.rollback();
                } else {
                    trx.rollback(savepoint);
                }
                boolean bl = b2;
                return bl;
            }
            b2 = this.saveUpdate();
            if (b2) {
                if (localTrx != null) {
                    boolean bl = localTrx.commit();
                    return bl;
                }
                boolean bl = b2;
                return bl;
            }
            this.validateUniqueIndex();
            if (localTrx != null) {
                localTrx.rollback();
            } else {
                trx.rollback(savepoint);
            }
            boolean bl = b2;
            return bl;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "afterSave - " + this.toString(), e);
            String msg = DBException.getDefaultDBExceptionMessage(e);
            this.log.saveError(msg != null ? msg : "Error", e);
            if (localTrx != null) {
                localTrx.rollback();
            } else if (savepoint != null) {
                try {
                    trx.rollback(savepoint);
                }
                catch (SQLException sQLException) {}
                savepoint = null;
            }
            return false;
        }
        finally {
            if (localTrx != null) {
                localTrx.close();
                this.m_trxName = null;
            } else {
                if (savepoint != null) {
                    try {
                        trx.releaseSavepoint(savepoint);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                savepoint = null;
                trx = null;
            }
        }
    }

    public void saveEx() throws AdempiereException {
        if (!this.save()) {
            String val;
            Object msg = null;
            ValueNamePair err = CLogger.retrieveError();
            String string = val = err != null ? Msg.translate(this.getCtx(), err.getValue()) : UUID_NEW_RECORD;
            if (err != null) {
                msg = (String)(val != null ? val + ": " : UUID_NEW_RECORD) + err.getName();
            }
            if (msg == null || ((String)msg).length() == 0) {
                msg = "SaveError";
            }
            Exception ex = CLogger.retrieveException();
            throw new AdempiereException((String)msg, ex);
        }
    }

    public boolean saveCrossTenantSafe() {
        boolean crossTenantSet = isSafeCrossTenant.get();
        try {
            if (!crossTenantSet) {
                PO.setCrossTenantSafe();
            }
            boolean bl = this.save();
            return bl;
        }
        finally {
            if (!crossTenantSet) {
                PO.clearCrossTenantSafe();
            }
        }
    }

    public void saveCrossTenantSafeEx() {
        boolean crossTenantSet = isSafeCrossTenant.get();
        try {
            if (!crossTenantSet) {
                PO.setCrossTenantSafe();
            }
            this.saveEx();
        }
        finally {
            if (!crossTenantSet) {
                PO.clearCrossTenantSafe();
            }
        }
    }

    private boolean saveFinish(final boolean newRecord, boolean success) {
        if (success) {
            if (newRecord) {
                this.insertTranslations();
            } else {
                this.updateTranslations();
            }
            if (this.get_ColumnIndex("IsSummary") >= 0) {
                if (newRecord && this.getTable().hasCustomTree()) {
                    this.insert_Tree("TL");
                }
                int idxValue = this.get_ColumnIndex("Value");
                if (this.getTable().hasCustomTree() && (newRecord || idxValue >= 0 && this.is_ValueChanged(idxValue))) {
                    this.update_Tree("TL");
                }
            }
        }
        try {
            success = this.afterSave(newRecord, success);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "afterSave", e);
            this.log.saveError("Error", e, false);
            success = false;
        }
        if (success) {
            String errorMsg = ModelValidationEngine.get().fireModelChange(this, newRecord ? (this.isReplication() ? 7 : 4) : (this.isReplication() ? 8 : 5));
            this.setReplication(false);
            if (errorMsg != null) {
                this.log.saveError("Error", errorMsg);
                success = false;
            }
        }
        if (success) {
            String topic = newRecord ? "adempiere/po/postCreate" : "adempiere/po/postUpdate";
            Event event = EventManager.newEvent(topic, this, true);
            EventManager.getInstance().postEvent(event);
            if (s_docWFMgr == null) {
                try {
                    Class.forName("org.compiere.wf.DocWorkflowManager");
                }
                catch (Exception exception) {}
            }
            if (s_docWFMgr != null) {
                s_docWFMgr.process(this, this.p_info.getAD_Table_ID());
            }
            int size = this.p_info.getColumnCount();
            int i = 0;
            while (i < size) {
                if (this.m_newValues[i] != null) {
                    this.m_oldValues[i] = this.m_newValues[i] == Null.NULL ? null : this.m_newValues[i];
                }
                ++i;
            }
            this.m_newValues = new Object[size];
            this.m_createNew = false;
        }
        if (!newRecord) {
            MRecentItem.clearLabel(this.p_info.getAD_Table_ID(), this.get_ID(), this.get_UUID());
        }
        if (CacheMgt.get().hasCache(this.p_info.getTableName())) {
            Trx trx;
            boolean cacheResetScheduled = false;
            if (this.get_TrxName() != null && (trx = Trx.get(this.get_TrxName(), false)) != null) {
                trx.addTrxEventListener(new TrxEventListener(){

                    @Override
                    public void afterRollback(Trx trx2, boolean success) {
                        trx2.removeTrxEventListener(this);
                    }

                    @Override
                    public void afterCommit(Trx sav, boolean success) {
                        if (success) {
                            if (!newRecord) {
                                Adempiere.getThreadPoolExecutor().submit(() -> CacheMgt.get().reset(PO.this.p_info.getTableName(), PO.this.get_ID()));
                            } else if (PO.this.get_ID() > 0) {
                                Adempiere.getThreadPoolExecutor().submit(() -> CacheMgt.get().newRecord(PO.this.p_info.getTableName(), PO.this.get_ID()));
                            }
                        }
                        trx.removeTrxEventListener(this);
                    }

                    @Override
                    public void afterClose(Trx trx2) {
                    }
                });
                cacheResetScheduled = true;
            }
            if (!cacheResetScheduled) {
                if (!newRecord) {
                    Adempiere.getThreadPoolExecutor().submit(() -> CacheMgt.get().reset(this.p_info.getTableName(), this.get_ID()));
                } else if (this.get_ID() > 0) {
                    Adempiere.getThreadPoolExecutor().submit(() -> CacheMgt.get().newRecord(this.p_info.getTableName(), this.get_ID()));
                }
            }
        }
        return success;
    }

    private MTable getTable() {
        return MTable.get(this.getCtx(), this.get_TableName());
    }

    public boolean save(String trxName) {
        this.set_TrxName(trxName);
        return this.save();
    }

    public void saveReplica(boolean isFromReplication) throws AdempiereException {
        this.checkImmutable();
        this.setReplication(isFromReplication);
        this.saveEx();
    }

    public void saveCrossTenantSafeEx(String trxName) {
        boolean crossTenantSet = isSafeCrossTenant.get();
        try {
            if (!crossTenantSet) {
                PO.setCrossTenantSafe();
            }
            this.saveEx(trxName);
        }
        finally {
            if (!crossTenantSet) {
                PO.clearCrossTenantSafe();
            }
        }
    }

    public void saveEx(String trxName) throws AdempiereException {
        this.set_TrxName(trxName);
        this.saveEx();
    }

    public boolean is_Changed() {
        int size = this.get_ColumnCount();
        int i = 0;
        while (i < size) {
            if (this.is_ValueChanged(i)) {
                return true;
            }
            ++i;
        }
        return this.m_custom != null && this.m_custom.size() > 0;
    }

    protected boolean beforeSave(boolean newRecord) {
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        return success;
    }

    protected boolean saveUpdate() {
        boolean ok = this.doUpdate(this.isLogSQLScript());
        return this.saveFinish(false, ok);
    }

    private boolean isLogSQLScript() {
        return Env.isLogMigrationScript(this.p_info.getTableName());
    }

    private boolean doUpdate(boolean withValues) {
        ArrayList<Object> params = new ArrayList<Object>();
        String where = withValues && this.get_ID() > 999999 ? this.get_WhereClause(true, this.get_ValueAsString(this.getUUIDColumnName())) : this.get_WhereClause(true);
        ArrayList<Object> optimisticLockingParams = new ArrayList<Object>();
        if (this.is_UseOptimisticLocking() && this.m_optimisticLockingColumns != null && this.m_optimisticLockingColumns.length > 0) {
            StringBuilder builder = new StringBuilder(where);
            this.addOptimisticLockingClause(optimisticLockingParams, builder);
            where = builder.toString();
        }
        boolean changes = false;
        StringBuilder sql = new StringBuilder("UPDATE ");
        sql.append(this.p_info.getTableName()).append(" SET ");
        boolean updated = false;
        boolean updatedBy = false;
        this.lobReset();
        MSession session = MSession.get(this.p_ctx);
        if (session == null) {
            this.log.fine("No Session found");
        }
        int AD_ChangeLog_ID = 0;
        int uuidIndex = this.p_info.getColumnIndex(this.getUUIDColumnName());
        if (uuidIndex >= 0) {
            String value = (String)this.get_Value(uuidIndex);
            if (this.p_info.getColumn((int)uuidIndex).FieldLength == 36 && (value == null || value.length() == 0)) {
                UUID uuid = UUID.randomUUID();
                this.set_ValueNoCheck(this.p_info.getColumnName(uuidIndex), uuid.toString());
            }
        }
        int size = this.get_ColumnCount();
        int i = 0;
        while (i < size) {
            block85: {
                String columnName;
                int dt;
                Class<?> c;
                Object value;
                block87: {
                    block86: {
                        value = this.m_newValues[i];
                        if (value == null || this.p_info.isVirtualColumn(i)) break block85;
                        c = this.p_info.getColumnClass(i);
                        dt = this.p_info.getColumnDisplayType(i);
                        columnName = this.p_info.getColumnName(i);
                        if (!columnName.equals("UpdatedBy")) break block86;
                        if (updatedBy) break block85;
                        updatedBy = true;
                        break block87;
                    }
                    if (!columnName.equals("Updated")) break block87;
                    if (updated) break block85;
                    updated = true;
                }
                if (DisplayType.isLOB(dt)) {
                    this.lobAdd(value, i, dt);
                    if (!changes && !updatedBy) {
                        int AD_User_ID = Env.getContextAsInt(this.p_ctx, "#AD_User_ID");
                        this.set_ValueNoCheck("UpdatedBy", AD_User_ID);
                        sql.append("UpdatedBy=").append(AD_User_ID);
                        changes = true;
                        updatedBy = true;
                    }
                } else {
                    if (columnName.equals("DocumentNo")) {
                        String strValue = (String)value;
                        if (strValue.startsWith("<") && strValue.endsWith(">")) {
                            value = null;
                            int AD_Client_ID = this.getAD_Client_ID();
                            int index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
                            if (index == -1) {
                                index = this.p_info.getColumnIndex("C_DocType_ID");
                            }
                            if (index != -1) {
                                value = DB.getDocumentNo(this.get_ValueAsInt(index), this.m_trxName, false, this);
                            }
                            if (value == null) {
                                value = DB.getDocumentNo(AD_Client_ID, this.p_info.getTableName(), this.m_trxName, this);
                            }
                        } else if (this.log.isLoggable(Level.INFO)) {
                            this.log.info("DocumentNo updated: " + String.valueOf(this.m_oldValues[i]) + " -> " + String.valueOf(value));
                        }
                    }
                    if (changes) {
                        sql.append(", ");
                    }
                    changes = true;
                    sql.append(DB.getDatabase().quoteColumnName(columnName)).append("=");
                    if (withValues) {
                        if (value == Null.NULL) {
                            sql.append("NULL");
                        } else if (value instanceof Integer && XML_ATTRIBUTE_Record_ID.equalsIgnoreCase(columnName)) {
                            Integer idValue = (Integer)value;
                            if (idValue <= 999999) {
                                sql.append(value);
                            } else if (this.p_info.getColumnIndex(XML_ATTRIBUTE_AD_Table_ID) >= 0) {
                                int tableId = this.get_ValueAsInt(XML_ATTRIBUTE_AD_Table_ID);
                                if (tableId > 0) {
                                    MTable refTable = MTable.get(Env.getCtx(), tableId);
                                    String refTableName = refTable.getTableName();
                                    refKeyColumnName = refTable.getKeyColumns()[0];
                                    refUUColumnName = MTable.getUUIDColumnName(refTableName);
                                    refUUValue = DB.getSQLValueString(this.get_TrxName(), "SELECT " + refUUColumnName + " FROM " + refTableName + " WHERE " + refKeyColumnName + "=?", (Integer)value);
                                    sql.append("toRecordId('" + refTableName + "','" + refUUValue + "')");
                                } else {
                                    sql.append(value);
                                }
                            } else {
                                sql.append(value);
                            }
                        } else if (value instanceof Integer && this.p_info.isColumnLookup(i)) {
                            Integer idValue = (Integer)value;
                            if (idValue <= 999999) {
                                sql.append(value);
                            } else {
                                MColumn col = MColumn.get(this.p_info.getAD_Column_ID(columnName));
                                String refTableName = col.getReferenceTableName();
                                MTable refTable = MTable.get(Env.getCtx(), refTableName);
                                refKeyColumnName = refTable.getKeyColumns()[0];
                                refUUColumnName = MTable.getUUIDColumnName(refTableName);
                                refUUValue = DB.getSQLValueString(this.get_TrxName(), "SELECT " + refUUColumnName + " FROM " + refTableName + " WHERE " + refKeyColumnName + "=?", (Integer)value);
                                sql.append("toRecordId('" + refTableName + "','" + refUUValue + "')");
                            }
                        } else if (value instanceof Integer || value instanceof BigDecimal) {
                            sql.append(value);
                        } else if (c == Boolean.class) {
                            boolean bValue = false;
                            bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                            sql.append(this.encrypt(i, bValue ? "'Y'" : "'N'"));
                        } else if (value instanceof Timestamp) {
                            sql.append(DB.TO_DATE((Timestamp)this.encrypt(i, value), this.p_info.getColumnDisplayType(i) == 15));
                        } else if (value.toString().length() == 0) {
                            sql.append(DB.TO_STRING(value.toString()));
                        } else {
                            sql.append(this.encrypt(i, DB.TO_STRING(value.toString())));
                        }
                    } else {
                        if (value instanceof Timestamp && dt == 15) {
                            sql.append("trunc(cast(? as date))");
                        } else if (dt == 200267) {
                            sql.append(DB.getJSONCast());
                        } else {
                            sql.append("?");
                        }
                        if (value == Null.NULL) {
                            params.add(null);
                        } else if (c == Boolean.class) {
                            boolean bValue = false;
                            bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                            params.add(this.encrypt(i, bValue ? "Y" : "N"));
                        } else if (c == String.class) {
                            if (value.toString().length() == 0) {
                                params.add(null);
                            } else {
                                params.add(this.encrypt(i, value));
                            }
                        } else {
                            params.add(value);
                        }
                    }
                    if (!(session == null || !this.p_info.isAllowLogging(i) || this.p_info.isEncrypted(i) || this.p_info.isVirtualColumn(i) || "Password".equals(columnName) || session.isSkipChangeLogForUpdate(this.get_TableName()))) {
                        MChangeLog cLog;
                        Object oldV = this.m_oldValues[i];
                        Object newV = value;
                        if (oldV != null && oldV == Null.NULL) {
                            oldV = null;
                        }
                        if (newV != null && newV == Null.NULL) {
                            newV = null;
                        }
                        if ((cLog = session.changeLog(this.m_trxName, AD_ChangeLog_ID, this.p_info.getAD_Table_ID(), this.p_info.getColumn((int)i).AD_Column_ID, this.m_IDs.length == 1 ? this.get_ID() : 0, this.get_UUID(), this.getAD_Client_ID(), this.getAD_Org_ID(), oldV, newV, ENTITYTYPE_UserMaintained)) != null) {
                            AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
                        }
                    }
                }
            }
            ++i;
        }
        if (this.m_custom != null) {
            Iterator<String> it = this.m_custom.keySet().iterator();
            while (it.hasNext()) {
                if (changes) {
                    sql.append(", ");
                }
                changes = true;
                String column = it.next();
                String value = this.m_custom.get(column);
                int index = this.p_info.getColumnIndex(column);
                if (withValues) {
                    sql.append(column).append("=").append(this.encrypt(index, value));
                    continue;
                }
                sql.append(column).append("=?");
                if (value == null || value.toString().length() == 0) {
                    params.add(null);
                    continue;
                }
                params.add(this.encrypt(index, value));
            }
            this.m_custom = null;
        }
        if (changes) {
            boolean ok;
            if (this.m_trxName == null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.p_info.getTableName() + "." + where);
                }
            } else if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("[" + this.m_trxName + "] - " + this.p_info.getTableName() + "." + where);
            }
            if (!updated) {
                Timestamp now = new Timestamp(System.currentTimeMillis());
                this.set_ValueNoCheck("Updated", now);
                if (withValues) {
                    sql.append(",Updated=").append(DB.TO_DATE(now, false));
                } else {
                    sql.append(",Updated=?");
                    params.add(now);
                }
            }
            if (!updatedBy) {
                int AD_User_ID = Env.getContextAsInt(this.p_ctx, "#AD_User_ID");
                this.set_ValueNoCheck("UpdatedBy", AD_User_ID);
                if (withValues) {
                    sql.append(",UpdatedBy=").append(AD_User_ID);
                } else {
                    sql.append(",UpdatedBy=?");
                    params.add(AD_User_ID);
                }
            }
            sql.append(" WHERE ").append(where);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(sql.toString());
            }
            if (this.is_UseOptimisticLocking() && optimisticLockingParams.size() > 0) {
                params.addAll(optimisticLockingParams);
            }
            int no = 0;
            no = this.isUseTimeoutForUpdate() ? (withValues ? DB.executeUpdateEx(sql.toString(), this.m_trxName, 300) : DB.executeUpdateEx(sql.toString(), params.toArray(), this.m_trxName, 300)) : (withValues ? DB.executeUpdate(sql.toString(), this.m_trxName) : DB.executeUpdate(sql.toString(), params.toArray(), false, this.m_trxName));
            boolean bl = ok = no == 1;
            if (ok) {
                ok = this.lobSave();
            } else if (CLogger.peekError() == null) {
                if (this.m_trxName == null) {
                    this.log.saveError("SaveError", "Update return " + no + " instead of 1 - " + this.p_info.getTableName() + "." + where);
                } else {
                    this.log.saveError("SaveError", "Update return " + no + " instead of 1 - [" + this.m_trxName + "] - " + this.p_info.getTableName() + "." + where);
                }
            } else {
                Object msg = "Not updated - ";
                msg = CLogMgt.isLevelFiner() ? (String)msg + sql.toString() : (String)msg + this.get_TableName();
                if (this.m_trxName == null) {
                    this.log.log(Level.WARNING, (String)msg);
                } else {
                    this.log.log(Level.WARNING, "[" + this.m_trxName + "]" + (String)msg);
                }
            }
            return ok;
        }
        return true;
    }

    private void addOptimisticLockingClause(List<Object> optimisticLockingParams, StringBuilder where) {
        String[] stringArray = this.m_optimisticLockingColumns;
        int n = this.m_optimisticLockingColumns.length;
        int n2 = 0;
        while (n2 < n) {
            String oc = stringArray[n2];
            int index = this.get_ColumnIndex(oc);
            if (index >= 0) {
                Class<?> c = this.p_info.getColumnClass(index);
                int dt = this.p_info.getColumnDisplayType(index);
                if (!DisplayType.isLOB(dt)) {
                    Object value = this.get_ValueOld(oc);
                    if (value == null) {
                        where.append(" AND ").append(oc).append(" IS NULL ");
                    } else if (value instanceof Timestamp) {
                        if (dt == 15) {
                            where.append(" AND ").append(oc).append(" = trunc(cast(? as date))");
                        } else {
                            where.append(" AND ").append(oc).append(" = ? ");
                        }
                        optimisticLockingParams.add(value);
                    } else if (c == Boolean.class) {
                        where.append(" AND ").append(oc).append(" = ? ");
                        boolean bValue = false;
                        bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                        optimisticLockingParams.add(this.encrypt(index, bValue ? "Y" : "N"));
                    } else if (c == String.class) {
                        if (value.toString().length() == 0) {
                            where.append(" AND ").append(oc).append(" = '' ");
                        } else {
                            where.append(" AND ").append(oc).append(" = ? ");
                            optimisticLockingParams.add(this.encrypt(index, value));
                        }
                    } else {
                        where.append(" AND ").append(oc).append(" = ? ");
                        optimisticLockingParams.add(value);
                    }
                }
            }
            ++n2;
        }
    }

    public boolean is_UseOptimisticLocking() {
        if (this.m_useOptimisticLocking != null) {
            return this.m_useOptimisticLocking;
        }
        return SystemProperties.isOptimisticLocking();
    }

    public void set_UseOptimisticLocking(boolean enable) {
        this.m_useOptimisticLocking = enable;
    }

    public String[] get_OptimisticLockingColumns() {
        return this.m_optimisticLockingColumns;
    }

    public void set_OptimisticLockingColumns(String[] columns) {
        this.m_optimisticLockingColumns = columns;
    }

    private boolean isUseTimeoutForUpdate() {
        return SystemProperties.isUseTimeoutForUpdate() && DB.getDatabase().isQueryTimeoutSupported();
    }

    private boolean saveNew() {
        String value;
        String columnName;
        int index;
        int uuidIndex;
        if (this.m_IDs.length == 1 && this.p_info.hasKeyColumn() && this.m_KeyColumns[0].endsWith("_ID") && (Env.isUseCentralizedId(this.p_info.getTableName()) || !this.isLogSQLScript())) {
            int no = this.saveNew_getID();
            if (no <= 0) {
                no = DB.getNextID(this.getAD_Client_ID(), this.p_info.getTableName(), this.m_trxName);
            }
            if (this.isReplication() && this.get_ID() > 0) {
                no = this.get_ID();
            }
            if (no <= 0) {
                this.log.severe("No NextID (" + no + ")");
                return this.saveFinish(true, false);
            }
            this.m_IDs[0] = no;
            this.set_ValueNoCheck(this.m_KeyColumns[0], this.m_IDs[0]);
            this.saveNew_afterSetID();
        }
        if ((uuidIndex = this.p_info.getColumnIndex(this.getUUIDColumnName())) >= 0) {
            String value2 = (String)this.get_Value(uuidIndex);
            if (this.p_info.getColumn((int)uuidIndex).FieldLength == 36 && (value2 == null || value2.length() == 0)) {
                UUID uuid = UUID.randomUUID();
                this.set_ValueNoCheck(this.p_info.getColumnName(uuidIndex), uuid.toString());
            }
        }
        if (this.m_trxName == null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.p_info.getTableName() + " - " + this.get_WhereClause(true));
            }
        } else if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("[" + this.m_trxName + "] - " + this.p_info.getTableName() + " - " + this.get_WhereClause(true));
        }
        if ((index = this.p_info.getColumnIndex(columnName = "DocumentNo")) != -1) {
            value = (String)this.get_Value(index);
            if (value != null && value.startsWith("<") && value.endsWith(">")) {
                value = null;
            }
            if (value == null || value.length() == 0) {
                int dt = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
                if (dt == -1) {
                    dt = this.p_info.getColumnIndex("C_DocType_ID");
                }
                if (dt != -1) {
                    value = DB.getDocumentNo(this.get_ValueAsInt(dt), this.m_trxName, false, this);
                }
                if (value == null) {
                    value = DB.getDocumentNo(this.getAD_Client_ID(), this.p_info.getTableName(), this.m_trxName, this);
                }
                this.set_ValueNoCheck(columnName, value);
            }
        }
        if (!("M_AttributeInstance".equals(this.get_TableName()) || (index = this.p_info.getColumnIndex(columnName = "Value")) == -1 || this.p_info.isVirtualColumn(index) || (value = (String)this.get_Value(index)) != null && value.length() != 0)) {
            value = DB.getDocumentNo(this.getAD_Client_ID(), this.p_info.getTableName(), this.m_trxName, this);
            this.set_ValueNoCheck(columnName, value);
        }
        boolean ok = this.doInsert(this.isLogSQLScript());
        return this.saveFinish(true, ok);
    }

    private boolean doInsert(boolean withValues) {
        boolean ok;
        this.lobReset();
        MSession session = MSession.get(this.p_ctx);
        if (session == null) {
            this.log.fine("No Session found");
        }
        int AD_ChangeLog_ID = 0;
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sqlInsert = new StringBuilder();
        AD_ChangeLog_ID = this.buildInsertSQL(sqlInsert, withValues, params, session, AD_ChangeLog_ID, false);
        int no = withValues ? DB.executeUpdate(sqlInsert.toString(), this.m_trxName) : DB.executeUpdate(sqlInsert.toString(), params.toArray(), false, this.m_trxName);
        boolean bl = ok = no == 1;
        if (ok) {
            if (withValues && this.m_IDs.length == 1 && this.p_info.hasKeyColumn() && this.m_KeyColumns[0].endsWith("_ID") && !Env.isUseCentralizedId(this.p_info.getTableName())) {
                StringBuilder sql = new StringBuilder("SELECT ").append(this.m_KeyColumns[0]).append(" FROM ").append(this.p_info.getTableName()).append(" WHERE ").append(this.getUUIDColumnName()).append("=?");
                int id = DB.getSQLValueEx(this.get_TrxName(), sql.toString(), this.get_ValueAsString(this.getUUIDColumnName()));
                this.m_IDs[0] = id;
                this.set_ValueNoCheck(this.m_KeyColumns[0], this.m_IDs[0]);
            }
            if (withValues && !Env.isUseCentralizedId(this.p_info.getTableName())) {
                int ki = this.p_info.getColumnIndex(this.m_KeyColumns[0]);
                String insertLog = MSysConfig.getValue("SYSTEM_INSERT_CHANGELOG", "N", this.getAD_Client_ID());
                if (session != null && this.p_info.isAllowLogging(ki) && !this.p_info.isEncrypted(ki) && !this.p_info.isVirtualColumn(ki) && !"Password".equals(this.p_info.getColumnName(ki)) && (insertLog.equalsIgnoreCase("Y") || insertLog.equalsIgnoreCase("K") && (this.p_info.getColumn((int)ki).IsKey || !this.p_info.hasKeyColumn() && this.p_info.getColumn((int)ki).ColumnName.equals(PO.getUUIDColumnName(this.p_info.getTableName()))))) {
                    int id = this.m_IDs.length == 1 ? this.get_ID() : 0;
                    MChangeLog cLog = session.changeLog(this.m_trxName, AD_ChangeLog_ID, this.p_info.getAD_Table_ID(), this.p_info.getColumn((int)ki).AD_Column_ID, this.m_IDs.length == 1 ? this.get_ID() : 0, this.get_UUID(), this.getAD_Client_ID(), this.getAD_Org_ID(), null, id == 0 ? this.get_UUID() : Integer.valueOf(id), "I");
                    if (cLog != null) {
                        AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
                    }
                }
            }
            ok = this.lobSave();
            if (!this.load(this.m_trxName, new String[0])) {
                if (this.m_trxName == null) {
                    this.log.log(Level.SEVERE, "reloading");
                } else {
                    this.log.log(Level.SEVERE, "[" + this.m_trxName + "] - reloading");
                }
                ok = false;
            }
        } else {
            Object msg = "Not inserted - ";
            msg = CLogMgt.isLevelFiner() ? (String)msg + sqlInsert.toString() : (String)msg + this.get_TableName();
            if (this.m_trxName == null) {
                this.log.log(Level.WARNING, (String)msg);
            } else {
                this.log.log(Level.WARNING, "[" + this.m_trxName + "]" + (String)msg);
            }
        }
        return ok;
    }

    public String toInsertSQL() {
        StringBuilder sqlInsert = new StringBuilder();
        this.buildInsertSQL(sqlInsert, true, null, null, 0, true);
        return sqlInsert.toString();
    }

    protected int buildInsertSQL(StringBuilder sqlInsert, boolean withValues, List<Object> params, MSession session, int AD_ChangeLog_ID, boolean generateScriptOnly) {
        sqlInsert.append("INSERT INTO ");
        sqlInsert.append(this.p_info.getTableName()).append(" (");
        StringBuilder sqlValues = new StringBuilder(") VALUES (");
        int size = this.get_ColumnCount();
        boolean doComma = false;
        int i = 0;
        while (i < size) {
            block54: {
                int dt;
                Object value;
                block55: {
                    value = this.get_Value(i);
                    if (value == null || this.p_info.isVirtualColumn(i)) break block54;
                    dt = this.p_info.getColumnDisplayType(i);
                    if (!DisplayType.isLOB(dt)) break block55;
                    this.lobAdd(value, i, dt);
                    if (!this.p_info.isColumnMandatory(i)) break block54;
                }
                if (!generateScriptOnly || !this.p_info.isEncrypted(i) && !this.p_info.isSecure(i) && !"Password".equalsIgnoreCase(this.p_info.getColumnName(i))) {
                    if (doComma) {
                        sqlInsert.append(",");
                        sqlValues.append(",");
                    } else {
                        doComma = true;
                    }
                    sqlInsert.append(DB.getDatabase().quoteColumnName(this.p_info.getColumnName(i)));
                    Class<?> c = this.p_info.getColumnClass(i);
                    if (withValues) {
                        try {
                            String refUUValue;
                            String refUUColumnName;
                            String refKeyColumnName;
                            if (this.m_IDs.length == 1 && this.p_info.hasKeyColumn() && this.m_KeyColumns[0].endsWith("_ID") && this.m_KeyColumns[0].equals(this.p_info.getColumnName(i)) && (generateScriptOnly || !Env.isUseCentralizedId(this.p_info.getTableName()))) {
                                if (generateScriptOnly && this.get_ID() > 0 && this.get_ID() <= 999999) {
                                    sqlValues.append(value);
                                }
                                MSequence sequence = MSequence.get(Env.getCtx(), this.p_info.getTableName(), this.get_TrxName(), true);
                                sqlValues.append("nextidfunc(" + sequence.getAD_Sequence_ID() + ",'N')");
                            }
                            if (c == Object.class) {
                                sqlValues.append(this.saveNewSpecial(value, i));
                            }
                            if (value == null || value.equals(Null.NULL)) {
                                sqlValues.append("NULL");
                            }
                            if (value instanceof Integer && XML_ATTRIBUTE_Record_ID.equalsIgnoreCase(this.p_info.getColumnName(i))) {
                                Integer idValue = (Integer)value;
                                if (idValue <= 999999) {
                                    sqlValues.append(value);
                                }
                                if (this.p_info.getColumnIndex(XML_ATTRIBUTE_AD_Table_ID) >= 0) {
                                    int tableId = this.get_ValueAsInt(XML_ATTRIBUTE_AD_Table_ID);
                                    if (tableId > 0) {
                                        MTable refTable = MTable.get(Env.getCtx(), tableId);
                                        String refTableName = refTable.getTableName();
                                        refKeyColumnName = refTable.getKeyColumns()[0];
                                        refUUColumnName = MTable.getUUIDColumnName(refTableName);
                                        refUUValue = DB.getSQLValueString(this.get_TrxName(), "SELECT " + refUUColumnName + " FROM " + refTableName + " WHERE " + refKeyColumnName + "=?", (Integer)value);
                                        sqlValues.append("toRecordId('" + refTableName + "','" + refUUValue + "')");
                                    }
                                    sqlValues.append(value);
                                }
                                sqlValues.append(value);
                            }
                            if (value instanceof Integer && this.p_info.isColumnLookup(i)) {
                                Integer idValue = (Integer)value;
                                if (idValue <= 999999) {
                                    sqlValues.append(value);
                                }
                                MColumn col = MColumn.get(this.p_info.getAD_Column_ID(this.p_info.getColumnName(i)));
                                String refTableName = col.getReferenceTableName();
                                MTable refTable = MTable.get(Env.getCtx(), refTableName);
                                refKeyColumnName = refTable.getKeyColumns()[0];
                                refUUColumnName = MTable.getUUIDColumnName(refTable.getTableName());
                                refUUValue = DB.getSQLValueString(this.get_TrxName(), "SELECT " + refUUColumnName + " FROM " + refTableName + " WHERE " + refKeyColumnName + "=?", (Integer)value);
                                sqlValues.append("toRecordId('" + refTableName + "','" + refUUValue + "')");
                            }
                            if (value instanceof Integer || value instanceof BigDecimal) {
                                sqlValues.append(value);
                            }
                            if (c == Boolean.class) {
                                boolean bValue = false;
                                bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                                sqlValues.append(this.encrypt(i, bValue ? "'Y'" : "'N'"));
                            }
                            if (value instanceof Timestamp) {
                                sqlValues.append(DB.TO_DATE((Timestamp)this.encrypt(i, value), this.p_info.getColumnDisplayType(i) == 15));
                            }
                            if (c == String.class) {
                                sqlValues.append(this.encrypt(i, DB.TO_STRING((String)value)));
                            }
                            if (DisplayType.isLOB(dt)) {
                                if (this.p_info.isColumnMandatory(i)) {
                                    sqlValues.append("''");
                                }
                                sqlValues.append("null");
                            }
                            sqlValues.append(this.saveNewSpecial(value, i));
                        }
                        catch (Exception e) {
                            Object msg = UUID_NEW_RECORD;
                            if (this.m_trxName != null) {
                                msg = "[" + this.m_trxName + "] - ";
                            }
                            msg = (String)msg + this.p_info.toString(i) + " - Value=" + String.valueOf(value) + "(" + (value == null ? "null" : value.getClass().getName()) + ")";
                            this.log.log(Level.SEVERE, (String)msg, e);
                            throw new DBException(e);
                        }
                    } else {
                        if (value instanceof Timestamp && dt == 15) {
                            sqlValues.append("trunc(cast(? as date))");
                        } else if (dt == 200267) {
                            sqlValues.append(DB.getJSONCast());
                        } else {
                            sqlValues.append("?");
                        }
                        if (DisplayType.isLOB(dt)) {
                            if (this.p_info.isColumnMandatory(i)) {
                                if (dt == 23) {
                                    params.add(new byte[1]);
                                } else {
                                    params.add(UUID_NEW_RECORD);
                                }
                            } else {
                                params.add(null);
                            }
                        } else if (value == null || value.equals(Null.NULL)) {
                            params.add(null);
                        } else if (c == Boolean.class) {
                            boolean bValue = false;
                            bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                            params.add(this.encrypt(i, bValue ? "Y" : "N"));
                        } else if (c == String.class) {
                            if (value.toString().length() == 0) {
                                params.add(null);
                            } else {
                                params.add(this.encrypt(i, value));
                            }
                        } else {
                            params.add(value);
                        }
                    }
                    if (session != null && (!withValues || Env.isUseCentralizedId(this.p_info.getTableName()))) {
                        MChangeLog cLog;
                        String insertLog = MSysConfig.getValue("SYSTEM_INSERT_CHANGELOG", "N", this.getAD_Client_ID());
                        if (!generateScriptOnly && session != null && this.p_info.isAllowLogging(i) && !this.p_info.isEncrypted(i) && !this.p_info.isVirtualColumn(i) && !"Password".equals(this.p_info.getColumnName(i)) && (insertLog.equalsIgnoreCase("Y") || insertLog.equalsIgnoreCase("K") && (this.p_info.getColumn((int)i).IsKey || !this.p_info.hasKeyColumn() && this.p_info.getColumn((int)i).ColumnName.equals(PO.getUUIDColumnName(this.p_info.getTableName())))) && (cLog = session.changeLog(this.m_trxName, AD_ChangeLog_ID, this.p_info.getAD_Table_ID(), this.p_info.getColumn((int)i).AD_Column_ID, this.m_IDs.length == 1 ? this.get_ID() : 0, this.get_UUID(), this.getAD_Client_ID(), this.getAD_Org_ID(), null, value, "I")) != null) {
                            AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
                        }
                    }
                }
            }
            ++i;
        }
        if (this.m_custom != null) {
            for (String column : this.m_custom.keySet()) {
                int index = this.p_info.getColumnIndex(column);
                String value = this.m_custom.get(column);
                if (value == null) continue;
                if (doComma) {
                    sqlInsert.append(",");
                    sqlValues.append(",");
                } else {
                    doComma = true;
                }
                sqlInsert.append(column);
                if (withValues) {
                    sqlValues.append(this.encrypt(index, value));
                    continue;
                }
                sqlValues.append("?");
                if (value == null || value.toString().length() == 0) {
                    params.add(null);
                    continue;
                }
                params.add(this.encrypt(index, value));
            }
            this.m_custom = null;
        }
        sqlInsert.append((CharSequence)sqlValues).append(")");
        return AD_ChangeLog_ID;
    }

    protected int saveNew_getID() {
        if (this.get_ID() > 0 && this.get_ID() < 999999) {
            return this.get_ID();
        }
        return 0;
    }

    protected void saveNew_afterSetID() {
    }

    public String get_WhereClause(boolean withValues) {
        return this.get_WhereClause(withValues, null);
    }

    public String get_WhereClause(boolean withValues, String uuID) {
        StringBuilder sb = new StringBuilder();
        if (!Util.isEmpty(uuID, true)) {
            sb.append(this.getUUIDColumnName()).append("=");
            if (withValues) {
                sb.append(DB.TO_STRING(uuID));
            } else {
                sb.append("?");
            }
            return sb.toString();
        }
        int i = 0;
        while (i < this.m_IDs.length) {
            if (i != 0) {
                sb.append(" AND ");
            }
            sb.append(this.m_KeyColumns[i]).append("=");
            if (withValues) {
                if (this.m_KeyColumns[i].endsWith("_ID")) {
                    sb.append(this.m_IDs[i]);
                } else if (this.m_IDs[i] instanceof Timestamp) {
                    sb.append(DB.TO_DATE((Timestamp)this.m_IDs[i], false));
                } else {
                    sb.append("'");
                    if (this.m_IDs[i] instanceof Boolean) {
                        if (((Boolean)this.m_IDs[i]).booleanValue()) {
                            sb.append("Y");
                        } else {
                            sb.append("N");
                        }
                    } else {
                        sb.append(this.m_IDs[i]);
                    }
                    sb.append("'");
                }
            } else {
                sb.append("?");
            }
            ++i;
        }
        return sb.toString();
    }

    protected String saveNewSpecial(Object value, int index) {
        String colName = this.p_info.getColumnName(index);
        String colClass = this.p_info.getColumnClass(index).toString();
        String colValue = value == null ? "null" : value.getClass().toString();
        this.log.log(Level.SEVERE, "Unknown class for column " + colName + " (" + colClass + ") - Value=" + colValue);
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }

    private Object encrypt(int index, Object xx) {
        if (xx == null) {
            return null;
        }
        if (index != -1 && this.p_info.isEncrypted(index)) {
            return SecureEngine.encrypt(xx, this.getAD_Client_ID());
        }
        return xx;
    }

    private Object decrypt(int index, Object yy) {
        if (yy == null) {
            return null;
        }
        if (index != -1 && this.p_info.isEncrypted(index)) {
            return SecureEngine.decrypt(yy, this.getAD_Client_ID());
        }
        return yy;
    }

    /*
     * Exception decompiling
     */
    public boolean delete(boolean force) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteEx(boolean force) throws AdempiereException {
        if (!this.delete(force)) {
            String msg = null;
            ValueNamePair err = CLogger.retrieveError();
            if (err != null) {
                msg = err.getName();
            }
            if (msg == null || msg.length() == 0) {
                msg = "DeleteError";
            }
            Exception ex = CLogger.retrieveException();
            throw new AdempiereException(msg, ex);
        }
    }

    public boolean delete(boolean force, String trxName) {
        this.set_TrxName(trxName);
        return this.delete(force);
    }

    public void deleteEx(boolean force, String trxName) throws AdempiereException {
        this.set_TrxName(trxName);
        this.deleteEx(force);
    }

    protected boolean beforeDelete() {
        return true;
    }

    protected boolean afterDelete(boolean success) {
        return success;
    }

    protected boolean postDelete() {
        return true;
    }

    private boolean insertTranslations() {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !(this.m_IDs[0] instanceof Integer) && !(this.m_IDs[0] instanceof String) || !this.p_info.isTranslated()) {
            return true;
        }
        StringBuilder iColumns = new StringBuilder();
        StringBuilder sColumns = new StringBuilder();
        int i = 0;
        while (i < this.p_info.getColumnCount()) {
            if (this.p_info.isColumnTranslated(i)) {
                iColumns.append(this.p_info.getColumnName(i)).append(",");
                sColumns.append("t.").append(this.p_info.getColumnName(i)).append(",");
            }
            ++i;
        }
        if (iColumns.length() == 0) {
            return true;
        }
        String tableName = this.p_info.getTableName();
        String keyColumn = this.m_KeyColumns[0];
        boolean uuidFunction = DB.isGenerateUUIDSupported();
        String trlTableName = tableName + "_Trl";
        MTable trlTable = MTable.get(this.getCtx(), trlTableName, this.get_TrxName());
        if (trlTable == null) {
            throw new AdempiereException("Translation table " + trlTableName + " does not exist");
        }
        MColumn uuidColumn = trlTable.getColumn(PO.getUUIDColumnName(trlTableName));
        StringBuilder sql = new StringBuilder("INSERT INTO ").append(tableName).append("_Trl (AD_Language,").append(keyColumn).append(", ").append((CharSequence)iColumns).append(" IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy");
        if (uuidColumn != null && uuidFunction) {
            sql.append(",").append(PO.getUUIDColumnName(tableName + "_Trl")).append(" ) ");
        } else {
            sql.append(" ) ");
        }
        sql.append("SELECT l.AD_Language,t.").append(keyColumn).append(", ").append((CharSequence)sColumns).append(" CASE WHEN l.AD_Language=c.AD_Language THEN 'Y' ELSE 'N' END AS IsTranslated,t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy");
        if (uuidColumn != null && uuidFunction) {
            sql.append(",Generate_UUID() ");
        } else {
            sql.append(" ");
        }
        sql.append("FROM AD_Language l, ").append(tableName).append(" t, AD_Client c ").append("WHERE t.AD_Client_ID=c.AD_Client_ID AND l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.").append(keyColumn).append("=");
        MTable table2 = MTable.get(this.getCtx(), tableName);
        if (table2.isUUIDKeyTable()) {
            sql.append(DB.TO_STRING(this.get_UUID()));
        } else {
            sql.append(this.get_ID());
        }
        sql.append(" AND NOT EXISTS (SELECT * FROM ").append(tableName).append("_Trl tt WHERE tt.AD_Language=l.AD_Language AND tt.").append(keyColumn).append("=t.").append(keyColumn).append(")");
        int no = -1;
        try {
            no = DB.executeUpdateEx(sql.toString(), this.m_trxName);
        }
        catch (DBException e) {
            Object msg = DBException.isValueTooLarge(e) ? Msg.getMsg(this.getCtx(), "MismatchTrlColumnSize") : "insertTranslations -> " + e.getLocalizedMessage();
            throw new AdempiereException((String)msg, e);
        }
        if (uuidColumn != null && !uuidFunction) {
            UUIDGenerator.updateUUID(uuidColumn, this.get_TrxName());
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + no);
        }
        return no > 0;
    }

    private boolean updateTranslations() {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !(this.m_IDs[0] instanceof Integer) && !(this.m_IDs[0] instanceof String) || !this.p_info.isTranslated()) {
            return true;
        }
        String tableName = this.p_info.getTableName();
        boolean trlColumnChanged = false;
        int i = 0;
        while (i < this.p_info.getColumnCount()) {
            if (this.p_info.isColumnTranslated(i) && this.is_ValueChanged(this.p_info.getColumnName(i))) {
                trlColumnChanged = true;
                break;
            }
            ++i;
        }
        if (!trlColumnChanged) {
            return true;
        }
        MClient client = MClient.get(this.getCtx());
        String keyColumn = this.m_KeyColumns[0];
        StringBuilder sqlupdate = new StringBuilder("UPDATE ").append(tableName).append("_Trl SET ");
        ArrayList<Object> values = new ArrayList<Object>();
        StringBuilder sqlcols = new StringBuilder();
        int i2 = 0;
        while (i2 < this.p_info.getColumnCount()) {
            String columnName = this.p_info.getColumnName(i2);
            if (this.p_info.isColumnTranslated(i2) && this.is_ValueChanged(columnName)) {
                String[] availableLanguages;
                sqlcols.append(columnName).append("=?,");
                values.add(this.get_Value(columnName));
                String[] stringArray = availableLanguages = Language.getNames();
                int n = availableLanguages.length;
                int n2 = 0;
                while (n2 < n) {
                    String langName = stringArray[n2];
                    Language language = Language.getLanguage(langName);
                    String key = this.getTrlCacheKey(columnName, language.getAD_Language());
                    trl_cache.remove(key);
                    ++n2;
                }
            }
            ++i2;
        }
        MTable table2 = MTable.get(this.getCtx(), tableName);
        StringBuilder whereid = new StringBuilder(" WHERE ").append(keyColumn).append("=");
        if (table2.isUUIDKeyTable()) {
            whereid.append(DB.TO_STRING(this.get_UUID()));
        } else {
            whereid.append(this.get_ID());
        }
        StringBuilder andClientLang = new StringBuilder(" AND AD_Language=").append(DB.TO_STRING(client.getAD_Language()));
        StringBuilder andNotClientLang = new StringBuilder(" AND AD_Language!=").append(DB.TO_STRING(client.getAD_Language()));
        String baselang = Language.getBaseAD_Language();
        StringBuilder andBaseLang = new StringBuilder(" AND AD_Language=").append(DB.TO_STRING(baselang));
        StringBuilder andNotBaseLang = new StringBuilder(" AND AD_Language!=").append(DB.TO_STRING(baselang));
        int no = -1;
        try {
            Object[] params = new Object[values.size()];
            values.toArray(params);
            if (client.isMultiLingualDocument()) {
                if (client.getAD_Language().equals(baselang)) {
                    StringBuilder sqlexec = new StringBuilder().append((CharSequence)sqlupdate).append("IsTranslated='N'").append((CharSequence)whereid);
                    no = DB.executeUpdateEx(sqlexec.toString(), this.m_trxName);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("#" + no);
                    }
                } else {
                    StringBuilder sqlexec = new StringBuilder().append((CharSequence)sqlupdate).append((CharSequence)sqlcols).append("IsTranslated='Y'").append((CharSequence)whereid).append((CharSequence)(this.getAD_Client_ID() == 0 ? andBaseLang : andClientLang));
                    no = DB.executeUpdateEx(sqlexec.toString(), params, this.m_trxName);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("#" + no);
                    }
                    if (no >= 0) {
                        sqlexec = new StringBuilder().append((CharSequence)sqlupdate).append("IsTranslated='N'").append((CharSequence)whereid).append((CharSequence)(this.getAD_Client_ID() == 0 ? andNotBaseLang : andNotClientLang));
                        no = DB.executeUpdateEx(sqlexec.toString(), this.m_trxName);
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("#" + no);
                        }
                    }
                }
            } else {
                StringBuilder sqlexec = new StringBuilder().append((CharSequence)sqlupdate).append((CharSequence)sqlcols).append("IsTranslated='Y'").append((CharSequence)whereid);
                no = DB.executeUpdateEx(sqlexec.toString(), params, this.m_trxName);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("#" + no);
                }
            }
        }
        catch (DBException e) {
            Object msg = DBException.isValueTooLarge(e) ? Msg.getMsg(this.getCtx(), "MismatchTrlColumnSize") : "updateTranslations -> " + e.getLocalizedMessage();
            throw new AdempiereException((String)msg, e);
        }
        return no >= 0;
    }

    private boolean deleteTranslations(String trxName) {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !(this.m_IDs[0] instanceof Integer) && !(this.m_IDs[0] instanceof String) || !this.p_info.isTranslated()) {
            return true;
        }
        String tableName = this.p_info.getTableName();
        MTable table2 = MTable.get(this.getCtx(), tableName);
        String keyColumn = this.m_KeyColumns[0];
        StringBuilder sql = new StringBuilder("DELETE FROM ").append(tableName).append("_Trl WHERE ").append(keyColumn).append("=");
        if (table2.isUUIDKeyTable()) {
            sql.append(DB.TO_STRING(this.get_UUID()));
        } else {
            sql.append(this.get_ID());
        }
        int no = DB.executeUpdate(sql.toString(), trxName);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + no);
        }
        return no >= 0;
    }

    protected boolean insert_Accounting(String acctTableName, String acctBaseTable, String whereClause) {
        if (this.s_acctColumns == null || acctTableName.startsWith("C_BP_")) {
            block20: {
                this.s_acctColumns = new ArrayList();
                String sql = "SELECT c.ColumnName FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE t.TableName=? AND c.IsActive='Y' AND c.AD_Reference_ID=25 ORDER BY c.ColumnName";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setString(1, acctTableName);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            this.s_acctColumns.add(rs.getString(1));
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, acctTableName, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (this.s_acctColumns.size() == 0) {
                this.log.severe("No Columns for " + acctTableName);
                return false;
            }
        }
        StringBuilder sb = new StringBuilder("INSERT INTO ").append(acctTableName).append(" (").append(this.get_TableName()).append("_ID, C_AcctSchema_ID, AD_Client_ID,AD_Org_ID,IsActive, Created,CreatedBy,Updated,UpdatedBy ");
        int i = 0;
        while (i < this.s_acctColumns.size()) {
            sb.append(",").append(this.s_acctColumns.get(i));
            ++i;
        }
        boolean uuidFunction = DB.isGenerateUUIDSupported();
        MTable acctTable = MTable.get(this.getCtx(), acctTableName, this.get_TrxName());
        if (acctTableName == null) {
            throw new AdempiereException("Accounting table " + acctTableName + " does not exist");
        }
        MColumn uuidColumn = acctTable.getColumn(PO.getUUIDColumnName(acctTableName));
        if (uuidColumn != null && uuidFunction) {
            sb.append(",").append(PO.getUUIDColumnName(acctTableName));
        }
        sb.append(") SELECT ").append(this.get_ID() > 999999 && Env.isLogMigrationScript(this.get_TableName()) ? "toRecordId(" + DB.TO_STRING(this.get_TableName()) + "," + DB.TO_STRING(this.get_UUID()) + ")" : Integer.valueOf(this.get_ID())).append(", p.C_AcctSchema_ID, p.AD_Client_ID,0,'Y', getDate(),").append(this.getUpdatedBy()).append(",getDate(),").append(this.getUpdatedBy());
        int i2 = 0;
        while (i2 < this.s_acctColumns.size()) {
            sb.append(",p.").append(this.s_acctColumns.get(i2));
            ++i2;
        }
        if (uuidColumn != null && uuidFunction) {
            sb.append(",generate_uuid()");
        }
        sb.append(" FROM ").append(acctBaseTable).append(" p WHERE p.AD_Client_ID=").append(this.getAD_Client_ID() > 999999 && Env.isLogMigrationScript(this.get_TableName()) ? "toRecordId('AD_Client'," + DB.TO_STRING(MClient.get(this.getAD_Client_ID()).getAD_Client_UU()) + ")" : Integer.valueOf(this.getAD_Client_ID()));
        if (whereClause != null && whereClause.length() > 0) {
            sb.append(" AND ").append(whereClause);
        }
        sb.append(" AND NOT EXISTS (SELECT * FROM ").append(acctTableName).append(" e WHERE e.C_AcctSchema_ID=p.C_AcctSchema_ID AND e.").append(this.get_TableName()).append("_ID=");
        if (this.get_ID() > 999999 && Env.isLogMigrationScript(this.get_TableName())) {
            sb.append("toRecordId(").append(DB.TO_STRING(this.get_TableName())).append(",").append(DB.TO_STRING(this.get_UUID())).append("))");
        } else {
            sb.append(this.get_ID()).append(")");
        }
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (no > 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#" + no);
            }
        } else {
            this.log.warning("#" + no + " - Table=" + acctTableName + " from " + acctBaseTable);
        }
        if (uuidColumn != null && !uuidFunction) {
            UUIDGenerator.updateUUID(uuidColumn, this.get_TrxName());
        }
        return no > 0;
    }

    @Deprecated
    protected boolean delete_Accounting(String acctTable) {
        return true;
    }

    protected boolean insert_Tree(String treeType) {
        return this.insert_Tree(treeType, 0);
    }

    protected boolean insert_Tree(String treeType, int C_Element_ID) {
        String treeTableName = MTree_Base.getNodeTableName(treeType);
        boolean uuidFunction = DB.isGenerateUUIDSupported();
        MTable treeTable = MTable.get(this.getCtx(), treeTableName, this.get_TrxName());
        if (treeTable == null) {
            throw new AdempiereException("Tree table " + treeTableName + " does not exist");
        }
        MColumn uuidColumn = treeTable.getColumn(PO.getUUIDColumnName(treeTableName));
        StringBuilder sb = new StringBuilder("INSERT INTO ").append(treeTableName).append(" (AD_Client_ID,AD_Org_ID, IsActive,Created,CreatedBy,Updated,UpdatedBy, AD_Tree_ID, Node_ID, Parent_ID, SeqNo");
        if (uuidColumn != null && uuidFunction) {
            sb.append(", ").append(PO.getUUIDColumnName(treeTableName)).append(") ");
        } else {
            sb.append(") ");
        }
        sb.append("SELECT t.AD_Client_ID, 0, 'Y', getDate(), " + this.getUpdatedBy() + ", getDate(), " + this.getUpdatedBy() + ",t.AD_Tree_ID, ").append(this.get_ID() > 999999 && Env.isLogMigrationScript(this.get_TableName()) ? "toRecordId(" + DB.TO_STRING(this.get_TableName()) + "," + DB.TO_STRING(this.get_UUID()) + ")" : Integer.valueOf(this.get_ID())).append(", 0, 999");
        if (uuidColumn != null && uuidFunction) {
            sb.append(", Generate_UUID() ");
        } else {
            sb.append(" ");
        }
        sb.append("FROM AD_Tree t WHERE t.AD_Client_ID=").append(this.getAD_Client_ID() > 999999 && Env.isLogMigrationScript(this.get_TableName()) ? "toRecordId('AD_Client'," + DB.TO_STRING(MClient.get(this.getAD_Client_ID()).getAD_Client_UU()) + ")" : Integer.valueOf(this.getAD_Client_ID())).append(" AND t.IsActive='Y'");
        if (C_Element_ID != 0) {
            sb.append(" AND EXISTS (SELECT * FROM C_Element ae WHERE ae.C_Element_ID=").append(C_Element_ID > 999999 && Env.isLogMigrationScript(this.get_TableName()) ? "toRecordId('C_Element'," + DB.TO_STRING(new MElement(this.getCtx(), C_Element_ID, this.get_TrxName()).getC_Element_UU()) + ")" : Integer.valueOf(C_Element_ID)).append(" AND t.AD_Tree_ID=ae.AD_Tree_ID)");
        } else {
            sb.append(" AND t.IsAllNodes='Y' AND t.TreeType='").append(treeType).append("'");
        }
        if ("TL".equals(treeType)) {
            sb.append(" AND t.AD_Table_ID=").append(this.get_Table_ID() > 999999 && Env.isLogMigrationScript(this.get_TableName()) ? "toRecordId('AD_Table'," + DB.TO_STRING(MTable.get(this.get_Table_ID()).getAD_Table_UU()) + ")" : Integer.valueOf(this.get_Table_ID()));
        }
        sb.append(" AND NOT EXISTS (SELECT * FROM " + MTree_Base.getNodeTableName(treeType) + " e WHERE e.AD_Tree_ID=t.AD_Tree_ID AND Node_ID=").append(this.get_ID() > 999999 && Env.isLogMigrationScript(this.get_TableName()) ? "toRecordId(" + DB.TO_STRING(this.get_TableName()) + "," + DB.TO_STRING(this.get_UUID()) + ")" : Integer.valueOf(this.get_ID())).append(")");
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (no > 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#" + no + " - TreeType=" + treeType);
            }
        } else if (!"TL".equals(treeType)) {
            this.log.warning("#" + no + " - TreeType=" + treeType);
        }
        if (uuidColumn != null && !uuidFunction) {
            UUIDGenerator.updateUUID(uuidColumn, this.get_TrxName());
        }
        return no > 0;
    }

    public void update_Tree(String treeType) {
        Object[] parameters;
        String whereTree;
        String sourceTableName;
        int idxValueCol = this.get_ColumnIndex("Value");
        if (idxValueCol < 0) {
            return;
        }
        int idxValueIsSummary = this.get_ColumnIndex("IsSummary");
        if (idxValueIsSummary < 0) {
            return;
        }
        String value = this.get_Value(idxValueCol).toString();
        if (value == null) {
            return;
        }
        String tableName = MTree_Base.getNodeTableName(treeType);
        if ("TL".equals(treeType)) {
            sourceTableName = this.get_TableName();
            whereTree = "TreeType=? AND AD_Table_ID=?";
            parameters = new Object[]{treeType, this.get_Table_ID()};
        } else {
            sourceTableName = MTree_Base.getSourceTableName(treeType);
            if ("EV".equals(treeType) && this instanceof I_C_ElementValue) {
                whereTree = "TreeType=? AND AD_Tree_ID=?";
                parameters = new Object[]{treeType, ((I_C_ElementValue)((Object)this)).getC_Element().getAD_Tree_ID()};
            } else {
                whereTree = "TreeType=?";
                parameters = new Object[]{treeType};
            }
        }
        String updateSeqNo = "UPDATE " + tableName + " SET SeqNo=SeqNo+1 WHERE Parent_ID=? AND SeqNo>=? AND AD_Tree_ID=?";
        String update = "UPDATE " + tableName + " SET SeqNo=?, Parent_ID=? WHERE Node_ID=? AND AD_Tree_ID=?";
        String selMinSeqNo = "SELECT COALESCE(MIN(tn.SeqNo),-1) FROM AD_TreeNode tn JOIN " + sourceTableName + " n ON (tn.Node_ID=n." + sourceTableName + "_ID) WHERE tn.Parent_ID=? AND tn.AD_Tree_ID=? AND n.Value>?";
        String selMaxSeqNo = "SELECT COALESCE(MAX(tn.SeqNo)+1,999) FROM AD_TreeNode tn JOIN " + sourceTableName + " n ON (tn.Node_ID=n." + sourceTableName + "_ID) WHERE tn.Parent_ID=? AND tn.AD_Tree_ID=? AND n.Value<?";
        List trees = new Query(this.getCtx(), "AD_Tree", whereTree, this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(parameters).list();
        for (MTree_Base tree : trees) {
            if (!tree.isTreeDrivenByValue()) continue;
            int newParentID = -1;
            if ("C_ElementValue".equals(sourceTableName)) {
                newParentID = this.retrieveIdOfElementValue(value, this.getAD_Client_ID(), ((I_C_ElementValue)((Object)this)).getC_Element().getC_Element_ID(), this.get_TrxName());
            } else {
                int linkColId = tree.getParent_Column_ID();
                String linkColName = null;
                int linkID = 0;
                if (linkColId > 0) {
                    linkColName = MColumn.getColumnName(Env.getCtx(), linkColId);
                    linkID = (Integer)this.get_Value(linkColName);
                }
                newParentID = PO.retrieveIdOfParentValue(value, sourceTableName, linkColName, linkID, this.getAD_Client_ID(), this.get_TrxName());
            }
            int seqNo = DB.getSQLValueEx(this.get_TrxName(), selMinSeqNo, newParentID, tree.getAD_Tree_ID(), value);
            if (seqNo == -1) {
                seqNo = DB.getSQLValueEx(this.get_TrxName(), selMaxSeqNo, newParentID, tree.getAD_Tree_ID(), value);
            }
            DB.executeUpdateEx(updateSeqNo, new Object[]{newParentID, seqNo, tree.getAD_Tree_ID()}, this.get_TrxName());
            DB.executeUpdateEx(update, new Object[]{seqNo, newParentID, this.get_ID(), tree.getAD_Tree_ID()}, this.get_TrxName());
        }
    }

    private int retrieveIdOfElementValue(String value, int clientID, int elementID, String trxName) {
        String sql = "SELECT C_ElementValue_ID FROM C_ElementValue WHERE IsSummary='Y' AND AD_Client_ID=? AND C_Element_ID=? AND Value=?";
        int pos = value.length() - 1;
        while (pos > 0) {
            String testParentValue = value.substring(0, pos);
            int parentID = DB.getSQLValueEx(trxName, sql, clientID, elementID, testParentValue);
            if (parentID > 0) {
                return parentID;
            }
            --pos;
        }
        return 0;
    }

    public static int retrieveIdOfParentValue(String value, String tableName, int clientID, String trxName) {
        return PO.retrieveIdOfParentValue(value, tableName, null, 0, clientID, trxName);
    }

    public static int retrieveIdOfParentValue(String value, String tableName, String linkCol, int linkID, int clientID, String trxName) {
        String sql = "SELECT " + tableName + "_ID FROM " + tableName + " WHERE IsSummary='Y'";
        if (!Util.isEmpty(linkCol)) {
            sql = sql + " AND " + linkCol + "=" + linkID;
        }
        sql = sql + " AND AD_Client_ID=? AND Value=?";
        int pos = value.length() - 1;
        while (pos > 0) {
            String testParentValue = value.substring(0, pos);
            int parentID = DB.getSQLValueEx(trxName, sql, clientID, testParentValue);
            if (parentID > 0) {
                return parentID;
            }
            --pos;
        }
        return 0;
    }

    protected boolean delete_Tree(String treeType) {
        int cnt;
        int id = this.get_ID();
        if (id == 0) {
            id = this.get_IDOld();
        }
        StringBuilder countSql = new StringBuilder("SELECT COUNT(*) FROM ").append(MTree_Base.getNodeTableName(treeType)).append(" n JOIN AD_Tree t ON n.AD_Tree_ID=t.AD_Tree_ID").append(" WHERE Parent_ID=? AND t.TreeType=?");
        if ("TL".equals(treeType)) {
            countSql.append(" AND t.AD_Table_ID=").append(this.get_Table_ID());
        }
        if ((cnt = DB.getSQLValueEx(this.get_TrxName(), countSql.toString(), id, treeType)) > 0) {
            throw new AdempiereException(Msg.getMsg(Env.getCtx(), "NoParentDelete", new Object[]{cnt}));
        }
        StringBuilder sb = new StringBuilder("DELETE FROM ").append(MTree_Base.getNodeTableName(treeType)).append(" n WHERE Node_ID=").append(id).append(" AND EXISTS (SELECT * FROM AD_Tree t WHERE t.AD_Tree_ID=n.AD_Tree_ID AND t.TreeType='").append(treeType).append("'");
        if ("TL".equals(treeType)) {
            sb.append(" AND t.AD_Table_ID=").append(this.get_Table_ID());
        }
        sb.append(")");
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (no > 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#" + no + " - TreeType=" + treeType);
            }
        } else if (!"TL".equals(treeType)) {
            this.log.warning("#" + no + " - TreeType=" + treeType);
        }
        return no > 0;
    }

    public boolean lock() {
        int index = this.get_ProcessingIndex();
        if (index != -1) {
            this.m_newValues[index] = Boolean.TRUE;
            String sql = "UPDATE " + this.p_info.getTableName() + " SET Processing='Y' WHERE (Processing='N' OR Processing IS NULL) AND " + this.get_WhereClause(true);
            boolean success = false;
            if (this.isUseTimeoutForUpdate()) {
                success = DB.executeUpdateEx(sql, null, 300) == 1;
            } else {
                boolean bl = success = DB.executeUpdate(sql, null) == 1;
            }
            if (success) {
                this.log.fine("success");
            } else {
                this.log.log(Level.WARNING, "failed");
            }
            return success;
        }
        return false;
    }

    private int get_ProcessingIndex() {
        return this.p_info.getColumnIndex("Processing");
    }

    public boolean unlock(String trxName) {
        int index = this.get_ProcessingIndex();
        if (index != -1) {
            this.m_newValues[index] = Boolean.FALSE;
            String sql = "UPDATE " + this.p_info.getTableName() + " SET Processing='N' WHERE " + this.get_WhereClause(true);
            boolean success = false;
            if (this.isUseTimeoutForUpdate()) {
                success = DB.executeUpdateEx(sql, trxName, 300) == 1;
            } else {
                boolean bl = success = DB.executeUpdate(sql, trxName) == 1;
            }
            if (success) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("success" + (String)(trxName == null ? UUID_NEW_RECORD : "[" + trxName + "]"));
                }
            } else {
                this.log.log(Level.WARNING, "failed" + (String)(trxName == null ? UUID_NEW_RECORD : " [" + trxName + "]"));
            }
            return success;
        }
        return true;
    }

    public void set_TrxName(String trxName) {
        if (trxName != null) {
            this.checkImmutable();
        }
        this.m_trxName = trxName;
    }

    public String get_TrxName() {
        return this.m_trxName;
    }

    public MAttachment getAttachment() {
        return this.getAttachment(false);
    }

    public MAttachment getAttachment(boolean requery) {
        if (this.m_attachment == null || requery) {
            this.m_attachment = MAttachment.get(this.getCtx(), this.p_info.getAD_Table_ID(), this.get_ID(), this.get_UUID(), null);
        }
        return this.m_attachment;
    }

    public MAttachment createAttachment() {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            this.m_attachment = new MAttachment(this.getCtx(), this.p_info.getAD_Table_ID(), this.get_ID(), this.get_UUID(), null);
        }
        return this.m_attachment;
    }

    public boolean isAttachment(String extension) {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_attachment.getEntryCount()) {
            if (this.m_attachment.getEntryName(i).endsWith(extension)) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("#" + i + ": " + this.m_attachment.getEntryName(i));
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public byte[] getAttachmentData(String extension) {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            return null;
        }
        int i = 0;
        while (i < this.m_attachment.getEntryCount()) {
            if (this.m_attachment.getEntryName(i).endsWith(extension)) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("#" + i + ": " + this.m_attachment.getEntryName(i));
                }
                return this.m_attachment.getEntryData(i);
            }
            ++i;
        }
        return null;
    }

    public boolean isPdfAttachment() {
        return this.isAttachment(".pdf");
    }

    public byte[] getPdfAttachment() {
        return this.getAttachmentData(".pdf");
    }

    public void dump() {
        if (CLogMgt.isLevelFinest()) {
            this.log.finer(this.get_WhereClause(true));
            int i = 0;
            while (i < this.get_ColumnCount()) {
                this.dump(i);
                ++i;
            }
        }
    }

    public void dump(int index) {
        StringBuilder sb = new StringBuilder(" ").append(index);
        if (index < 0 || index >= this.get_ColumnCount()) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(sb.append(": invalid").toString());
            }
            return;
        }
        sb.append(": ").append(this.get_ColumnName(index)).append(" = ").append(this.m_oldValues[index]).append(" (").append(this.m_newValues[index]).append(")");
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(sb.toString());
        }
    }

    public static int[] getAllIDs(String TableName, String WhereClause, String trxName) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(TableName).append("_ID FROM ").append(TableName);
        if (WhereClause != null && WhereClause.length() > 0) {
            sql.append(" WHERE ").append(WhereClause);
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), trxName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getInt(1));
                }
            }
            catch (SQLException e) {
                s_log.log(Level.SEVERE, sql.toString(), e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        int[] retValue = new int[list.size()];
        int i = 0;
        while (i < retValue.length) {
            retValue[i] = (Integer)list.get(i);
            ++i;
        }
        return retValue;
    }

    protected static String getFindParameter(String query) {
        if (query == null) {
            return null;
        }
        if (((String)query).length() == 0 || ((String)query).equals("%")) {
            return null;
        }
        if (!((String)query).endsWith("%")) {
            query = (String)query + "%";
        }
        return ((String)query).toUpperCase();
    }

    private Object get_LOB(Object value) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Value=" + String.valueOf(value));
        }
        if (value == null) {
            return null;
        }
        Object retValue = null;
        long length = -99L;
        try {
            if (value instanceof String || value instanceof byte[]) {
                retValue = value;
            } else if (value instanceof Clob) {
                Clob clob = (Clob)value;
                length = clob.length();
                retValue = clob.getSubString(1L, (int)length);
            } else if (value instanceof Blob) {
                Blob blob = (Blob)value;
                length = blob.length();
                int index = 1;
                if (blob.getClass().getName().equals("oracle.jdbc.rowset.OracleSerialBlob")) {
                    index = 0;
                }
                retValue = blob.getBytes(index, (int)length);
            } else {
                this.log.log(Level.SEVERE, "Unknown: " + String.valueOf(value));
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Length=" + length, e);
        }
        return retValue;
    }

    private void lobReset() {
        this.m_lobInfo = null;
    }

    private void lobAdd(Object value, int index, int displayType) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Value=" + String.valueOf(value));
        }
        PO_LOB lob = new PO_LOB(this.p_info.getTableName(), this.get_ColumnName(index), this.get_WhereClause(true), displayType, value);
        if (this.m_lobInfo == null) {
            this.m_lobInfo = new ArrayList();
        }
        this.m_lobInfo.add(lob);
    }

    private boolean lobSave() {
        if (this.m_lobInfo == null) {
            return true;
        }
        boolean retValue = true;
        int i = 0;
        while (i < this.m_lobInfo.size()) {
            PO_LOB lob = this.m_lobInfo.get(i);
            if (!lob.save(this.get_TrxName())) {
                retValue = false;
                break;
            }
            ++i;
        }
        this.lobReset();
        return retValue;
    }

    public StringBuffer get_xmlString(StringBuffer xml) {
        if (xml == null) {
            xml = new StringBuffer();
        } else {
            xml.append(Env.NL);
        }
        try {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(this.get_xmlDocument(xml.length() != 0));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            StringBuffer newXML = writer.getBuffer();
            if (xml.length() != 0) {
                int tagIndex = newXML.indexOf("?>");
                if (tagIndex != -1) {
                    xml.append(newXML.substring(tagIndex + 2));
                } else {
                    xml.append(newXML);
                }
            } else {
                xml.append(newXML);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, UUID_NEW_RECORD, e);
        }
        return xml;
    }

    public Document get_xmlDocument(boolean noComment) {
        Object value;
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            if (!noComment) {
                document.appendChild(document.createComment(Adempiere.getSummaryAscii()));
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, UUID_NEW_RECORD, e);
        }
        Element root = document.createElement(this.get_TableName());
        root.setAttribute(XML_ATTRIBUTE_AD_Table_ID, String.valueOf(this.get_Table_ID()));
        root.setAttribute(XML_ATTRIBUTE_Record_ID, String.valueOf(this.get_ID()));
        document.appendChild(root);
        int size = this.get_ColumnCount();
        int i = 0;
        while (i < size) {
            if (!this.p_info.isVirtualColumn(i)) {
                Element col = document.createElement(this.p_info.getColumnName(i));
                value = this.get_Value(i);
                int dt = this.p_info.getColumnDisplayType(i);
                Class<?> c = this.p_info.getColumnClass(i);
                if (value != null && !value.equals(Null.NULL)) {
                    if (c == Object.class) {
                        col.setAttributeNS("http://www.w3.org/XML/1998/namespace", "space", "preserve");
                        col.appendChild(document.createCDATASection(value.toString()));
                    } else if (value instanceof Integer || value instanceof BigDecimal) {
                        col.appendChild(document.createTextNode(value.toString()));
                    } else if (c == Boolean.class) {
                        boolean bValue = false;
                        bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                        col.appendChild(document.createTextNode(bValue ? "Y" : "N"));
                    } else if (value instanceof Timestamp) {
                        col.appendChild(document.createTextNode(value.toString()));
                    } else if (c == String.class) {
                        col.setAttributeNS("http://www.w3.org/XML/1998/namespace", "space", "preserve");
                        col.appendChild(document.createCDATASection((String)value));
                    } else if (DisplayType.isLOB(dt)) {
                        col.setAttributeNS("http://www.w3.org/XML/1998/namespace", "space", "preserve");
                        col.appendChild(document.createCDATASection(value.toString()));
                    } else {
                        col.setAttributeNS("http://www.w3.org/XML/1998/namespace", "space", "preserve");
                        col.appendChild(document.createCDATASection(value.toString()));
                    }
                }
                root.appendChild(col);
            }
            ++i;
        }
        if (this.m_custom != null) {
            for (String columnName : this.m_custom.keySet()) {
                value = this.m_custom.get(columnName);
                Element col = document.createElement(columnName);
                if (value != null) {
                    col.appendChild(document.createTextNode((String)value));
                }
                root.appendChild(col);
            }
            this.m_custom = null;
        }
        return document;
    }

    public void setDoc(Doc doc) {
        this.m_doc = doc;
    }

    public void setReplication(boolean isFromReplication) {
        this.m_isReplication = isFromReplication;
    }

    public boolean isReplication() {
        return this.m_isReplication;
    }

    public Doc getDoc() {
        return this.m_doc;
    }

    public static void set_TrxName(PO[] lines, String trxName) {
        PO[] pOArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            PO line = pOArray[n2];
            line.set_TrxName(trxName);
            ++n2;
        }
    }

    public int get_ValueAsInt(String columnName) {
        int idx = this.get_ColumnIndex(columnName);
        if (idx < 0) {
            return 0;
        }
        return this.get_ValueAsInt(idx);
    }

    public boolean get_ValueAsBoolean(String columnName) {
        Object oo = this.get_Value(columnName);
        if (oo != null) {
            if (oo instanceof Boolean) {
                return (Boolean)oo;
            }
            return "Y".equals(oo);
        }
        return false;
    }

    public String getUUIDColumnName() {
        return PO.getUUIDColumnName(this.get_TableName());
    }

    public static String getUUIDColumnName(String tableName) {
        String columnName = tableName + "_UU";
        if (columnName.length() <= 30) {
            return columnName;
        }
        int i = columnName.length() - 30;
        String oldColumnName = tableName.substring(0, tableName.length() - i) + "_UU";
        MTable table2 = MTable.get(null, tableName);
        if (table2 != null && table2.columnExists(oldColumnName)) {
            return oldColumnName;
        }
        if (columnName.length() > 63) {
            i = columnName.length() - 63;
            columnName = tableName.substring(0, tableName.length() - i) + "_UU";
        }
        return columnName;
    }

    @Deprecated
    protected Object clone() throws CloneNotSupportedException {
        int i;
        PO clone = (PO)super.clone();
        clone.m_trxName = null;
        if (this.m_custom != null) {
            clone.m_custom = new HashMap();
            clone.m_custom.putAll(this.m_custom);
        }
        if (this.m_newValues != null) {
            clone.m_newValues = new Object[this.m_newValues.length];
            i = 0;
            while (i < this.m_newValues.length) {
                clone.m_newValues[i] = this.m_newValues[i];
                ++i;
            }
        }
        if (this.m_oldValues != null) {
            clone.m_oldValues = new Object[this.m_oldValues.length];
            i = 0;
            while (i < this.m_oldValues.length) {
                clone.m_oldValues[i] = this.m_oldValues[i];
                ++i;
            }
        }
        if (this.m_IDs != null) {
            clone.m_IDs = new Object[this.m_IDs.length];
            i = 0;
            while (i < this.m_IDs.length) {
                clone.m_IDs[i] = this.m_IDs[i];
                ++i;
            }
        }
        clone.p_ctx = Env.getCtx();
        clone.m_doc = null;
        clone.m_lobInfo = null;
        clone.m_attachment = null;
        clone.m_isReplication = false;
        return clone;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.log = CLogger.getCLogger(this.getClass());
        this.p_ctx = Env.getCtx();
        this.p_info = this.initPO(this.p_ctx);
    }

    public void set_Attribute(String attributeName, Object value) {
        this.checkImmutable();
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap();
        }
        this.m_attributes.put(attributeName, value);
    }

    public Object get_Attribute(String attributeName) {
        if (this.m_attributes != null) {
            return this.m_attributes.get(attributeName);
        }
        return null;
    }

    public HashMap<String, Object> get_Attributes() {
        return this.m_attributes;
    }

    protected void makeImmutable() {
        if (this.is_Immutable()) {
            return;
        }
        this.m_isImmutable = true;
        this.m_trxName = null;
    }

    public boolean is_Immutable() {
        return this.m_isImmutable;
    }

    private void validateUniqueIndex() {
        ValueNamePair ppE = CLogger.retrieveError();
        if (ppE != null) {
            Exception e;
            String msg = ppE.getValue();
            Object info = ppE.getName();
            if ("DBExecuteError".equals(msg)) {
                info = "DBExecuteError:" + (String)info;
            }
            if (DBException.isUniqueContraintError(e = CLogger.peekException())) {
                MTableIndex index;
                boolean found = false;
                String dbIndexName = DB.getDatabase().getNameOfUniqueConstraintError(e);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("dbIndexName=" + dbIndexName);
                }
                if ((index = (MTableIndex)new Query(this.getCtx(), "AD_TableIndex", "AD_Table_ID=? AND UPPER(Name)=UPPER(?)", null).setParameters(this.get_Table_ID(), dbIndexName).setOnlyActiveRecords(true).first()) != null && index.getAD_Message_ID() > 0) {
                    MMessage message = MMessage.get(this.getCtx(), index.getAD_Message_ID());
                    this.log.saveError("SaveError", Msg.getMsg(this.getCtx(), message.getValue()));
                    found = true;
                }
                if (!found) {
                    this.log.saveError(msg, (String)info);
                }
            } else {
                this.log.saveError(msg, (String)info);
            }
        }
    }

    private void checkValidContext() {
        if (this.getCtx().isEmpty() && this.getCtx().getProperty("#AD_Client_ID") == null) {
            throw new AdempiereException("Context lost");
        }
    }

    public static void setCrossTenantSafe() {
        isSafeCrossTenant.set(Boolean.TRUE);
    }

    public static void clearCrossTenantSafe() {
        isSafeCrossTenant.set(Boolean.FALSE);
    }

    private void checkCrossTenant(boolean writing) {
        int poClientID;
        if (isSafeCrossTenant.get().booleanValue()) {
            return;
        }
        int envClientID = Env.getAD_Client_ID(this.getCtx());
        if (envClientID > 0 && (poClientID = this.getAD_Client_ID()) != envClientID && (poClientID != 0 || writing)) {
            this.log.warning("Table=" + this.get_TableName() + " Record_ID=" + this.get_ID() + " Env.AD_Client_ID=" + envClientID + " PO.AD_Client_ID=" + poClientID + " writing=" + writing + " Session=" + Env.getContext(this.getCtx(), "#AD_Session_ID"));
            String message = "Cross tenant PO " + (writing ? "writing" : "reading") + " request detected from session " + Env.getContext(this.getCtx(), "#AD_Session_ID") + " for table " + this.get_TableName() + " Record_ID=" + this.get_ID();
            throw new AdempiereException(message);
        }
    }

    public boolean validForeignKeys() {
        List<ValueNamePair> fks = this.getForeignColumnIdxs();
        if (fks == null) {
            return true;
        }
        for (ValueNamePair vnp : fks) {
            String fkcol = vnp.getID();
            String fktab = vnp.getName();
            int index = this.get_ColumnIndex(fkcol);
            if (!this.is_new() && !this.is_ValueChanged(index)) continue;
            Object fkval = null;
            fkval = fkcol.endsWith("_UU") ? this.get_ValueAsString(index) : Integer.valueOf(this.get_ValueAsInt(index));
            if (fkval == null || (!(fkval instanceof Integer) || (Integer)fkval <= 0) && (!(fkval instanceof String) || ((String)fkval).length() <= 0)) continue;
            MTable ft = MTable.get(this.getCtx(), fktab);
            boolean systemAccess = false;
            String accessLevel = ft.getAccessLevel();
            if ("7".equals(accessLevel) || "4".equals(accessLevel) || "6".equals(accessLevel)) {
                systemAccess = true;
            }
            StringBuilder sql = new StringBuilder("SELECT AD_Client_ID FROM ").append(fktab).append(" WHERE ").append(ft.getKeyColumns()[0]).append("=?");
            int pocid = DB.getSQLValue(this.get_TrxName(), sql.toString(), fkval);
            if (pocid < 0) {
                this.log.saveError("Error", "Foreign ID " + String.valueOf(fkval) + " not found in " + fkcol);
                return false;
            }
            if (pocid == 0 && !systemAccess) {
                this.log.saveError("Error", "System ID " + String.valueOf(fkval) + " cannot be used in " + fkcol);
                return false;
            }
            int curcid = Env.getAD_Client_ID(this.getCtx());
            if (pocid <= 0 || pocid == curcid) continue;
            this.log.saveError("Error", "Cross tenant ID " + String.valueOf(fkval) + " not allowed in " + fkcol);
            return false;
        }
        return true;
    }

    private void checkRecordIDCrossTenant() {
        if (isSafeCrossTenant.get().booleanValue()) {
            return;
        }
        if ("AD_PInstance".equals(this.p_info.getTableName())) {
            return;
        }
        int idxRecordId = this.p_info.getColumnIndex(XML_ATTRIBUTE_Record_ID);
        if (idxRecordId < 0) {
            return;
        }
        int idxTableId = this.p_info.getColumnIndex(XML_ATTRIBUTE_AD_Table_ID);
        if (idxTableId < 0) {
            return;
        }
        if (!(this.is_new() || this.is_ValueChanged(idxTableId) || this.is_ValueChanged(idxRecordId))) {
            return;
        }
        int recordId = this.get_ValueAsInt(idxRecordId);
        if (recordId <= 0) {
            return;
        }
        int tableId = this.get_ValueAsInt(idxTableId);
        if (tableId <= 0) {
            return;
        }
        MTable ft = MTable.get(this.getCtx(), tableId);
        if (ft.getKeyColumns().length > 1) {
            return;
        }
        boolean systemAccess = false;
        String accessLevel = ft.getAccessLevel();
        if ("7".equals(accessLevel) || "4".equals(accessLevel) || "6".equals(accessLevel)) {
            systemAccess = true;
        }
        StringBuilder sql = new StringBuilder("SELECT AD_Client_ID FROM ").append(ft.getTableName()).append(" WHERE ").append(ft.getKeyColumns()[0]).append("=?");
        int pocid = DB.getSQLValue(this.get_TrxName(), sql.toString(), recordId);
        if (pocid < 0) {
            throw new AdempiereException("Foreign ID " + recordId + " not found in " + ft.getTableName());
        }
        if (pocid == 0 && !systemAccess) {
            throw new AdempiereException("System ID " + recordId + " cannot be used in " + ft.getTableName());
        }
        int curcid = this.getAD_Client_ID();
        if (pocid > 0 && pocid != curcid) {
            throw new AdempiereException("Cross tenant ID " + recordId + " not allowed in " + ft.getTableName());
        }
    }

    private void checkRecordUUCrossTenant() {
        if (isSafeCrossTenant.get().booleanValue()) {
            return;
        }
        if ("AD_PInstance".equals(this.p_info.getTableName())) {
            return;
        }
        int idxRecordUU = this.p_info.getColumnIndex("Record_UU");
        if (idxRecordUU < 0) {
            return;
        }
        int idxTableId = this.p_info.getColumnIndex(XML_ATTRIBUTE_AD_Table_ID);
        if (idxTableId < 0) {
            return;
        }
        if (!(this.is_new() || this.is_ValueChanged(idxTableId) || this.is_ValueChanged(idxRecordUU))) {
            return;
        }
        int tableId = this.get_ValueAsInt(idxTableId);
        if (tableId <= 0) {
            return;
        }
        String recordUU = this.get_ValueAsString(idxRecordUU);
        if (Util.isEmpty(recordUU)) {
            return;
        }
        MTable ft = MTable.get(this.getCtx(), tableId);
        if (!ft.hasUUIDKey()) {
            return;
        }
        boolean systemAccess = false;
        String accessLevel = ft.getAccessLevel();
        if ("7".equals(accessLevel) || "4".equals(accessLevel) || "6".equals(accessLevel)) {
            systemAccess = true;
        }
        StringBuilder sql = new StringBuilder("SELECT AD_Client_ID FROM ").append(ft.getTableName()).append(" WHERE ").append(PO.getUUIDColumnName(ft.getTableName())).append("=?");
        int pocid = DB.getSQLValue(this.get_TrxName(), sql.toString(), recordUU);
        if (pocid < 0) {
            throw new AdempiereException("Foreign UUID " + recordUU + " not found in " + ft.getTableName());
        }
        if (pocid == 0 && !systemAccess) {
            throw new AdempiereException("System UUID " + recordUU + " cannot be used in " + ft.getTableName());
        }
        int curcid = this.getAD_Client_ID();
        if (pocid > 0 && pocid != curcid) {
            throw new AdempiereException("Cross tenant UUID " + recordUU + " not allowed in " + ft.getTableName());
        }
    }

    private List<ValueNamePair> getForeignColumnIdxs() {
        if (fks_cache.containsKey(this.get_Table_ID())) {
            List<ValueNamePair> retValue = fks_cache.get(this.get_Table_ID());
            return retValue;
        }
        ArrayList<ValueNamePair> retValue = new ArrayList<ValueNamePair>();
        int size = this.get_ColumnCount();
        int i = 0;
        while (i < size) {
            MColumn col;
            int dt = this.p_info.getColumnDisplayType(i);
            if ((dt != 13 && DisplayType.isID(dt) || dt != 200231 && DisplayType.isUUID(dt)) && !"AD_Client_ID".equals((col = MColumn.get(this.p_info.getColumn((int)i).AD_Column_ID)).getColumnName())) {
                String refTable = col.getReferenceTableName();
                retValue.add(new ValueNamePair(col.getColumnName(), refTable));
            }
            ++i;
        }
        if (retValue.size() == 0) {
            retValue = null;
        }
        fks_cache.put(this.get_Table_ID(), retValue);
        return retValue;
    }

    public boolean columnExists(String columnName, boolean throwException) {
        int idx = this.get_ColumnIndex(columnName);
        if (idx < 0 && throwException) {
            throw new AdempiereException("Column " + this.get_TableName() + "." + columnName + " not found");
        }
        return idx >= 0;
    }

    public boolean columnExists(String columnName) {
        return this.columnExists(columnName, false);
    }
}

