/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAccount;
import org.compiere.model.MClient;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MRole;
import org.compiere.model.MRoleOrgAccess;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Org;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.TrxEventListener;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MOrg
extends X_AD_Org
implements ImmutablePOSupport {
    private static final long serialVersionUID = -8501438599288536080L;
    private static ImmutableIntPOCache<Integer, MOrg> s_cache = new ImmutableIntPOCache("AD_Org", 50, 0, false, 0);
    private Integer m_linkedBPartner = null;

    public static MOrg[] getOfClient(PO po) {
        return MOrg.getOfClient(po.getAD_Client_ID());
    }

    public static MOrg[] getOfClient() {
        return MOrg.getOfClient(Env.getAD_Client_ID(Env.getCtx()));
    }

    public static MOrg[] getOfClient(int clientID) {
        List<MOrg> list = new Query(Env.getCtx(), "AD_Org", "AD_Client_ID=?", null).setOrderBy("Value").setOnlyActiveRecords(true).setParameters(clientID).list();
        for (MOrg org : list) {
            s_cache.put(org.get_ID(), org);
        }
        return list.toArray(new MOrg[list.size()]);
    }

    public static MOrg get(int AD_Org_ID) {
        return MOrg.get(Env.getCtx(), AD_Org_ID);
    }

    public static MOrg get(Properties ctx, int AD_Org_ID) {
        MOrg retValue = s_cache.get(ctx, AD_Org_ID, e -> new MOrg(ctx, (MOrg)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MOrg(ctx, AD_Org_ID, null);
        if (retValue.get_ID() == AD_Org_ID) {
            s_cache.put(AD_Org_ID, retValue, e -> new MOrg(Env.getCtx(), (MOrg)e));
            return retValue;
        }
        return null;
    }

    public MOrg(Properties ctx, String AD_Org_UU, String trxName) {
        super(ctx, AD_Org_UU, trxName);
        if (Util.isEmpty(AD_Org_UU)) {
            this.setInitialDefaults();
        }
    }

    public MOrg(Properties ctx, int AD_Org_ID, String trxName) {
        super(ctx, AD_Org_ID, trxName);
        if (AD_Org_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsSummary(false);
    }

    public MOrg(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MOrg(MClient client, String value, String name) {
        this(client.getCtx(), 0, client.get_TrxName());
        this.setAD_Client_ID(client.getAD_Client_ID());
        this.setValue(value);
        this.setName(name);
    }

    public MOrg(MOrg copy) {
        this(Env.getCtx(), copy);
    }

    public MOrg(Properties ctx, MOrg copy) {
        this(ctx, copy, null);
    }

    public MOrg(Properties ctx, MOrg copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_linkedBPartner = copy.m_linkedBPartner;
    }

    public MOrgInfo getInfo() {
        MOrgInfo orgInfo = MOrgInfo.getCopy(Env.getCtx(), this.getAD_Org_ID(), this.get_TrxName());
        return orgInfo;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord) {
            MOrgInfo info = new MOrgInfo(this);
            info.saveEx();
            MRoleOrgAccess.createForOrg(this);
            MRole role = MRole.getDefault(this.getCtx(), true);
            role = new MRole(this.getCtx(), role, this.get_TrxName());
            role.loadAccess(true);
            this.insert_Tree("OO");
        }
        if (newRecord || this.is_ValueChanged("Value")) {
            this.update_Tree("OO");
        }
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription(this.getCtx(), "AD_Org_ID=" + this.getAD_Org_ID(), this.get_TrxName());
            if ("Y".equals(Env.getContext(this.getCtx(), "$Element_OT"))) {
                MAccount.updateValueDescription(this.getCtx(), "AD_OrgTrx_ID=" + this.getAD_Org_ID(), this.get_TrxName());
            }
        }
        Trx.get(this.get_TrxName(), false).addTrxEventListener(new TrxEventListener(){

            @Override
            public void afterRollback(Trx trx, boolean success) {
            }

            @Override
            public void afterCommit(Trx trx, boolean success) {
                MRole.getDefault().loadAccess(true);
                CacheMgt.get().reset();
            }

            @Override
            public void afterClose(Trx trx) {
            }
        });
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.delete_Tree("OO");
        }
        return success;
    }

    public int getLinkedC_BPartner_ID(String trxName) {
        if (this.m_linkedBPartner == null) {
            int C_BPartner_ID = DB.getSQLValue(trxName, "SELECT C_BPartner_ID FROM C_BPartner WHERE AD_OrgBP_ID=?", this.getAD_Org_ID());
            if (C_BPartner_ID < 0) {
                C_BPartner_ID = 0;
            }
            this.m_linkedBPartner = C_BPartner_ID;
        }
        return this.m_linkedBPartner;
    }

    @Override
    public MOrg markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

