/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_AD_Menu;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_PA_DashboardContent;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MDashboardContent
extends X_PA_DashboardContent {
    private static final long serialVersionUID = -1360395253302002667L;
    private Integer m_AD_Menu_ID = null;

    public static int getForSessionColumnCount(boolean isShowInDashboard, int AD_User_ID, int AD_Role_ID) {
        int noOfCols = MDashboardContent.getForSessionQuery(isShowInDashboard, AD_User_ID, AD_Role_ID).aggregate("DISTINCT ColumnNo", "COUNT", Integer.class);
        return noOfCols;
    }

    public static MDashboardContent[] getForSession(boolean isShowInDashboard, int AD_User_ID, int AD_Role_ID) {
        List<MDashboardContent> list = MDashboardContent.getForSessionQuery(isShowInDashboard, AD_User_ID, AD_Role_ID).list();
        return list.toArray(new MDashboardContent[list.size()]);
    }

    public static Query getForSessionQuery(boolean isShowInDashboard, int AD_User_ID, int AD_Role_ID) {
        Properties ctx = Env.getCtx();
        StringBuilder whereClause = new StringBuilder("IsShowInDashboard").append("=?");
        if (AD_Role_ID == 0) {
            whereClause.append(" AND (").append("AD_Role_ID").append(" IS NULL OR ").append("AD_Role_ID").append("=?)");
        } else {
            whereClause.append(" AND ").append("AD_Role_ID").append("=?");
        }
        if (AD_User_ID == 0) {
            whereClause.append(" AND (").append("AD_User_ID").append(" IS NULL OR ").append("AD_User_ID").append("=?)");
        } else {
            whereClause.append(" AND ").append("AD_User_ID").append("=?");
        }
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(isShowInDashboard);
        parameters.add(AD_Role_ID);
        parameters.add(AD_User_ID);
        return new Query(ctx, "PA_DashboardContent", whereClause.toString(), null).setParameters(parameters).setOnlyActiveRecords(true).setApplyAccessFilter(true, false).setOrderBy("ColumnNo,AD_Client_ID,Line");
    }

    public static MDashboardContent[] getForUserList(int AD_User_ID, int AD_Role_ID) {
        List<MDashboardContent> list = MDashboardContent.getForUser(AD_User_ID, AD_Role_ID).list();
        return list.toArray(new MDashboardContent[list.size()]);
    }

    public static Query getForUser(int AD_User_ID, int AD_Role_ID) {
        Properties ctx = Env.getCtx();
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder();
        if (AD_Role_ID >= 0) {
            whereClause.append("AD_Role_ID").append("= ?");
            whereClause.append(" OR ").append("AD_Role_ID").append(" IS  NULL ");
            parameters.add(AD_Role_ID);
        }
        if (AD_User_ID >= 0) {
            whereClause.append(" AND ").append("AD_User_ID").append("= ?");
            whereClause.append(" OR ").append("AD_User_ID").append(" IS  NULL ");
            parameters.add(AD_User_ID);
        }
        if (AD_Client_ID >= 0) {
            whereClause.append(" AND ").append("AD_Client_ID").append(" IN ( 0 ,?)");
            parameters.add(AD_Client_ID);
        }
        whereClause.append(" AND IsShowInLogin='Y'");
        Query query = new Query(ctx, "PA_DashboardContent", whereClause.toString(), null);
        if (parameters.size() > 0) {
            query.setParameters(parameters);
        }
        query.setOnlyActiveRecords(true);
        query.setApplyAccessFilter(true, false);
        query.setOrderBy("ColumnNo,AD_Client_ID,Line");
        return query;
    }

    public static MDashboardContent[] getForSession(int AD_User_ID, int AD_Role_ID) {
        List<MDashboardContent> list = MDashboardContent.getForSessionQuery(AD_User_ID, AD_Role_ID).list();
        return list.toArray(new MDashboardContent[list.size()]);
    }

    public static Query getForSessionQuery(int AD_User_ID, int AD_Role_ID) {
        Properties ctx = Env.getCtx();
        StringBuilder whereClause = new StringBuilder();
        if (AD_Role_ID == 0) {
            whereClause.append("(").append("AD_Role_ID").append(" IS NULL OR ").append("AD_Role_ID").append("=?)");
        } else {
            whereClause.append("AD_Role_ID").append("=?");
        }
        if (AD_User_ID == 0) {
            whereClause.append(" AND (").append("AD_User_ID").append(" IS NULL OR ").append("AD_User_ID").append("=?)");
        } else {
            whereClause.append(" AND ").append("AD_User_ID").append("=?");
        }
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(AD_Role_ID);
        parameters.add(AD_User_ID);
        return new Query(ctx, "PA_DashboardContent", whereClause.toString(), null).setParameters(parameters).setOnlyActiveRecords(true).setApplyAccessFilter(true, false).setOrderBy("ColumnNo,AD_Client_ID,Line");
    }

    public MDashboardContent(Properties ctx, String PA_DashboardContent_UU, String trxName) {
        super(ctx, PA_DashboardContent_UU, trxName);
    }

    public MDashboardContent(Properties ctx, int PA_DashboardContent_ID, String trxName) {
        super(ctx, PA_DashboardContent_ID, trxName);
    }

    public MDashboardContent(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public int getAD_Menu_ID() {
        if (this.m_AD_Menu_ID != null) {
            return this.m_AD_Menu_ID;
        }
        if (this.getAD_Window_ID() <= 0) {
            this.m_AD_Menu_ID = -1;
            return this.m_AD_Menu_ID;
        }
        this.m_AD_Menu_ID = new Query(this.getCtx(), "AD_Menu", "AD_Window_ID=?", null).setParameters(this.getAD_Window_ID()).setOnlyActiveRecords(true).setOrderBy("AD_Menu_ID DESC").firstId();
        return this.m_AD_Menu_ID;
    }

    public I_AD_Menu getAD_Menu() {
        return (I_AD_Menu)((Object)MTable.get(this.getCtx(), "AD_Menu").getPO(this.getAD_Menu_ID(), this.get_TrxName()));
    }

    public static Map<String, String> parseProcessParameters(String parameters) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (Util.isEmpty(parameters, true)) {
            return paramMap;
        }
        HashMap<CallSite, String> multiSelections = new HashMap<CallSite, String>();
        String parsedParameters = parameters;
        int idx = 0;
        Pattern p2 = Pattern.compile("\"(.*?)\"");
        Matcher m = p2.matcher(parameters);
        while (m.find()) {
            String multiSelectionKey = "_MULTISELECTVALUE_" + idx;
            String multiSelection = parameters.substring(m.start(), m.end());
            multiSelections.put((CallSite)((Object)multiSelectionKey), multiSelection.replace("\"", ""));
            parsedParameters = parsedParameters.replaceFirst(multiSelection, multiSelectionKey);
            ++idx;
        }
        if (!Util.isEmpty(parsedParameters, true)) {
            String[] params;
            String[] stringArray = params = parsedParameters.split("[,]");
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                int pos = s.indexOf("=");
                if (pos < 0) {
                    throw new AdempiereException(Msg.getMsg(Env.getCtx(), "WrongProcessParameters"));
                }
                String key = s.substring(0, pos);
                String value = s.substring(pos + 1);
                if (value.startsWith("_MULTISELECTVALUE_")) {
                    value = (String)multiSelections.get(value);
                }
                paramMap.put(key, value);
                ++n2;
            }
        }
        return paramMap;
    }

    public String getEmptyMandatoryProcessPara() {
        StringBuilder emptyPara = new StringBuilder();
        int processID = this.getAD_Process_ID();
        if (processID > 0) {
            MProcess process = MProcess.get(processID);
            Map<String, String> paramMap = MDashboardContent.parseProcessParameters(this.getProcessParameters());
            MProcessPara[] mProcessParaArray = process.getParameters();
            int n = mProcessParaArray.length;
            int n2 = 0;
            while (n2 < n) {
                MProcessPara processPara = mProcessParaArray[n2];
                if (processPara.isMandatory() && Util.isEmpty(paramMap.get(processPara.getColumnName()), true)) {
                    if (!Util.isEmpty(emptyPara.toString(), true)) {
                        emptyPara.append(", ");
                    }
                    emptyPara.append(processPara.getColumnName());
                }
                ++n2;
            }
        }
        return emptyPara.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String emptyPara;
        if (this.getAD_Process_ID() > 0 && this.isEmbedReportContent() && !Util.isEmpty(emptyPara = this.getEmptyMandatoryProcessPara())) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "FillMandatoryParametersDashboard", new Object[]{emptyPara}));
            return false;
        }
        return true;
    }
}

