/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MBank;
import org.compiere.model.MSysConfig;
import org.compiere.model.X_C_BankAccount;
import org.compiere.util.Env;
import org.compiere.util.IBAN;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MBankAccount
extends X_C_BankAccount
implements ImmutablePOSupport {
    private static final long serialVersionUID = -3792366454862697171L;
    private static ImmutableIntPOCache<Integer, MBankAccount> s_cache = new ImmutableIntPOCache("C_BankAccount", 5);

    public static MBankAccount get(int C_BankAccount_ID) {
        return MBankAccount.get(Env.getCtx(), C_BankAccount_ID);
    }

    public static MBankAccount get(Properties ctx, int C_BankAccount_ID) {
        Integer key = C_BankAccount_ID;
        MBankAccount retValue = s_cache.get(ctx, key, e -> new MBankAccount(ctx, (MBankAccount)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MBankAccount(ctx, C_BankAccount_ID, null);
        if (retValue.get_ID() == C_BankAccount_ID) {
            s_cache.put(key, retValue, e -> new MBankAccount(Env.getCtx(), (MBankAccount)e));
            return retValue;
        }
        return null;
    }

    public static MBankAccount getCopy(Properties ctx, int C_BankAccount_ID, String trxName) {
        MBankAccount mba = MBankAccount.get(C_BankAccount_ID);
        if (mba != null) {
            mba = new MBankAccount(ctx, mba, trxName);
        }
        return mba;
    }

    public MBankAccount(Properties ctx, String C_BankAccount_UU, String trxName) {
        super(ctx, C_BankAccount_UU, trxName);
        if (Util.isEmpty(C_BankAccount_UU)) {
            this.setInitialDefaults();
        }
    }

    public MBankAccount(Properties ctx, int C_BankAccount_ID, String trxName) {
        super(ctx, C_BankAccount_ID, trxName);
        if (C_BankAccount_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsDefault(false);
        this.setBankAccountType("C");
        this.setCurrentBalance(Env.ZERO);
        this.setCreditLimit(Env.ZERO);
    }

    public MBankAccount(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBankAccount(MBankAccount copy) {
        this(Env.getCtx(), copy);
    }

    public MBankAccount(Properties ctx, MBankAccount copy) {
        this(ctx, copy, null);
    }

    public MBankAccount(Properties ctx, MBankAccount copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MBankAccount[").append(this.get_ID()).append("-").append(this.getAccountNo()).append("]");
        return sb.toString();
    }

    public MBank getBank() {
        return MBank.getCopy(this.getCtx(), this.getC_Bank_ID(), this.get_TrxName());
    }

    @Override
    public String getName() {
        StringBuilder msgreturn = new StringBuilder().append(this.getBank().getName()).append(" ").append(this.getAccountNo());
        return msgreturn.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (MSysConfig.getBooleanValue("IBAN_VALIDATION", true, Env.getAD_Client_ID(Env.getCtx())) && !Util.isEmpty(this.getIBAN())) {
            this.setIBAN(IBAN.normalizeIBAN(this.getIBAN()));
            if (!IBAN.isValid(this.getIBAN())) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "InvalidIBAN"));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            return this.insert_Accounting("C_BankAccount_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    @Override
    public MBankAccount markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

