/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;

public class LDAP {
    private static final CLogger log = CLogger.getCLogger(LDAP.class);

    public static boolean validate(String ldapURL, String domain, String userName, String password) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapURL);
        env.put("java.naming.security.authentication", "simple");
        StringBuilder principal = "openldap".equals(MSysConfig.getValue("LDAP_TYPE")) ? new StringBuilder("uid=").append(userName).append(",").append(domain) : new StringBuilder(userName).append("@").append(domain);
        env.put("java.naming.security.principal", principal.toString());
        env.put("java.naming.security.credentials", password);
        try {
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            ctx.getAttributes("");
        }
        catch (AuthenticationException e) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Error: " + String.valueOf(principal) + " - " + e.getLocalizedMessage());
            }
            return false;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, ldapURL + " - " + String.valueOf(principal), e);
            return false;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: " + String.valueOf(principal));
        }
        return true;
    }

    private static void dump(Attributes attrs) {
        if (attrs == null) {
            System.out.println("No attributes");
        } else {
            try {
                NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                while (ae.hasMore()) {
                    Attribute attr = ae.next();
                    System.out.println("attribute: " + attr.getID());
                    NamingEnumeration<?> e = attr.getAll();
                    while (e.hasMore()) {
                        System.out.println("    value: " + String.valueOf(e.next()));
                    }
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
    }
}

