/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Cash;
import org.compiere.acct.Fact;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MCashLine;
import org.compiere.util.Env;

public class Doc_Cash
extends Doc {
    public Doc_Cash(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MCash.class, rs, "CMC", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MCash cash = (MCash)this.getPO();
        this.setDateDoc(cash.getStatementDate());
        this.setAmount(0, cash.getStatementDifference());
        MCashBook cb = MCashBook.get(this.getCtx(), cash.getC_CashBook_ID());
        this.setC_CashBook_ID(cb.getC_CashBook_ID());
        this.setC_Currency_ID(cb.getC_Currency_ID());
        this.p_lines = this.loadLines(cash, cb);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Lines=" + this.p_lines.length);
        }
        return null;
    }

    private DocLine[] loadLines(MCash cash, MCashBook cb) {
        ArrayList<DocLine_Cash> list = new ArrayList<DocLine_Cash>();
        MCashLine[] lines = cash.getLines(false);
        int i2 = 0;
        while (i2 < lines.length) {
            MCashLine line = lines[i2];
            DocLine_Cash docLine = new DocLine_Cash(line, this);
            list.add(docLine);
            ++i2;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuilder sb = new StringBuilder(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        int i2 = 0;
        while (i2 < this.p_lines.length) {
            retValue = retValue.subtract(this.p_lines[i2].getAmtSource());
            sb.append("-").append(this.p_lines[i2].getAmtSource());
            ++i2;
        }
        sb.append("]");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.toString() + " Balance=" + String.valueOf(retValue) + sb.toString());
        }
        return Env.ZERO;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        if (this.getC_CashBook_ID() == 0) {
            this.p_Error = "C_CashBook_ID not set";
            this.log.log(Level.SEVERE, this.p_Error);
            return null;
        }
        Fact fact = new Fact(this, as, "A");
        BigDecimal assetAmt = Env.ZERO;
        int i2 = 0;
        while (i2 < this.p_lines.length) {
            DocLine_Cash line = (DocLine_Cash)this.p_lines[i2];
            String CashType = line.getCashType();
            if (CashType.equals("E")) {
                fact.createLine((DocLine)line, this.getAccount(22, as), this.getC_Currency_ID(), line.getAmount().negate(), null);
                assetAmt = assetAmt.subtract(line.getAmount().negate());
            } else if (CashType.equals("R")) {
                assetAmt = assetAmt.add(line.getAmount());
                fact.createLine((DocLine)line, this.getAccount(23, as), this.getC_Currency_ID(), null, line.getAmount());
            } else if (CashType.equals("C")) {
                fact.createLine(line, line.getChargeAccount(as, line.getAmount().negate()), this.getC_Currency_ID(), line.getAmount().negate());
                assetAmt = assetAmt.subtract(line.getAmount().negate());
            } else if (CashType.equals("D")) {
                fact.createLine(line, this.getAccount(24, as), this.getC_Currency_ID(), line.getAmount().negate());
                assetAmt = assetAmt.add(line.getAmount());
            } else if (CashType.equals("I")) {
                if (line.getC_Currency_ID() == this.getC_Currency_ID()) {
                    assetAmt = assetAmt.add(line.getAmount());
                } else {
                    fact.createLine(line, this.getAccount(20, as), line.getC_Currency_ID(), line.getAmount());
                }
                fact.createLine(line, this.getAccount(21, as), line.getC_Currency_ID(), line.getAmount().negate());
            } else if (CashType.equals("T")) {
                int temp = this.getC_BankAccount_ID();
                this.setC_BankAccount_ID(line.getC_BankAccount_ID());
                fact.createLine(line, this.getAccount(11, as), line.getC_Currency_ID(), line.getAmount().negate());
                this.setC_BankAccount_ID(temp);
                if (line.getC_Currency_ID() == this.getC_Currency_ID()) {
                    assetAmt = assetAmt.add(line.getAmount());
                } else {
                    fact.createLine(line, this.getAccount(20, as), line.getC_Currency_ID(), line.getAmount());
                }
            }
            ++i2;
        }
        if (assetAmt.compareTo(Env.ZERO) != 0) {
            fact.createLine(null, this.getAccount(20, as), this.getC_Currency_ID(), assetAmt);
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }
}

